/*
 * Decompiled with CFR 0.152.
 */
package it.unimi.dsi.mg4j.document;

import it.unimi.dsi.Util;
import it.unimi.dsi.fastutil.objects.Reference2ObjectArrayMap;
import it.unimi.dsi.fastutil.objects.Reference2ObjectMap;
import it.unimi.dsi.fastutil.objects.Reference2ObjectMaps;
import it.unimi.dsi.mg4j.document.AbstractDocumentFactory;
import it.unimi.dsi.util.Properties;
import java.lang.reflect.InvocationTargetException;
import java.util.Iterator;
import java.util.NoSuchElementException;
import org.apache.commons.configuration.ConfigurationException;
import org.apache.log4j.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class PropertyBasedDocumentFactory
extends AbstractDocumentFactory {
    private static final long serialVersionUID = 1L;
    private static final Logger LOGGER = Util.getLogger(PropertyBasedDocumentFactory.class);
    protected Reference2ObjectMap<Enum<?>, Object> defaultMetadata;

    public static PropertyBasedDocumentFactory getInstance(Class<?> klass, String[] property) throws InstantiationException, IllegalAccessException, InvocationTargetException, NoSuchMethodException {
        return (PropertyBasedDocumentFactory)klass.getConstructor(String[].class).newInstance(new Object[]{property});
    }

    public static PropertyBasedDocumentFactory getInstance(Class<?> klass, Properties properties) throws InstantiationException, IllegalAccessException, InvocationTargetException, NoSuchMethodException {
        return (PropertyBasedDocumentFactory)klass.getConstructor(Properties.class).newInstance(properties);
    }

    public static PropertyBasedDocumentFactory getInstance(Class<?> klass) throws InstantiationException, IllegalAccessException, InvocationTargetException, NoSuchMethodException {
        return (PropertyBasedDocumentFactory)klass.getConstructor(new Class[0]).newInstance(new Object[0]);
    }

    public static PropertyBasedDocumentFactory getInstance(Class<?> klass, Reference2ObjectMap<Enum<?>, Object> metadata) throws InstantiationException, IllegalAccessException, InvocationTargetException, NoSuchMethodException {
        return (PropertyBasedDocumentFactory)klass.getConstructor(Reference2ObjectMap.class).newInstance(metadata);
    }

    private void logMetadata() {
        LOGGER.debug((Object)(this.getClass().getName() + " initialised with default metadata " + this.defaultMetadata));
    }

    protected PropertyBasedDocumentFactory(Reference2ObjectMap<Enum<?>, Object> defaultMetadata) {
        this.defaultMetadata = defaultMetadata;
        this.logMetadata();
    }

    protected PropertyBasedDocumentFactory(Properties properties) throws ConfigurationException {
        this.defaultMetadata = this.parseProperties(properties);
        this.logMetadata();
    }

    protected PropertyBasedDocumentFactory(String[] property) throws ConfigurationException {
        this.defaultMetadata = this.parseProperties(property);
        this.logMetadata();
    }

    protected PropertyBasedDocumentFactory() {
        this.defaultMetadata = Reference2ObjectMaps.EMPTY_MAP;
        this.logMetadata();
    }

    public static boolean sameKey(Enum<?> enumKey, String key) {
        return key.equals(enumKey.name().toLowerCase());
    }

    protected boolean parseProperty(String key, String[] valuesUnused, Reference2ObjectMap<Enum<?>, Object> metadataUnused) throws ConfigurationException {
        if (PropertyBasedDocumentFactory.sameKey(MetadataKeys.LOCALE, key)) {
            throw new ConfigurationException("Locales are currently unsupported");
        }
        return false;
    }

    protected static String ensureJustOne(String key, String[] values) throws ConfigurationException {
        if (values.length != 1) {
            throw new ConfigurationException("Property " + key + " should have just one value");
        }
        return values[0];
    }

    public Reference2ObjectMap<Enum<?>, Object> parseProperties(Properties properties) throws ConfigurationException {
        String className = this.getClass().getName();
        Reference2ObjectArrayMap metadata = new Reference2ObjectArrayMap();
        Iterator i = properties.getKeys();
        while (i.hasNext()) {
            String key = i.next().toString();
            int lastDot = key.lastIndexOf(46);
            String qualifier = lastDot == -1 ? "" : key.substring(0, lastDot);
            if (!className.startsWith(qualifier) || this.parseProperty(key.substring(lastDot + 1), properties.getStringArray(key), (Reference2ObjectMap<Enum<?>, Object>)metadata) || !className.equals(qualifier)) continue;
            throw new ConfigurationException("Unknown property " + key);
        }
        return metadata.isEmpty() ? Reference2ObjectMaps.EMPTY_MAP : metadata;
    }

    public Reference2ObjectMap<Enum<?>, Object> parseProperties(String[] property) throws ConfigurationException {
        Reference2ObjectArrayMap metadata = new Reference2ObjectArrayMap();
        for (int i = 0; i < property.length; ++i) {
            Properties properties;
            int pos = property[i].indexOf(61);
            if (pos != -1) {
                properties = new Properties();
                properties.addProperty(property[i].substring(0, pos), (Object)property[i].substring(pos + 1));
            } else {
                properties = new Properties(property[i]);
            }
            metadata.putAll(this.parseProperties(properties));
        }
        return metadata;
    }

    protected Object resolve(Enum<?> key, Reference2ObjectMap<Enum<?>, Object> metadata) {
        Object value = metadata.get(key);
        return value != null ? value : this.defaultMetadata.get(key);
    }

    protected Object resolve(Enum<?> key, Reference2ObjectMap<Enum<?>, Object> metadata, Object o) {
        Object value = metadata.get(key);
        return value != null ? value : o;
    }

    protected Object resolveNotNull(Enum<?> key, Reference2ObjectMap<Enum<?>, Object> metadata) {
        Object value = this.resolve(key, metadata);
        if (value == null) {
            throw new NoSuchElementException("The key " + key + " cannot be resolved");
        }
        return value;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum MetadataKeys {
        TITLE,
        URI,
        MIMETYPE,
        ENCODING,
        WORDREADER,
        LOCALE;

    }
}

