/*
 * Decompiled with CFR 0.152.
 */
package it.unimi.dsi.mg4j.document;

import it.unimi.dsi.fastutil.objects.Reference2ObjectMap;
import it.unimi.dsi.io.FastBufferedReader;
import it.unimi.dsi.io.WordReader;
import it.unimi.dsi.mg4j.document.AbstractDocument;
import it.unimi.dsi.mg4j.document.Document;
import it.unimi.dsi.mg4j.document.DocumentFactory;
import it.unimi.dsi.mg4j.document.PropertyBasedDocumentFactory;
import it.unimi.dsi.util.Properties;
import java.io.IOException;
import java.io.InputStream;
import java.io.InterruptedIOException;
import java.io.ObjectInputStream;
import java.io.PipedReader;
import java.io.PipedWriter;
import java.io.Writer;
import org.apache.commons.configuration.ConfigurationException;
import org.pdfbox.pdmodel.PDDocument;
import org.pdfbox.util.PDFTextStripper;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PdfDocumentFactory
extends PropertyBasedDocumentFactory {
    private static final long serialVersionUID = 1L;
    private transient PDFTextStripper textStripper = new PDFTextStripper();
    private final WordReader wordReader = new FastBufferedReader();

    @Override
    protected boolean parseProperty(String key, String[] values, Reference2ObjectMap<Enum<?>, Object> metadata) throws ConfigurationException {
        if (PdfDocumentFactory.sameKey(MetadataKeys.PARSETITLE, key)) {
            throw new ConfigurationException("PARSETITLE is not yet implemented");
        }
        return super.parseProperty(key, values, metadata);
    }

    public PdfDocumentFactory() throws IOException {
    }

    public PdfDocumentFactory(Properties properties) throws IOException, ConfigurationException {
        super(properties);
    }

    public PdfDocumentFactory(Reference2ObjectMap<Enum<?>, Object> defaultMetadata) throws IOException {
        super(defaultMetadata);
    }

    public PdfDocumentFactory(String[] property) throws IOException, ConfigurationException {
        super(property);
    }

    @Override
    public PdfDocumentFactory copy() {
        try {
            return new PdfDocumentFactory(this.defaultMetadata);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public int numberOfFields() {
        return 1;
    }

    @Override
    public String fieldName(int field) {
        this.ensureFieldIndex(field);
        return "text";
    }

    @Override
    public int fieldIndex(String fieldName) {
        return "text".equals(fieldName) ? 0 : -1;
    }

    @Override
    public DocumentFactory.FieldType fieldType(int field) {
        this.ensureFieldIndex(field);
        return DocumentFactory.FieldType.TEXT;
    }

    private void readObject(ObjectInputStream s) throws IOException, ClassNotFoundException {
        s.defaultReadObject();
        this.textStripper = new PDFTextStripper();
    }

    @Override
    public Document getDocument(final InputStream rawContent, final Reference2ObjectMap<Enum<?>, Object> metadata) {
        return new AbstractDocument(){
            private PDDocument pdfDocument;
            private Thread pipingThread;
            private PipedReader pipedReader;
            private PipedWriter pipedWriter;

            public CharSequence title() {
                return (CharSequence)PdfDocumentFactory.this.resolve(PropertyBasedDocumentFactory.MetadataKeys.TITLE, metadata);
            }

            public String toString() {
                return ((Object)this.title()).toString();
            }

            public CharSequence uri() {
                return (CharSequence)PdfDocumentFactory.this.resolve(PropertyBasedDocumentFactory.MetadataKeys.URI, metadata);
            }

            public Object content(int field) throws IOException {
                PdfDocumentFactory.this.ensureFieldIndex(field);
                this.pipedReader = new PipedReader();
                this.pipedWriter = new PipedWriter();
                this.pdfDocument = PDDocument.load((InputStream)rawContent);
                this.pipedWriter.connect(this.pipedReader);
                this.pipingThread = new Thread(){

                    public void run() {
                        try {
                            PdfDocumentFactory.this.textStripper.writeText(pdfDocument, (Writer)pipedWriter);
                            pipedWriter.close();
                            pipedWriter = null;
                        }
                        catch (InterruptedIOException dontCare) {
                        }
                        catch (IOException e) {
                            throw new RuntimeException(e);
                        }
                    }
                };
                this.pipingThread.start();
                return this.pipedReader;
            }

            public WordReader wordReader(int field) {
                PdfDocumentFactory.this.ensureFieldIndex(field);
                return PdfDocumentFactory.this.wordReader;
            }

            public void close() throws IOException {
                super.close();
                if (this.pipingThread != null) {
                    try {
                        this.pipingThread.interrupt();
                        this.pipingThread.join();
                        this.pipingThread = null;
                    }
                    catch (InterruptedException e) {
                        throw new RuntimeException(e);
                    }
                }
                if (this.pipedReader != null) {
                    this.pipedReader.close();
                    this.pipedReader = null;
                }
                if (this.pipedWriter != null) {
                    this.pipedWriter.close();
                    this.pipedWriter = null;
                }
                if (this.pdfDocument != null) {
                    this.pdfDocument.close();
                    this.pdfDocument = null;
                }
            }
        };
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum MetadataKeys {
        PARSETITLE;

    }
}

