/*
 * Decompiled with CFR 0.152.
 */
package it.unimi.dsi.mg4j.document;

import com.martiansoftware.jsap.FlaggedOption;
import com.martiansoftware.jsap.JSAP;
import com.martiansoftware.jsap.JSAPException;
import com.martiansoftware.jsap.JSAPResult;
import com.martiansoftware.jsap.Parameter;
import com.martiansoftware.jsap.SimpleJSAP;
import com.martiansoftware.jsap.StringParser;
import com.martiansoftware.jsap.UnflaggedOption;
import it.unimi.dsi.fastutil.ints.Int2IntMap;
import it.unimi.dsi.fastutil.ints.Int2IntOpenHashMap;
import it.unimi.dsi.fastutil.ints.IntArrayList;
import it.unimi.dsi.fastutil.io.BinIO;
import it.unimi.dsi.fastutil.objects.Reference2ObjectArrayMap;
import it.unimi.dsi.fastutil.objects.Reference2ObjectMap;
import it.unimi.dsi.io.MultipleInputStream;
import it.unimi.dsi.io.NullInputStream;
import it.unimi.dsi.lang.MutableString;
import it.unimi.dsi.mg4j.document.AbstractDocumentCollection;
import it.unimi.dsi.mg4j.document.AbstractDocumentIterator;
import it.unimi.dsi.mg4j.document.CompositeDocumentFactory;
import it.unimi.dsi.mg4j.document.Document;
import it.unimi.dsi.mg4j.document.DocumentFactory;
import it.unimi.dsi.mg4j.document.DocumentIterator;
import it.unimi.dsi.mg4j.document.IdentityDocumentFactory;
import it.unimi.dsi.mg4j.document.PropertyBasedDocumentFactory;
import it.unimi.dsi.mg4j.util.MG4JClassParser;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.lang.reflect.InvocationTargetException;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JdbcDocumentCollection
extends AbstractDocumentCollection
implements Serializable {
    private static final long serialVersionUID = 1L;
    protected final Int2IntMap id2doc;
    protected final int[] doc2id;
    protected final String dbUri;
    transient Class jdbcDriver;
    final String jdbcDriverName;
    protected final DocumentFactory factory;
    protected final String select;
    protected final String idSpec;
    protected final String where;

    public JdbcDocumentCollection(String dbUri, String jdbcDriverName, String select, String where, DocumentFactory factory) throws SQLException, ClassNotFoundException {
        this(dbUri, jdbcDriverName, select, "id", where, factory);
    }

    public JdbcDocumentCollection(String dbUri, String jdbcDriverName, String select, String idSpec, String where, DocumentFactory factory) throws SQLException, ClassNotFoundException {
        this.dbUri = dbUri;
        this.jdbcDriverName = jdbcDriverName;
        this.select = select;
        this.idSpec = idSpec;
        this.where = where;
        this.factory = factory;
        this.initDriver();
        Connection connection = DriverManager.getConnection(dbUri);
        Statement s = connection.createStatement();
        ResultSet rs = s.executeQuery(this.buildQuery(null));
        this.id2doc = new Int2IntOpenHashMap();
        this.id2doc.defaultReturnValue(-1);
        IntArrayList ids = new IntArrayList();
        int i = 0;
        while (rs.next()) {
            int id = rs.getInt(1);
            ids.add(id);
            this.id2doc.put(i, id);
            ++i;
        }
        this.doc2id = ids.toIntArray();
    }

    @Override
    public JdbcDocumentCollection copy() {
        try {
            return new JdbcDocumentCollection(this.dbUri, this.jdbcDriverName, this.select, this.idSpec, this.where, this.factory.copy());
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private String buildQuery(String additionalWhere) {
        MutableString query = new MutableString();
        query.append("SELECT ").append(this.select);
        if (this.where == null && additionalWhere != null) {
            query.append(" WHERE (").append(additionalWhere).append(")");
        }
        if (this.where != null && additionalWhere == null) {
            query.append(" WHERE (").append(this.where).append(")");
        }
        if (this.where != null && additionalWhere != null) {
            query.append(" WHERE (").append(this.where).append(") AND (").append(additionalWhere).append(")");
        }
        query.append(" ORDER BY 1");
        return query.toString();
    }

    private void initDriver() throws ClassNotFoundException {
        this.jdbcDriver = this.jdbcDriverName != null ? Class.forName(this.jdbcDriverName) : null;
    }

    @Override
    public DocumentFactory factory() {
        return this.factory;
    }

    @Override
    public int size() {
        return this.doc2id.length;
    }

    @Override
    public Document document(int index) throws IOException {
        MutableString title = new MutableString();
        return this.factory.getDocument(this.stream(index, title), this.metadata(index, (CharSequence)title));
    }

    public int id2doc(int id) {
        return this.id2doc.get(id);
    }

    public int doc2id(int doc) {
        this.ensureDocumentIndex(doc);
        return this.doc2id[doc];
    }

    protected Reference2ObjectMap<Enum<?>, Object> metadata(int index, CharSequence title) {
        Reference2ObjectArrayMap metadata = new Reference2ObjectArrayMap(2);
        if (title == null) {
            try {
                Connection connection = DriverManager.getConnection(this.dbUri);
                Statement s = connection.createStatement();
                ResultSet rs = s.executeQuery(this.buildQuery(this.idSpec + "=" + this.doc2id[index]));
                if (!rs.next()) {
                    throw new IllegalStateException("Id " + this.doc2id[index] + " is no longer in the database");
                }
                title = rs.getString(2);
            }
            catch (SQLException e) {
                throw new RuntimeException(e);
            }
        }
        metadata.put((Object)PropertyBasedDocumentFactory.MetadataKeys.TITLE, (Object)title);
        metadata.put((Object)PropertyBasedDocumentFactory.MetadataKeys.URI, (Object)Integer.toString(this.doc2id[index]));
        return metadata;
    }

    @Override
    public Reference2ObjectMap<Enum<?>, Object> metadata(int index) {
        this.ensureDocumentIndex(index);
        return this.metadata(index, null);
    }

    @Override
    public InputStream stream(int index) throws IOException {
        return this.stream(index, null);
    }

    private InputStream getStreamFromResultSet(ResultSet rs, MutableString title) throws SQLException {
        InputStream[] a = new InputStream[rs.getMetaData().getColumnCount() - 2];
        for (int i = 0; i < a.length; ++i) {
            a[i] = rs.getBinaryStream(i + 3);
            if (a[i] != null) continue;
            a[i] = NullInputStream.getInstance();
        }
        if (title != null) {
            title.replace(rs.getString(2));
        }
        return MultipleInputStream.getStream((InputStream[])a);
    }

    private InputStream stream(int index, MutableString title) throws IOException {
        this.ensureDocumentIndex(index);
        try {
            Connection connection = DriverManager.getConnection(this.dbUri);
            Statement s = connection.createStatement();
            ResultSet rs = s.executeQuery(this.buildQuery(this.idSpec + "=" + this.doc2id[index]));
            if (!rs.next()) {
                throw new IllegalStateException("Id " + this.doc2id[index] + " is no longer in the database");
            }
            return this.getStreamFromResultSet(rs, title);
        }
        catch (SQLException e) {
            throw new IOException(e.toString());
        }
    }

    @Override
    public DocumentIterator iterator() throws IOException {
        try {
            return new JdbcDocumentIterator();
        }
        catch (SQLException e) {
            throw new IOException(e.toString());
        }
    }

    private void readObject(ObjectInputStream s) throws IOException, ClassNotFoundException {
        s.defaultReadObject();
        this.initDriver();
    }

    public static void main(String[] arg) throws JSAPException, InvocationTargetException, NoSuchMethodException, IllegalAccessException, IOException, SQLException, ClassNotFoundException, InstantiationException {
        SimpleJSAP jsap = new SimpleJSAP(JdbcDocumentCollection.class.getName(), "Saves a serialised document collection based on a set of database rows. The first column of the query is used as an integer id, and the second column for titles. Each remaining column is used to build a segmented input stream, which is passed to a ComposedDocumentFactory made of the specified factories.", new Parameter[]{new FlaggedOption("property", (StringParser)JSAP.STRING_PARSER, JSAP.NO_DEFAULT, false, 'p', "property", "A 'key=value' specification, or the name of a property file").setAllowMultipleDeclarations(true), new FlaggedOption("jdbcDriver", (StringParser)JSAP.STRING_PARSER, JSAP.NO_DEFAULT, false, 'd', "driver", "The JDBC driver. You can omit it if it is already loaded."), new FlaggedOption("factory", (StringParser)MG4JClassParser.getParser(), IdentityDocumentFactory.class.getName(), false, 'f', "factory", "One document factory for each indexed field.").setAllowMultipleDeclarations(true), new FlaggedOption("fieldName", (StringParser)JSAP.STRING_PARSER, JSAP.NO_DEFAULT, false, 'n', "field-name", "One field name for each field in the composed document factory. If all specified factories have just one field, the name of the SQL column will be used as a default field name.").setAllowMultipleDeclarations(true), new UnflaggedOption("collection", (StringParser)JSAP.STRING_PARSER, true, "The filename for the serialised collection."), new UnflaggedOption("dburi", (StringParser)JSAP.STRING_PARSER, true, "The JDBC URI defining the database."), new UnflaggedOption("select", (StringParser)JSAP.STRING_PARSER, true, "A SQL query generating the collection, except for the WHERE part."), new FlaggedOption("idSpec", (StringParser)JSAP.STRING_PARSER, "id", false, 'i', "id-spec", "An optional, more precise specification for the id field (the first column)."), new FlaggedOption("where", (StringParser)JSAP.STRING_PARSER, JSAP.NO_DEFAULT, false, 'w', "where", "The the WHERE part (without the WHERE keyword) of the SQL query generating the collection.")});
        JSAPResult jsapResult = jsap.parse(arg);
        if (jsap.messagePrinted()) {
            return;
        }
        Class<?> jdbcDriver = Class.forName(jsapResult.getString("jdbcDriver"));
        Connection connection = DriverManager.getConnection(jsapResult.getString("dburi"));
        Statement s = connection.createStatement();
        ResultSet rs = s.executeQuery("SELECT " + jsapResult.getString("select"));
        ResultSetMetaData metaData = rs.getMetaData();
        String[] column = new String[metaData.getColumnCount() - 2];
        for (int i = 3; i <= metaData.getColumnCount(); ++i) {
            column[i - 3] = metaData.getColumnName(i);
        }
        rs.close();
        DocumentFactory[] factory = new DocumentFactory[column.length];
        Class[] factoryClass = jsapResult.getClassArray("factory");
        String[] property = jsapResult.getStringArray("property");
        for (int i = 0; i < factory.length; ++i) {
            factory[i] = PropertyBasedDocumentFactory.getInstance(factoryClass[Math.min(i, factoryClass.length - 1)], property);
            if (factory[i].numberOfFields() <= 1 || jsapResult.userSpecified("fieldName")) continue;
            throw new IllegalArgumentException("For factories with more than one field you must specify the name of each field of the composed factory");
        }
        if (jsapResult.userSpecified("fieldName")) {
            column = jsapResult.getStringArray("fieldName");
        }
        BinIO.storeObject((Object)new JdbcDocumentCollection(jsapResult.getString("dburi"), jsapResult.getString("jdbcDriver"), jsapResult.getString("select"), jsapResult.getString("idSpec"), jsapResult.getString("where"), CompositeDocumentFactory.getFactory(factory, column)), (CharSequence)jsapResult.getString("collection"));
    }

    protected class JdbcDocumentIterator
    extends AbstractDocumentIterator {
        private final Connection connection;
        private final ResultSet rs;
        private final MutableString title = new MutableString();
        private int index = 0;

        private JdbcDocumentIterator() throws SQLException {
            this.connection = DriverManager.getConnection(JdbcDocumentCollection.this.dbUri);
            Statement s = this.connection.createStatement();
            this.rs = s.executeQuery(JdbcDocumentCollection.this.buildQuery(null));
        }

        public Document nextDocument() throws IOException {
            try {
                if (!this.rs.next()) {
                    return null;
                }
                while (this.rs.getInt(1) < JdbcDocumentCollection.this.doc2id[this.index]) {
                    this.rs.next();
                }
                if (this.rs.getInt(1) > JdbcDocumentCollection.this.doc2id[this.index]) {
                    throw new IllegalStateException("Row with id " + JdbcDocumentCollection.this.doc2id[this.index] + " is missing");
                }
                return JdbcDocumentCollection.this.factory.getDocument(JdbcDocumentCollection.this.getStreamFromResultSet(this.rs, this.title), JdbcDocumentCollection.this.metadata(this.index++, (CharSequence)this.title));
            }
            catch (SQLException e) {
                throw new IOException(e.toString());
            }
        }

        public void close() throws IOException {
            super.close();
            try {
                this.rs.close();
            }
            catch (SQLException e) {
                throw new IOException(e.toString());
            }
        }
    }
}

