/*
 * Decompiled with CFR 0.152.
 */
package it.unimi.dsi.mg4j.document;

import it.unimi.dsi.fastutil.chars.CharArrays;
import it.unimi.dsi.fastutil.objects.Reference2ObjectMap;
import it.unimi.dsi.io.FastBufferedReader;
import it.unimi.dsi.io.WordReader;
import it.unimi.dsi.mg4j.document.AbstractDocument;
import it.unimi.dsi.mg4j.document.Document;
import it.unimi.dsi.mg4j.document.DocumentFactory;
import it.unimi.dsi.mg4j.document.PropertyBasedDocumentFactory;
import it.unimi.dsi.mg4j.util.parser.callback.AnchorExtractor;
import it.unimi.dsi.parser.BulletParser;
import it.unimi.dsi.parser.callback.Callback;
import it.unimi.dsi.parser.callback.ComposedCallbackBuilder;
import it.unimi.dsi.parser.callback.TextExtractor;
import it.unimi.dsi.util.Properties;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.ObjectInputStream;
import java.io.Reader;
import java.nio.charset.Charset;
import org.apache.commons.configuration.ConfigurationException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HtmlDocumentFactory
extends PropertyBasedDocumentFactory {
    private static final long serialVersionUID = 1L;
    private static final int DEFAULT_BUFFER_SIZE = 16384;
    private transient BulletParser parser;
    private transient TextExtractor textExtractor;
    private transient AnchorExtractor anchorExtractor;
    private transient WordReader wordReader;
    private int maxPreAnchor;
    private int maxAnchor;
    private int maxPostAnchor;
    private transient char[] text;

    @Override
    protected boolean parseProperty(String key, String[] values, Reference2ObjectMap<Enum<?>, Object> metadata) throws ConfigurationException {
        if (HtmlDocumentFactory.sameKey(PropertyBasedDocumentFactory.MetadataKeys.MIMETYPE, key)) {
            metadata.put((Object)PropertyBasedDocumentFactory.MetadataKeys.MIMETYPE, (Object)HtmlDocumentFactory.ensureJustOne(key, values));
            return true;
        }
        if (HtmlDocumentFactory.sameKey(PropertyBasedDocumentFactory.MetadataKeys.ENCODING, key)) {
            metadata.put((Object)PropertyBasedDocumentFactory.MetadataKeys.ENCODING, (Object)Charset.forName(HtmlDocumentFactory.ensureJustOne(key, values)).toString());
            return true;
        }
        if (HtmlDocumentFactory.sameKey(MetadataKeys.MAXPREANCHOR, key)) {
            metadata.put((Object)MetadataKeys.MAXPREANCHOR, (Object)Integer.valueOf(HtmlDocumentFactory.ensureJustOne(key, values)));
            return true;
        }
        if (HtmlDocumentFactory.sameKey(MetadataKeys.MAXANCHOR, key)) {
            metadata.put((Object)MetadataKeys.MAXANCHOR, (Object)Integer.valueOf(HtmlDocumentFactory.ensureJustOne(key, values)));
            return true;
        }
        if (HtmlDocumentFactory.sameKey(MetadataKeys.MAXPOSTANCHOR, key)) {
            metadata.put((Object)MetadataKeys.MAXPOSTANCHOR, (Object)Integer.valueOf(HtmlDocumentFactory.ensureJustOne(key, values)));
            return true;
        }
        return super.parseProperty(key, values, metadata);
    }

    private void init() {
        this.parser = new BulletParser();
        ComposedCallbackBuilder composedBuilder = new ComposedCallbackBuilder();
        this.textExtractor = new TextExtractor();
        composedBuilder.add((Callback)this.textExtractor);
        this.anchorExtractor = new AnchorExtractor(this.maxPreAnchor, this.maxAnchor, this.maxPostAnchor);
        composedBuilder.add((Callback)this.anchorExtractor);
        this.parser.setCallback(composedBuilder.compose());
        this.wordReader = new FastBufferedReader();
        this.text = new char[16384];
    }

    private void initVars() {
        this.maxPreAnchor = (Integer)this.resolve(MetadataKeys.MAXPREANCHOR, this.defaultMetadata, 32);
        this.maxAnchor = (Integer)this.resolve(MetadataKeys.MAXANCHOR, this.defaultMetadata, 256);
        this.maxPostAnchor = (Integer)this.resolve(MetadataKeys.MAXPOSTANCHOR, this.defaultMetadata, 32);
    }

    @Override
    public HtmlDocumentFactory copy() {
        return new HtmlDocumentFactory(this.defaultMetadata);
    }

    public HtmlDocumentFactory(Properties properties) throws ConfigurationException {
        super(properties);
        this.initVars();
        this.init();
    }

    public HtmlDocumentFactory(Reference2ObjectMap<Enum<?>, Object> defaultMetadata) {
        super(defaultMetadata);
        this.initVars();
        this.init();
    }

    public HtmlDocumentFactory(String[] property) throws ConfigurationException {
        super(property);
        this.initVars();
        this.init();
    }

    public HtmlDocumentFactory() {
        this.initVars();
        this.init();
    }

    @Override
    public int numberOfFields() {
        return 3;
    }

    @Override
    public String fieldName(int field) {
        this.ensureFieldIndex(field);
        switch (field) {
            case 0: {
                return "text";
            }
            case 1: {
                return "title";
            }
            case 2: {
                return "anchor";
            }
        }
        throw new IllegalArgumentException();
    }

    @Override
    public int fieldIndex(String fieldName) {
        for (int i = 0; i < this.numberOfFields(); ++i) {
            if (!this.fieldName(i).equals(fieldName)) continue;
            return i;
        }
        return -1;
    }

    @Override
    public DocumentFactory.FieldType fieldType(int field) {
        this.ensureFieldIndex(field);
        switch (field) {
            case 0: {
                return DocumentFactory.FieldType.TEXT;
            }
            case 1: {
                return DocumentFactory.FieldType.TEXT;
            }
            case 2: {
                return DocumentFactory.FieldType.VIRTUAL;
            }
        }
        throw new IllegalArgumentException();
    }

    private void readObject(ObjectInputStream s) throws IOException, ClassNotFoundException {
        s.defaultReadObject();
        this.init();
    }

    @Override
    public Document getDocument(InputStream rawContent, Reference2ObjectMap<Enum<?>, Object> metadata) throws IOException {
        return new HtmlDocument(rawContent, metadata);
    }

    static /* synthetic */ char[] access$002(HtmlDocumentFactory x0, char[] x1) {
        x0.text = x1;
        return x1;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected class HtmlDocument
    extends AbstractDocument {
        private final Reference2ObjectMap<Enum<?>, Object> metadata;
        private boolean parsed;
        private final InputStream rawContent;

        private void ensureParsed() throws IOException {
            int l;
            if (this.parsed) {
                return;
            }
            int offset = 0;
            InputStreamReader r = new InputStreamReader(this.rawContent, (String)HtmlDocumentFactory.this.resolveNotNull(PropertyBasedDocumentFactory.MetadataKeys.ENCODING, this.metadata));
            while ((l = ((Reader)r).read(HtmlDocumentFactory.this.text, offset, HtmlDocumentFactory.this.text.length - offset)) > 0) {
                HtmlDocumentFactory.access$002(HtmlDocumentFactory.this, CharArrays.grow((char[])HtmlDocumentFactory.this.text, (int)((offset += l) + 1)));
            }
            HtmlDocumentFactory.this.parser.parse(HtmlDocumentFactory.this.text, 0, offset);
            ((HtmlDocumentFactory)HtmlDocumentFactory.this).textExtractor.title.trim();
            this.parsed = true;
        }

        protected HtmlDocument(InputStream rawContent, Reference2ObjectMap<Enum<?>, Object> metadata) {
            this.metadata = metadata;
            this.rawContent = rawContent;
        }

        @Override
        public CharSequence title() {
            try {
                this.ensureParsed();
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
            return (CharSequence)(((HtmlDocumentFactory)HtmlDocumentFactory.this).textExtractor.title.length() == 0 ? HtmlDocumentFactory.this.resolve(PropertyBasedDocumentFactory.MetadataKeys.TITLE, this.metadata) : ((HtmlDocumentFactory)HtmlDocumentFactory.this).textExtractor.title);
        }

        @Override
        public String toString() {
            return ((Object)this.title()).toString();
        }

        @Override
        public CharSequence uri() {
            return (CharSequence)HtmlDocumentFactory.this.resolve(PropertyBasedDocumentFactory.MetadataKeys.URI, this.metadata);
        }

        @Override
        public Object content(int field) throws IOException {
            HtmlDocumentFactory.this.ensureFieldIndex(field);
            this.ensureParsed();
            switch (field) {
                case 0: {
                    return new FastBufferedReader(((HtmlDocumentFactory)HtmlDocumentFactory.this).textExtractor.text);
                }
                case 1: {
                    return new FastBufferedReader(((HtmlDocumentFactory)HtmlDocumentFactory.this).textExtractor.title);
                }
                case 2: {
                    return ((HtmlDocumentFactory)HtmlDocumentFactory.this).anchorExtractor.anchors;
                }
            }
            throw new IllegalArgumentException();
        }

        @Override
        public WordReader wordReader(int field) {
            HtmlDocumentFactory.this.ensureFieldIndex(field);
            return HtmlDocumentFactory.this.wordReader;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum MetadataKeys {
        MAXPREANCHOR,
        MAXANCHOR,
        MAXPOSTANCHOR;

    }
}

