/*
 * Decompiled with CFR 0.152.
 */
package it.unimi.dsi.mg4j.document;

import it.unimi.dsi.fastutil.io.BinIO;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import it.unimi.dsi.fastutil.objects.Object2IntOpenHashMap;
import it.unimi.dsi.fastutil.objects.Object2ObjectLinkedOpenHashMap;
import it.unimi.dsi.fastutil.objects.ObjectIterator;
import it.unimi.dsi.fastutil.objects.Reference2ObjectMap;
import it.unimi.dsi.io.FastBufferedReader;
import it.unimi.dsi.io.NullReader;
import it.unimi.dsi.io.WordReader;
import it.unimi.dsi.mg4j.document.AbstractDocument;
import it.unimi.dsi.mg4j.document.Document;
import it.unimi.dsi.mg4j.document.DocumentFactory;
import it.unimi.dsi.mg4j.document.FileSetDocumentCollection;
import it.unimi.dsi.mg4j.document.PropertyBasedDocumentFactory;
import it.unimi.dsi.util.Properties;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.util.Map;
import org.apache.commons.configuration.ConfigurationException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DispatchingDocumentFactory
extends PropertyBasedDocumentFactory {
    private static final long serialVersionUID = 1L;
    private static final boolean DEBUG = false;
    public static final String OTHERWISE_IN_RULE = "?";
    private int n;
    private DocumentFactory[] documentFactory;
    private int numberOfFields;
    private String[] fieldName;
    private DocumentFactory.FieldType[] fieldType;
    private int[][] rename;
    private DispatchingStrategy strategy;
    private Enum<?> dispatchingKey;
    private Object2ObjectLinkedOpenHashMap<String, Class<? extends DocumentFactory>> value2factoryClass;
    private final WordReader nullReader = new FastBufferedReader();

    private void init(DocumentFactory[] documentFactory, String[] fieldName, DocumentFactory.FieldType[] fieldType, int[][] rename, DispatchingStrategy strategy) {
        this.n = documentFactory.length;
        this.documentFactory = documentFactory;
        this.numberOfFields = fieldName.length;
        this.fieldName = fieldName;
        this.fieldType = fieldType;
        this.rename = rename;
        this.strategy = strategy;
    }

    private void checkAttributes() {
        if (this.fieldName.length != this.fieldType.length || this.rename.length != this.documentFactory.length || this.documentFactory.length != this.n || this.fieldName.length != this.numberOfFields) {
            throw new IllegalArgumentException("Length mismatch in defining the dispatching factory");
        }
        for (int f = 0; f < this.n; ++f) {
            if (this.rename[f].length != this.numberOfFields) {
                throw new IllegalArgumentException("The number of fields (" + this.numberOfFields + ") does not match the mapping rule for factory " + this.documentFactory[f].getClass().getName());
            }
            for (int k = 0; k < this.numberOfFields; ++k) {
                if (this.rename[f][k] < -1 || this.rename[f][k] >= this.documentFactory[f].numberOfFields()) {
                    throw new IllegalArgumentException(this.rename[f][k] + " is not a field of factory " + this.documentFactory[f]);
                }
                if (this.rename[f][k] < 0 || this.fieldType[k] == this.documentFactory[f].fieldType(this.rename[f][k])) continue;
                throw new IllegalArgumentException("Field " + this.rename[f][k] + " of factory " + this.documentFactory[f] + " has a type different from the type of the field it is mapped to");
            }
        }
        if (this.n == 0 || this.numberOfFields == 0) {
            throw new IllegalArgumentException("Zero factories or fields specified");
        }
        if (this.strategy == null) {
            throw new IllegalArgumentException("No strategy was specified");
        }
    }

    private void setExtraArguments(Object xtraPars) throws IllegalArgumentException {
        int f;
        if (this.value2factoryClass == null) {
            throw new IllegalArgumentException("No " + (Object)((Object)MetadataKeys.RULE) + " property was specified for the dispatching factory");
        }
        this.n = this.value2factoryClass.values().size();
        this.documentFactory = new DocumentFactory[this.n];
        ObjectIterator it = this.value2factoryClass.values().iterator();
        for (f = 0; f < this.n; ++f) {
            Class documentFactoryClass = (Class)it.next();
            try {
                if (xtraPars == null) {
                    this.documentFactory[f] = (DocumentFactory)documentFactoryClass.newInstance();
                    continue;
                }
                this.documentFactory[f] = (DocumentFactory)documentFactoryClass.getConstructor(xtraPars.getClass()).newInstance(xtraPars);
                continue;
            }
            catch (Exception e) {
                throw new IllegalArgumentException(e);
            }
        }
        this.fieldType = new DocumentFactory.FieldType[this.numberOfFields];
        if (this.rename == null) {
            throw new IllegalArgumentException("No " + (Object)((Object)MetadataKeys.MAP) + " property was specified for the dispatching factory");
        }
        for (f = 0; f < this.n; ++f) {
            for (int k = 0; k < this.numberOfFields; ++k) {
                int kk = this.rename[f][k];
                if (kk >= 0 && this.fieldType[k] != null && this.fieldType[k] != this.documentFactory[f].fieldType(kk)) {
                    throw new IllegalArgumentException("Mismatch between field types for field " + f + ", relative to the remapping of factory " + this.documentFactory[f].getClass().getName() + " (the type used to be " + (Object)((Object)this.fieldType[k]) + ", but now we want it to be " + (Object)((Object)this.documentFactory[f].fieldType(kk)) + ")");
                }
                if (kk < 0) continue;
                this.fieldType[k] = this.documentFactory[f].fieldType(kk);
            }
        }
        for (f = 0; f < this.numberOfFields; ++f) {
            if (this.fieldType[f] != null) continue;
            throw new IllegalArgumentException("The type of field " + this.fieldName[f] + " could not be deduced, because it is never mapped to");
        }
        if (this.dispatchingKey == null) {
            throw new IllegalArgumentException("No " + (Object)((Object)MetadataKeys.KEY) + " property was specified for the dispatching factory");
        }
        Object2IntOpenHashMap value2int = new Object2IntOpenHashMap();
        value2int.defaultReturnValue(-1);
        for (Map.Entry e : this.value2factoryClass.entrySet()) {
            int k;
            for (k = 0; k < this.n; ++k) {
                if (e.getValue() != this.documentFactory[k].getClass()) continue;
                if (((String)e.getKey()).equals(OTHERWISE_IN_RULE)) {
                    value2int.defaultReturnValue(k);
                    break;
                }
                value2int.put(e.getKey(), k);
                break;
            }
            if (k != this.n) continue;
            throw new IllegalArgumentException("Mismatch in the rule mapping " + (String)e.getKey() + " to " + e.getValue());
        }
        System.out.println("Building a strategy mapping " + this.dispatchingKey + " to " + value2int);
        this.strategy = new StringBasedDispatchingStrategy(this.dispatchingKey, (Object2IntMap<String>)value2int);
    }

    public DispatchingDocumentFactory(DocumentFactory[] documentFactory, String[] fieldName, DocumentFactory.FieldType[] fieldType, int[][] rename, DispatchingStrategy strategy) {
        this.init(documentFactory, fieldName, fieldType, rename, strategy);
        this.checkAttributes();
    }

    @Override
    public DispatchingDocumentFactory copy() {
        DocumentFactory[] documentFactory = new DocumentFactory[this.documentFactory.length];
        int i = documentFactory.length;
        while (i-- != 0) {
            documentFactory[i] = this.documentFactory[i].copy();
        }
        return new DispatchingDocumentFactory(documentFactory, this.fieldName, this.fieldType, this.rename, this.strategy);
    }

    public DispatchingDocumentFactory(Properties properties) throws ConfigurationException {
        super(properties);
        this.setExtraArguments(properties);
        this.checkAttributes();
    }

    public DispatchingDocumentFactory(String[] property) throws ConfigurationException {
        super(property);
        this.setExtraArguments(property);
        this.checkAttributes();
    }

    public DispatchingDocumentFactory(Reference2ObjectMap<Enum<?>, Object> defaultMetadata) {
        super(defaultMetadata);
        this.checkAttributes();
    }

    public DispatchingDocumentFactory() {
        this.checkAttributes();
    }

    @Override
    protected boolean parseProperty(String key, String[] values, Reference2ObjectMap<Enum<?>, Object> metadata) throws ConfigurationException {
        if (DispatchingDocumentFactory.sameKey(MetadataKeys.FIELDNAME, key)) {
            this.fieldName = values;
            this.numberOfFields = this.fieldName.length;
            return true;
        }
        if (DispatchingDocumentFactory.sameKey(MetadataKeys.KEY, key)) {
            String dispatchingKeyName = DispatchingDocumentFactory.ensureJustOne(key, values);
            int lastDot = dispatchingKeyName.lastIndexOf(46);
            try {
                this.dispatchingKey = Enum.valueOf(Class.forName(dispatchingKeyName.substring(0, lastDot)), dispatchingKeyName.substring(lastDot + 1));
            }
            catch (ClassNotFoundException e) {
                throw new IllegalArgumentException("The class specified in the key " + dispatchingKeyName + " cannot be found");
            }
            return true;
        }
        if (DispatchingDocumentFactory.sameKey(MetadataKeys.RULE, key)) {
            String[] rules = values;
            this.value2factoryClass = new Object2ObjectLinkedOpenHashMap();
            int m = rules.length;
            for (int i = 0; i < m; ++i) {
                int pos = rules[i].indexOf(58);
                if (pos <= 0 || pos == rules[i].length() - 1) {
                    throw new ConfigurationException("Rule " + rules[i] + " does not contain a colon or it is malformed");
                }
                if (rules[i].indexOf(58, pos + 1) >= 0) {
                    throw new ConfigurationException("Rule " + rules[i] + " contains too many colons");
                }
                String factoryName = rules[i].substring(pos + 1);
                Class<?> factoryClass = null;
                try {
                    factoryClass = Class.forName(factoryName);
                    if (!DocumentFactory.class.isAssignableFrom(factoryClass)) {
                        throw new ClassNotFoundException();
                    }
                }
                catch (ClassNotFoundException e) {
                    throw new ConfigurationException("ParsingFactory " + factoryName + " is invalid; maybe the package name is missing");
                }
                this.value2factoryClass.put((Object)rules[i].substring(0, pos), factoryClass);
            }
            m = this.value2factoryClass.values().size();
            return true;
        }
        if (DispatchingDocumentFactory.sameKey(MetadataKeys.MAP, key)) {
            String[] pieces = values;
            int m = pieces.length;
            this.rename = new int[m][];
            for (int i = 0; i < m; ++i) {
                String[] subpieces = pieces[i].split(":");
                if (i > 0 && subpieces.length != this.rename[0].length) {
                    throw new ConfigurationException("Length mismatch in the map " + values);
                }
                this.rename[i] = new int[subpieces.length];
                for (int k = 0; k < subpieces.length; ++k) {
                    try {
                        this.rename[i][k] = Integer.parseInt(subpieces[k]);
                        continue;
                    }
                    catch (NumberFormatException e) {
                        throw new ConfigurationException("Number format exception in the map " + values);
                    }
                }
            }
        }
        return super.parseProperty(key, values, metadata);
    }

    @Override
    public int numberOfFields() {
        return this.numberOfFields;
    }

    @Override
    public String fieldName(int field) {
        this.ensureFieldIndex(field);
        return this.fieldName[field];
    }

    @Override
    public int fieldIndex(String fieldName) {
        for (int k = 0; k < this.numberOfFields; ++k) {
            if (!this.fieldName[k].equals(fieldName)) continue;
            return k;
        }
        return -1;
    }

    @Override
    public DocumentFactory.FieldType fieldType(int field) {
        this.ensureFieldIndex(field);
        return this.fieldType[field];
    }

    @Override
    public Document getDocument(InputStream rawContent, Reference2ObjectMap<Enum<?>, Object> metadata) throws IOException {
        final int factoryIndex = this.strategy.factoryNumber(metadata, this);
        System.out.println("The strategy returned " + factoryIndex);
        if (factoryIndex < 0 || factoryIndex >= this.n) {
            throw new IllegalArgumentException();
        }
        System.out.println("Going to parse a document with " + metadata + ", using " + this.documentFactory[factoryIndex].getClass().getName());
        DocumentFactory factory = this.documentFactory[factoryIndex];
        final Document document = factory.getDocument(rawContent, metadata);
        return new AbstractDocument(){

            public CharSequence title() {
                return document.title();
            }

            public String toString() {
                return document.toString();
            }

            public CharSequence uri() {
                return document.uri();
            }

            public Object content(int field) throws IOException {
                DispatchingDocumentFactory.this.ensureFieldIndex(field);
                if (DispatchingDocumentFactory.this.rename[factoryIndex][field] < 0) {
                    return NullReader.getInstance();
                }
                return document.content(DispatchingDocumentFactory.this.rename[factoryIndex][field]);
            }

            public WordReader wordReader(int field) {
                DispatchingDocumentFactory.this.ensureFieldIndex(field);
                if (DispatchingDocumentFactory.this.rename[factoryIndex][field] < 0) {
                    return DispatchingDocumentFactory.this.nullReader;
                }
                return document.wordReader(DispatchingDocumentFactory.this.rename[factoryIndex][field]);
            }

            public void close() throws IOException {
                super.close();
                document.close();
            }
        };
    }

    public static void main(String[] arg) throws IOException, ConfigurationException {
        Properties p = new Properties();
        p.addProperty(MetadataKeys.FIELDNAME.name().toLowerCase(), (Object)"text,title");
        p.addProperty(MetadataKeys.KEY.name().toLowerCase(), (Object)PropertyBasedDocumentFactory.MetadataKeys.MIMETYPE.name());
        p.addProperty(MetadataKeys.RULE.name().toLowerCase(), (Object)"application/pdf:it.unimi.dsi.mg4j.document.PdfDocumentFactory,text/html:it.unimi.dsi.mg4j.document.HtmlDocumentFactory,?:it.unimi.dsi.mg4j.document.IdentityDocumentFactory");
        p.addProperty(MetadataKeys.MAP.name().toLowerCase(), (Object)"0:-1,0:1,0:-1");
        p.addProperty(MetadataKeys.MAP.name().toLowerCase(), (Object)"0:-1,0:1,0:-1");
        p.addProperty(MetadataKeys.MAP.name().toLowerCase(), (Object)"0:-1,0:1,0:-1");
        p.addProperty(PropertyBasedDocumentFactory.MetadataKeys.ENCODING.name().toLowerCase(), (Object)"iso-8859-1");
        DispatchingDocumentFactory factory = new DispatchingDocumentFactory(p);
        FileSetDocumentCollection dc = new FileSetDocumentCollection(arg, factory);
        BinIO.storeObject((Object)dc, (CharSequence)"test.collection");
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class StringBasedDispatchingStrategy
    implements DispatchingStrategy {
        private static final long serialVersionUID = 1L;
        private final Enum<?> key;
        private final Object2IntMap<String> value;

        public StringBasedDispatchingStrategy(Enum<?> key, Object2IntMap<String> value) {
            this.key = key;
            this.value = value;
        }

        @Override
        public int factoryNumber(Reference2ObjectMap<Enum<?>, Object> metadata, PropertyBasedDocumentFactory factory) {
            Object val = factory.resolve(this.key, metadata);
            return this.value.getInt(val);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static interface DispatchingStrategy
    extends Serializable {
        public int factoryNumber(Reference2ObjectMap<Enum<?>, Object> var1, PropertyBasedDocumentFactory var2);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum MetadataKeys {
        FIELDNAME,
        KEY,
        RULE,
        MAP;

    }
}

