/*
 * Decompiled with CFR 0.152.
 */
package it.unimi.dsi.mg4j.document;

import it.unimi.dsi.fastutil.objects.Object2IntOpenHashMap;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import it.unimi.dsi.fastutil.objects.Reference2ObjectMap;
import it.unimi.dsi.io.WordReader;
import it.unimi.dsi.lang.FlyweightPrototype;
import it.unimi.dsi.lang.FlyweightPrototypes;
import it.unimi.dsi.mg4j.document.AbstractDocument;
import it.unimi.dsi.mg4j.document.AbstractDocumentFactory;
import it.unimi.dsi.mg4j.document.Document;
import it.unimi.dsi.mg4j.document.DocumentFactory;
import java.io.IOException;
import java.io.InputStream;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CompositeDocumentFactory
extends AbstractDocumentFactory {
    private static final long serialVersionUID = 1L;
    private final DocumentFactory[] documentFactory;
    private final int numberOfFields;
    private final String[] fieldName;
    private final DocumentFactory.FieldType[] fieldType;
    private final Object2IntOpenHashMap<String> field2Index;
    final int[] factoryIndex;
    final int[] originalFieldIndex;

    protected CompositeDocumentFactory(DocumentFactory[] documentFactory, String[] fieldName) {
        int i;
        boolean hasNames;
        this.documentFactory = documentFactory;
        int n = 0;
        for (int i2 = 0; i2 < this.documentFactory.length; ++i2) {
            n += documentFactory[i2].numberOfFields();
        }
        this.numberOfFields = n;
        boolean bl = hasNames = fieldName != null;
        if (hasNames && fieldName.length != this.numberOfFields) {
            throw new IllegalArgumentException("There is a mismatch between the number of fields (" + this.numberOfFields + ") and the number of names (" + fieldName.length + ")");
        }
        this.fieldName = hasNames ? fieldName : new String[this.numberOfFields];
        this.fieldType = new DocumentFactory.FieldType[this.numberOfFields];
        this.factoryIndex = new int[this.numberOfFields];
        this.originalFieldIndex = new int[this.numberOfFields];
        n = 0;
        for (i = 0; i < this.documentFactory.length; ++i) {
            int j = 0;
            while (j < documentFactory[i].numberOfFields()) {
                if (!hasNames) {
                    this.fieldName[n] = documentFactory[i].fieldName(j);
                }
                this.fieldType[n] = documentFactory[i].fieldType(j);
                this.factoryIndex[n] = i;
                this.originalFieldIndex[n] = j++;
                ++n;
            }
        }
        this.field2Index = new Object2IntOpenHashMap(this.fieldName.length, 0.5f);
        this.field2Index.defaultReturnValue(-1);
        for (i = 0; i < this.fieldName.length; ++i) {
            this.field2Index.put((Object)this.fieldName[i], i);
        }
        if (this.field2Index.size() != this.fieldName.length) {
            throw new IllegalArgumentException("The field name array " + ObjectArrayList.wrap((Object[])fieldName) + " contains duplicates");
        }
    }

    @Override
    public CompositeDocumentFactory copy() {
        return new CompositeDocumentFactory((DocumentFactory[])FlyweightPrototypes.copy((FlyweightPrototype[])this.documentFactory), this.fieldName);
    }

    public static DocumentFactory getFactory(DocumentFactory[] documentFactory, String[] fieldName) {
        if (documentFactory.length == 1 && fieldName == null) {
            return documentFactory[0];
        }
        return new CompositeDocumentFactory(documentFactory, fieldName);
    }

    public static DocumentFactory getFactory(DocumentFactory ... documentFactory) {
        return CompositeDocumentFactory.getFactory(documentFactory, null);
    }

    @Override
    public int numberOfFields() {
        return this.numberOfFields;
    }

    @Override
    public String fieldName(int field) {
        this.ensureFieldIndex(field);
        return this.fieldName[field];
    }

    @Override
    public int fieldIndex(String fieldName) {
        return this.field2Index.getInt((Object)fieldName);
    }

    @Override
    public DocumentFactory.FieldType fieldType(int field) {
        this.ensureFieldIndex(field);
        return this.fieldType[field];
    }

    @Override
    public Document getDocument(InputStream rawContent, Reference2ObjectMap<Enum<?>, Object> metadata) throws IOException {
        return new CompositeDocument(metadata, rawContent);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected class CompositeDocument
    extends AbstractDocument {
        private int currFactory = 0;
        private int currField = -1;
        private Document currDocument;
        private CharSequence title;
        private CharSequence uri;
        private final Reference2ObjectMap<Enum<?>, Object> metadata;
        private final InputStream rawContent;

        protected CompositeDocument(Reference2ObjectMap<Enum<?>, Object> metadata, InputStream rawContent) throws IOException {
            this.metadata = metadata;
            this.rawContent = rawContent;
            this.currDocument = CompositeDocumentFactory.this.documentFactory[0].getDocument(rawContent, metadata);
            this.title = this.currDocument.title();
            this.uri = this.currDocument.uri();
        }

        @Override
        public CharSequence title() {
            return this.title;
        }

        @Override
        public String toString() {
            return ((Object)this.title).toString();
        }

        @Override
        public CharSequence uri() {
            return this.uri;
        }

        @Override
        public Object content(int field) throws IOException {
            CompositeDocumentFactory.this.ensureFieldIndex(field);
            if (field <= this.currField) {
                throw new IllegalStateException("Composite document factories require sequential access");
            }
            if (this.currFactory < CompositeDocumentFactory.this.factoryIndex[field]) {
                while (this.currFactory < CompositeDocumentFactory.this.factoryIndex[field]) {
                    this.rawContent.reset();
                    ++this.currFactory;
                }
                if (this.currDocument != null) {
                    this.currDocument.close();
                }
                this.currDocument = CompositeDocumentFactory.this.documentFactory[this.currFactory].getDocument(this.rawContent, this.metadata);
            }
            this.currField = field;
            return this.currDocument.content(CompositeDocumentFactory.this.originalFieldIndex[field]);
        }

        @Override
        public WordReader wordReader(int field) {
            CompositeDocumentFactory.this.ensureFieldIndex(field);
            if (field != this.currField) {
                throw new IllegalStateException("The specified field (" + field + ") is not the one of the last document returned (" + this.currField + ")");
            }
            return this.currDocument.wordReader(CompositeDocumentFactory.this.originalFieldIndex[field]);
        }

        @Override
        public void close() throws IOException {
            if (this.currDocument != null) {
                this.currDocument.close();
            }
            super.close();
        }
    }
}

