/*
 * Decompiled with CFR 0.152.
 */
package it.unimi.dsi.fastutil.shorts;

import it.unimi.dsi.fastutil.Lists;
import it.unimi.dsi.fastutil.shorts.AbstractShortList;
import it.unimi.dsi.fastutil.shorts.ShortCollection;
import it.unimi.dsi.fastutil.shorts.ShortCollections;
import it.unimi.dsi.fastutil.shorts.ShortIterators;
import it.unimi.dsi.fastutil.shorts.ShortList;
import it.unimi.dsi.fastutil.shorts.ShortListIterator;
import java.io.Serializable;
import java.util.Collection;
import java.util.List;
import java.util.ListIterator;

public class ShortLists {
    private ShortLists() {
    }

    public static ShortList singleton(short element) {
        return new Singleton(element);
    }

    public static ShortList singleton(Object element) {
        return new Singleton((Short)element);
    }

    public static ShortList synchronize(ShortList l) {
        return new SynchronizedList(l);
    }

    public static ShortList synchronize(ShortList l, Object sync) {
        return new SynchronizedList(l, sync);
    }

    public static ShortList unmodifiable(ShortList l) {
        return new UnmodifiableList(l);
    }

    public static class UnmodifiableList
    extends ShortCollections.UnmodifiableCollection
    implements ShortList,
    Serializable {
        public static final long serialVersionUID = -7046029254386353129L;
        protected final ShortList list;

        protected UnmodifiableList(ShortList l) {
            super(l);
            this.list = l;
        }

        public short getShort(int i) {
            return this.list.getShort(i);
        }

        public short set(int i, short k) {
            throw new UnsupportedOperationException();
        }

        public void add(int i, short k) {
            throw new UnsupportedOperationException();
        }

        public short removeShort(int i) {
            throw new UnsupportedOperationException();
        }

        public int indexOf(short k) {
            return this.list.indexOf(k);
        }

        public int lastIndexOf(short k) {
            return this.list.lastIndexOf(k);
        }

        public boolean addAll(int index, Collection c) {
            throw new UnsupportedOperationException();
        }

        public boolean addAll(int index, ShortCollection c) {
            throw new UnsupportedOperationException();
        }

        public boolean addAll(List l) {
            throw new UnsupportedOperationException();
        }

        public boolean addAll(ShortList l) {
            throw new UnsupportedOperationException();
        }

        public boolean addAll(int index, List l) {
            throw new UnsupportedOperationException();
        }

        public boolean addAll(int index, ShortList l) {
            throw new UnsupportedOperationException();
        }

        public void getElements(int from, short[] a, int offset, int length) {
            this.list.getElements(from, a, offset, length);
        }

        public void removeElements(int from, int to) {
            throw new UnsupportedOperationException();
        }

        public void addElements(int index, short[] a, int offset, int length) {
            throw new UnsupportedOperationException();
        }

        public void addElements(int index, short[] a) {
            throw new UnsupportedOperationException();
        }

        public void size(int size) {
            this.list.size(size);
        }

        public ListIterator listIterator() {
            return ShortIterators.unmodifiable((ShortListIterator)this.list.listIterator());
        }

        public ListIterator listIterator(int i) {
            return ShortIterators.unmodifiable((ShortListIterator)this.list.listIterator(i));
        }

        public ShortListIterator shortListIterator() {
            return ShortIterators.unmodifiable(this.list.shortListIterator());
        }

        public ShortListIterator shortListIterator(int i) {
            return ShortIterators.unmodifiable(this.list.shortListIterator(i));
        }

        public List subList(int from, int to) {
            return new UnmodifiableList((ShortList)this.list.subList(from, to));
        }

        public ShortList shortSubList(int from, int to) {
            return new UnmodifiableList(this.list.shortSubList(from, to));
        }

        public boolean equals(Object o) {
            return this.collection.equals(o);
        }

        public int hashCode() {
            return this.collection.hashCode();
        }

        public int compareTo(Object o) {
            return this.list.compareTo(o);
        }

        public Object get(int i) {
            return this.list.get(i);
        }

        public void add(int i, Object k) {
            throw new UnsupportedOperationException();
        }

        public Object set(int index, Object k) {
            throw new UnsupportedOperationException();
        }

        public Object remove(int i) {
            throw new UnsupportedOperationException();
        }

        public int indexOf(Object o) {
            return this.list.indexOf(o);
        }

        public int lastIndexOf(Object o) {
            return this.list.lastIndexOf(o);
        }
    }

    public static class SynchronizedList
    extends ShortCollections.SynchronizedCollection
    implements ShortList,
    Serializable {
        public static final long serialVersionUID = -7046029254386353129L;
        protected final ShortList list;

        protected SynchronizedList(ShortList l, Object sync) {
            super(l, sync);
            this.list = l;
        }

        protected SynchronizedList(ShortList l) {
            super(l);
            this.list = l;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public short getShort(int i) {
            Object object = this.sync;
            synchronized (object) {
                return this.list.getShort(i);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public short set(int i, short k) {
            Object object = this.sync;
            synchronized (object) {
                return this.list.set(i, k);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void add(int i, short k) {
            Object object = this.sync;
            synchronized (object) {
                this.list.add(i, k);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public short removeShort(int i) {
            Object object = this.sync;
            synchronized (object) {
                return this.list.removeShort(i);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public int indexOf(short k) {
            Object object = this.sync;
            synchronized (object) {
                return this.list.indexOf(k);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public int lastIndexOf(short k) {
            Object object = this.sync;
            synchronized (object) {
                return this.list.lastIndexOf(k);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean addAll(int index, Collection c) {
            Object object = this.sync;
            synchronized (object) {
                return this.list.addAll(index, c);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean addAll(int index, ShortCollection c) {
            Object object = this.sync;
            synchronized (object) {
                return this.list.addAll(index, c);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean addAll(List l) {
            Object object = this.sync;
            synchronized (object) {
                return this.list.addAll(l);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean addAll(ShortList l) {
            Object object = this.sync;
            synchronized (object) {
                return this.list.addAll(l);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean addAll(int index, List l) {
            Object object = this.sync;
            synchronized (object) {
                return this.list.addAll(index, l);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean addAll(int index, ShortList l) {
            Object object = this.sync;
            synchronized (object) {
                return this.list.addAll(index, l);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void getElements(int from, short[] a, int offset, int length) {
            Object object = this.sync;
            synchronized (object) {
                this.list.getElements(from, a, offset, length);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void removeElements(int from, int to) {
            Object object = this.sync;
            synchronized (object) {
                this.list.removeElements(from, to);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void addElements(int index, short[] a, int offset, int length) {
            Object object = this.sync;
            synchronized (object) {
                this.list.addElements(index, a, offset, length);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void addElements(int index, short[] a) {
            Object object = this.sync;
            synchronized (object) {
                this.list.addElements(index, a);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void size(int size) {
            Object object = this.sync;
            synchronized (object) {
                this.list.size(size);
            }
        }

        public ListIterator listIterator() {
            return this.list.listIterator();
        }

        public ListIterator listIterator(int i) {
            return this.list.listIterator(i);
        }

        public ShortListIterator shortListIterator() {
            return this.list.shortListIterator();
        }

        public ShortListIterator shortListIterator(int i) {
            return this.list.shortListIterator(i);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public List subList(int from, int to) {
            Object object = this.sync;
            synchronized (object) {
                return new SynchronizedList((ShortList)this.list.subList(from, to), this.sync);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public ShortList shortSubList(int from, int to) {
            Object object = this.sync;
            synchronized (object) {
                return new SynchronizedList(this.list.shortSubList(from, to), this.sync);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean equals(Object o) {
            Object object = this.sync;
            synchronized (object) {
                return this.collection.equals(o);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public int hashCode() {
            Object object = this.sync;
            synchronized (object) {
                return this.collection.hashCode();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public int compareTo(Object o) {
            Object object = this.sync;
            synchronized (object) {
                return this.list.compareTo(o);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Object get(int i) {
            Object object = this.sync;
            synchronized (object) {
                return this.list.get(i);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void add(int i, Object k) {
            Object object = this.sync;
            synchronized (object) {
                this.list.add(i, k);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Object set(int index, Object k) {
            Object object = this.sync;
            synchronized (object) {
                return this.list.set(index, k);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Object remove(int i) {
            Object object = this.sync;
            synchronized (object) {
                return this.list.remove(i);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public int indexOf(Object o) {
            Object object = this.sync;
            synchronized (object) {
                return this.list.indexOf(o);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public int lastIndexOf(Object o) {
            Object object = this.sync;
            synchronized (object) {
                return this.list.lastIndexOf(o);
            }
        }
    }

    public static class Singleton
    extends AbstractShortList
    implements Serializable,
    Cloneable {
        public static final long serialVersionUID = -7046029254386353129L;
        private final short element;

        private Singleton(short element) {
            this.element = element;
        }

        public boolean rem(short k) {
            throw new UnsupportedOperationException();
        }

        public boolean add(short k) {
            throw new UnsupportedOperationException();
        }

        public void add(int i, short k) {
            throw new UnsupportedOperationException();
        }

        public short getShort(int i) {
            if (i == 0) {
                return this.element;
            }
            throw new IndexOutOfBoundsException();
        }

        public short removeShort(int i) {
            throw new UnsupportedOperationException();
        }

        public boolean contains(short k) {
            return k == this.element;
        }

        public boolean addAll(ShortList c) {
            throw new UnsupportedOperationException();
        }

        public boolean addAll(ShortCollection c) {
            throw new UnsupportedOperationException();
        }

        public boolean addAll(int i, ShortList c) {
            throw new UnsupportedOperationException();
        }

        public boolean addAll(int i, ShortCollection c) {
            throw new UnsupportedOperationException();
        }

        public boolean removeAll(ShortCollection c) {
            throw new UnsupportedOperationException();
        }

        public boolean retainAll(ShortCollection c) {
            throw new UnsupportedOperationException();
        }

        public boolean addAll(List c) {
            throw new UnsupportedOperationException();
        }

        public boolean addAll(Collection c) {
            throw new UnsupportedOperationException();
        }

        public boolean addAll(int i, List c) {
            throw new UnsupportedOperationException();
        }

        public boolean addAll(int i, Collection c) {
            throw new UnsupportedOperationException();
        }

        public boolean removeAll(Collection c) {
            throw new UnsupportedOperationException();
        }

        public boolean retainAll(Collection c) {
            throw new UnsupportedOperationException();
        }

        public short[] toShortArray() {
            short[] a = new short[]{this.element};
            return a;
        }

        public ShortListIterator shortListIterator() {
            return ShortIterators.wrap(this.toShortArray());
        }

        public ShortListIterator shortListIterator(int i) {
            if (i > 1 || i < 0) {
                throw new IndexOutOfBoundsException();
            }
            ShortListIterator l = ShortIterators.wrap(this.toShortArray());
            if (i == 1) {
                l.next();
            }
            return l;
        }

        public ShortList shortSubList(int from, int to) {
            this.ensureIndex(from);
            this.ensureIndex(to);
            if (from > to) {
                throw new IndexOutOfBoundsException("Start index (" + from + ") is greater than end index (" + to + ")");
            }
            if (from != 0 || to != 1) {
                return Lists.EMPTY_LIST;
            }
            return this;
        }

        public int size() {
            return 1;
        }

        public void size(int size) {
            throw new UnsupportedOperationException();
        }

        public void clear() {
            throw new UnsupportedOperationException();
        }

        public Object clone() {
            return this;
        }
    }
}

