/*
 * Decompiled with CFR 0.152.
 */
package it.unimi.dsi.fastutil.shorts;

import it.unimi.dsi.fastutil.Arrays;
import it.unimi.dsi.fastutil.shorts.AbstractShortList;
import it.unimi.dsi.fastutil.shorts.AbstractShortListIterator;
import it.unimi.dsi.fastutil.shorts.ShortArrays;
import it.unimi.dsi.fastutil.shorts.ShortCollection;
import it.unimi.dsi.fastutil.shorts.ShortIterator;
import it.unimi.dsi.fastutil.shorts.ShortIterators;
import it.unimi.dsi.fastutil.shorts.ShortList;
import it.unimi.dsi.fastutil.shorts.ShortListIterator;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.Collection;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.RandomAccess;

public class ShortArrayList
extends AbstractShortList
implements RandomAccess,
Cloneable,
Serializable {
    public static final int DEFAULT_INITIAL_CAPACITY = 16;
    protected static final long ONEOVERPHI = 106039L;
    protected transient short[] a;
    protected int size;
    public static final long serialVersionUID = -7046029254386353130L;
    private static final boolean ASSERTS = false;

    protected ShortArrayList(short[] a, boolean dummy) {
        this.a = a;
    }

    public ShortArrayList(int capacity) {
        if (capacity < 0) {
            throw new IllegalArgumentException("Initial capacity (" + capacity + ") is negative");
        }
        this.a = new short[capacity];
    }

    public ShortArrayList() {
        this(16);
    }

    public ShortArrayList(Collection c) {
        this(c.size());
        this.size = ShortIterators.unwrap(ShortIterators.asShortIterator(c.iterator()), this.a);
    }

    public ShortArrayList(ShortCollection c) {
        this(c.size());
        this.size = ShortIterators.unwrap(c.shortIterator(), this.a);
    }

    public ShortArrayList(ShortList l) {
        this(l.size());
        this.size = l.size();
        l.getElements(0, this.a, 0, this.size);
    }

    public ShortArrayList(short[] a) {
        this(a, 0, a.length);
    }

    public ShortArrayList(short[] a, int offset, int length) {
        this(length);
        System.arraycopy(a, offset, this.a, 0, length);
        this.size = length;
    }

    public ShortArrayList(Iterator i) {
        this(ShortIterators.asShortIterator(i));
    }

    public ShortArrayList(ShortIterator i) {
        this();
        while (i.hasNext()) {
            this.add(i.nextShort());
        }
    }

    public short[] elements() {
        return this.a;
    }

    public static ShortArrayList wrap(short[] a, int length) {
        if (length > a.length) {
            throw new IllegalArgumentException("The specified length (" + length + ") is greater than the array size (" + a.length + ")");
        }
        ShortArrayList l = new ShortArrayList(a, false);
        l.size = length;
        return l;
    }

    public static ShortArrayList wrap(short[] a) {
        return ShortArrayList.wrap(a, a.length);
    }

    public void ensureCapacity(int capacity) {
        this.a = ShortArrays.ensureCapacity(this.a, capacity, this.size);
    }

    public void add(int index, short k) {
        this.ensureIndex(index);
        this.a = ShortArrays.grow(this.a, this.size + 1, this.size);
        if (index != this.size) {
            System.arraycopy(this.a, index, this.a, index + 1, this.size - index);
        }
        this.a[index] = k;
        ++this.size;
    }

    public boolean add(short k) {
        this.a = ShortArrays.grow(this.a, this.size + 1, this.size);
        this.a[this.size++] = k;
        return true;
    }

    public boolean addAll(int index, ShortCollection c) {
        this.ensureIndex(index);
        int n = c.size();
        if (n == 0) {
            return false;
        }
        this.a = ShortArrays.grow(this.a, this.size + n, this.size);
        if (index != this.size) {
            System.arraycopy(this.a, index, this.a, index + n, this.size - index);
        }
        ShortIterator i = c.shortIterator();
        this.size += n;
        while (n-- != 0) {
            this.a[index++] = i.nextShort();
        }
        return true;
    }

    public boolean addAll(int index, ShortList l) {
        this.ensureIndex(index);
        int n = l.size();
        if (n == 0) {
            return false;
        }
        this.a = ShortArrays.grow(this.a, this.size + n, this.size);
        if (index != this.size) {
            System.arraycopy(this.a, index, this.a, index + n, this.size - index);
        }
        l.getElements(0, this.a, index, n);
        this.size += n;
        return true;
    }

    public boolean addAll(ShortList l) {
        return this.addAll(this.size, l);
    }

    public short getShort(int index) {
        if (index >= this.size) {
            throw new IndexOutOfBoundsException("Index (" + index + ") is greater than or equal to list size (" + this.size + ")");
        }
        return this.a[index];
    }

    public int indexOf(short k) {
        for (int i = 0; i < this.size; ++i) {
            if (k != this.a[i]) continue;
            return i;
        }
        return -1;
    }

    public int lastIndexOf(short k) {
        int i = this.size;
        while (i-- != 0) {
            if (k != this.a[i]) continue;
            return i;
        }
        return -1;
    }

    public short removeShort(int index) {
        if (index >= this.size) {
            throw new IndexOutOfBoundsException("Index (" + index + ") is greater than or equal to list size (" + this.size + ")");
        }
        short old = this.a[index];
        --this.size;
        if (index != this.size) {
            System.arraycopy(this.a, index + 1, this.a, index, this.size - index);
        }
        return old;
    }

    public boolean rem(short k) {
        int index = this.indexOf(k);
        if (index == -1) {
            return false;
        }
        this.removeShort(index);
        return true;
    }

    public short set(int index, short k) {
        if (index >= this.size) {
            throw new IndexOutOfBoundsException("Index (" + index + ") is greater than or equal to list size (" + this.size + ")");
        }
        short old = this.a[index];
        this.a[index] = k;
        return old;
    }

    public void clear() {
        this.size = 0;
    }

    public int size() {
        return this.size;
    }

    public void size(int size) {
        if (size > this.a.length) {
            this.ensureCapacity(size);
        }
        if (size > this.size) {
            for (int i = this.size; i < size; ++i) {
                this.a[i] = 0;
            }
        }
        this.size = size;
    }

    public boolean isEmpty() {
        return this.size == 0;
    }

    public void trim() {
        this.trim(0);
    }

    public void trim(int n) {
        if (n >= this.a.length || this.size == this.a.length) {
            return;
        }
        short[] t = new short[Math.max(n, this.size)];
        System.arraycopy(this.a, 0, t, 0, this.size);
        this.a = t;
    }

    public void getElements(int from, short[] a, int offset, int length) {
        ShortArrays.ensureOffsetLength(a, offset, length);
        System.arraycopy(this.a, from, a, offset, length);
    }

    public void removeElements(int from, int to) {
        Arrays.ensureFromTo(this.size, from, to);
        System.arraycopy(this.a, to, this.a, from, this.size - to);
        this.size -= to - from;
    }

    public void addElements(int index, short[] a, int offset, int length) {
        this.ensureIndex(index);
        ShortArrays.ensureOffsetLength(a, offset, length);
        this.a = ShortArrays.grow(this.a, this.size + length, this.size);
        System.arraycopy(this.a, index, this.a, index + length, this.size - index);
        System.arraycopy(a, offset, this.a, index, length);
        this.size += length;
    }

    public short[] toShortArray(short[] a) {
        if (a == null || a.length < this.size) {
            a = new short[this.size];
        }
        System.arraycopy(this.a, 0, a, 0, this.size);
        return a;
    }

    public ShortListIterator shortListIterator(final int index) {
        this.ensureIndex(index);
        return new AbstractShortListIterator(){
            int pos;
            int last;
            {
                this.pos = index;
                this.last = -1;
            }

            public boolean hasNext() {
                return this.pos < ShortArrayList.this.size;
            }

            public boolean hasPrevious() {
                return this.pos > 0;
            }

            public short nextShort() {
                if (!this.hasNext()) {
                    throw new NoSuchElementException();
                }
                this.last = this.pos++;
                return ShortArrayList.this.a[this.last];
            }

            public short previousShort() {
                if (!this.hasPrevious()) {
                    throw new NoSuchElementException();
                }
                this.last = --this.pos;
                return ShortArrayList.this.a[this.pos];
            }

            public int nextIndex() {
                return this.pos;
            }

            public int previousIndex() {
                return this.pos - 1;
            }

            public void add(short k) {
                if (this.last == -1) {
                    throw new IllegalStateException();
                }
                ShortArrayList.this.add(this.pos++, k);
                this.last = -1;
            }

            public void set(short k) {
                if (this.last == -1) {
                    throw new IllegalStateException();
                }
                ShortArrayList.this.set(this.last, k);
            }

            public void remove() {
                if (this.last == -1) {
                    throw new IllegalStateException();
                }
                ShortArrayList.this.removeShort(this.last);
                if (this.last < this.pos) {
                    --this.pos;
                }
                this.last = -1;
            }
        };
    }

    public Object clone() {
        ShortArrayList c = new ShortArrayList(this.size);
        System.arraycopy(this.a, 0, c.a, 0, this.size);
        c.size = this.size;
        return c;
    }

    private boolean valEquals(Object a, Object b) {
        return a == null ? b == null : a.equals(b);
    }

    public boolean equals(ShortArrayList l) {
        if (l == this) {
            return true;
        }
        int s = this.size();
        if (s != l.size()) {
            return false;
        }
        short[] a1 = this.a;
        short[] a2 = l.a;
        while (s-- != 0) {
            if (a1[s] == a2[s]) continue;
            return false;
        }
        return true;
    }

    public int compareTo(ShortArrayList l) {
        int i2;
        int s1 = this.size();
        int s2 = l.size();
        short[] a1 = this.a;
        short[] a2 = l.a;
        int i1 = 0;
        for (i2 = 0; i1 < s1 && i2 < s2; ++i1, ++i2) {
            int r;
            if ((a1[i1] < a2[i2] ? -1 : (r = a1[i1] == a2[i2] ? 0 : 1)) == 0) continue;
            return r;
        }
        return i2 < s2 ? -1 : (i1 < s1 ? 1 : 0);
    }

    private void writeObject(ObjectOutputStream s) throws IOException {
        s.defaultWriteObject();
        for (int i = 0; i < this.size; ++i) {
            s.writeShort(this.a[i]);
        }
    }

    private void readObject(ObjectInputStream s) throws IOException, ClassNotFoundException {
        s.defaultReadObject();
        this.a = new short[this.size];
        for (int i = 0; i < this.size; ++i) {
            this.a[i] = s.readShort();
        }
    }
}

