/*
 * Decompiled with CFR 0.152.
 */
package it.unimi.dsi.fastutil.shorts;

import it.unimi.dsi.fastutil.IndirectDoublePriorityQueue;
import it.unimi.dsi.fastutil.shorts.ShortArrayIndirectPriorityQueue;
import it.unimi.dsi.fastutil.shorts.ShortComparator;
import it.unimi.dsi.fastutil.shorts.ShortComparators;
import java.util.Comparator;

public class ShortArrayIndirectDoublePriorityQueue
extends ShortArrayIndirectPriorityQueue
implements IndirectDoublePriorityQueue {
    protected ShortComparator secondaryComparator;

    public ShortArrayIndirectDoublePriorityQueue(short[] refArray, int capacity, ShortComparator c, ShortComparator d) {
        super(refArray, capacity, c);
        this.secondaryComparator = d;
    }

    public ShortArrayIndirectDoublePriorityQueue(short[] refArray, int capacity, ShortComparator c) {
        super(refArray, capacity, c == null ? ShortComparators.OPPOSITE_COMPARATOR : ShortComparators.oppositeComparator(c));
    }

    public ShortArrayIndirectDoublePriorityQueue(short[] refArray, int capacity) {
        this(refArray, capacity, null);
    }

    public ShortArrayIndirectDoublePriorityQueue(short[] refArray, ShortComparator c, ShortComparator d) {
        this(refArray, refArray.length, c, d);
    }

    public ShortArrayIndirectDoublePriorityQueue(short[] refArray, ShortComparator c) {
        this(refArray, refArray.length, c);
    }

    public ShortArrayIndirectDoublePriorityQueue(short[] refArray) {
        this(refArray, refArray.length, null);
    }

    public ShortArrayIndirectDoublePriorityQueue(short[] refArray, int[] a, int size, ShortComparator c, ShortComparator d) {
        this(refArray, 0, c, d);
        this.array = a;
        this.size = size;
    }

    public ShortArrayIndirectDoublePriorityQueue(short[] refArray, int[] a, ShortComparator c, ShortComparator d) {
        this(refArray, a, a.length, c, d);
    }

    public ShortArrayIndirectDoublePriorityQueue(short[] refArray, int[] a, int size, ShortComparator c) {
        this(refArray, 0, c);
        this.array = a;
        this.size = size;
    }

    public ShortArrayIndirectDoublePriorityQueue(short[] refArray, int[] a, ShortComparator c) {
        this(refArray, a, a.length, c);
    }

    public ShortArrayIndirectDoublePriorityQueue(short[] refArray, int[] a, int size) {
        this(refArray, a, size, null);
    }

    public ShortArrayIndirectDoublePriorityQueue(short[] refArray, int[] a) {
        this(refArray, a, a.length);
    }

    private int findSecondaryFirst() {
        int i = this.size;
        int firstIndex = --i;
        short first = this.refArray[this.array[firstIndex]];
        if (this.secondaryComparator == null) {
            while (i-- != 0) {
                if (this.refArray[this.array[i]] >= first) continue;
                firstIndex = i;
                first = this.refArray[this.array[firstIndex]];
            }
        } else {
            while (i-- != 0) {
                if (this.secondaryComparator.compare(this.refArray[this.array[i]], first) >= 0) continue;
                firstIndex = i;
                first = this.refArray[this.array[firstIndex]];
            }
        }
        return firstIndex;
    }

    private int findSecondaryLast() {
        int i = this.size;
        int lastIndex = --i;
        short last = this.refArray[this.array[lastIndex]];
        if (this.secondaryComparator == null) {
            while (i-- != 0) {
                if (last >= this.refArray[this.array[i]]) continue;
                lastIndex = i;
                last = this.refArray[this.array[lastIndex]];
            }
        } else {
            while (i-- != 0) {
                if (this.secondaryComparator.compare(last, this.refArray[this.array[i]]) >= 0) continue;
                lastIndex = i;
                last = this.refArray[this.array[lastIndex]];
            }
        }
        return lastIndex;
    }

    public int secondaryFirst() {
        return this.array[this.findSecondaryFirst()];
    }

    public int secondaryLast() {
        return this.array[this.findSecondaryLast()];
    }

    public void changed(int i) {
    }

    public Comparator secondaryComparator() {
        return this.secondaryComparator;
    }
}

