/*
 * Decompiled with CFR 0.152.
 */
package it.unimi.dsi.fastutil.shorts;

import it.unimi.dsi.fastutil.shorts.Short2ShortMaps;
import it.unimi.dsi.fastutil.shorts.Short2ShortSortedMap;
import it.unimi.dsi.fastutil.shorts.ShortComparator;
import it.unimi.dsi.fastutil.shorts.ShortSortedSets;
import java.io.Serializable;
import java.util.Comparator;
import java.util.NoSuchElementException;
import java.util.Set;
import java.util.SortedMap;

public class Short2ShortSortedMaps {
    public static final EmptySortedMap EMPTY_MAP = new EmptySortedMap();

    private Short2ShortSortedMaps() {
    }

    public static Short2ShortSortedMap singleton(short key, short value) {
        return new Singleton(key, value);
    }

    public static Short2ShortSortedMap singleton(short key, short value, ShortComparator comparator) {
        return new Singleton(key, value, comparator);
    }

    public static Short2ShortSortedMap singleton(Object key, Object value) {
        return new Singleton((Short)key, (Short)value);
    }

    public static Short2ShortSortedMap singleton(Object key, Object value, ShortComparator comparator) {
        return new Singleton((Short)key, (Short)value, comparator);
    }

    public static Short2ShortSortedMap synchronize(Short2ShortSortedMap m) {
        return new SynchronizedSortedMap(m);
    }

    public static Short2ShortSortedMap synchronize(Short2ShortSortedMap m, Object sync) {
        return new SynchronizedSortedMap(m, sync);
    }

    public static Short2ShortSortedMap unmodifiable(Short2ShortSortedMap m) {
        return new UnmodifiableSortedMap(m);
    }

    public static class UnmodifiableSortedMap
    extends Short2ShortMaps.UnmodifiableMap
    implements Short2ShortSortedMap,
    Serializable {
        public static final long serialVersionUID = -7046029254386353129L;
        protected final Short2ShortSortedMap sortedMap;

        protected UnmodifiableSortedMap(Short2ShortSortedMap m) {
            super(m);
            this.sortedMap = m;
        }

        public Comparator comparator() {
            return this.sortedMap.comparator();
        }

        public Short2ShortSortedMap subMap(short from, short to) {
            return new UnmodifiableSortedMap(this.sortedMap.subMap(from, to));
        }

        public Short2ShortSortedMap headMap(short to) {
            return new UnmodifiableSortedMap(this.sortedMap.headMap(to));
        }

        public Short2ShortSortedMap tailMap(short from) {
            return new UnmodifiableSortedMap(this.sortedMap.tailMap(from));
        }

        public short firstShortKey() {
            return this.sortedMap.firstShortKey();
        }

        public short lastShortKey() {
            return this.sortedMap.lastShortKey();
        }

        public Object firstKey() {
            return this.sortedMap.firstKey();
        }

        public Object lastKey() {
            return this.sortedMap.lastKey();
        }

        public SortedMap subMap(Object from, Object to) {
            return new UnmodifiableSortedMap((Short2ShortSortedMap)this.sortedMap.subMap(from, to));
        }

        public SortedMap headMap(Object to) {
            return new UnmodifiableSortedMap((Short2ShortSortedMap)this.sortedMap.headMap(to));
        }

        public SortedMap tailMap(Object from) {
            return new UnmodifiableSortedMap((Short2ShortSortedMap)this.sortedMap.tailMap(from));
        }
    }

    public static class SynchronizedSortedMap
    extends Short2ShortMaps.SynchronizedMap
    implements Short2ShortSortedMap,
    Serializable {
        public static final long serialVersionUID = -7046029254386353129L;
        protected final Short2ShortSortedMap sortedMap;

        protected SynchronizedSortedMap(Short2ShortSortedMap m, Object sync) {
            super(m, sync);
            this.sortedMap = m;
        }

        protected SynchronizedSortedMap(Short2ShortSortedMap m) {
            super(m);
            this.sortedMap = m;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Comparator comparator() {
            Object object = this.sync;
            synchronized (object) {
                return this.sortedMap.comparator();
            }
        }

        public Short2ShortSortedMap subMap(short from, short to) {
            return new SynchronizedSortedMap(this.sortedMap.subMap(from, to), this.sync);
        }

        public Short2ShortSortedMap headMap(short to) {
            return new SynchronizedSortedMap(this.sortedMap.headMap(to), this.sync);
        }

        public Short2ShortSortedMap tailMap(short from) {
            return new SynchronizedSortedMap(this.sortedMap.tailMap(from), this.sync);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public short firstShortKey() {
            Object object = this.sync;
            synchronized (object) {
                return this.sortedMap.firstShortKey();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public short lastShortKey() {
            Object object = this.sync;
            synchronized (object) {
                return this.sortedMap.lastShortKey();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Object firstKey() {
            Object object = this.sync;
            synchronized (object) {
                return this.sortedMap.firstKey();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Object lastKey() {
            Object object = this.sync;
            synchronized (object) {
                return this.sortedMap.lastKey();
            }
        }

        public SortedMap subMap(Object from, Object to) {
            return new SynchronizedSortedMap((Short2ShortSortedMap)this.sortedMap.subMap(from, to), this.sync);
        }

        public SortedMap headMap(Object to) {
            return new SynchronizedSortedMap((Short2ShortSortedMap)this.sortedMap.headMap(to), this.sync);
        }

        public SortedMap tailMap(Object from) {
            return new SynchronizedSortedMap((Short2ShortSortedMap)this.sortedMap.tailMap(from), this.sync);
        }
    }

    public static class Singleton
    extends Short2ShortMaps.Singleton
    implements Short2ShortSortedMap,
    Serializable,
    Cloneable {
        public static final long serialVersionUID = -7046029254386353129L;
        protected final ShortComparator comparator;

        protected Singleton(short key, short value, ShortComparator comparator) {
            super(key, value);
            this.comparator = comparator;
        }

        protected Singleton(short key, short value) {
            this(key, value, null);
        }

        final int compare(short k1, short k2) {
            return this.comparator == null ? (k1 < k2 ? -1 : (k1 == k2 ? 0 : 1)) : this.comparator.compare(k1, k2);
        }

        public Comparator comparator() {
            return this.comparator;
        }

        public Set keySet() {
            if (this.keys == null) {
                this.keys = ShortSortedSets.singleton(this.key, this.comparator);
            }
            return this.keys;
        }

        public Short2ShortSortedMap subMap(short from, short to) {
            if (this.compare(from, this.key) <= 0 && this.compare(this.key, to) < 0) {
                return this;
            }
            return EMPTY_MAP;
        }

        public Short2ShortSortedMap headMap(short to) {
            if (this.compare(this.key, to) < 0) {
                return this;
            }
            return EMPTY_MAP;
        }

        public Short2ShortSortedMap tailMap(short from) {
            if (this.compare(from, this.key) <= 0) {
                return this;
            }
            return EMPTY_MAP;
        }

        public short firstShortKey() {
            return this.key;
        }

        public short lastShortKey() {
            return this.key;
        }

        public SortedMap headMap(Object oto) {
            return this.headMap((Short)oto);
        }

        public SortedMap tailMap(Object ofrom) {
            return this.tailMap((Short)ofrom);
        }

        public SortedMap subMap(Object ofrom, Object oto) {
            return this.subMap((Short)ofrom, (Short)oto);
        }

        public Object firstKey() {
            return new Short(this.firstShortKey());
        }

        public Object lastKey() {
            return new Short(this.lastShortKey());
        }
    }

    public static class EmptySortedMap
    extends Short2ShortMaps.EmptyMap
    implements Short2ShortSortedMap,
    Serializable,
    Cloneable {
        public static final long serialVersionUID = -7046029254386353129L;

        protected EmptySortedMap() {
        }

        public Comparator comparator() {
            return null;
        }

        public Short2ShortSortedMap subMap(short from, short to) {
            return EMPTY_MAP;
        }

        public Short2ShortSortedMap headMap(short to) {
            return EMPTY_MAP;
        }

        public Short2ShortSortedMap tailMap(short from) {
            return EMPTY_MAP;
        }

        public short firstShortKey() {
            throw new NoSuchElementException();
        }

        public short lastShortKey() {
            throw new NoSuchElementException();
        }

        public SortedMap headMap(Object oto) {
            return this.headMap((Short)oto);
        }

        public SortedMap tailMap(Object ofrom) {
            return this.tailMap((Short)ofrom);
        }

        public SortedMap subMap(Object ofrom, Object oto) {
            return this.subMap((Short)ofrom, (Short)oto);
        }

        public Object firstKey() {
            return new Short(this.firstShortKey());
        }

        public Object lastKey() {
            return new Short(this.lastShortKey());
        }
    }
}

