/*
 * Decompiled with CFR 0.152.
 */
package it.unimi.dsi.fastutil.shorts;

import it.unimi.dsi.fastutil.Sets;
import it.unimi.dsi.fastutil.objects.ObjectSet;
import it.unimi.dsi.fastutil.objects.ObjectSets;
import it.unimi.dsi.fastutil.shorts.AbstractShort2ShortMap;
import it.unimi.dsi.fastutil.shorts.Short2ShortMap;
import it.unimi.dsi.fastutil.shorts.ShortCollection;
import it.unimi.dsi.fastutil.shorts.ShortCollections;
import it.unimi.dsi.fastutil.shorts.ShortSet;
import it.unimi.dsi.fastutil.shorts.ShortSets;
import java.io.Serializable;
import java.util.Collection;
import java.util.Map;
import java.util.Set;

public class Short2ShortMaps {
    public static final EmptyMap EMPTY_MAP = new EmptyMap();

    private Short2ShortMaps() {
    }

    public static Short2ShortMap singleton(short key, short value) {
        return new Singleton(key, value);
    }

    public static Short2ShortMap singleton(Object key, Object value) {
        return new Singleton((Short)key, (Short)value);
    }

    public static Short2ShortMap synchronize(Short2ShortMap m) {
        return new SynchronizedMap(m);
    }

    public static Short2ShortMap synchronize(Short2ShortMap m, Object sync) {
        return new SynchronizedMap(m, sync);
    }

    public static Short2ShortMap unmodifiable(Short2ShortMap m) {
        return new UnmodifiableMap(m);
    }

    public static class UnmodifiableMap
    extends AbstractShort2ShortMap
    implements Short2ShortMap,
    Serializable {
        public static final long serialVersionUID = -7046029254386353129L;
        protected final Short2ShortMap map;
        protected volatile transient Set entries;
        protected volatile transient Set keys;
        protected volatile transient Collection values;

        protected UnmodifiableMap(Short2ShortMap m) {
            if (m == null) {
                throw new NullPointerException();
            }
            this.map = m;
        }

        public Object remove(Object ok) {
            throw new UnsupportedOperationException();
        }

        public Object get(Object ok) {
            return this.map.get(ok);
        }

        public int size() {
            return this.map.size();
        }

        public boolean containsKey(short k) {
            return this.map.containsKey(k);
        }

        public boolean containsValue(short v) {
            return this.map.containsValue(v);
        }

        public short defaultReturnValue() {
            throw new UnsupportedOperationException();
        }

        public void defaultReturnValue(short defRetValue) {
            throw new UnsupportedOperationException();
        }

        public short put(short k, short v) {
            throw new UnsupportedOperationException();
        }

        public void putAll(Short2ShortMap c) {
            throw new UnsupportedOperationException();
        }

        public void putAll(Map m) {
            throw new UnsupportedOperationException();
        }

        public Set entrySet() {
            if (this.entries == null) {
                this.entries = ObjectSets.unmodifiable((ObjectSet)this.map.entrySet());
            }
            return this.entries;
        }

        public Set keySet() {
            if (this.keys == null) {
                this.keys = ShortSets.unmodifiable((ShortSet)this.map.keySet());
            }
            return this.keys;
        }

        public Collection values() {
            if (this.values == null) {
                return ShortCollections.unmodifiable((ShortCollection)this.map.values());
            }
            return this.values;
        }

        public void clear() {
            throw new UnsupportedOperationException();
        }

        public String toString() {
            return this.map.toString();
        }

        public Object put(Object k, Object v) {
            throw new UnsupportedOperationException();
        }

        public short remove(short k) {
            throw new UnsupportedOperationException();
        }

        public short get(short k) {
            return this.map.get(k);
        }

        public boolean containsKey(Object ok) {
            return this.map.containsKey(ok);
        }

        public boolean containsValue(Object ov) {
            return this.map.containsValue(ov);
        }
    }

    public static class SynchronizedMap
    extends AbstractShort2ShortMap
    implements Short2ShortMap,
    Serializable {
        public static final long serialVersionUID = -7046029254386353129L;
        protected final Short2ShortMap map;
        protected final Object sync;
        protected volatile transient Set entries;
        protected volatile transient Set keys;
        protected volatile transient Collection values;

        protected SynchronizedMap(Short2ShortMap m, Object sync) {
            if (m == null) {
                throw new NullPointerException();
            }
            this.map = m;
            this.sync = sync;
        }

        protected SynchronizedMap(Short2ShortMap m) {
            if (m == null) {
                throw new NullPointerException();
            }
            this.map = m;
            this.sync = this;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Object remove(Object ok) {
            Object object = this.sync;
            synchronized (object) {
                return this.map.remove(ok);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Object get(Object ok) {
            Object object = this.sync;
            synchronized (object) {
                return this.map.get(ok);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public int size() {
            Object object = this.sync;
            synchronized (object) {
                return this.map.size();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean containsKey(short k) {
            Object object = this.sync;
            synchronized (object) {
                return this.map.containsKey(k);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean containsValue(short v) {
            Object object = this.sync;
            synchronized (object) {
                return this.map.containsValue(v);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public short defaultReturnValue() {
            Object object = this.sync;
            synchronized (object) {
                return this.map.defaultReturnValue();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void defaultReturnValue(short defRetValue) {
            Object object = this.sync;
            synchronized (object) {
                this.map.defaultReturnValue(defRetValue);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public short put(short k, short v) {
            Object object = this.sync;
            synchronized (object) {
                return this.map.put(k, v);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void putAll(Short2ShortMap c) {
            Object object = this.sync;
            synchronized (object) {
                this.map.putAll(c);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void putAll(Map m) {
            Object object = this.sync;
            synchronized (object) {
                this.map.putAll(m);
            }
        }

        public Set entrySet() {
            if (this.entries == null) {
                this.entries = ObjectSets.synchronize((ObjectSet)this.map.entrySet(), this.sync);
            }
            return this.entries;
        }

        public Set keySet() {
            if (this.keys == null) {
                this.keys = ShortSets.synchronize((ShortSet)this.map.keySet(), this.sync);
            }
            return this.keys;
        }

        public Collection values() {
            if (this.values == null) {
                return ShortCollections.synchronize((ShortCollection)this.map.values(), this.sync);
            }
            return this.values;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void clear() {
            Object object = this.sync;
            synchronized (object) {
                this.map.clear();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public String toString() {
            Object object = this.sync;
            synchronized (object) {
                return this.map.toString();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Object put(Object k, Object v) {
            Object object = this.sync;
            synchronized (object) {
                return this.map.put(k, v);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public short remove(short k) {
            Object object = this.sync;
            synchronized (object) {
                return this.map.remove(k);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public short get(short k) {
            Object object = this.sync;
            synchronized (object) {
                return this.map.get(k);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean containsKey(Object ok) {
            Object object = this.sync;
            synchronized (object) {
                return this.map.containsKey(ok);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean containsValue(Object ov) {
            Object object = this.sync;
            synchronized (object) {
                return this.map.containsValue(ov);
            }
        }
    }

    public static class Singleton
    extends AbstractShort2ShortMap
    implements Serializable,
    Cloneable {
        public static final long serialVersionUID = -7046029254386353129L;
        protected final short key;
        protected final short value;
        protected volatile transient Set entries;
        protected volatile transient Set keys;
        protected volatile transient Collection values;

        protected Singleton(short key, short value) {
            this.key = key;
            this.value = value;
        }

        public boolean containsKey(short k) {
            return this.key == k;
        }

        public boolean containsValue(short v) {
            return this.value == v;
        }

        public void putAll(Map m) {
            throw new UnsupportedOperationException();
        }

        public Set entrySet() {
            if (this.entries == null) {
                this.entries = ObjectSets.singleton(new SingletonEntry());
            }
            return this.entries;
        }

        public Set keySet() {
            if (this.keys == null) {
                this.keys = ShortSets.singleton(this.key);
            }
            return this.keys;
        }

        public Collection values() {
            if (this.values == null) {
                this.values = ShortSets.singleton(this.value);
            }
            return this.values;
        }

        public short get(short k) {
            if (this.key == k) {
                return this.value;
            }
            return this.defRetValue;
        }

        public int size() {
            return 1;
        }

        public Object clone() {
            return this;
        }

        private class SingletonEntry
        implements Short2ShortMap.Entry {
            private SingletonEntry() {
            }

            public Object getKey() {
                return new Short(Singleton.this.key);
            }

            public Object getValue() {
                return new Short(Singleton.this.value);
            }

            public short getShortKey() {
                return Singleton.this.key;
            }

            public short getShortValue() {
                return Singleton.this.value;
            }

            public short setValue(short value) {
                throw new UnsupportedOperationException();
            }

            public Object setValue(Object value) {
                throw new UnsupportedOperationException();
            }

            public boolean equals(Object o) {
                if (!(o instanceof Map.Entry)) {
                    return false;
                }
                Map.Entry e = (Map.Entry)o;
                return Singleton.this.key == (Short)e.getKey() && Singleton.this.value == (Short)e.getValue();
            }

            public int hashCode() {
                return Singleton.this.key ^ Singleton.this.value;
            }

            public String toString() {
                return Singleton.this.key + "->" + Singleton.this.value;
            }
        }
    }

    public static class EmptyMap
    extends AbstractShort2ShortMap
    implements Serializable,
    Cloneable {
        public static final long serialVersionUID = -7046029254386353129L;

        protected EmptyMap() {
        }

        public short put(short k, short v) {
            throw new UnsupportedOperationException();
        }

        public Object get(Object ok) {
            return null;
        }

        public boolean containsKey(short k) {
            return false;
        }

        public boolean containsValue(short v) {
            return false;
        }

        public short defaultReturnValue() {
            return 0;
        }

        public void defaultReturnValue(short defRetValue) {
            throw new UnsupportedOperationException();
        }

        public void putAll(Map m) {
            throw new UnsupportedOperationException();
        }

        public Set entrySet() {
            return Sets.EMPTY_SET;
        }

        public Set keySet() {
            return Sets.EMPTY_SET;
        }

        public Collection values() {
            return Sets.EMPTY_SET;
        }

        public Object put(Object k, Object v) {
            throw new UnsupportedOperationException();
        }

        public short get(short k) {
            return 0;
        }

        public boolean containsKey(Object ok) {
            return false;
        }

        public boolean containsValue(Object ov) {
            return false;
        }

        public int size() {
            return 0;
        }

        public void clear() {
        }

        private Object readResolve() {
            return EMPTY_MAP;
        }

        public Object clone() {
            return EMPTY_MAP;
        }
    }
}

