/*
 * Decompiled with CFR 0.152.
 */
package it.unimi.dsi.fastutil.shorts;

import it.unimi.dsi.fastutil.Hash;
import it.unimi.dsi.fastutil.bytes.AbstractByteCollection;
import it.unimi.dsi.fastutil.bytes.ByteArrays;
import it.unimi.dsi.fastutil.bytes.ByteCollection;
import it.unimi.dsi.fastutil.bytes.ByteIterator;
import it.unimi.dsi.fastutil.objects.AbstractObjectIterator;
import it.unimi.dsi.fastutil.objects.AbstractObjectSet;
import it.unimi.dsi.fastutil.objects.ObjectIterator;
import it.unimi.dsi.fastutil.objects.ObjectSet;
import it.unimi.dsi.fastutil.shorts.AbstractShort2ByteMap;
import it.unimi.dsi.fastutil.shorts.AbstractShortSet;
import it.unimi.dsi.fastutil.shorts.Short2ByteMap;
import it.unimi.dsi.fastutil.shorts.ShortIterator;
import it.unimi.dsi.fastutil.shorts.ShortSet;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;

public class Short2ByteOpenHashMap
extends AbstractShort2ByteMap
implements Serializable,
Cloneable,
Hash,
Short2ByteMap {
    protected transient short[] key;
    protected transient byte[] value;
    protected transient byte[] state;
    protected final float f;
    protected transient int p;
    protected transient int maxFill;
    protected transient int free;
    protected int count;
    protected volatile transient ObjectSet entries;
    protected volatile transient ShortSet keys;
    protected volatile transient ByteCollection values;
    protected transient int growthFactor = 16;
    public static final long serialVersionUID = -7046029254386353129L;
    private static final boolean ASSERTS = false;

    public Short2ByteOpenHashMap(int n, float f) {
        if (f <= 0.0f || f > 1.0f) {
            throw new IllegalArgumentException("Load factor must be greater than 0 and smaller than or equal to 1");
        }
        if (n < 0) {
            throw new IllegalArgumentException("Hash table size must be nonnegative");
        }
        int l = Arrays.binarySearch(PRIMES, (int)((float)n / f) + 1);
        if (l < 0) {
            l = -l - 1;
        }
        this.p = l;
        this.free = PRIMES[this.p];
        this.f = f;
        this.maxFill = (int)((float)this.free * f);
        this.key = new short[this.free];
        this.value = new byte[this.free];
        this.state = new byte[this.free];
    }

    public Short2ByteOpenHashMap(int n) {
        this(n, 0.75f);
    }

    public Short2ByteOpenHashMap() {
        this(16, 0.75f);
    }

    public Short2ByteOpenHashMap(Map m, float f) {
        this(m.size(), f);
        this.putAll(m);
    }

    public Short2ByteOpenHashMap(Map m) {
        this(m, 0.75f);
    }

    public Short2ByteOpenHashMap(Short2ByteMap m, float f) {
        this(m.size(), f);
        this.putAll((Map)m);
    }

    public Short2ByteOpenHashMap(Short2ByteMap m) {
        this(m, 0.75f);
    }

    public void growthFactor(int growthFactor) {
        if (growthFactor <= 0) {
            throw new IllegalArgumentException("Illegal growth factor " + growthFactor);
        }
        this.growthFactor = growthFactor;
    }

    public int growthFactor() {
        return this.growthFactor;
    }

    private int findInsertionPoint(short k) {
        byte[] state = this.state;
        int k2i = k & Integer.MAX_VALUE;
        short[] key = this.key;
        int n = key.length;
        int h1 = k2i % n;
        if (state[h1] == -1 && k != key[h1]) {
            int h2 = k2i % (n - 2) + 1;
            while (state[h1 = (h1 + h2) % n] == -1 && k != key[h1]) {
            }
        }
        if (state[h1] == 0) {
            return h1;
        }
        if (state[h1] == -1) {
            return -h1 - 1;
        }
        int i = h1;
        if (state[h1] != 0 && k != key[h1]) {
            int h2 = k2i % (n - 2) + 1;
            while (state[h1 = (h1 + h2) % n] != 0 && k != key[h1]) {
            }
        }
        return state[h1] == -1 ? -h1 - 1 : i;
    }

    private int findKey(short k) {
        byte[] state = this.state;
        int k2i = k & Integer.MAX_VALUE;
        short[] key = this.key;
        int n = key.length;
        int h1 = k2i % n;
        if (state[h1] != 0 && k != key[h1]) {
            int h2 = k2i % (n - 2) + 1;
            while (state[h1 = (h1 + h2) % n] != 0 && k != key[h1]) {
            }
        }
        return state[h1] == -1 ? h1 : -1;
    }

    public byte put(short k, byte v) {
        int i = this.findInsertionPoint(k);
        if (i < 0) {
            byte oldValue = this.value[-i - 1];
            this.value[-i - 1] = v;
            return oldValue;
        }
        if (this.state[i] == 0) {
            --this.free;
        }
        this.state[i] = -1;
        this.key[i] = k;
        this.value[i] = v;
        if (++this.count >= this.maxFill) {
            int newP = Math.min(this.p + this.growthFactor, PRIMES.length - 1);
            while (PRIMES[newP] == PRIMES[this.p]) {
                ++newP;
            }
            this.rehash(newP);
        }
        if (this.free == 0) {
            this.rehash(this.p);
        }
        return this.defRetValue;
    }

    public Object put(Object ok, Object ov) {
        byte v = (Byte)ov;
        short k = (Short)ok;
        int i = this.findInsertionPoint(k);
        if (i < 0) {
            byte oldValue = this.value[-i - 1];
            this.value[-i - 1] = v;
            return new Byte(oldValue);
        }
        if (this.state[i] == 0) {
            --this.free;
        }
        this.state[i] = -1;
        this.key[i] = k;
        this.value[i] = v;
        if (++this.count >= this.maxFill) {
            this.rehash(Math.min(this.p + 16, PRIMES.length - 1));
        }
        if (this.free == 0) {
            this.rehash(this.p);
        }
        return null;
    }

    public boolean containsValue(byte v) {
        byte[] value = this.value;
        byte[] state = this.state;
        int i = 0;
        int j = this.count;
        while (j-- != 0) {
            while (state[i] != -1) {
                ++i;
            }
            if (value[i] == v) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public void clear() {
        if (this.free == this.state.length) {
            return;
        }
        this.free = this.state.length;
        this.count = 0;
        ByteArrays.fill(this.state, (byte)0);
    }

    public boolean containsKey(short k) {
        return this.findKey(k) >= 0;
    }

    public int size() {
        return this.count;
    }

    public boolean isEmpty() {
        return this.count == 0;
    }

    public byte get(short k) {
        int i = this.findKey(k);
        return i < 0 ? this.defRetValue : this.value[i];
    }

    public byte remove(short k) {
        int i = this.findKey(k);
        if (i < 0) {
            return this.defRetValue;
        }
        this.state[i] = 1;
        --this.count;
        return this.value[i];
    }

    public Object get(Object ok) {
        int i = this.findKey((Short)ok);
        return i < 0 ? null : new Byte(this.value[i]);
    }

    public Object remove(Object ok) {
        short k = (Short)ok;
        int i = this.findKey(k);
        if (i < 0) {
            return null;
        }
        this.state[i] = 1;
        --this.count;
        return new Byte(this.value[i]);
    }

    public Set entrySet() {
        if (this.entries == null) {
            this.entries = new AbstractObjectSet(){

                public ObjectIterator objectIterator() {
                    return new MapIterator();
                }

                public boolean contains(Object o) {
                    if (!(o instanceof Map.Entry)) {
                        return false;
                    }
                    Map.Entry e = (Map.Entry)o;
                    int i = Short2ByteOpenHashMap.this.findKey((Short)e.getKey());
                    return i >= 0 && Short2ByteOpenHashMap.this.value[i] == (Byte)e.getValue();
                }

                public boolean remove(Object o) {
                    if (!(o instanceof Map.Entry)) {
                        return false;
                    }
                    Map.Entry e = (Map.Entry)o;
                    int i = Short2ByteOpenHashMap.this.findKey((Short)e.getKey());
                    if (i >= 0) {
                        Short2ByteOpenHashMap.this.remove(e.getKey());
                    }
                    return i >= 0;
                }

                public int size() {
                    return Short2ByteOpenHashMap.this.count;
                }

                public void clear() {
                    Short2ByteOpenHashMap.this.clear();
                }
            };
        }
        return this.entries;
    }

    public Set keySet() {
        if (this.keys == null) {
            this.keys = new KeySet();
        }
        return this.keys;
    }

    public Collection values() {
        if (this.values == null) {
            this.values = new AbstractByteCollection(){

                public ByteIterator byteIterator() {
                    return new ValueIterator();
                }

                public int size() {
                    return Short2ByteOpenHashMap.this.count;
                }

                public boolean contains(byte v) {
                    return Short2ByteOpenHashMap.this.containsValue(v);
                }

                public void clear() {
                    Short2ByteOpenHashMap.this.clear();
                }
            };
        }
        return this.values;
    }

    public boolean rehash() {
        try {
            this.rehash(this.p);
        }
        catch (OutOfMemoryError cantDoIt) {
            return false;
        }
        return true;
    }

    public boolean trim() {
        int l = Arrays.binarySearch(PRIMES, (int)((float)this.count / this.f) + 1);
        if (l < 0) {
            l = -l - 1;
        }
        if (l >= this.p) {
            return true;
        }
        try {
            this.rehash(l);
        }
        catch (OutOfMemoryError cantDoIt) {
            return false;
        }
        return true;
    }

    public boolean trim(int n) {
        int l = Arrays.binarySearch(PRIMES, (int)Math.min(2.1474836E9f, (float)Math.max(n, this.count) / this.f) + 1);
        if (l < 0) {
            l = -l - 1;
        }
        if (this.p <= l) {
            return true;
        }
        try {
            this.rehash(l);
        }
        catch (OutOfMemoryError cantDoIt) {
            return false;
        }
        return true;
    }

    protected void rehash(int newP) {
        int i = 0;
        int j = this.count;
        int newN = PRIMES[newP];
        short[] key = this.key;
        short[] newKey = new short[newN];
        byte[] value = this.value;
        byte[] newValue = new byte[newN];
        byte[] state = this.state;
        byte[] newState = new byte[newN];
        while (j-- != 0) {
            while (state[i] != -1) {
                ++i;
            }
            short k = key[i];
            byte v = value[i];
            int k2i = k & Integer.MAX_VALUE;
            int h1 = k2i % newN;
            int h2 = k2i % (newN - 2) + 1;
            if (newState[h1] != 0) {
                h2 = k2i % (newN - 2) + 1;
                while (newState[h1 = (h1 + h2) % newN] != 0) {
                }
            }
            newState[h1] = -1;
            newKey[h1] = k;
            newValue[h1] = v;
            ++i;
        }
        this.p = newP;
        this.free = newN - this.count;
        this.maxFill = (int)((float)newN * this.f);
        this.key = newKey;
        this.value = newValue;
        this.state = newState;
    }

    public Object clone() {
        Short2ByteOpenHashMap c;
        try {
            c = (Short2ByteOpenHashMap)super.clone();
        }
        catch (CloneNotSupportedException cantHappen) {
            throw new InternalError();
        }
        c.keys = null;
        c.values = null;
        c.entries = null;
        c.key = (short[])this.key.clone();
        c.value = (byte[])this.value.clone();
        c.state = (byte[])this.state.clone();
        return c;
    }

    public int hashCode() {
        int h = 0;
        int i = 0;
        int j = this.count;
        while (j-- != 0) {
            while (this.state[i] != -1) {
                ++i;
            }
            int t = 0;
            t = this.key[i];
            h += (t ^= this.value[i]);
            ++i;
        }
        return h;
    }

    private void writeObject(ObjectOutputStream s) throws IOException {
        short[] key = this.key;
        byte[] value = this.value;
        byte[] state = this.state;
        MapIterator i = new MapIterator();
        int j = this.count;
        s.defaultWriteObject();
        while (j-- != 0) {
            int e = i.nextEntry();
            s.writeShort(key[e]);
            s.writeByte(value[e]);
        }
    }

    private void checkTable() {
        int n = this.state.length;
        while (n-- != 0) {
            if (this.state[n] == -1 && !this.containsKey(this.key[n])) {
                throw new AssertionError((Object)("Hash table has key " + this.key[n] + " marked as occupied, but the key does not belong to the table"));
            }
        }
    }

    private void readObject(ObjectInputStream s) throws IOException, ClassNotFoundException {
        s.defaultReadObject();
        this.growthFactor = 16;
        this.p = Arrays.binarySearch(PRIMES, (int)((float)this.count / this.f) + 1);
        if (this.p < 0) {
            this.p = -this.p - 1;
        }
        int n = PRIMES[this.p];
        this.maxFill = (int)((float)n * this.f);
        this.free = n - this.count;
        this.key = new short[n];
        short[] key = this.key;
        this.value = new byte[n];
        byte[] value = this.value;
        this.state = new byte[n];
        byte[] state = this.state;
        int i = this.count;
        while (i-- != 0) {
            short k = s.readShort();
            byte v = s.readByte();
            int k2i = k & Integer.MAX_VALUE;
            int h1 = k2i % n;
            if (state[h1] != 0) {
                int h2 = k2i % (n - 2) + 1;
                while (state[h1 = (h1 + h2) % n] != 0) {
                }
            }
            state[h1] = -1;
            key[h1] = k;
            value[h1] = v;
        }
    }

    private final class ValueIterator
    extends MapIterator
    implements ByteIterator {
        public byte nextByte() {
            return Short2ByteOpenHashMap.this.value[this.nextEntry()];
        }

        public Object next() {
            return new Byte(Short2ByteOpenHashMap.this.value[this.nextEntry()]);
        }

        public void set(byte v) {
            throw new UnsupportedOperationException();
        }

        public void add(byte v) {
            throw new UnsupportedOperationException();
        }
    }

    private final class KeySet
    extends AbstractShortSet {
        private KeySet() {
        }

        public ShortIterator shortIterator() {
            return new KeyIterator();
        }

        public int size() {
            return Short2ByteOpenHashMap.this.count;
        }

        public boolean contains(short k) {
            return Short2ByteOpenHashMap.this.containsKey(k);
        }

        public boolean remove(short k) {
            int oldCount = Short2ByteOpenHashMap.this.count;
            Short2ByteOpenHashMap.this.remove(k);
            return Short2ByteOpenHashMap.this.count != oldCount;
        }

        public void clear() {
            Short2ByteOpenHashMap.this.clear();
        }
    }

    private final class KeyIterator
    extends MapIterator
    implements ShortIterator {
        public short nextShort() {
            return Short2ByteOpenHashMap.this.key[this.nextEntry()];
        }

        public Object next() {
            return new Short(Short2ByteOpenHashMap.this.key[this.nextEntry()]);
        }

        public void set(short k) {
            throw new UnsupportedOperationException();
        }

        public void add(short k) {
            throw new UnsupportedOperationException();
        }
    }

    private class MapIterator
    extends AbstractObjectIterator {
        int pos = 0;
        int last = -1;
        int c;

        private MapIterator() {
            this.c = Short2ByteOpenHashMap.this.count;
            byte[] state = Short2ByteOpenHashMap.this.state;
            int n = state.length;
            if (this.c != 0) {
                while (this.pos < n && state[this.pos] != -1) {
                    ++this.pos;
                }
            }
        }

        public boolean hasNext() {
            return this.c != 0 && this.pos < Short2ByteOpenHashMap.this.state.length;
        }

        public int nextEntry() {
            byte[] state = Short2ByteOpenHashMap.this.state;
            int n = state.length;
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            this.last = this.pos;
            if (--this.c != 0) {
                do {
                    ++this.pos;
                } while (this.pos < n && state[this.pos] != -1);
            }
            return this.last;
        }

        public Object next() {
            return new MapEntry(this.nextEntry());
        }

        public void remove() {
            if (this.last == -1) {
                throw new IllegalStateException();
            }
            Short2ByteOpenHashMap.this.state[this.last] = 1;
            --Short2ByteOpenHashMap.this.count;
        }
    }

    private final class MapEntry
    implements Short2ByteMap.Entry {
        private int index;

        MapEntry(int index) {
            this.index = index;
        }

        public Object getKey() {
            return new Short(Short2ByteOpenHashMap.this.key[this.index]);
        }

        public short getShortKey() {
            return Short2ByteOpenHashMap.this.key[this.index];
        }

        public Object getValue() {
            return new Byte(Short2ByteOpenHashMap.this.value[this.index]);
        }

        public byte getByteValue() {
            return Short2ByteOpenHashMap.this.value[this.index];
        }

        public byte setValue(byte v) {
            byte oldValue = Short2ByteOpenHashMap.this.value[this.index];
            Short2ByteOpenHashMap.this.value[this.index] = v;
            return oldValue;
        }

        public Object setValue(Object v) {
            return new Byte(this.setValue((Byte)v));
        }

        public boolean equals(Object o) {
            if (!(o instanceof Map.Entry)) {
                return false;
            }
            Map.Entry e = (Map.Entry)o;
            return Short2ByteOpenHashMap.this.key[this.index] == (Short)e.getKey() && Short2ByteOpenHashMap.this.value[this.index] == (Byte)e.getValue();
        }

        public int hashCode() {
            return Short2ByteOpenHashMap.this.key[this.index] ^ Short2ByteOpenHashMap.this.value[this.index];
        }

        public String toString() {
            return Short2ByteOpenHashMap.this.key[this.index] + "->" + Short2ByteOpenHashMap.this.value[this.index];
        }
    }
}

