/*
 * Decompiled with CFR 0.152.
 */
package it.unimi.dsi.fastutil.shorts;

import it.unimi.dsi.fastutil.objects.ObjectIterators;
import it.unimi.dsi.fastutil.shorts.ShortCollection;
import it.unimi.dsi.fastutil.shorts.ShortIterator;
import it.unimi.dsi.fastutil.shorts.ShortIterators;
import java.lang.reflect.Array;
import java.util.Collection;
import java.util.Iterator;

public abstract class AbstractShortCollection
implements ShortCollection {
    protected AbstractShortCollection() {
    }

    public short[] toArray(short[] a) {
        return this.toShortArray(a);
    }

    public short[] toShortArray() {
        return this.toShortArray(null);
    }

    public short[] toShortArray(short[] a) {
        if (a == null || a.length < this.size()) {
            a = new short[this.size()];
        }
        ShortIterators.unwrap(this.shortIterator(), a);
        return a;
    }

    public boolean addAll(ShortCollection c) {
        boolean retVal = false;
        ShortIterator i = c.shortIterator();
        int n = c.size();
        while (n-- != 0) {
            if (!this.add(i.nextShort())) continue;
            retVal = true;
        }
        return retVal;
    }

    public boolean containsAll(ShortCollection c) {
        ShortIterator i = c.shortIterator();
        int n = c.size();
        while (n-- != 0) {
            if (this.contains(i.nextShort())) continue;
            return false;
        }
        return true;
    }

    public boolean retainAll(ShortCollection c) {
        boolean retVal = false;
        int n = this.size();
        ShortIterator i = this.shortIterator();
        while (n-- != 0) {
            if (c.contains(i.nextShort())) continue;
            i.remove();
            retVal = true;
        }
        return retVal;
    }

    public boolean removeAll(ShortCollection c) {
        boolean retVal = false;
        int n = c.size();
        ShortIterator i = c.shortIterator();
        while (n-- != 0) {
            if (!this.rem(i.nextShort())) continue;
            retVal = true;
        }
        return retVal;
    }

    public Object[] toArray() {
        return this.toArray((Object[])null);
    }

    public Object[] toArray(Object[] a) {
        if (a == null) {
            a = new Object[this.size()];
        } else if (a.length < this.size()) {
            a = (Object[])Array.newInstance(a.getClass().getComponentType(), this.size());
        }
        ObjectIterators.unwrap((Iterator)this.shortIterator(), a);
        return a;
    }

    public boolean addAll(Collection c) {
        boolean retVal = false;
        Iterator i = c.iterator();
        int n = c.size();
        while (n-- != 0) {
            if (!this.add(i.next())) continue;
            retVal = true;
        }
        return retVal;
    }

    public boolean add(short k) {
        throw new UnsupportedOperationException();
    }

    public boolean rem(short k) {
        throw new UnsupportedOperationException();
    }

    public boolean remove(Object ok) {
        return this.rem((Short)ok);
    }

    public void clear() {
        throw new UnsupportedOperationException();
    }

    public Iterator iterator() {
        return this.shortIterator();
    }

    public boolean add(Object o) {
        return this.add((Short)o);
    }

    public boolean rem(Object o) {
        return this.rem((Short)o);
    }

    public boolean contains(Object o) {
        return this.contains((Short)o);
    }

    public boolean containsAll(Collection c) {
        int n = c.size();
        Iterator i = c.iterator();
        while (n-- != 0) {
            if (this.contains(i.next())) continue;
            return false;
        }
        return true;
    }

    public boolean retainAll(Collection c) {
        boolean retVal = false;
        int n = this.size();
        Iterator i = this.iterator();
        while (n-- != 0) {
            if (c.contains(i.next())) continue;
            i.remove();
            retVal = true;
        }
        return retVal;
    }

    public boolean removeAll(Collection c) {
        boolean retVal = false;
        int n = c.size();
        Iterator i = c.iterator();
        while (n-- != 0) {
            if (!this.remove(i.next())) continue;
            retVal = true;
        }
        return retVal;
    }

    public boolean isEmpty() {
        return this.size() == 0;
    }

    public String toString() {
        StringBuffer s = new StringBuffer();
        ShortIterator i = this.shortIterator();
        int n = this.size();
        boolean first = true;
        s.append("{");
        while (n-- != 0) {
            if (first) {
                first = false;
            } else {
                s.append(", ");
            }
            short k = i.nextShort();
            s.append(String.valueOf(k));
        }
        s.append("}");
        return s.toString();
    }
}

