/*
 * Decompiled with CFR 0.152.
 */
package it.unimi.dsi.fastutil.shorts;

import it.unimi.dsi.fastutil.HashCommon;
import it.unimi.dsi.fastutil.longs.AbstractLongCollection;
import it.unimi.dsi.fastutil.longs.AbstractLongIterator;
import it.unimi.dsi.fastutil.longs.LongCollection;
import it.unimi.dsi.fastutil.longs.LongIterator;
import it.unimi.dsi.fastutil.shorts.AbstractShortIterator;
import it.unimi.dsi.fastutil.shorts.AbstractShortSet;
import it.unimi.dsi.fastutil.shorts.Short2LongMap;
import it.unimi.dsi.fastutil.shorts.ShortIterator;
import it.unimi.dsi.fastutil.shorts.ShortSet;
import java.io.Serializable;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;

public abstract class AbstractShort2LongMap
implements Short2LongMap,
Serializable {
    protected long defRetValue;

    protected AbstractShort2LongMap() {
    }

    public void setDefRetValue(long rv) {
        this.defaultReturnValue(rv);
    }

    public long getDefRetValue() {
        return this.defaultReturnValue();
    }

    public void defaultReturnValue(long rv) {
        this.defRetValue = rv;
    }

    public long defaultReturnValue() {
        return this.defRetValue;
    }

    public long put(short key, long value) {
        throw new UnsupportedOperationException();
    }

    public long remove(short key) {
        throw new UnsupportedOperationException();
    }

    public void clear() {
        throw new UnsupportedOperationException();
    }

    public Object get(Object ok) {
        short k = (Short)ok;
        return this.containsKey(k) ? new Long(this.get(k)) : null;
    }

    public Object put(Object ok, Object ov) {
        short k = (Short)ok;
        long v = this.put(k, (Long)ov);
        return this.containsKey(k) ? new Long(v) : null;
    }

    public Object remove(Object ok) {
        short k = (Short)ok;
        long v = this.remove(k);
        return this.containsKey(k) ? new Long(v) : null;
    }

    public boolean containsValue(Object ov) {
        return this.containsValue((Long)ov);
    }

    public boolean containsKey(Object ok) {
        return this.containsKey((Short)ok);
    }

    public boolean containsValue(long v) {
        return ((LongCollection)this.values()).contains(v);
    }

    public boolean containsKey(short k) {
        return ((ShortSet)this.keySet()).contains(k);
    }

    public void putAll(Map m) {
        int n = m.size();
        Iterator i = m.entrySet().iterator();
        if (m instanceof Short2LongMap) {
            while (n-- != 0) {
                Short2LongMap.Entry e = (Short2LongMap.Entry)i.next();
                this.put(e.getShortKey(), e.getLongValue());
            }
        } else {
            while (n-- != 0) {
                Map.Entry e = i.next();
                this.put(e.getKey(), e.getValue());
            }
        }
    }

    public boolean isEmpty() {
        return this.size() == 0;
    }

    public Set keySet() {
        return new AbstractShortSet(){

            public boolean contains(short k) {
                return AbstractShort2LongMap.this.containsKey(k);
            }

            public int size() {
                return AbstractShort2LongMap.this.size();
            }

            public ShortIterator shortIterator() {
                return new AbstractShortIterator(this){
                    final Iterator i;
                    private final /* synthetic */ 1 this$1;
                    {
                        this.this$1 = this$1;
                        this.i = 1.access$000(this.this$1).entrySet().iterator();
                    }

                    public short nextShort() {
                        return ((Short2LongMap.Entry)this.i.next()).getShortKey();
                    }

                    public boolean hasNext() {
                        return this.i.hasNext();
                    }
                };
            }

            static /* synthetic */ AbstractShort2LongMap access$000(1 x0) {
                return x0.AbstractShort2LongMap.this;
            }
        };
    }

    public Collection values() {
        return new AbstractLongCollection(){

            public boolean contains(long k) {
                return AbstractShort2LongMap.this.containsValue(k);
            }

            public int size() {
                return AbstractShort2LongMap.this.size();
            }

            public LongIterator longIterator() {
                return new AbstractLongIterator(this){
                    final Iterator i;
                    private final /* synthetic */ 3 this$1;
                    {
                        this.this$1 = this$1;
                        this.i = 3.access$100(this.this$1).entrySet().iterator();
                    }

                    public long nextLong() {
                        return ((Short2LongMap.Entry)this.i.next()).getLongValue();
                    }

                    public boolean hasNext() {
                        return this.i.hasNext();
                    }
                };
            }

            static /* synthetic */ AbstractShort2LongMap access$100(3 x0) {
                return x0.AbstractShort2LongMap.this;
            }
        };
    }

    public int hashCode() {
        int h = 0;
        int n = this.size();
        Iterator i = this.entrySet().iterator();
        while (n-- != 0) {
            h += ((Object)i.next()).hashCode();
        }
        return h;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Map)) {
            return false;
        }
        Map m = (Map)o;
        if (m.size() != this.size()) {
            return false;
        }
        return this.entrySet().containsAll(m.entrySet());
    }

    public String toString() {
        StringBuffer s = new StringBuffer();
        Iterator i = this.entrySet().iterator();
        int n = this.size();
        boolean first = true;
        s.append("{");
        while (n-- != 0) {
            if (first) {
                first = false;
            } else {
                s.append(", ");
            }
            Short2LongMap.Entry e = (Short2LongMap.Entry)i.next();
            s.append(String.valueOf(e.getShortKey()));
            s.append("=>");
            s.append(String.valueOf(e.getLongValue()));
        }
        s.append("}");
        return s.toString();
    }

    public static class BasicEntry
    implements Short2LongMap.Entry {
        protected short key;
        protected long value;

        public BasicEntry(Object key, Object value) {
            this.key = (Short)key;
            this.value = (Long)value;
        }

        public BasicEntry(short key, long value) {
            this.key = key;
            this.value = value;
        }

        public Object getKey() {
            return new Short(this.key);
        }

        public short getShortKey() {
            return this.key;
        }

        public Object getValue() {
            return new Long(this.value);
        }

        public long getLongValue() {
            return this.value;
        }

        public long setValue(long value) {
            throw new UnsupportedOperationException();
        }

        public Object setValue(Object value) {
            return new Long(this.setValue((Long)value));
        }

        public boolean equals(Object o) {
            if (!(o instanceof Map.Entry)) {
                return false;
            }
            Map.Entry e = (Map.Entry)o;
            return this.key == (Short)e.getKey() && this.value == (Long)e.getValue();
        }

        public int hashCode() {
            return this.key ^ HashCommon.long2int(this.value);
        }

        public String toString() {
            return this.key + "->" + this.value;
        }
    }
}

