/*
 * Decompiled with CFR 0.152.
 */
package it.unimi.dsi.fastutil.shorts;

import it.unimi.dsi.fastutil.bytes.AbstractByteCollection;
import it.unimi.dsi.fastutil.bytes.AbstractByteIterator;
import it.unimi.dsi.fastutil.bytes.ByteCollection;
import it.unimi.dsi.fastutil.bytes.ByteIterator;
import it.unimi.dsi.fastutil.shorts.AbstractShortIterator;
import it.unimi.dsi.fastutil.shorts.AbstractShortSet;
import it.unimi.dsi.fastutil.shorts.Short2ByteMap;
import it.unimi.dsi.fastutil.shorts.ShortIterator;
import it.unimi.dsi.fastutil.shorts.ShortSet;
import java.io.Serializable;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;

public abstract class AbstractShort2ByteMap
implements Short2ByteMap,
Serializable {
    protected byte defRetValue;

    protected AbstractShort2ByteMap() {
    }

    public void setDefRetValue(byte rv) {
        this.defaultReturnValue(rv);
    }

    public byte getDefRetValue() {
        return this.defaultReturnValue();
    }

    public void defaultReturnValue(byte rv) {
        this.defRetValue = rv;
    }

    public byte defaultReturnValue() {
        return this.defRetValue;
    }

    public byte put(short key, byte value) {
        throw new UnsupportedOperationException();
    }

    public byte remove(short key) {
        throw new UnsupportedOperationException();
    }

    public void clear() {
        throw new UnsupportedOperationException();
    }

    public Object get(Object ok) {
        short k = (Short)ok;
        return this.containsKey(k) ? new Byte(this.get(k)) : null;
    }

    public Object put(Object ok, Object ov) {
        short k = (Short)ok;
        byte v = this.put(k, (Byte)ov);
        return this.containsKey(k) ? new Byte(v) : null;
    }

    public Object remove(Object ok) {
        short k = (Short)ok;
        byte v = this.remove(k);
        return this.containsKey(k) ? new Byte(v) : null;
    }

    public boolean containsValue(Object ov) {
        return this.containsValue((Byte)ov);
    }

    public boolean containsKey(Object ok) {
        return this.containsKey((Short)ok);
    }

    public boolean containsValue(byte v) {
        return ((ByteCollection)this.values()).contains(v);
    }

    public boolean containsKey(short k) {
        return ((ShortSet)this.keySet()).contains(k);
    }

    public void putAll(Map m) {
        int n = m.size();
        Iterator i = m.entrySet().iterator();
        if (m instanceof Short2ByteMap) {
            while (n-- != 0) {
                Short2ByteMap.Entry e = (Short2ByteMap.Entry)i.next();
                this.put(e.getShortKey(), e.getByteValue());
            }
        } else {
            while (n-- != 0) {
                Map.Entry e = i.next();
                this.put(e.getKey(), e.getValue());
            }
        }
    }

    public boolean isEmpty() {
        return this.size() == 0;
    }

    public Set keySet() {
        return new AbstractShortSet(){

            public boolean contains(short k) {
                return AbstractShort2ByteMap.this.containsKey(k);
            }

            public int size() {
                return AbstractShort2ByteMap.this.size();
            }

            public ShortIterator shortIterator() {
                return new AbstractShortIterator(this){
                    final Iterator i;
                    private final /* synthetic */ 1 this$1;
                    {
                        this.this$1 = this$1;
                        this.i = 1.access$000(this.this$1).entrySet().iterator();
                    }

                    public short nextShort() {
                        return ((Short2ByteMap.Entry)this.i.next()).getShortKey();
                    }

                    public boolean hasNext() {
                        return this.i.hasNext();
                    }
                };
            }

            static /* synthetic */ AbstractShort2ByteMap access$000(1 x0) {
                return x0.AbstractShort2ByteMap.this;
            }
        };
    }

    public Collection values() {
        return new AbstractByteCollection(){

            public boolean contains(byte k) {
                return AbstractShort2ByteMap.this.containsValue(k);
            }

            public int size() {
                return AbstractShort2ByteMap.this.size();
            }

            public ByteIterator byteIterator() {
                return new AbstractByteIterator(this){
                    final Iterator i;
                    private final /* synthetic */ 3 this$1;
                    {
                        this.this$1 = this$1;
                        this.i = 3.access$100(this.this$1).entrySet().iterator();
                    }

                    public byte nextByte() {
                        return ((Short2ByteMap.Entry)this.i.next()).getByteValue();
                    }

                    public boolean hasNext() {
                        return this.i.hasNext();
                    }
                };
            }

            static /* synthetic */ AbstractShort2ByteMap access$100(3 x0) {
                return x0.AbstractShort2ByteMap.this;
            }
        };
    }

    public int hashCode() {
        int h = 0;
        int n = this.size();
        Iterator i = this.entrySet().iterator();
        while (n-- != 0) {
            h += ((Object)i.next()).hashCode();
        }
        return h;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Map)) {
            return false;
        }
        Map m = (Map)o;
        if (m.size() != this.size()) {
            return false;
        }
        return this.entrySet().containsAll(m.entrySet());
    }

    public String toString() {
        StringBuffer s = new StringBuffer();
        Iterator i = this.entrySet().iterator();
        int n = this.size();
        boolean first = true;
        s.append("{");
        while (n-- != 0) {
            if (first) {
                first = false;
            } else {
                s.append(", ");
            }
            Short2ByteMap.Entry e = (Short2ByteMap.Entry)i.next();
            s.append(String.valueOf(e.getShortKey()));
            s.append("=>");
            s.append(String.valueOf(e.getByteValue()));
        }
        s.append("}");
        return s.toString();
    }

    public static class BasicEntry
    implements Short2ByteMap.Entry {
        protected short key;
        protected byte value;

        public BasicEntry(Object key, Object value) {
            this.key = (Short)key;
            this.value = (Byte)value;
        }

        public BasicEntry(short key, byte value) {
            this.key = key;
            this.value = value;
        }

        public Object getKey() {
            return new Short(this.key);
        }

        public short getShortKey() {
            return this.key;
        }

        public Object getValue() {
            return new Byte(this.value);
        }

        public byte getByteValue() {
            return this.value;
        }

        public byte setValue(byte value) {
            throw new UnsupportedOperationException();
        }

        public Object setValue(Object value) {
            return new Byte(this.setValue((Byte)value));
        }

        public boolean equals(Object o) {
            if (!(o instanceof Map.Entry)) {
                return false;
            }
            Map.Entry e = (Map.Entry)o;
            return this.key == (Short)e.getKey() && this.value == (Byte)e.getValue();
        }

        public int hashCode() {
            return this.key ^ this.value;
        }

        public String toString() {
            return this.key + "->" + this.value;
        }
    }
}

