/*
 * Decompiled with CFR 0.152.
 */
package it.unimi.dsi.fastutil.shorts;

import it.unimi.dsi.fastutil.booleans.AbstractBooleanCollection;
import it.unimi.dsi.fastutil.booleans.AbstractBooleanIterator;
import it.unimi.dsi.fastutil.booleans.BooleanCollection;
import it.unimi.dsi.fastutil.booleans.BooleanIterator;
import it.unimi.dsi.fastutil.shorts.AbstractShortIterator;
import it.unimi.dsi.fastutil.shorts.AbstractShortSet;
import it.unimi.dsi.fastutil.shorts.Short2BooleanMap;
import it.unimi.dsi.fastutil.shorts.ShortIterator;
import it.unimi.dsi.fastutil.shorts.ShortSet;
import java.io.Serializable;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;

public abstract class AbstractShort2BooleanMap
implements Short2BooleanMap,
Serializable {
    protected boolean defRetValue;

    protected AbstractShort2BooleanMap() {
    }

    public void setDefRetValue(boolean rv) {
        this.defaultReturnValue(rv);
    }

    public boolean getDefRetValue() {
        return this.defaultReturnValue();
    }

    public void defaultReturnValue(boolean rv) {
        this.defRetValue = rv;
    }

    public boolean defaultReturnValue() {
        return this.defRetValue;
    }

    public boolean put(short key, boolean value) {
        throw new UnsupportedOperationException();
    }

    public boolean remove(short key) {
        throw new UnsupportedOperationException();
    }

    public void clear() {
        throw new UnsupportedOperationException();
    }

    public Object get(Object ok) {
        short k = (Short)ok;
        return this.containsKey(k) ? Boolean.valueOf(this.get(k)) : null;
    }

    public Object put(Object ok, Object ov) {
        short k = (Short)ok;
        boolean v = this.put(k, (Boolean)ov);
        return this.containsKey(k) ? Boolean.valueOf(v) : null;
    }

    public Object remove(Object ok) {
        short k = (Short)ok;
        boolean v = this.remove(k);
        return this.containsKey(k) ? Boolean.valueOf(v) : null;
    }

    public boolean containsValue(Object ov) {
        return this.containsValue((Boolean)ov);
    }

    public boolean containsKey(Object ok) {
        return this.containsKey((Short)ok);
    }

    public boolean containsValue(boolean v) {
        return ((BooleanCollection)this.values()).contains(v);
    }

    public boolean containsKey(short k) {
        return ((ShortSet)this.keySet()).contains(k);
    }

    public void putAll(Map m) {
        int n = m.size();
        Iterator i = m.entrySet().iterator();
        if (m instanceof Short2BooleanMap) {
            while (n-- != 0) {
                Short2BooleanMap.Entry e = (Short2BooleanMap.Entry)i.next();
                this.put(e.getShortKey(), e.getBooleanValue());
            }
        } else {
            while (n-- != 0) {
                Map.Entry e = i.next();
                this.put(e.getKey(), e.getValue());
            }
        }
    }

    public boolean isEmpty() {
        return this.size() == 0;
    }

    public Set keySet() {
        return new AbstractShortSet(){

            public boolean contains(short k) {
                return AbstractShort2BooleanMap.this.containsKey(k);
            }

            public int size() {
                return AbstractShort2BooleanMap.this.size();
            }

            public ShortIterator shortIterator() {
                return new AbstractShortIterator(this){
                    final Iterator i;
                    private final /* synthetic */ 1 this$1;
                    {
                        this.this$1 = this$1;
                        this.i = 1.access$000(this.this$1).entrySet().iterator();
                    }

                    public short nextShort() {
                        return ((Short2BooleanMap.Entry)this.i.next()).getShortKey();
                    }

                    public boolean hasNext() {
                        return this.i.hasNext();
                    }
                };
            }

            static /* synthetic */ AbstractShort2BooleanMap access$000(1 x0) {
                return x0.AbstractShort2BooleanMap.this;
            }
        };
    }

    public Collection values() {
        return new AbstractBooleanCollection(){

            public boolean contains(boolean k) {
                return AbstractShort2BooleanMap.this.containsValue(k);
            }

            public int size() {
                return AbstractShort2BooleanMap.this.size();
            }

            public BooleanIterator booleanIterator() {
                return new AbstractBooleanIterator(this){
                    final Iterator i;
                    private final /* synthetic */ 3 this$1;
                    {
                        this.this$1 = this$1;
                        this.i = 3.access$100(this.this$1).entrySet().iterator();
                    }

                    public boolean nextBoolean() {
                        return ((Short2BooleanMap.Entry)this.i.next()).getBooleanValue();
                    }

                    public boolean hasNext() {
                        return this.i.hasNext();
                    }
                };
            }

            static /* synthetic */ AbstractShort2BooleanMap access$100(3 x0) {
                return x0.AbstractShort2BooleanMap.this;
            }
        };
    }

    public int hashCode() {
        int h = 0;
        int n = this.size();
        Iterator i = this.entrySet().iterator();
        while (n-- != 0) {
            h += ((Object)i.next()).hashCode();
        }
        return h;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Map)) {
            return false;
        }
        Map m = (Map)o;
        if (m.size() != this.size()) {
            return false;
        }
        return this.entrySet().containsAll(m.entrySet());
    }

    public String toString() {
        StringBuffer s = new StringBuffer();
        Iterator i = this.entrySet().iterator();
        int n = this.size();
        boolean first = true;
        s.append("{");
        while (n-- != 0) {
            if (first) {
                first = false;
            } else {
                s.append(", ");
            }
            Short2BooleanMap.Entry e = (Short2BooleanMap.Entry)i.next();
            s.append(String.valueOf(e.getShortKey()));
            s.append("=>");
            s.append(String.valueOf(e.getBooleanValue()));
        }
        s.append("}");
        return s.toString();
    }

    public static class BasicEntry
    implements Short2BooleanMap.Entry {
        protected short key;
        protected boolean value;

        public BasicEntry(Object key, Object value) {
            this.key = (Short)key;
            this.value = (Boolean)value;
        }

        public BasicEntry(short key, boolean value) {
            this.key = key;
            this.value = value;
        }

        public Object getKey() {
            return new Short(this.key);
        }

        public short getShortKey() {
            return this.key;
        }

        public Object getValue() {
            return this.value;
        }

        public boolean getBooleanValue() {
            return this.value;
        }

        public boolean setValue(boolean value) {
            throw new UnsupportedOperationException();
        }

        public Object setValue(Object value) {
            return this.setValue((Boolean)value);
        }

        public boolean equals(Object o) {
            if (!(o instanceof Map.Entry)) {
                return false;
            }
            Map.Entry e = (Map.Entry)o;
            return this.key == (Short)e.getKey() && this.value == (Boolean)e.getValue();
        }

        public int hashCode() {
            return this.key ^ (this.value ? 1231 : 1237);
        }

        public String toString() {
            return this.key + "->" + this.value;
        }
    }
}

