/*
 * Decompiled with CFR 0.152.
 */
package it.unimi.dsi.fastutil.objects;

import it.unimi.dsi.fastutil.Sets;
import it.unimi.dsi.fastutil.objects.ObjectBidirectionalIterator;
import it.unimi.dsi.fastutil.objects.ObjectIterators;
import it.unimi.dsi.fastutil.objects.ReferenceSets;
import it.unimi.dsi.fastutil.objects.ReferenceSortedSet;
import java.io.Serializable;
import java.util.Comparator;
import java.util.SortedSet;

public class ReferenceSortedSets {
    private ReferenceSortedSets() {
    }

    public static ReferenceSortedSet singleton(Object element) {
        return new Singleton(element);
    }

    public static ReferenceSortedSet singleton(Object element, Comparator comparator) {
        return new Singleton(element, comparator);
    }

    public static ReferenceSortedSet synchronize(ReferenceSortedSet s) {
        return new SynchronizedSortedSet(s);
    }

    public static ReferenceSortedSet synchronize(ReferenceSortedSet s, Object sync) {
        return new SynchronizedSortedSet(s, sync);
    }

    public static ReferenceSortedSet unmodifiable(ReferenceSortedSet s) {
        return new UnmodifiableSortedSet(s);
    }

    public static class UnmodifiableSortedSet
    extends ReferenceSets.UnmodifiableSet
    implements ReferenceSortedSet,
    Serializable {
        public static final long serialVersionUID = -7046029254386353129L;
        protected final ReferenceSortedSet sortedSet;

        protected UnmodifiableSortedSet(ReferenceSortedSet s) {
            super(s);
            this.sortedSet = s;
        }

        public Comparator comparator() {
            return this.sortedSet.comparator();
        }

        public SortedSet subSet(Object from, Object to) {
            return new UnmodifiableSortedSet((ReferenceSortedSet)this.sortedSet.subSet(from, to));
        }

        public SortedSet headSet(Object to) {
            return new UnmodifiableSortedSet((ReferenceSortedSet)this.sortedSet.headSet(to));
        }

        public SortedSet tailSet(Object from) {
            return new UnmodifiableSortedSet((ReferenceSortedSet)this.sortedSet.tailSet(from));
        }

        public ObjectBidirectionalIterator iterator(Object from) {
            return ObjectIterators.unmodifiable(this.sortedSet.iterator(from));
        }

        public Object first() {
            return this.sortedSet.first();
        }

        public Object last() {
            return this.sortedSet.last();
        }
    }

    public static class SynchronizedSortedSet
    extends ReferenceSets.SynchronizedSet
    implements ReferenceSortedSet,
    Serializable {
        public static final long serialVersionUID = -7046029254386353129L;
        protected final ReferenceSortedSet sortedSet;

        protected SynchronizedSortedSet(ReferenceSortedSet s, Object sync) {
            super(s, sync);
            this.sortedSet = s;
        }

        protected SynchronizedSortedSet(ReferenceSortedSet s) {
            super(s);
            this.sortedSet = s;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Comparator comparator() {
            Object object = this.sync;
            synchronized (object) {
                return this.sortedSet.comparator();
            }
        }

        public SortedSet subSet(Object from, Object to) {
            return new SynchronizedSortedSet((ReferenceSortedSet)this.sortedSet.subSet(from, to), this.sync);
        }

        public SortedSet headSet(Object to) {
            return new SynchronizedSortedSet((ReferenceSortedSet)this.sortedSet.headSet(to), this.sync);
        }

        public SortedSet tailSet(Object from) {
            return new SynchronizedSortedSet((ReferenceSortedSet)this.sortedSet.tailSet(from), this.sync);
        }

        public ObjectBidirectionalIterator iterator(Object from) {
            return this.sortedSet.iterator(from);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Object first() {
            Object object = this.sync;
            synchronized (object) {
                return this.sortedSet.first();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Object last() {
            Object object = this.sync;
            synchronized (object) {
                return this.sortedSet.last();
            }
        }
    }

    public static class Singleton
    extends ReferenceSets.Singleton
    implements ReferenceSortedSet,
    Serializable,
    Cloneable {
        public static final long serialVersionUID = -7046029254386353129L;
        final Comparator comparator;

        private Singleton(Object element, Comparator comparator) {
            super(element);
            this.comparator = comparator;
        }

        private Singleton(Object element) {
            this(element, (Comparator)null);
        }

        final int compare(Object k1, Object k2) {
            return this.comparator == null ? ((Comparable)k1).compareTo(k2) : this.comparator.compare(k1, k2);
        }

        public ObjectBidirectionalIterator iterator(Object from) {
            ObjectBidirectionalIterator i = (ObjectBidirectionalIterator)this.objectIterator();
            if (this.compare(this.element, from) <= 0) {
                i.next();
            }
            return i;
        }

        public Comparator comparator() {
            return this.comparator;
        }

        public SortedSet subSet(Object from, Object to) {
            if (this.compare(from, this.element) <= 0 && this.compare(this.element, to) < 0) {
                return this;
            }
            return Sets.EMPTY_SET;
        }

        public SortedSet headSet(Object to) {
            if (this.compare(this.element, to) < 0) {
                return this;
            }
            return Sets.EMPTY_SET;
        }

        public SortedSet tailSet(Object from) {
            if (this.compare(from, this.element) <= 0) {
                return this;
            }
            return Sets.EMPTY_SET;
        }

        public Object first() {
            return this.element;
        }

        public Object last() {
            return this.element;
        }
    }
}

