/*
 * Decompiled with CFR 0.152.
 */
package it.unimi.dsi.fastutil.objects;

import it.unimi.dsi.fastutil.Hash;
import it.unimi.dsi.fastutil.HashCommon;
import it.unimi.dsi.fastutil.bytes.ByteArrays;
import it.unimi.dsi.fastutil.objects.AbstractObjectIterator;
import it.unimi.dsi.fastutil.objects.AbstractObjectSet;
import it.unimi.dsi.fastutil.objects.AbstractReference2ReferenceMap;
import it.unimi.dsi.fastutil.objects.AbstractReferenceCollection;
import it.unimi.dsi.fastutil.objects.AbstractReferenceSet;
import it.unimi.dsi.fastutil.objects.ObjectArrays;
import it.unimi.dsi.fastutil.objects.ObjectIterator;
import it.unimi.dsi.fastutil.objects.ObjectSet;
import it.unimi.dsi.fastutil.objects.Reference2ReferenceMap;
import it.unimi.dsi.fastutil.objects.ReferenceCollection;
import it.unimi.dsi.fastutil.objects.ReferenceSet;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;

public class Reference2ReferenceOpenHashMap
extends AbstractReference2ReferenceMap
implements Serializable,
Cloneable,
Hash,
Reference2ReferenceMap {
    protected transient Object[] key;
    protected transient Object[] value;
    protected transient byte[] state;
    protected final float f;
    protected transient int p;
    protected transient int maxFill;
    protected transient int free;
    protected int count;
    protected volatile transient ObjectSet entries;
    protected volatile transient ReferenceSet keys;
    protected volatile transient ReferenceCollection values;
    protected transient int growthFactor = 16;
    public static final long serialVersionUID = -7046029254386353129L;
    private static final boolean ASSERTS = false;

    public Reference2ReferenceOpenHashMap(int n, float f) {
        if (f <= 0.0f || f > 1.0f) {
            throw new IllegalArgumentException("Load factor must be greater than 0 and smaller than or equal to 1");
        }
        if (n < 0) {
            throw new IllegalArgumentException("Hash table size must be nonnegative");
        }
        int l = Arrays.binarySearch(PRIMES, (int)((float)n / f) + 1);
        if (l < 0) {
            l = -l - 1;
        }
        this.p = l;
        this.free = PRIMES[this.p];
        this.f = f;
        this.maxFill = (int)((float)this.free * f);
        this.key = new Object[this.free];
        this.value = new Object[this.free];
        this.state = new byte[this.free];
    }

    public Reference2ReferenceOpenHashMap(int n) {
        this(n, 0.75f);
    }

    public Reference2ReferenceOpenHashMap() {
        this(16, 0.75f);
    }

    public Reference2ReferenceOpenHashMap(Map m, float f) {
        this(m.size(), f);
        this.putAll(m);
    }

    public Reference2ReferenceOpenHashMap(Map m) {
        this(m, 0.75f);
    }

    public Reference2ReferenceOpenHashMap(Reference2ReferenceMap m, float f) {
        this(m.size(), f);
        this.putAll((Map)m);
    }

    public Reference2ReferenceOpenHashMap(Reference2ReferenceMap m) {
        this(m, 0.75f);
    }

    public void growthFactor(int growthFactor) {
        if (growthFactor <= 0) {
            throw new IllegalArgumentException("Illegal growth factor " + growthFactor);
        }
        this.growthFactor = growthFactor;
    }

    public int growthFactor() {
        return this.growthFactor;
    }

    private int findInsertionPoint(Object k) {
        Object[] key = this.key;
        byte[] state = this.state;
        int n = key.length;
        int k2i = System.identityHashCode(k) & Integer.MAX_VALUE;
        int h1 = k2i % n;
        if (state[h1] == -1 && k != key[h1]) {
            int h2 = k2i % (n - 2) + 1;
            while (state[h1 = (h1 + h2) % n] == -1 && k != key[h1]) {
            }
        }
        if (state[h1] == 0) {
            return h1;
        }
        if (state[h1] == -1) {
            return -h1 - 1;
        }
        int i = h1;
        if (state[h1] != 0 && k != key[h1]) {
            int h2 = k2i % (n - 2) + 1;
            while (state[h1 = (h1 + h2) % n] != 0 && k != key[h1]) {
            }
        }
        return state[h1] == -1 ? -h1 - 1 : i;
    }

    private int findKey(Object k) {
        Object[] key = this.key;
        byte[] state = this.state;
        int n = key.length;
        int k2i = System.identityHashCode(k) & Integer.MAX_VALUE;
        int h1 = k2i % n;
        if (state[h1] != 0 && k != key[h1]) {
            int h2 = k2i % (n - 2) + 1;
            while (state[h1 = (h1 + h2) % n] != 0 && k != key[h1]) {
            }
        }
        return state[h1] == -1 ? h1 : -1;
    }

    public Object put(Object k, Object v) {
        int i = this.findInsertionPoint(k);
        if (i < 0) {
            Object oldValue = this.value[-i - 1];
            this.value[-i - 1] = v;
            return oldValue;
        }
        if (this.state[i] == 0) {
            --this.free;
        }
        this.state[i] = -1;
        this.key[i] = k;
        this.value[i] = v;
        if (++this.count >= this.maxFill) {
            int newP = Math.min(this.p + this.growthFactor, PRIMES.length - 1);
            while (PRIMES[newP] == PRIMES[this.p]) {
                ++newP;
            }
            this.rehash(newP);
        }
        if (this.free == 0) {
            this.rehash(this.p);
        }
        return this.defRetValue;
    }

    public boolean containsValue(Object v) {
        Object[] value = this.value;
        byte[] state = this.state;
        int i = 0;
        int j = this.count;
        while (j-- != 0) {
            while (state[i] != -1) {
                ++i;
            }
            if (value[i] == v) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public void clear() {
        if (this.free == this.state.length) {
            return;
        }
        this.free = this.state.length;
        this.count = 0;
        ByteArrays.fill(this.state, (byte)0);
        ObjectArrays.fill(this.key, null);
        ObjectArrays.fill(this.value, null);
    }

    public boolean containsKey(Object k) {
        return this.findKey(k) >= 0;
    }

    public int size() {
        return this.count;
    }

    public boolean isEmpty() {
        return this.count == 0;
    }

    public Object get(Object k) {
        int i = this.findKey(k);
        return i < 0 ? this.defRetValue : this.value[i];
    }

    public Object remove(Object k) {
        int i = this.findKey(k);
        if (i < 0) {
            return this.defRetValue;
        }
        this.state[i] = 1;
        --this.count;
        this.key[i] = HashCommon.REMOVED;
        Object v = this.value[i];
        this.value[i] = HashCommon.REMOVED;
        return v;
    }

    public Set entrySet() {
        if (this.entries == null) {
            this.entries = new AbstractObjectSet(){

                public ObjectIterator objectIterator() {
                    return new MapIterator();
                }

                public boolean contains(Object o) {
                    if (!(o instanceof Map.Entry)) {
                        return false;
                    }
                    Map.Entry e = (Map.Entry)o;
                    int i = Reference2ReferenceOpenHashMap.this.findKey(e.getKey());
                    return i >= 0 && Reference2ReferenceOpenHashMap.this.value[i] == e.getValue();
                }

                public boolean remove(Object o) {
                    if (!(o instanceof Map.Entry)) {
                        return false;
                    }
                    Map.Entry e = (Map.Entry)o;
                    int i = Reference2ReferenceOpenHashMap.this.findKey(e.getKey());
                    if (i >= 0) {
                        Reference2ReferenceOpenHashMap.this.remove(e.getKey());
                    }
                    return i >= 0;
                }

                public int size() {
                    return Reference2ReferenceOpenHashMap.this.count;
                }

                public void clear() {
                    Reference2ReferenceOpenHashMap.this.clear();
                }
            };
        }
        return this.entries;
    }

    public Set keySet() {
        if (this.keys == null) {
            this.keys = new KeySet();
        }
        return this.keys;
    }

    public Collection values() {
        if (this.values == null) {
            this.values = new AbstractReferenceCollection(){

                public ObjectIterator objectIterator() {
                    return new ValueIterator();
                }

                public int size() {
                    return Reference2ReferenceOpenHashMap.this.count;
                }

                public boolean contains(Object v) {
                    return Reference2ReferenceOpenHashMap.this.containsValue(v);
                }

                public void clear() {
                    Reference2ReferenceOpenHashMap.this.clear();
                }
            };
        }
        return this.values;
    }

    public boolean rehash() {
        try {
            this.rehash(this.p);
        }
        catch (OutOfMemoryError cantDoIt) {
            return false;
        }
        return true;
    }

    public boolean trim() {
        int l = Arrays.binarySearch(PRIMES, (int)((float)this.count / this.f) + 1);
        if (l < 0) {
            l = -l - 1;
        }
        if (l >= this.p) {
            return true;
        }
        try {
            this.rehash(l);
        }
        catch (OutOfMemoryError cantDoIt) {
            return false;
        }
        return true;
    }

    public boolean trim(int n) {
        int l = Arrays.binarySearch(PRIMES, (int)Math.min(2.1474836E9f, (float)Math.max(n, this.count) / this.f) + 1);
        if (l < 0) {
            l = -l - 1;
        }
        if (this.p <= l) {
            return true;
        }
        try {
            this.rehash(l);
        }
        catch (OutOfMemoryError cantDoIt) {
            return false;
        }
        return true;
    }

    protected void rehash(int newP) {
        int i = 0;
        int j = this.count;
        int newN = PRIMES[newP];
        Object[] key = this.key;
        Object[] newKey = new Object[newN];
        Object[] value = this.value;
        Object[] newValue = new Object[newN];
        byte[] state = this.state;
        byte[] newState = new byte[newN];
        while (j-- != 0) {
            while (state[i] != -1) {
                ++i;
            }
            Object k = key[i];
            Object v = value[i];
            int k2i = System.identityHashCode(k) & Integer.MAX_VALUE;
            int h1 = k2i % newN;
            int h2 = k2i % (newN - 2) + 1;
            if (newState[h1] != 0) {
                h2 = k2i % (newN - 2) + 1;
                while (newState[h1 = (h1 + h2) % newN] != 0) {
                }
            }
            newState[h1] = -1;
            newKey[h1] = k;
            newValue[h1] = v;
            ++i;
        }
        this.p = newP;
        this.free = newN - this.count;
        this.maxFill = (int)((float)newN * this.f);
        this.key = newKey;
        this.value = newValue;
        this.state = newState;
    }

    public Object clone() {
        Reference2ReferenceOpenHashMap c;
        try {
            c = (Reference2ReferenceOpenHashMap)super.clone();
        }
        catch (CloneNotSupportedException cantHappen) {
            throw new InternalError();
        }
        c.keys = null;
        c.values = null;
        c.entries = null;
        c.key = (Object[])this.key.clone();
        c.value = (Object[])this.value.clone();
        c.state = (byte[])this.state.clone();
        return c;
    }

    public int hashCode() {
        int h = 0;
        int i = 0;
        int j = this.count;
        while (j-- != 0) {
            while (this.state[i] != -1) {
                ++i;
            }
            int t = 0;
            if (this != this.key[i]) {
                t = System.identityHashCode(this.key[i]);
            }
            if (this != this.value[i]) {
                t ^= System.identityHashCode(this.value[i]);
            }
            h += t;
            ++i;
        }
        return h;
    }

    private void writeObject(ObjectOutputStream s) throws IOException {
        Object[] key = this.key;
        Object[] value = this.value;
        byte[] state = this.state;
        MapIterator i = new MapIterator();
        int j = this.count;
        s.defaultWriteObject();
        while (j-- != 0) {
            int e = i.nextEntry();
            s.writeObject(key[e]);
            s.writeObject(value[e]);
        }
    }

    private void checkTable() {
        int n = this.state.length;
        while (n-- != 0) {
            if (this.state[n] == -1 && !this.containsKey(this.key[n])) {
                throw new AssertionError((Object)("Hash table has key " + this.key[n] + " marked as occupied, but the key does not belong to the table"));
            }
        }
    }

    private void readObject(ObjectInputStream s) throws IOException, ClassNotFoundException {
        s.defaultReadObject();
        this.growthFactor = 16;
        this.p = Arrays.binarySearch(PRIMES, (int)((float)this.count / this.f) + 1);
        if (this.p < 0) {
            this.p = -this.p - 1;
        }
        int n = PRIMES[this.p];
        this.maxFill = (int)((float)n * this.f);
        this.free = n - this.count;
        this.key = new Object[n];
        Object[] key = this.key;
        this.value = new Object[n];
        Object[] value = this.value;
        this.state = new byte[n];
        byte[] state = this.state;
        int i = this.count;
        while (i-- != 0) {
            Object k = s.readObject();
            Object v = s.readObject();
            int k2i = System.identityHashCode(k) & Integer.MAX_VALUE;
            int h1 = k2i % n;
            if (state[h1] != 0) {
                int h2 = k2i % (n - 2) + 1;
                while (state[h1 = (h1 + h2) % n] != 0) {
                }
            }
            state[h1] = -1;
            key[h1] = k;
            value[h1] = v;
        }
    }

    private final class ValueIterator
    extends MapIterator
    implements ObjectIterator {
        public Object next() {
            return Reference2ReferenceOpenHashMap.this.value[this.nextEntry()];
        }

        public void set(Object v) {
            throw new UnsupportedOperationException();
        }

        public void add(Object v) {
            throw new UnsupportedOperationException();
        }
    }

    private final class KeySet
    extends AbstractReferenceSet {
        private KeySet() {
        }

        public ObjectIterator objectIterator() {
            return new KeyIterator();
        }

        public int size() {
            return Reference2ReferenceOpenHashMap.this.count;
        }

        public boolean contains(Object k) {
            return Reference2ReferenceOpenHashMap.this.containsKey(k);
        }

        public boolean remove(Object k) {
            int oldCount = Reference2ReferenceOpenHashMap.this.count;
            Reference2ReferenceOpenHashMap.this.remove(k);
            return Reference2ReferenceOpenHashMap.this.count != oldCount;
        }

        public void clear() {
            Reference2ReferenceOpenHashMap.this.clear();
        }
    }

    private final class KeyIterator
    extends MapIterator
    implements ObjectIterator {
        public Object next() {
            return Reference2ReferenceOpenHashMap.this.key[this.nextEntry()];
        }

        public void set(Object k) {
            throw new UnsupportedOperationException();
        }

        public void add(Object k) {
            throw new UnsupportedOperationException();
        }
    }

    private class MapIterator
    extends AbstractObjectIterator {
        int pos = 0;
        int last = -1;
        int c;

        private MapIterator() {
            this.c = Reference2ReferenceOpenHashMap.this.count;
            byte[] state = Reference2ReferenceOpenHashMap.this.state;
            int n = state.length;
            if (this.c != 0) {
                while (this.pos < n && state[this.pos] != -1) {
                    ++this.pos;
                }
            }
        }

        public boolean hasNext() {
            return this.c != 0 && this.pos < Reference2ReferenceOpenHashMap.this.state.length;
        }

        public int nextEntry() {
            byte[] state = Reference2ReferenceOpenHashMap.this.state;
            int n = state.length;
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            this.last = this.pos;
            if (--this.c != 0) {
                do {
                    ++this.pos;
                } while (this.pos < n && state[this.pos] != -1);
            }
            return this.last;
        }

        public Object next() {
            return new MapEntry(this.nextEntry());
        }

        public void remove() {
            if (this.last == -1) {
                throw new IllegalStateException();
            }
            Reference2ReferenceOpenHashMap.this.state[this.last] = 1;
            Reference2ReferenceOpenHashMap.this.value[this.last] = HashCommon.REMOVED;
            --Reference2ReferenceOpenHashMap.this.count;
        }
    }

    private final class MapEntry
    implements Reference2ReferenceMap.Entry {
        private int index;

        MapEntry(int index) {
            this.index = index;
        }

        public Object getKey() {
            return Reference2ReferenceOpenHashMap.this.key[this.index];
        }

        public Object getValue() {
            return Reference2ReferenceOpenHashMap.this.value[this.index];
        }

        public Object setValue(Object v) {
            Object oldValue = Reference2ReferenceOpenHashMap.this.value[this.index];
            Reference2ReferenceOpenHashMap.this.value[this.index] = v;
            return oldValue;
        }

        public boolean equals(Object o) {
            if (!(o instanceof Map.Entry)) {
                return false;
            }
            Map.Entry e = (Map.Entry)o;
            return Reference2ReferenceOpenHashMap.this.key[this.index] == e.getKey() && Reference2ReferenceOpenHashMap.this.value[this.index] == e.getValue();
        }

        public int hashCode() {
            return System.identityHashCode(Reference2ReferenceOpenHashMap.this.key[this.index]) ^ System.identityHashCode(Reference2ReferenceOpenHashMap.this.value[this.index]);
        }

        public String toString() {
            return Reference2ReferenceOpenHashMap.this.key[this.index] + "->" + Reference2ReferenceOpenHashMap.this.value[this.index];
        }
    }
}

