/*
 * Decompiled with CFR 0.152.
 */
package it.unimi.dsi.fastutil.objects;

import it.unimi.dsi.fastutil.Sets;
import it.unimi.dsi.fastutil.chars.CharCollection;
import it.unimi.dsi.fastutil.chars.CharCollections;
import it.unimi.dsi.fastutil.chars.CharSets;
import it.unimi.dsi.fastutil.objects.AbstractReference2CharMap;
import it.unimi.dsi.fastutil.objects.ObjectSet;
import it.unimi.dsi.fastutil.objects.ObjectSets;
import it.unimi.dsi.fastutil.objects.Reference2CharMap;
import it.unimi.dsi.fastutil.objects.ReferenceSet;
import it.unimi.dsi.fastutil.objects.ReferenceSets;
import java.io.Serializable;
import java.util.Collection;
import java.util.Map;
import java.util.Set;

public class Reference2CharMaps {
    public static final EmptyMap EMPTY_MAP = new EmptyMap();

    private Reference2CharMaps() {
    }

    public static Reference2CharMap singleton(Object key, char value) {
        return new Singleton(key, value);
    }

    public static Reference2CharMap singleton(Object key, Object value) {
        return new Singleton(key, ((Character)value).charValue());
    }

    public static Reference2CharMap synchronize(Reference2CharMap m) {
        return new SynchronizedMap(m);
    }

    public static Reference2CharMap synchronize(Reference2CharMap m, Object sync) {
        return new SynchronizedMap(m, sync);
    }

    public static Reference2CharMap unmodifiable(Reference2CharMap m) {
        return new UnmodifiableMap(m);
    }

    public static class UnmodifiableMap
    extends AbstractReference2CharMap
    implements Reference2CharMap,
    Serializable {
        public static final long serialVersionUID = -7046029254386353129L;
        protected final Reference2CharMap map;
        protected volatile transient Set entries;
        protected volatile transient Set keys;
        protected volatile transient Collection values;

        protected UnmodifiableMap(Reference2CharMap m) {
            if (m == null) {
                throw new NullPointerException();
            }
            this.map = m;
        }

        public Object remove(Object ok) {
            throw new UnsupportedOperationException();
        }

        public Object get(Object ok) {
            return this.map.get(ok);
        }

        public int size() {
            return this.map.size();
        }

        public boolean containsKey(Object k) {
            return this.map.containsKey(k);
        }

        public boolean containsValue(char v) {
            return this.map.containsValue(v);
        }

        public char defaultReturnValue() {
            throw new UnsupportedOperationException();
        }

        public void defaultReturnValue(char defRetValue) {
            throw new UnsupportedOperationException();
        }

        public char put(Object k, char v) {
            throw new UnsupportedOperationException();
        }

        public void putAll(Reference2CharMap c) {
            throw new UnsupportedOperationException();
        }

        public void putAll(Map m) {
            throw new UnsupportedOperationException();
        }

        public Set entrySet() {
            if (this.entries == null) {
                this.entries = ObjectSets.unmodifiable((ObjectSet)this.map.entrySet());
            }
            return this.entries;
        }

        public Set keySet() {
            if (this.keys == null) {
                this.keys = ReferenceSets.unmodifiable((ReferenceSet)this.map.keySet());
            }
            return this.keys;
        }

        public Collection values() {
            if (this.values == null) {
                return CharCollections.unmodifiable((CharCollection)this.map.values());
            }
            return this.values;
        }

        public void clear() {
            throw new UnsupportedOperationException();
        }

        public String toString() {
            return this.map.toString();
        }

        public Object put(Object k, Object v) {
            throw new UnsupportedOperationException();
        }

        public boolean containsValue(Object ov) {
            return this.map.containsValue(ov);
        }

        public char removeChar(Object k) {
            throw new UnsupportedOperationException();
        }

        public char getChar(Object k) {
            return this.map.getChar(k);
        }
    }

    public static class SynchronizedMap
    extends AbstractReference2CharMap
    implements Reference2CharMap,
    Serializable {
        public static final long serialVersionUID = -7046029254386353129L;
        protected final Reference2CharMap map;
        protected final Object sync;
        protected volatile transient Set entries;
        protected volatile transient Set keys;
        protected volatile transient Collection values;

        protected SynchronizedMap(Reference2CharMap m, Object sync) {
            if (m == null) {
                throw new NullPointerException();
            }
            this.map = m;
            this.sync = sync;
        }

        protected SynchronizedMap(Reference2CharMap m) {
            if (m == null) {
                throw new NullPointerException();
            }
            this.map = m;
            this.sync = this;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Object remove(Object ok) {
            Object object = this.sync;
            synchronized (object) {
                return this.map.remove(ok);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Object get(Object ok) {
            Object object = this.sync;
            synchronized (object) {
                return this.map.get(ok);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public int size() {
            Object object = this.sync;
            synchronized (object) {
                return this.map.size();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean containsKey(Object k) {
            Object object = this.sync;
            synchronized (object) {
                return this.map.containsKey(k);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean containsValue(char v) {
            Object object = this.sync;
            synchronized (object) {
                return this.map.containsValue(v);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public char defaultReturnValue() {
            Object object = this.sync;
            synchronized (object) {
                return this.map.defaultReturnValue();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void defaultReturnValue(char defRetValue) {
            Object object = this.sync;
            synchronized (object) {
                this.map.defaultReturnValue(defRetValue);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public char put(Object k, char v) {
            Object object = this.sync;
            synchronized (object) {
                return this.map.put(k, v);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void putAll(Reference2CharMap c) {
            Object object = this.sync;
            synchronized (object) {
                this.map.putAll(c);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void putAll(Map m) {
            Object object = this.sync;
            synchronized (object) {
                this.map.putAll(m);
            }
        }

        public Set entrySet() {
            if (this.entries == null) {
                this.entries = ObjectSets.synchronize((ObjectSet)this.map.entrySet(), this.sync);
            }
            return this.entries;
        }

        public Set keySet() {
            if (this.keys == null) {
                this.keys = ReferenceSets.synchronize((ReferenceSet)this.map.keySet(), this.sync);
            }
            return this.keys;
        }

        public Collection values() {
            if (this.values == null) {
                return CharCollections.synchronize((CharCollection)this.map.values(), this.sync);
            }
            return this.values;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void clear() {
            Object object = this.sync;
            synchronized (object) {
                this.map.clear();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public String toString() {
            Object object = this.sync;
            synchronized (object) {
                return this.map.toString();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Object put(Object k, Object v) {
            Object object = this.sync;
            synchronized (object) {
                return this.map.put(k, v);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean containsValue(Object ov) {
            Object object = this.sync;
            synchronized (object) {
                return this.map.containsValue(ov);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public char removeChar(Object k) {
            Object object = this.sync;
            synchronized (object) {
                return this.map.removeChar(k);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public char getChar(Object k) {
            Object object = this.sync;
            synchronized (object) {
                return this.map.getChar(k);
            }
        }
    }

    public static class Singleton
    extends AbstractReference2CharMap
    implements Serializable,
    Cloneable {
        public static final long serialVersionUID = -7046029254386353129L;
        protected final Object key;
        protected final char value;
        protected volatile transient Set entries;
        protected volatile transient Set keys;
        protected volatile transient Collection values;

        protected Singleton(Object key, char value) {
            this.key = key;
            this.value = value;
        }

        public boolean containsKey(Object k) {
            return this.key == k;
        }

        public boolean containsValue(char v) {
            return this.value == v;
        }

        public void putAll(Map m) {
            throw new UnsupportedOperationException();
        }

        public Set entrySet() {
            if (this.entries == null) {
                this.entries = ObjectSets.singleton(new SingletonEntry());
            }
            return this.entries;
        }

        public Set keySet() {
            if (this.keys == null) {
                this.keys = ReferenceSets.singleton(this.key);
            }
            return this.keys;
        }

        public Collection values() {
            if (this.values == null) {
                this.values = CharSets.singleton(this.value);
            }
            return this.values;
        }

        public char getChar(Object k) {
            if (this.key == k) {
                return this.value;
            }
            return this.defRetValue;
        }

        public int size() {
            return 1;
        }

        public Object clone() {
            return this;
        }

        private class SingletonEntry
        implements Reference2CharMap.Entry {
            private SingletonEntry() {
            }

            public Object getKey() {
                return Singleton.this.key;
            }

            public Object getValue() {
                return new Character(Singleton.this.value);
            }

            public char getCharValue() {
                return Singleton.this.value;
            }

            public char setValue(char value) {
                throw new UnsupportedOperationException();
            }

            public Object setValue(Object value) {
                throw new UnsupportedOperationException();
            }

            public boolean equals(Object o) {
                if (!(o instanceof Map.Entry)) {
                    return false;
                }
                Map.Entry e = (Map.Entry)o;
                return Singleton.this.key == e.getKey() && Singleton.this.value == ((Character)e.getValue()).charValue();
            }

            public int hashCode() {
                return System.identityHashCode(Singleton.this.key) ^ Singleton.this.value;
            }

            public String toString() {
                return Singleton.this.key + "->" + Singleton.this.value;
            }
        }
    }

    public static class EmptyMap
    extends AbstractReference2CharMap
    implements Serializable,
    Cloneable {
        public static final long serialVersionUID = -7046029254386353129L;

        protected EmptyMap() {
        }

        public char put(Object k, char v) {
            throw new UnsupportedOperationException();
        }

        public Object get(Object ok) {
            return null;
        }

        public boolean containsKey(Object k) {
            return false;
        }

        public boolean containsValue(char v) {
            return false;
        }

        public char defaultReturnValue() {
            return '\u0000';
        }

        public void defaultReturnValue(char defRetValue) {
            throw new UnsupportedOperationException();
        }

        public void putAll(Map m) {
            throw new UnsupportedOperationException();
        }

        public Set entrySet() {
            return Sets.EMPTY_SET;
        }

        public Set keySet() {
            return Sets.EMPTY_SET;
        }

        public Collection values() {
            return Sets.EMPTY_SET;
        }

        public Object put(Object k, Object v) {
            throw new UnsupportedOperationException();
        }

        public boolean containsValue(Object ov) {
            return false;
        }

        public char getChar(Object k) {
            return '\u0000';
        }

        public int size() {
            return 0;
        }

        public void clear() {
        }

        private Object readResolve() {
            return EMPTY_MAP;
        }

        public Object clone() {
            return EMPTY_MAP;
        }
    }
}

