/*
 * Decompiled with CFR 0.152.
 */
package it.unimi.dsi.fastutil.objects;

import it.unimi.dsi.fastutil.Lists;
import it.unimi.dsi.fastutil.objects.AbstractObjectList;
import it.unimi.dsi.fastutil.objects.ObjectCollection;
import it.unimi.dsi.fastutil.objects.ObjectCollections;
import it.unimi.dsi.fastutil.objects.ObjectIterators;
import it.unimi.dsi.fastutil.objects.ObjectList;
import it.unimi.dsi.fastutil.objects.ObjectListIterator;
import java.io.Serializable;
import java.util.Collection;
import java.util.List;
import java.util.ListIterator;

public class ObjectLists {
    private ObjectLists() {
    }

    public static ObjectList singleton(Object element) {
        return new Singleton(element);
    }

    public static ObjectList synchronize(ObjectList l) {
        return new SynchronizedList(l);
    }

    public static ObjectList synchronize(ObjectList l, Object sync) {
        return new SynchronizedList(l, sync);
    }

    public static ObjectList unmodifiable(ObjectList l) {
        return new UnmodifiableList(l);
    }

    public static class UnmodifiableList
    extends ObjectCollections.UnmodifiableCollection
    implements ObjectList,
    Serializable {
        public static final long serialVersionUID = -7046029254386353129L;
        protected final ObjectList list;

        protected UnmodifiableList(ObjectList l) {
            super(l);
            this.list = l;
        }

        public Object get(int i) {
            return this.list.get(i);
        }

        public Object set(int i, Object k) {
            throw new UnsupportedOperationException();
        }

        public void add(int i, Object k) {
            throw new UnsupportedOperationException();
        }

        public Object remove(int i) {
            throw new UnsupportedOperationException();
        }

        public int indexOf(Object k) {
            return this.list.indexOf(k);
        }

        public int lastIndexOf(Object k) {
            return this.list.lastIndexOf(k);
        }

        public boolean addAll(int index, Collection c) {
            throw new UnsupportedOperationException();
        }

        public boolean addAll(int index, ObjectCollection c) {
            throw new UnsupportedOperationException();
        }

        public boolean addAll(List l) {
            throw new UnsupportedOperationException();
        }

        public boolean addAll(ObjectList l) {
            throw new UnsupportedOperationException();
        }

        public boolean addAll(int index, List l) {
            throw new UnsupportedOperationException();
        }

        public boolean addAll(int index, ObjectList l) {
            throw new UnsupportedOperationException();
        }

        public void getElements(int from, Object[] a, int offset, int length) {
            this.list.getElements(from, a, offset, length);
        }

        public void removeElements(int from, int to) {
            throw new UnsupportedOperationException();
        }

        public void addElements(int index, Object[] a, int offset, int length) {
            throw new UnsupportedOperationException();
        }

        public void addElements(int index, Object[] a) {
            throw new UnsupportedOperationException();
        }

        public void size(int size) {
            this.list.size(size);
        }

        public ListIterator listIterator() {
            return ObjectIterators.unmodifiable((ObjectListIterator)this.list.listIterator());
        }

        public ListIterator listIterator(int i) {
            return ObjectIterators.unmodifiable((ObjectListIterator)this.list.listIterator(i));
        }

        public ObjectListIterator objectListIterator() {
            return ObjectIterators.unmodifiable(this.list.objectListIterator());
        }

        public ObjectListIterator objectListIterator(int i) {
            return ObjectIterators.unmodifiable(this.list.objectListIterator(i));
        }

        public List subList(int from, int to) {
            return new UnmodifiableList((ObjectList)this.list.subList(from, to));
        }

        public ObjectList objectSubList(int from, int to) {
            return new UnmodifiableList(this.list.objectSubList(from, to));
        }

        public boolean equals(Object o) {
            return this.collection.equals(o);
        }

        public int hashCode() {
            return this.collection.hashCode();
        }

        public int compareTo(Object o) {
            return this.list.compareTo(o);
        }
    }

    public static class SynchronizedList
    extends ObjectCollections.SynchronizedCollection
    implements ObjectList,
    Serializable {
        public static final long serialVersionUID = -7046029254386353129L;
        protected final ObjectList list;

        protected SynchronizedList(ObjectList l, Object sync) {
            super(l, sync);
            this.list = l;
        }

        protected SynchronizedList(ObjectList l) {
            super(l);
            this.list = l;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Object get(int i) {
            Object object = this.sync;
            synchronized (object) {
                return this.list.get(i);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Object set(int i, Object k) {
            Object object = this.sync;
            synchronized (object) {
                return this.list.set(i, k);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void add(int i, Object k) {
            Object object = this.sync;
            synchronized (object) {
                this.list.add(i, k);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Object remove(int i) {
            Object object = this.sync;
            synchronized (object) {
                return this.list.remove(i);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public int indexOf(Object k) {
            Object object = this.sync;
            synchronized (object) {
                return this.list.indexOf(k);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public int lastIndexOf(Object k) {
            Object object = this.sync;
            synchronized (object) {
                return this.list.lastIndexOf(k);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean addAll(int index, Collection c) {
            Object object = this.sync;
            synchronized (object) {
                return this.list.addAll(index, c);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean addAll(int index, ObjectCollection c) {
            Object object = this.sync;
            synchronized (object) {
                return this.list.addAll(index, c);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean addAll(List l) {
            Object object = this.sync;
            synchronized (object) {
                return this.list.addAll(l);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean addAll(ObjectList l) {
            Object object = this.sync;
            synchronized (object) {
                return this.list.addAll(l);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean addAll(int index, List l) {
            Object object = this.sync;
            synchronized (object) {
                return this.list.addAll(index, l);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean addAll(int index, ObjectList l) {
            Object object = this.sync;
            synchronized (object) {
                return this.list.addAll(index, l);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void getElements(int from, Object[] a, int offset, int length) {
            Object object = this.sync;
            synchronized (object) {
                this.list.getElements(from, a, offset, length);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void removeElements(int from, int to) {
            Object object = this.sync;
            synchronized (object) {
                this.list.removeElements(from, to);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void addElements(int index, Object[] a, int offset, int length) {
            Object object = this.sync;
            synchronized (object) {
                this.list.addElements(index, a, offset, length);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void addElements(int index, Object[] a) {
            Object object = this.sync;
            synchronized (object) {
                this.list.addElements(index, a);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void size(int size) {
            Object object = this.sync;
            synchronized (object) {
                this.list.size(size);
            }
        }

        public ListIterator listIterator() {
            return this.list.listIterator();
        }

        public ListIterator listIterator(int i) {
            return this.list.listIterator(i);
        }

        public ObjectListIterator objectListIterator() {
            return this.list.objectListIterator();
        }

        public ObjectListIterator objectListIterator(int i) {
            return this.list.objectListIterator(i);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public List subList(int from, int to) {
            Object object = this.sync;
            synchronized (object) {
                return new SynchronizedList((ObjectList)this.list.subList(from, to), this.sync);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public ObjectList objectSubList(int from, int to) {
            Object object = this.sync;
            synchronized (object) {
                return new SynchronizedList(this.list.objectSubList(from, to), this.sync);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean equals(Object o) {
            Object object = this.sync;
            synchronized (object) {
                return this.collection.equals(o);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public int hashCode() {
            Object object = this.sync;
            synchronized (object) {
                return this.collection.hashCode();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public int compareTo(Object o) {
            Object object = this.sync;
            synchronized (object) {
                return this.list.compareTo(o);
            }
        }
    }

    public static class Singleton
    extends AbstractObjectList
    implements Serializable,
    Cloneable {
        public static final long serialVersionUID = -7046029254386353129L;
        private final Object element;

        private Singleton(Object element) {
            this.element = element;
        }

        public boolean rem(Object k) {
            throw new UnsupportedOperationException();
        }

        public boolean add(Object k) {
            throw new UnsupportedOperationException();
        }

        public void add(int i, Object k) {
            throw new UnsupportedOperationException();
        }

        public Object get(int i) {
            if (i == 0) {
                return this.element;
            }
            throw new IndexOutOfBoundsException();
        }

        public Object remove(int i) {
            throw new UnsupportedOperationException();
        }

        public boolean contains(Object k) {
            return k == null ? this.element == null : k.equals(this.element);
        }

        public boolean addAll(ObjectList c) {
            throw new UnsupportedOperationException();
        }

        public boolean addAll(ObjectCollection c) {
            throw new UnsupportedOperationException();
        }

        public boolean addAll(int i, ObjectList c) {
            throw new UnsupportedOperationException();
        }

        public boolean addAll(int i, ObjectCollection c) {
            throw new UnsupportedOperationException();
        }

        public boolean removeAll(ObjectCollection c) {
            throw new UnsupportedOperationException();
        }

        public boolean retainAll(ObjectCollection c) {
            throw new UnsupportedOperationException();
        }

        public Object[] toArray() {
            Object[] a = new Object[]{this.element};
            return a;
        }

        public ObjectListIterator objectListIterator() {
            return ObjectIterators.wrap(this.toArray());
        }

        public ObjectListIterator objectListIterator(int i) {
            if (i > 1 || i < 0) {
                throw new IndexOutOfBoundsException();
            }
            ObjectListIterator l = ObjectIterators.wrap(this.toArray());
            if (i == 1) {
                l.next();
            }
            return l;
        }

        public ObjectList objectSubList(int from, int to) {
            this.ensureIndex(from);
            this.ensureIndex(to);
            if (from > to) {
                throw new IndexOutOfBoundsException("Start index (" + from + ") is greater than end index (" + to + ")");
            }
            if (from != 0 || to != 1) {
                return Lists.EMPTY_LIST;
            }
            return this;
        }

        public int size() {
            return 1;
        }

        public void size(int size) {
            throw new UnsupportedOperationException();
        }

        public void clear() {
            throw new UnsupportedOperationException();
        }

        public Object clone() {
            return this;
        }
    }
}

