/*
 * Decompiled with CFR 0.152.
 */
package it.unimi.dsi.fastutil.objects;

import it.unimi.dsi.fastutil.Iterators;
import it.unimi.dsi.fastutil.objects.AbstractObjectBidirectionalIterator;
import it.unimi.dsi.fastutil.objects.AbstractObjectIterator;
import it.unimi.dsi.fastutil.objects.AbstractObjectListIterator;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import it.unimi.dsi.fastutil.objects.ObjectArrays;
import it.unimi.dsi.fastutil.objects.ObjectBidirectionalIterator;
import it.unimi.dsi.fastutil.objects.ObjectCollection;
import it.unimi.dsi.fastutil.objects.ObjectIterator;
import it.unimi.dsi.fastutil.objects.ObjectList;
import it.unimi.dsi.fastutil.objects.ObjectListIterator;
import java.util.Iterator;
import java.util.ListIterator;
import java.util.NoSuchElementException;

public class ObjectIterators {
    private ObjectIterators() {
    }

    public static ObjectListIterator emptyObjectIterator() {
        return Iterators.EMPTY_ITERATOR;
    }

    public static ObjectListIterator wrap(Object[] array, int offset, int length) {
        ObjectArrays.ensureOffsetLength(array, offset, length);
        return new ArrayIterator(array, offset, length);
    }

    public static ObjectListIterator wrap(Object[] array) {
        return new ArrayIterator(array, 0, array.length);
    }

    public static int unwrap(Iterator i, Object[] array, int offset, int max) {
        if (max < 0) {
            throw new IllegalArgumentException("The maximum number of elements (" + max + ") is negative");
        }
        if (offset < 0 || offset + max > array.length) {
            throw new IllegalArgumentException();
        }
        int j = max;
        while (j-- != 0 && i.hasNext()) {
            array[offset++] = i.next();
        }
        return max - j - 1;
    }

    public static int unwrap(Iterator i, Object[] array) {
        return ObjectIterators.unwrap(i, array, 0, array.length);
    }

    public static Object[] unwrap(Iterator i, int max) {
        if (max < 0) {
            throw new IllegalArgumentException("The maximum number of elements (" + max + ") is negative");
        }
        Object[] array = new Object[16];
        int j = 0;
        while (max-- != 0 && i.hasNext()) {
            if (j == array.length) {
                array = ObjectArrays.grow(array, j + 1);
            }
            array[j++] = i.next();
        }
        return ObjectArrays.trim(array, j);
    }

    public static Object[] unwrap(Iterator i) {
        return ObjectIterators.unwrap(i, Integer.MAX_VALUE);
    }

    public static int unwrap(Iterator i, ObjectCollection c, int max) {
        if (max < 0) {
            throw new IllegalArgumentException("The maximum number of elements (" + max + ") is negative");
        }
        int j = max;
        while (j-- != 0 && i.hasNext()) {
            c.add(i.next());
        }
        return max - j - 1;
    }

    public static long unwrap(Iterator i, ObjectCollection c) {
        long n = 0L;
        while (i.hasNext()) {
            c.add(i.next());
            ++n;
        }
        return n;
    }

    public static int pour(Iterator i, ObjectCollection s, int max) {
        if (max < 0) {
            throw new IllegalArgumentException("The maximum number of elements (" + max + ") is negative");
        }
        int j = max;
        while (j-- != 0 && i.hasNext()) {
            s.add(i.next());
        }
        return max - j - 1;
    }

    public static int pour(Iterator i, ObjectCollection s) {
        return ObjectIterators.pour(i, s, Integer.MAX_VALUE);
    }

    public static ObjectList pour(Iterator i, int max) {
        ObjectArrayList l = new ObjectArrayList();
        ObjectIterators.pour(i, l, max);
        l.trim();
        return l;
    }

    public static ObjectList pour(Iterator i) {
        return ObjectIterators.pour(i, Integer.MAX_VALUE);
    }

    public static ObjectListIterator asObjectIterator(ListIterator i) {
        if (i instanceof ObjectListIterator) {
            return (ObjectListIterator)i;
        }
        return new ListIteratorWrapper(i);
    }

    public static ObjectIterator asObjectIterator(Iterator i) {
        if (i instanceof ObjectIterator) {
            return (ObjectIterator)i;
        }
        return new IteratorWrapper(i);
    }

    public static ObjectIterator concat(ObjectIterator[] a) {
        return ObjectIterators.concat(a, 0, a.length);
    }

    public static ObjectIterator concat(ObjectIterator[] a, int offset, int length) {
        return new IteratorConcatenator(a, offset, length);
    }

    public static ObjectIterator unmodifiable(ObjectIterator i) {
        return new UnmodifiableIterator(i);
    }

    public static ObjectBidirectionalIterator unmodifiable(ObjectBidirectionalIterator i) {
        return new UnmodifiableBidirectionalIterator(i);
    }

    public static ObjectListIterator unmodifiable(ObjectListIterator i) {
        return new UnmodifiableListIterator(i);
    }

    public static class UnmodifiableListIterator
    extends AbstractObjectListIterator {
        protected final ObjectListIterator i;

        public UnmodifiableListIterator(ObjectListIterator i) {
            this.i = i;
        }

        public boolean hasNext() {
            return this.i.hasNext();
        }

        public boolean hasPrevious() {
            return this.i.hasPrevious();
        }

        public Object next() {
            return this.i.next();
        }

        public Object previous() {
            return this.i.previous();
        }

        public int nextIndex() {
            return this.i.nextIndex();
        }

        public int previousIndex() {
            return this.i.previousIndex();
        }
    }

    public static class UnmodifiableBidirectionalIterator
    extends AbstractObjectBidirectionalIterator {
        protected final ObjectBidirectionalIterator i;

        public UnmodifiableBidirectionalIterator(ObjectBidirectionalIterator i) {
            this.i = i;
        }

        public boolean hasNext() {
            return this.i.hasNext();
        }

        public boolean hasPrevious() {
            return this.i.hasPrevious();
        }

        public Object next() {
            return this.i.next();
        }

        public Object previous() {
            return this.i.previous();
        }
    }

    public static class UnmodifiableIterator
    extends AbstractObjectIterator {
        protected final ObjectIterator i;

        public UnmodifiableIterator(ObjectIterator i) {
            this.i = i;
        }

        public boolean hasNext() {
            return this.i.hasNext();
        }

        public Object next() {
            return this.i.next();
        }
    }

    private static class IteratorConcatenator
    extends AbstractObjectIterator {
        final ObjectIterator[] a;
        int offset;
        int length;
        int lastOffset = -1;

        public IteratorConcatenator(ObjectIterator[] a, int offset, int length) {
            this.a = a;
            this.offset = offset;
            this.length = length;
            this.advance();
        }

        private void advance() {
            while (this.length != 0 && !this.a[this.offset].hasNext()) {
                --this.length;
                ++this.offset;
            }
        }

        public boolean hasNext() {
            return this.length > 0;
        }

        public Object next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            this.lastOffset = this.offset;
            Object next = this.a[this.lastOffset].next();
            this.advance();
            return next;
        }

        public void remove() {
            if (this.lastOffset == -1) {
                throw new IllegalStateException();
            }
            this.a[this.lastOffset].remove();
        }

        public int skip(int n) {
            this.lastOffset = -1;
            int skipped = 0;
            while (skipped < n && this.length != 0) {
                skipped += this.a[this.offset].skip(n - skipped);
                if (this.a[this.offset].hasNext()) break;
                --this.length;
                ++this.offset;
            }
            return skipped;
        }
    }

    private static class ListIteratorWrapper
    extends AbstractObjectListIterator {
        final ListIterator i;

        public ListIteratorWrapper(ListIterator i) {
            this.i = i;
        }

        public boolean hasNext() {
            return this.i.hasNext();
        }

        public boolean hasPrevious() {
            return this.i.hasPrevious();
        }

        public int nextIndex() {
            return this.i.nextIndex();
        }

        public int previousIndex() {
            return this.i.previousIndex();
        }

        public void set(Object k) {
            this.i.set(k);
        }

        public void add(Object k) {
            this.i.add(k);
        }

        public void remove() {
            this.i.remove();
        }

        public Object next() {
            return this.i.next();
        }

        public Object previous() {
            return this.i.previous();
        }
    }

    private static class IteratorWrapper
    extends AbstractObjectIterator {
        final Iterator i;

        public IteratorWrapper(Iterator i) {
            this.i = i;
        }

        public boolean hasNext() {
            return this.i.hasNext();
        }

        public void remove() {
            this.i.remove();
        }

        public Object next() {
            return this.i.next();
        }
    }

    private static class ArrayIterator
    extends AbstractObjectListIterator {
        private final Object[] array;
        private final int offset;
        private final int length;
        private int curr;

        public ArrayIterator(Object[] array, int offset, int length) {
            this.array = array;
            this.offset = offset;
            this.length = length;
        }

        public boolean hasNext() {
            return this.curr < this.length;
        }

        public boolean hasPrevious() {
            return this.curr > 0;
        }

        public Object next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            return this.array[this.offset + this.curr++];
        }

        public Object previous() {
            if (!this.hasPrevious()) {
                throw new NoSuchElementException();
            }
            return this.array[this.offset + --this.curr];
        }

        public int skip(int n) {
            if (n <= this.length - this.curr) {
                this.curr += n;
                return n;
            }
            n = this.length - this.curr;
            this.curr = this.length;
            return n;
        }

        public int back(int n) {
            if (n <= this.curr) {
                this.curr -= n;
                return n;
            }
            n = this.curr;
            this.curr = 0;
            return n;
        }

        public int nextIndex() {
            return this.curr;
        }

        public int previousIndex() {
            return this.curr - 1;
        }
    }
}

