/*
 * Decompiled with CFR 0.152.
 */
package it.unimi.dsi.fastutil.objects;

import it.unimi.dsi.fastutil.AbstractPriorityQueue;
import it.unimi.dsi.fastutil.objects.ObjectArrays;
import it.unimi.dsi.fastutil.objects.ObjectHeaps;
import java.util.Comparator;
import java.util.NoSuchElementException;

public class ObjectHeapPriorityQueue
extends AbstractPriorityQueue {
    protected Object[] heap = ObjectArrays.EMPTY_ARRAY;
    protected int size;
    protected Comparator c;

    public ObjectHeapPriorityQueue(int capacity, Comparator c) {
        if (capacity > 0) {
            this.heap = new Object[capacity];
        }
        this.c = c;
    }

    public ObjectHeapPriorityQueue(int capacity) {
        this(capacity, null);
    }

    public ObjectHeapPriorityQueue(Comparator c) {
        this(0, c);
    }

    public ObjectHeapPriorityQueue() {
        this(0, null);
    }

    public ObjectHeapPriorityQueue(Object[] a, int size, Comparator c) {
        this(c);
        this.heap = a;
        this.size = size;
        ObjectHeaps.makeHeap(a, size, c);
    }

    public ObjectHeapPriorityQueue(Object[] a, Comparator c) {
        this(a, a.length, c);
    }

    public ObjectHeapPriorityQueue(Object[] a, int size) {
        this(a, size, null);
    }

    public ObjectHeapPriorityQueue(Object[] a) {
        this(a, a.length);
    }

    private void ensureNonEmpty() {
        if (this.size == 0) {
            throw new NoSuchElementException();
        }
    }

    public void enqueue(Object x) {
        if (this.size == this.heap.length) {
            this.heap = ObjectArrays.grow(this.heap, this.size + 1);
        }
        this.heap[this.size++] = x;
        ObjectHeaps.upHeap(this.heap, this.size, this.size - 1, this.c);
    }

    public Object dequeue() {
        this.ensureNonEmpty();
        Object result = this.heap[0];
        this.heap[0] = this.heap[--this.size];
        this.heap[this.size] = null;
        if (this.size != 0) {
            ObjectHeaps.downHeap(this.heap, this.size, 0, this.c);
        }
        return result;
    }

    public Object first() {
        this.ensureNonEmpty();
        return this.heap[0];
    }

    public void changed() {
        this.ensureNonEmpty();
        ObjectHeaps.downHeap(this.heap, this.size, 0, this.c);
    }

    public int size() {
        return this.size;
    }

    public void clear() {
        ObjectArrays.fill(this.heap, 0, this.size, null);
        this.size = 0;
    }

    public void trim() {
        this.heap = ObjectArrays.trim(this.heap, this.size);
    }

    public Comparator comparator() {
        return this.c;
    }
}

