/*
 * Decompiled with CFR 0.152.
 */
package it.unimi.dsi.fastutil.objects;

import java.util.Comparator;

public class ObjectComparators {
    public static final Comparator NATURAL_COMPARATOR = new Comparator(){

        public final int compare(Object a, Object b) {
            return ((Comparable)a).compareTo(b);
        }
    };
    public static final Comparator OPPOSITE_COMPARATOR = new Comparator(){

        public final int compare(Object a, Object b) {
            return ((Comparable)b).compareTo(a);
        }
    };

    private ObjectComparators() {
    }

    public static Comparator oppositeComparator(final Comparator c) {
        return new Comparator(){
            private final Comparator comparator;
            {
                this.comparator = c;
            }

            public final int compare(Object a, Object b) {
                return -this.comparator.compare(a, b);
            }
        };
    }
}

