/*
 * Decompiled with CFR 0.152.
 */
package it.unimi.dsi.fastutil.objects;

import it.unimi.dsi.fastutil.Hash;
import it.unimi.dsi.fastutil.HashCommon;
import it.unimi.dsi.fastutil.bytes.ByteArrays;
import it.unimi.dsi.fastutil.longs.AbstractLongCollection;
import it.unimi.dsi.fastutil.longs.LongCollection;
import it.unimi.dsi.fastutil.longs.LongIterator;
import it.unimi.dsi.fastutil.longs.LongListIterator;
import it.unimi.dsi.fastutil.objects.AbstractObject2LongSortedMap;
import it.unimi.dsi.fastutil.objects.AbstractObjectListIterator;
import it.unimi.dsi.fastutil.objects.AbstractObjectSet;
import it.unimi.dsi.fastutil.objects.AbstractObjectSortedSet;
import it.unimi.dsi.fastutil.objects.Object2LongMap;
import it.unimi.dsi.fastutil.objects.Object2LongSortedMap;
import it.unimi.dsi.fastutil.objects.ObjectArrays;
import it.unimi.dsi.fastutil.objects.ObjectBidirectionalIterator;
import it.unimi.dsi.fastutil.objects.ObjectIterator;
import it.unimi.dsi.fastutil.objects.ObjectListIterator;
import it.unimi.dsi.fastutil.objects.ObjectSet;
import it.unimi.dsi.fastutil.objects.ObjectSortedSet;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import java.util.SortedMap;
import java.util.SortedSet;

public class Object2LongLinkedOpenHashMap
extends AbstractObject2LongSortedMap
implements Serializable,
Cloneable,
Hash,
Object2LongSortedMap {
    protected transient Object[] key;
    protected transient long[] value;
    protected transient byte[] state;
    protected final float f;
    protected transient int p;
    protected transient int maxFill;
    protected transient int free;
    protected int count;
    protected volatile transient ObjectSet entries;
    protected volatile transient ObjectSet keys;
    protected volatile transient LongCollection values;
    protected transient int growthFactor = 16;
    protected transient int first = -1;
    protected transient int last = -1;
    protected transient int[] link;
    public static final long serialVersionUID = -7046029254386353129L;
    private static final boolean ASSERTS = false;

    public Object2LongLinkedOpenHashMap(int n, float f) {
        if (f <= 0.0f || f > 1.0f) {
            throw new IllegalArgumentException("Load factor must be greater than 0 and smaller than or equal to 1");
        }
        if (n < 0) {
            throw new IllegalArgumentException("Hash table size must be nonnegative");
        }
        int l = Arrays.binarySearch(PRIMES, (int)((float)n / f) + 1);
        if (l < 0) {
            l = -l - 1;
        }
        this.p = l;
        this.free = PRIMES[this.p];
        this.f = f;
        this.maxFill = (int)((float)this.free * f);
        this.key = new Object[this.free];
        this.value = new long[this.free];
        this.state = new byte[this.free];
        this.link = new int[this.free];
    }

    public Object2LongLinkedOpenHashMap(int n) {
        this(n, 0.75f);
    }

    public Object2LongLinkedOpenHashMap() {
        this(16, 0.75f);
    }

    public Object2LongLinkedOpenHashMap(Map m, float f) {
        this(m.size(), f);
        this.putAll(m);
    }

    public Object2LongLinkedOpenHashMap(Map m) {
        this(m, 0.75f);
    }

    public Object2LongLinkedOpenHashMap(Object2LongMap m, float f) {
        this(m.size(), f);
        this.putAll((Map)m);
    }

    public Object2LongLinkedOpenHashMap(Object2LongMap m) {
        this(m, 0.75f);
    }

    public void growthFactor(int growthFactor) {
        if (growthFactor <= 0) {
            throw new IllegalArgumentException("Illegal growth factor " + growthFactor);
        }
        this.growthFactor = growthFactor;
    }

    public int growthFactor() {
        return this.growthFactor;
    }

    private int findInsertionPoint(Object k) {
        Object[] key;
        int n;
        byte[] state = this.state;
        int h = k == null ? 0 : k.hashCode();
        int k2i = h & Integer.MAX_VALUE;
        int h1 = k2i % (n = (key = this.key).length);
        if (state[h1] == -1 && !(k != null ? h == key[h1].hashCode() && k.equals(key[h1]) : key[h1] == null)) {
            int h2 = k2i % (n - 2) + 1;
            while (state[h1 = (h1 + h2) % n] == -1 && !(k == null ? key[h1] == null : h == key[h1].hashCode() && k.equals(key[h1]))) {
            }
        }
        if (state[h1] == 0) {
            return h1;
        }
        if (state[h1] == -1) {
            return -h1 - 1;
        }
        int i = h1;
        if (state[h1] != 0 && !(k != null ? h == key[h1].hashCode() && k.equals(key[h1]) : key[h1] == null)) {
            int h2 = k2i % (n - 2) + 1;
            while (state[h1 = (h1 + h2) % n] != 0 && !(k == null ? key[h1] == null : h == key[h1].hashCode() && k.equals(key[h1]))) {
            }
        }
        return state[h1] == -1 ? -h1 - 1 : i;
    }

    private int findKey(Object k) {
        Object[] key;
        int n;
        byte[] state = this.state;
        int h = k == null ? 0 : k.hashCode();
        int k2i = h & Integer.MAX_VALUE;
        int h1 = k2i % (n = (key = this.key).length);
        if (state[h1] != 0 && !(k != null ? h == key[h1].hashCode() && k.equals(key[h1]) : key[h1] == null)) {
            int h2 = k2i % (n - 2) + 1;
            while (state[h1 = (h1 + h2) % n] != 0 && !(k == null ? key[h1] == null : h == key[h1].hashCode() && k.equals(key[h1]))) {
            }
        }
        return state[h1] == -1 ? h1 : -1;
    }

    public long put(Object k, long v) {
        int i = this.findInsertionPoint(k);
        if (i < 0) {
            long oldValue = this.value[-i - 1];
            this.value[-i - 1] = v;
            return oldValue;
        }
        if (this.state[i] == 0) {
            --this.free;
        }
        this.state[i] = -1;
        this.key[i] = k;
        this.value[i] = v;
        if (this.count == 0) {
            this.first = this.last = i;
            this.link[i] = 0;
        } else {
            int n = this.last;
            this.link[n] = this.link[n] ^ ~i;
            this.link[i] = ~this.last;
            this.last = i;
        }
        if (++this.count >= this.maxFill) {
            int newP = Math.min(this.p + this.growthFactor, PRIMES.length - 1);
            while (PRIMES[newP] == PRIMES[this.p]) {
                ++newP;
            }
            this.rehash(newP);
        }
        if (this.free == 0) {
            this.rehash(this.p);
        }
        return this.defRetValue;
    }

    public Object put(Object ok, Object ov) {
        long v = (Long)ov;
        Object k = ok;
        int i = this.findInsertionPoint(k);
        if (i < 0) {
            long oldValue = this.value[-i - 1];
            this.value[-i - 1] = v;
            return new Long(oldValue);
        }
        if (this.state[i] == 0) {
            --this.free;
        }
        this.state[i] = -1;
        this.key[i] = k;
        this.value[i] = v;
        if (this.count == 0) {
            this.first = this.last = i;
            this.link[i] = 0;
        } else {
            int n = this.last;
            this.link[n] = this.link[n] ^ ~i;
            this.link[i] = ~this.last;
            this.last = i;
        }
        if (++this.count >= this.maxFill) {
            this.rehash(Math.min(this.p + 16, PRIMES.length - 1));
        }
        if (this.free == 0) {
            this.rehash(this.p);
        }
        return null;
    }

    public boolean containsValue(long v) {
        long[] value = this.value;
        byte[] state = this.state;
        int i = 0;
        int j = this.count;
        while (j-- != 0) {
            while (state[i] != -1) {
                ++i;
            }
            if (value[i] == v) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public void clear() {
        if (this.free == this.state.length) {
            return;
        }
        this.free = this.state.length;
        this.count = 0;
        ByteArrays.fill(this.state, (byte)0);
        ObjectArrays.fill(this.key, null);
        this.last = -1;
        this.first = -1;
    }

    private void fixPointers(int i) {
        int next;
        if (this.count == 0) {
            this.last = -1;
            this.first = -1;
            return;
        }
        if (this.first == i) {
            int n = this.first = ~this.link[i];
            this.link[n] = this.link[n] ^ ~i;
            return;
        }
        if (this.last == i) {
            int n = this.last = ~this.link[i];
            this.link[n] = this.link[n] ^ ~i;
            return;
        }
        int j = this.first;
        int prev = -1;
        while ((next = this.link[j] ^ prev) != i) {
            prev = j;
            j = next;
        }
        int n = j;
        this.link[n] = this.link[n] ^ (this.link[i] ^ i ^ j);
        int n2 = this.link[i] ^ j;
        this.link[n2] = this.link[n2] ^ (i ^ j);
    }

    public Object firstKey() {
        if (this.count == 0) {
            throw new NoSuchElementException();
        }
        return this.key[this.first];
    }

    public Object lastKey() {
        if (this.count == 0) {
            throw new NoSuchElementException();
        }
        return this.key[this.last];
    }

    public Comparator comparator() {
        return null;
    }

    public SortedMap tailMap(Object from) {
        throw new UnsupportedOperationException();
    }

    public SortedMap headMap(Object to) {
        throw new UnsupportedOperationException();
    }

    public SortedMap subMap(Object from, Object to) {
        throw new UnsupportedOperationException();
    }

    public boolean containsKey(Object k) {
        return this.findKey(k) >= 0;
    }

    public int size() {
        return this.count;
    }

    public boolean isEmpty() {
        return this.count == 0;
    }

    public long getLong(Object k) {
        int i = this.findKey(k);
        return i < 0 ? this.defRetValue : this.value[i];
    }

    public long removeLong(Object k) {
        int i = this.findKey(k);
        if (i < 0) {
            return this.defRetValue;
        }
        this.state[i] = 1;
        --this.count;
        this.key[i] = HashCommon.REMOVED;
        this.fixPointers(i);
        return this.value[i];
    }

    public Object get(Object ok) {
        int i = this.findKey(ok);
        return i < 0 ? null : new Long(this.value[i]);
    }

    public Object remove(Object ok) {
        Object k = ok;
        int i = this.findKey(k);
        if (i < 0) {
            return null;
        }
        this.state[i] = 1;
        --this.count;
        this.key[i] = HashCommon.REMOVED;
        this.fixPointers(i);
        return new Long(this.value[i]);
    }

    public Set entrySet() {
        if (this.entries == null) {
            this.entries = new AbstractObjectSet(){

                public ObjectIterator objectIterator() {
                    return new MapIterator();
                }

                public boolean contains(Object o) {
                    if (!(o instanceof Map.Entry)) {
                        return false;
                    }
                    Map.Entry e = (Map.Entry)o;
                    int i = Object2LongLinkedOpenHashMap.this.findKey(e.getKey());
                    return i >= 0 && Object2LongLinkedOpenHashMap.this.value[i] == (Long)e.getValue();
                }

                public boolean remove(Object o) {
                    if (!(o instanceof Map.Entry)) {
                        return false;
                    }
                    Map.Entry e = (Map.Entry)o;
                    int i = Object2LongLinkedOpenHashMap.this.findKey(e.getKey());
                    if (i >= 0) {
                        Object2LongLinkedOpenHashMap.this.remove(e.getKey());
                    }
                    return i >= 0;
                }

                public int size() {
                    return Object2LongLinkedOpenHashMap.this.count;
                }

                public void clear() {
                    Object2LongLinkedOpenHashMap.this.clear();
                }
            };
        }
        return this.entries;
    }

    public Set keySet() {
        if (this.keys == null) {
            this.keys = new KeySet();
        }
        return this.keys;
    }

    public Collection values() {
        if (this.values == null) {
            this.values = new AbstractLongCollection(){

                public LongIterator longIterator() {
                    return new ValueIterator();
                }

                public int size() {
                    return Object2LongLinkedOpenHashMap.this.count;
                }

                public boolean contains(long v) {
                    return Object2LongLinkedOpenHashMap.this.containsValue(v);
                }

                public void clear() {
                    Object2LongLinkedOpenHashMap.this.clear();
                }
            };
        }
        return this.values;
    }

    public boolean rehash() {
        try {
            this.rehash(this.p);
        }
        catch (OutOfMemoryError cantDoIt) {
            return false;
        }
        return true;
    }

    public boolean trim() {
        int l = Arrays.binarySearch(PRIMES, (int)((float)this.count / this.f) + 1);
        if (l < 0) {
            l = -l - 1;
        }
        if (l >= this.p) {
            return true;
        }
        try {
            this.rehash(l);
        }
        catch (OutOfMemoryError cantDoIt) {
            return false;
        }
        return true;
    }

    public boolean trim(int n) {
        int l = Arrays.binarySearch(PRIMES, (int)Math.min(2.1474836E9f, (float)Math.max(n, this.count) / this.f) + 1);
        if (l < 0) {
            l = -l - 1;
        }
        if (this.p <= l) {
            return true;
        }
        try {
            this.rehash(l);
        }
        catch (OutOfMemoryError cantDoIt) {
            return false;
        }
        return true;
    }

    protected void rehash(int newP) {
        int i = this.first;
        int j = this.count;
        int prev = -1;
        int newPrev = -1;
        int newN = PRIMES[newP];
        Object[] key = this.key;
        Object[] newKey = new Object[newN];
        long[] value = this.value;
        long[] newValue = new long[newN];
        byte[] state = this.state;
        byte[] newState = new byte[newN];
        int[] link = this.link;
        int[] newLink = new int[newN];
        this.first = -1;
        while (j-- != 0) {
            while (state[i] != -1) {
                ++i;
            }
            Object k = key[i];
            long v = value[i];
            int k2i = (k == null ? 0 : k.hashCode()) & Integer.MAX_VALUE;
            int h1 = k2i % newN;
            int h2 = k2i % (newN - 2) + 1;
            if (newState[h1] != 0) {
                h2 = k2i % (newN - 2) + 1;
                while (newState[h1 = (h1 + h2) % newN] != 0) {
                }
            }
            newState[h1] = -1;
            newKey[h1] = k;
            newValue[h1] = v;
            int t = i;
            i = link[i] ^ prev;
            prev = t;
            if (this.first != -1) {
                int n = newPrev;
                newLink[n] = newLink[n] ^ h1;
                newLink[h1] = newPrev;
                newPrev = h1;
                continue;
            }
            newPrev = this.first = h1;
            newLink[h1] = -1;
        }
        this.p = newP;
        this.free = newN - this.count;
        this.maxFill = (int)((float)newN * this.f);
        this.key = newKey;
        this.value = newValue;
        this.state = newState;
        this.link = newLink;
        this.last = newPrev;
        if (newPrev != -1) {
            int n = newPrev;
            newLink[n] = ~newLink[n];
        }
    }

    public Object clone() {
        Object2LongLinkedOpenHashMap c;
        try {
            c = (Object2LongLinkedOpenHashMap)super.clone();
        }
        catch (CloneNotSupportedException cantHappen) {
            throw new InternalError();
        }
        c.keys = null;
        c.values = null;
        c.entries = null;
        c.key = (Object[])this.key.clone();
        c.value = (long[])this.value.clone();
        c.state = (byte[])this.state.clone();
        c.link = (int[])this.link.clone();
        return c;
    }

    public int hashCode() {
        int h = 0;
        int i = 0;
        int j = this.count;
        while (j-- != 0) {
            while (this.state[i] != -1) {
                ++i;
            }
            int t = 0;
            if (this != this.key[i]) {
                t = this.key[i] == null ? 0 : this.key[i].hashCode();
            }
            h += (t ^= HashCommon.long2int(this.value[i]));
            ++i;
        }
        return h;
    }

    private void writeObject(ObjectOutputStream s) throws IOException {
        Object[] key = this.key;
        long[] value = this.value;
        byte[] state = this.state;
        MapIterator i = new MapIterator();
        int j = this.count;
        s.defaultWriteObject();
        while (j-- != 0) {
            int e = i.nextEntry();
            s.writeObject(key[e]);
            s.writeLong(value[e]);
        }
    }

    private void checkTable() {
        Object k;
        int n = this.state.length;
        while (n-- != 0) {
            if (this.state[n] == -1 && !this.containsKey(this.key[n])) {
                throw new AssertionError((Object)("Hash table has key " + this.key[n] + " marked as occupied, but the key does not belong to the table"));
            }
        }
        ObjectBidirectionalIterator i = (ObjectBidirectionalIterator)this.keySet().iterator();
        n = this.size();
        while (n-- != 0) {
            k = i.next();
            if (!this.containsKey(k)) {
                throw new AssertionError((Object)("Linked hash table forward enumerates key " + k + ", but the key does not belong to the table"));
            }
        }
        if (i.hasNext()) {
            throw new AssertionError((Object)"Forward iterator not exhausted");
        }
        n = this.size();
        if (n > 0) {
            i = ((ObjectSortedSet)this.keySet()).iterator(this.lastKey());
            while (n-- != 0) {
                k = i.previous();
                if (!this.containsKey(k)) {
                    throw new AssertionError((Object)("Linked hash table backward enumerates key " + k + ", but the key does not belong to the table"));
                }
            }
            if (i.hasPrevious()) {
                throw new AssertionError((Object)"Previous iterator not exhausted");
            }
        }
    }

    private void readObject(ObjectInputStream s) throws IOException, ClassNotFoundException {
        s.defaultReadObject();
        this.growthFactor = 16;
        this.p = Arrays.binarySearch(PRIMES, (int)((float)this.count / this.f) + 1);
        if (this.p < 0) {
            this.p = -this.p - 1;
        }
        int n = PRIMES[this.p];
        this.maxFill = (int)((float)n * this.f);
        this.free = n - this.count;
        this.key = new Object[n];
        Object[] key = this.key;
        this.value = new long[n];
        long[] value = this.value;
        this.state = new byte[n];
        byte[] state = this.state;
        this.link = new int[n];
        int[] link = this.link;
        int prev = -1;
        this.last = -1;
        this.first = -1;
        int i = this.count;
        while (i-- != 0) {
            Object k = s.readObject();
            long v = s.readLong();
            int k2i = (k == null ? 0 : k.hashCode()) & Integer.MAX_VALUE;
            int h1 = k2i % n;
            if (state[h1] != 0) {
                int h2 = k2i % (n - 2) + 1;
                while (state[h1 = (h1 + h2) % n] != 0) {
                }
            }
            state[h1] = -1;
            key[h1] = k;
            value[h1] = v;
            if (this.first != -1) {
                int n2 = prev;
                link[n2] = link[n2] ^ h1;
                link[h1] = prev;
                prev = h1;
                continue;
            }
            prev = this.first = h1;
            link[h1] = -1;
        }
        this.last = prev;
        if (prev != -1) {
            int n3 = prev;
            link[n3] = ~link[n3];
        }
    }

    private final class ValueIterator
    extends MapIterator
    implements LongListIterator {
        public long previousLong() {
            return Object2LongLinkedOpenHashMap.this.value[this.previousEntry()];
        }

        public Object previous() {
            return new Long(Object2LongLinkedOpenHashMap.this.value[this.previousEntry()]);
        }

        public long nextLong() {
            return Object2LongLinkedOpenHashMap.this.value[this.nextEntry()];
        }

        public Object next() {
            return new Long(Object2LongLinkedOpenHashMap.this.value[this.nextEntry()]);
        }

        public void set(long v) {
            throw new UnsupportedOperationException();
        }

        public void add(long v) {
            throw new UnsupportedOperationException();
        }
    }

    private final class KeySet
    extends AbstractObjectSortedSet
    implements ObjectSortedSet {
        private KeySet() {
        }

        public ObjectBidirectionalIterator iterator(Object from) {
            return new KeyIterator(from);
        }

        public ObjectIterator objectIterator() {
            return new KeyIterator();
        }

        public int size() {
            return Object2LongLinkedOpenHashMap.this.count;
        }

        public boolean contains(Object k) {
            return Object2LongLinkedOpenHashMap.this.containsKey(k);
        }

        public boolean remove(Object k) {
            int oldCount = Object2LongLinkedOpenHashMap.this.count;
            Object2LongLinkedOpenHashMap.this.remove(k);
            return Object2LongLinkedOpenHashMap.this.count != oldCount;
        }

        public void clear() {
            Object2LongLinkedOpenHashMap.this.clear();
        }

        public Object first() {
            if (Object2LongLinkedOpenHashMap.this.count == 0) {
                throw new NoSuchElementException();
            }
            return Object2LongLinkedOpenHashMap.this.key[Object2LongLinkedOpenHashMap.this.first];
        }

        public Object last() {
            if (Object2LongLinkedOpenHashMap.this.count == 0) {
                throw new NoSuchElementException();
            }
            return Object2LongLinkedOpenHashMap.this.key[Object2LongLinkedOpenHashMap.this.last];
        }

        public Comparator comparator() {
            return null;
        }

        public final SortedSet tailSet(Object from) {
            throw new UnsupportedOperationException();
        }

        public final SortedSet headSet(Object to) {
            throw new UnsupportedOperationException();
        }

        public final SortedSet subSet(Object from, Object to) {
            throw new UnsupportedOperationException();
        }
    }

    private final class KeyIterator
    extends MapIterator
    implements ObjectListIterator {
        public KeyIterator(Object k) {
            super(k);
        }

        public Object previous() {
            return Object2LongLinkedOpenHashMap.this.key[this.previousEntry()];
        }

        public KeyIterator() {
        }

        public Object next() {
            return Object2LongLinkedOpenHashMap.this.key[this.nextEntry()];
        }

        public void set(Object k) {
            throw new UnsupportedOperationException();
        }

        public void add(Object k) {
            throw new UnsupportedOperationException();
        }
    }

    private class MapIterator
    extends AbstractObjectListIterator {
        int prev = -1;
        int next = -1;
        int curr = -1;
        int index = 0;

        MapIterator() {
            this.next = Object2LongLinkedOpenHashMap.this.first;
        }

        MapIterator(Object from) {
            if (Object2LongLinkedOpenHashMap.this.key[Object2LongLinkedOpenHashMap.this.last] == null ? from == null : Object2LongLinkedOpenHashMap.this.key[Object2LongLinkedOpenHashMap.this.last].equals(from)) {
                this.prev = Object2LongLinkedOpenHashMap.this.last;
                this.index = Object2LongLinkedOpenHashMap.this.count;
            } else {
                int e;
                if (!Object2LongLinkedOpenHashMap.this.containsKey(from)) {
                    throw new IllegalArgumentException("The key " + from + " does not belong to this set.");
                }
                this.next = Object2LongLinkedOpenHashMap.this.first;
                while (!(Object2LongLinkedOpenHashMap.this.key[e = this.nextEntry()] == null ? from == null : Object2LongLinkedOpenHashMap.this.key[e].equals(from))) {
                }
                this.curr = -1;
            }
        }

        public boolean hasNext() {
            return this.next != -1;
        }

        public boolean hasPrevious() {
            return this.prev != -1;
        }

        int nextEntry() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            this.curr = this.next;
            this.next = Object2LongLinkedOpenHashMap.this.link[this.curr] ^ this.prev;
            this.prev = this.curr;
            ++this.index;
            return this.curr;
        }

        int previousEntry() {
            if (!this.hasPrevious()) {
                throw new NoSuchElementException();
            }
            this.curr = this.prev;
            this.prev = Object2LongLinkedOpenHashMap.this.link[this.curr] ^ this.next;
            this.next = this.curr;
            --this.index;
            return this.curr;
        }

        public Object next() {
            return new MapEntry(this.nextEntry());
        }

        public Object previous() {
            return new MapEntry(this.previousEntry());
        }

        public int nextIndex() {
            return this.index;
        }

        public int previousIndex() {
            return this.index - 1;
        }

        public void remove() {
            if (this.curr == -1) {
                throw new IllegalStateException();
            }
            Object2LongLinkedOpenHashMap.this.state[this.curr] = 1;
            Object2LongLinkedOpenHashMap.this.key[this.curr] = HashCommon.REMOVED;
            if (this.curr == this.prev) {
                --this.index;
                this.prev = Object2LongLinkedOpenHashMap.this.link[this.curr] ^ this.next;
            } else {
                this.next = Object2LongLinkedOpenHashMap.this.link[this.curr] ^ this.prev;
            }
            --Object2LongLinkedOpenHashMap.this.count;
            if (this.prev == -1) {
                Object2LongLinkedOpenHashMap.this.first = this.next;
            } else {
                int n = this.prev;
                Object2LongLinkedOpenHashMap.this.link[n] = Object2LongLinkedOpenHashMap.this.link[n] ^ (this.curr ^ this.next);
            }
            if (this.next == -1) {
                Object2LongLinkedOpenHashMap.this.last = this.prev;
            } else {
                int n = this.next;
                Object2LongLinkedOpenHashMap.this.link[n] = Object2LongLinkedOpenHashMap.this.link[n] ^ (this.curr ^ this.prev);
            }
            this.curr = -1;
        }

        public void set(Object o) {
            throw new UnsupportedOperationException();
        }

        public void add(Object o) {
            throw new UnsupportedOperationException();
        }
    }

    private final class MapEntry
    implements Object2LongMap.Entry {
        private int index;

        MapEntry(int index) {
            this.index = index;
        }

        public Object getKey() {
            return Object2LongLinkedOpenHashMap.this.key[this.index];
        }

        public Object getValue() {
            return new Long(Object2LongLinkedOpenHashMap.this.value[this.index]);
        }

        public long getLongValue() {
            return Object2LongLinkedOpenHashMap.this.value[this.index];
        }

        public long setValue(long v) {
            long oldValue = Object2LongLinkedOpenHashMap.this.value[this.index];
            Object2LongLinkedOpenHashMap.this.value[this.index] = v;
            return oldValue;
        }

        public Object setValue(Object v) {
            return new Long(this.setValue((Long)v));
        }

        public boolean equals(Object o) {
            if (!(o instanceof Map.Entry)) {
                return false;
            }
            Map.Entry e = (Map.Entry)o;
            return (Object2LongLinkedOpenHashMap.this.key[this.index] == null ? e.getKey() == null : Object2LongLinkedOpenHashMap.this.key[this.index].equals(e.getKey())) && Object2LongLinkedOpenHashMap.this.value[this.index] == (Long)e.getValue();
        }

        public int hashCode() {
            return (Object2LongLinkedOpenHashMap.this.key[this.index] == null ? 0 : Object2LongLinkedOpenHashMap.this.key[this.index].hashCode()) ^ HashCommon.long2int(Object2LongLinkedOpenHashMap.this.value[this.index]);
        }

        public String toString() {
            return Object2LongLinkedOpenHashMap.this.key[this.index] + "->" + Object2LongLinkedOpenHashMap.this.value[this.index];
        }
    }
}

