/*
 * Decompiled with CFR 0.152.
 */
package it.unimi.dsi.fastutil.objects;

import it.unimi.dsi.fastutil.Hash;
import it.unimi.dsi.fastutil.HashCommon;
import it.unimi.dsi.fastutil.booleans.AbstractBooleanCollection;
import it.unimi.dsi.fastutil.booleans.BooleanCollection;
import it.unimi.dsi.fastutil.booleans.BooleanIterator;
import it.unimi.dsi.fastutil.bytes.ByteArrays;
import it.unimi.dsi.fastutil.objects.AbstractObject2BooleanMap;
import it.unimi.dsi.fastutil.objects.AbstractObjectIterator;
import it.unimi.dsi.fastutil.objects.AbstractObjectSet;
import it.unimi.dsi.fastutil.objects.Object2BooleanMap;
import it.unimi.dsi.fastutil.objects.ObjectArrays;
import it.unimi.dsi.fastutil.objects.ObjectIterator;
import it.unimi.dsi.fastutil.objects.ObjectSet;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;

public class Object2BooleanOpenCustomHashMap
extends AbstractObject2BooleanMap
implements Serializable,
Cloneable,
Hash,
Object2BooleanMap {
    protected transient Object[] key;
    protected transient boolean[] value;
    protected transient byte[] state;
    protected final float f;
    protected transient int p;
    protected transient int maxFill;
    protected transient int free;
    protected int count;
    protected volatile transient ObjectSet entries;
    protected volatile transient ObjectSet keys;
    protected volatile transient BooleanCollection values;
    protected transient int growthFactor = 16;
    protected Hash.Strategy strategy;
    public static final long serialVersionUID = -7046029254386353129L;
    private static final boolean ASSERTS = false;

    public Object2BooleanOpenCustomHashMap(int n, float f, Hash.Strategy strategy) {
        this.strategy = strategy;
        if (f <= 0.0f || f > 1.0f) {
            throw new IllegalArgumentException("Load factor must be greater than 0 and smaller than or equal to 1");
        }
        if (n < 0) {
            throw new IllegalArgumentException("Hash table size must be nonnegative");
        }
        int l = Arrays.binarySearch(PRIMES, (int)((float)n / f) + 1);
        if (l < 0) {
            l = -l - 1;
        }
        this.p = l;
        this.free = PRIMES[this.p];
        this.f = f;
        this.maxFill = (int)((float)this.free * f);
        this.key = new Object[this.free];
        this.value = new boolean[this.free];
        this.state = new byte[this.free];
    }

    public Object2BooleanOpenCustomHashMap(int n, Hash.Strategy strategy) {
        this(n, 0.75f, strategy);
    }

    public Object2BooleanOpenCustomHashMap(Hash.Strategy strategy) {
        this(16, 0.75f, strategy);
    }

    public Object2BooleanOpenCustomHashMap(Map m, float f, Hash.Strategy strategy) {
        this(m.size(), f, strategy);
        this.putAll(m);
    }

    public Object2BooleanOpenCustomHashMap(Map m, Hash.Strategy strategy) {
        this(m, 0.75f, strategy);
    }

    public Object2BooleanOpenCustomHashMap(Object2BooleanMap m, float f, Hash.Strategy strategy) {
        this(m.size(), f, strategy);
        this.putAll((Map)m);
    }

    public Object2BooleanOpenCustomHashMap(Object2BooleanMap m, Hash.Strategy strategy) {
        this(m, 0.75f, strategy);
    }

    public Hash.Strategy strategy() {
        return this.strategy;
    }

    public void growthFactor(int growthFactor) {
        if (growthFactor <= 0) {
            throw new IllegalArgumentException("Illegal growth factor " + growthFactor);
        }
        this.growthFactor = growthFactor;
    }

    public int growthFactor() {
        return this.growthFactor;
    }

    private int findInsertionPoint(Object k) {
        Object[] key = this.key;
        byte[] state = this.state;
        int n = key.length;
        int h = this.strategy.hashCode(k);
        int k2i = h & Integer.MAX_VALUE;
        int h1 = k2i % n;
        if (!(state[h1] != -1 || h == this.strategy.hashCode(key[h1]) && this.strategy.equals(k, key[h1]))) {
            int h2 = k2i % (n - 2) + 1;
            while (!(state[h1 = (h1 + h2) % n] != -1 || h == this.strategy.hashCode(key[h1]) && this.strategy.equals(k, key[h1]))) {
            }
        }
        if (state[h1] == 0) {
            return h1;
        }
        if (state[h1] == -1) {
            return -h1 - 1;
        }
        int i = h1;
        if (!(state[h1] == 0 || h == this.strategy.hashCode(key[h1]) && this.strategy.equals(k, key[h1]))) {
            int h2 = k2i % (n - 2) + 1;
            while (!(state[h1 = (h1 + h2) % n] == 0 || h == this.strategy.hashCode(key[h1]) && this.strategy.equals(k, key[h1]))) {
            }
        }
        return state[h1] == -1 ? -h1 - 1 : i;
    }

    private int findKey(Object k) {
        Object[] key = this.key;
        byte[] state = this.state;
        int n = key.length;
        int h = this.strategy.hashCode(k);
        int k2i = h & Integer.MAX_VALUE;
        int h1 = k2i % n;
        if (!(state[h1] == 0 || h == this.strategy.hashCode(key[h1]) && this.strategy.equals(k, key[h1]))) {
            int h2 = k2i % (n - 2) + 1;
            while (!(state[h1 = (h1 + h2) % n] == 0 || h == this.strategy.hashCode(key[h1]) && this.strategy.equals(k, key[h1]))) {
            }
        }
        return state[h1] == -1 ? h1 : -1;
    }

    public boolean put(Object k, boolean v) {
        int i = this.findInsertionPoint(k);
        if (i < 0) {
            boolean oldValue = this.value[-i - 1];
            this.value[-i - 1] = v;
            return oldValue;
        }
        if (this.state[i] == 0) {
            --this.free;
        }
        this.state[i] = -1;
        this.key[i] = k;
        this.value[i] = v;
        if (++this.count >= this.maxFill) {
            int newP = Math.min(this.p + this.growthFactor, PRIMES.length - 1);
            while (PRIMES[newP] == PRIMES[this.p]) {
                ++newP;
            }
            this.rehash(newP);
        }
        if (this.free == 0) {
            this.rehash(this.p);
        }
        return this.defRetValue;
    }

    public Object put(Object ok, Object ov) {
        boolean v = (Boolean)ov;
        Object k = ok;
        int i = this.findInsertionPoint(k);
        if (i < 0) {
            boolean oldValue = this.value[-i - 1];
            this.value[-i - 1] = v;
            return oldValue;
        }
        if (this.state[i] == 0) {
            --this.free;
        }
        this.state[i] = -1;
        this.key[i] = k;
        this.value[i] = v;
        if (++this.count >= this.maxFill) {
            this.rehash(Math.min(this.p + 16, PRIMES.length - 1));
        }
        if (this.free == 0) {
            this.rehash(this.p);
        }
        return null;
    }

    public boolean containsValue(boolean v) {
        boolean[] value = this.value;
        byte[] state = this.state;
        int i = 0;
        int j = this.count;
        while (j-- != 0) {
            while (state[i] != -1) {
                ++i;
            }
            if (value[i] == v) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public void clear() {
        if (this.free == this.state.length) {
            return;
        }
        this.free = this.state.length;
        this.count = 0;
        ByteArrays.fill(this.state, (byte)0);
        ObjectArrays.fill(this.key, null);
    }

    public boolean containsKey(Object k) {
        return this.findKey(k) >= 0;
    }

    public int size() {
        return this.count;
    }

    public boolean isEmpty() {
        return this.count == 0;
    }

    public boolean getBoolean(Object k) {
        int i = this.findKey(k);
        return i < 0 ? this.defRetValue : this.value[i];
    }

    public boolean removeBoolean(Object k) {
        int i = this.findKey(k);
        if (i < 0) {
            return this.defRetValue;
        }
        this.state[i] = 1;
        --this.count;
        this.key[i] = HashCommon.REMOVED;
        return this.value[i];
    }

    public Object get(Object ok) {
        int i = this.findKey(ok);
        return i < 0 ? null : Boolean.valueOf(this.value[i]);
    }

    public Object remove(Object ok) {
        Object k = ok;
        int i = this.findKey(k);
        if (i < 0) {
            return null;
        }
        this.state[i] = 1;
        --this.count;
        this.key[i] = HashCommon.REMOVED;
        return this.value[i];
    }

    public Set entrySet() {
        if (this.entries == null) {
            this.entries = new AbstractObjectSet(){

                public ObjectIterator objectIterator() {
                    return new MapIterator();
                }

                public boolean contains(Object o) {
                    if (!(o instanceof Map.Entry)) {
                        return false;
                    }
                    Map.Entry e = (Map.Entry)o;
                    int i = Object2BooleanOpenCustomHashMap.this.findKey(e.getKey());
                    return i >= 0 && Object2BooleanOpenCustomHashMap.this.value[i] == (Boolean)e.getValue();
                }

                public boolean remove(Object o) {
                    if (!(o instanceof Map.Entry)) {
                        return false;
                    }
                    Map.Entry e = (Map.Entry)o;
                    int i = Object2BooleanOpenCustomHashMap.this.findKey(e.getKey());
                    if (i >= 0) {
                        Object2BooleanOpenCustomHashMap.this.remove(e.getKey());
                    }
                    return i >= 0;
                }

                public int size() {
                    return Object2BooleanOpenCustomHashMap.this.count;
                }

                public void clear() {
                    Object2BooleanOpenCustomHashMap.this.clear();
                }
            };
        }
        return this.entries;
    }

    public Set keySet() {
        if (this.keys == null) {
            this.keys = new KeySet();
        }
        return this.keys;
    }

    public Collection values() {
        if (this.values == null) {
            this.values = new AbstractBooleanCollection(){

                public BooleanIterator booleanIterator() {
                    return new ValueIterator();
                }

                public int size() {
                    return Object2BooleanOpenCustomHashMap.this.count;
                }

                public boolean contains(boolean v) {
                    return Object2BooleanOpenCustomHashMap.this.containsValue(v);
                }

                public void clear() {
                    Object2BooleanOpenCustomHashMap.this.clear();
                }
            };
        }
        return this.values;
    }

    public boolean rehash() {
        try {
            this.rehash(this.p);
        }
        catch (OutOfMemoryError cantDoIt) {
            return false;
        }
        return true;
    }

    public boolean trim() {
        int l = Arrays.binarySearch(PRIMES, (int)((float)this.count / this.f) + 1);
        if (l < 0) {
            l = -l - 1;
        }
        if (l >= this.p) {
            return true;
        }
        try {
            this.rehash(l);
        }
        catch (OutOfMemoryError cantDoIt) {
            return false;
        }
        return true;
    }

    public boolean trim(int n) {
        int l = Arrays.binarySearch(PRIMES, (int)Math.min(2.1474836E9f, (float)Math.max(n, this.count) / this.f) + 1);
        if (l < 0) {
            l = -l - 1;
        }
        if (this.p <= l) {
            return true;
        }
        try {
            this.rehash(l);
        }
        catch (OutOfMemoryError cantDoIt) {
            return false;
        }
        return true;
    }

    protected void rehash(int newP) {
        int i = 0;
        int j = this.count;
        int newN = PRIMES[newP];
        Object[] key = this.key;
        Object[] newKey = new Object[newN];
        boolean[] value = this.value;
        boolean[] newValue = new boolean[newN];
        byte[] state = this.state;
        byte[] newState = new byte[newN];
        while (j-- != 0) {
            while (state[i] != -1) {
                ++i;
            }
            Object k = key[i];
            boolean v = value[i];
            int k2i = this.strategy.hashCode(k) & Integer.MAX_VALUE;
            int h1 = k2i % newN;
            int h2 = k2i % (newN - 2) + 1;
            if (newState[h1] != 0) {
                h2 = k2i % (newN - 2) + 1;
                while (newState[h1 = (h1 + h2) % newN] != 0) {
                }
            }
            newState[h1] = -1;
            newKey[h1] = k;
            newValue[h1] = v;
            ++i;
        }
        this.p = newP;
        this.free = newN - this.count;
        this.maxFill = (int)((float)newN * this.f);
        this.key = newKey;
        this.value = newValue;
        this.state = newState;
    }

    public Object clone() {
        Object2BooleanOpenCustomHashMap c;
        try {
            c = (Object2BooleanOpenCustomHashMap)super.clone();
        }
        catch (CloneNotSupportedException cantHappen) {
            throw new InternalError();
        }
        c.keys = null;
        c.values = null;
        c.entries = null;
        c.key = (Object[])this.key.clone();
        c.value = (boolean[])this.value.clone();
        c.state = (byte[])this.state.clone();
        c.strategy = this.strategy;
        return c;
    }

    public int hashCode() {
        int h = 0;
        int i = 0;
        int j = this.count;
        while (j-- != 0) {
            while (this.state[i] != -1) {
                ++i;
            }
            int t = 0;
            if (this != this.key[i]) {
                t = this.strategy.hashCode(this.key[i]);
            }
            h += (t ^= this.value[i] ? 1231 : 1237);
            ++i;
        }
        return h;
    }

    private void writeObject(ObjectOutputStream s) throws IOException {
        Object[] key = this.key;
        boolean[] value = this.value;
        byte[] state = this.state;
        MapIterator i = new MapIterator();
        int j = this.count;
        s.defaultWriteObject();
        while (j-- != 0) {
            int e = i.nextEntry();
            s.writeObject(key[e]);
            s.writeBoolean(value[e]);
        }
    }

    private void checkTable() {
        int n = this.state.length;
        while (n-- != 0) {
            if (this.state[n] == -1 && !this.containsKey(this.key[n])) {
                throw new AssertionError((Object)("Hash table has key " + this.key[n] + " marked as occupied, but the key does not belong to the table"));
            }
        }
    }

    private void readObject(ObjectInputStream s) throws IOException, ClassNotFoundException {
        s.defaultReadObject();
        this.growthFactor = 16;
        this.p = Arrays.binarySearch(PRIMES, (int)((float)this.count / this.f) + 1);
        if (this.p < 0) {
            this.p = -this.p - 1;
        }
        int n = PRIMES[this.p];
        this.maxFill = (int)((float)n * this.f);
        this.free = n - this.count;
        this.key = new Object[n];
        Object[] key = this.key;
        this.value = new boolean[n];
        boolean[] value = this.value;
        this.state = new byte[n];
        byte[] state = this.state;
        int i = this.count;
        while (i-- != 0) {
            Object k = s.readObject();
            boolean v = s.readBoolean();
            int k2i = this.strategy.hashCode(k) & Integer.MAX_VALUE;
            int h1 = k2i % n;
            if (state[h1] != 0) {
                int h2 = k2i % (n - 2) + 1;
                while (state[h1 = (h1 + h2) % n] != 0) {
                }
            }
            state[h1] = -1;
            key[h1] = k;
            value[h1] = v;
        }
    }

    private final class ValueIterator
    extends MapIterator
    implements BooleanIterator {
        public boolean nextBoolean() {
            return Object2BooleanOpenCustomHashMap.this.value[this.nextEntry()];
        }

        public Object next() {
            return Object2BooleanOpenCustomHashMap.this.value[this.nextEntry()];
        }

        public void set(boolean v) {
            throw new UnsupportedOperationException();
        }

        public void add(boolean v) {
            throw new UnsupportedOperationException();
        }
    }

    private final class KeySet
    extends AbstractObjectSet {
        private KeySet() {
        }

        public ObjectIterator objectIterator() {
            return new KeyIterator();
        }

        public int size() {
            return Object2BooleanOpenCustomHashMap.this.count;
        }

        public boolean contains(Object k) {
            return Object2BooleanOpenCustomHashMap.this.containsKey(k);
        }

        public boolean remove(Object k) {
            int oldCount = Object2BooleanOpenCustomHashMap.this.count;
            Object2BooleanOpenCustomHashMap.this.remove(k);
            return Object2BooleanOpenCustomHashMap.this.count != oldCount;
        }

        public void clear() {
            Object2BooleanOpenCustomHashMap.this.clear();
        }
    }

    private final class KeyIterator
    extends MapIterator
    implements ObjectIterator {
        public Object next() {
            return Object2BooleanOpenCustomHashMap.this.key[this.nextEntry()];
        }

        public void set(Object k) {
            throw new UnsupportedOperationException();
        }

        public void add(Object k) {
            throw new UnsupportedOperationException();
        }
    }

    private class MapIterator
    extends AbstractObjectIterator {
        int pos = 0;
        int last = -1;
        int c;

        private MapIterator() {
            this.c = Object2BooleanOpenCustomHashMap.this.count;
            byte[] state = Object2BooleanOpenCustomHashMap.this.state;
            int n = state.length;
            if (this.c != 0) {
                while (this.pos < n && state[this.pos] != -1) {
                    ++this.pos;
                }
            }
        }

        public boolean hasNext() {
            return this.c != 0 && this.pos < Object2BooleanOpenCustomHashMap.this.state.length;
        }

        public int nextEntry() {
            byte[] state = Object2BooleanOpenCustomHashMap.this.state;
            int n = state.length;
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            this.last = this.pos;
            if (--this.c != 0) {
                do {
                    ++this.pos;
                } while (this.pos < n && state[this.pos] != -1);
            }
            return this.last;
        }

        public Object next() {
            return new MapEntry(this.nextEntry());
        }

        public void remove() {
            if (this.last == -1) {
                throw new IllegalStateException();
            }
            Object2BooleanOpenCustomHashMap.this.state[this.last] = 1;
            Object2BooleanOpenCustomHashMap.this.key[this.last] = HashCommon.REMOVED;
            --Object2BooleanOpenCustomHashMap.this.count;
        }
    }

    private final class MapEntry
    implements Object2BooleanMap.Entry {
        private int index;

        MapEntry(int index) {
            this.index = index;
        }

        public Object getKey() {
            return Object2BooleanOpenCustomHashMap.this.key[this.index];
        }

        public Object getValue() {
            return Object2BooleanOpenCustomHashMap.this.value[this.index];
        }

        public boolean getBooleanValue() {
            return Object2BooleanOpenCustomHashMap.this.value[this.index];
        }

        public boolean setValue(boolean v) {
            boolean oldValue = Object2BooleanOpenCustomHashMap.this.value[this.index];
            Object2BooleanOpenCustomHashMap.this.value[this.index] = v;
            return oldValue;
        }

        public Object setValue(Object v) {
            return this.setValue((Boolean)v);
        }

        public boolean equals(Object o) {
            if (!(o instanceof Map.Entry)) {
                return false;
            }
            Map.Entry e = (Map.Entry)o;
            return Object2BooleanOpenCustomHashMap.this.strategy.equals(Object2BooleanOpenCustomHashMap.this.key[this.index], e.getKey()) && Object2BooleanOpenCustomHashMap.this.value[this.index] == (Boolean)e.getValue();
        }

        public int hashCode() {
            return Object2BooleanOpenCustomHashMap.this.strategy.hashCode(Object2BooleanOpenCustomHashMap.this.key[this.index]) ^ (Object2BooleanOpenCustomHashMap.this.value[this.index] ? 1231 : 1237);
        }

        public String toString() {
            return Object2BooleanOpenCustomHashMap.this.key[this.index] + "->" + Object2BooleanOpenCustomHashMap.this.value[this.index];
        }
    }
}

