/*
 * Decompiled with CFR 0.152.
 */
package it.unimi.dsi.fastutil.objects;

import it.unimi.dsi.fastutil.Stack;
import it.unimi.dsi.fastutil.objects.AbstractObjectListIterator;
import it.unimi.dsi.fastutil.objects.AbstractReferenceCollection;
import it.unimi.dsi.fastutil.objects.ObjectIterator;
import it.unimi.dsi.fastutil.objects.ObjectListIterator;
import it.unimi.dsi.fastutil.objects.ReferenceCollection;
import it.unimi.dsi.fastutil.objects.ReferenceList;
import java.io.Serializable;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.NoSuchElementException;

public abstract class AbstractReferenceList
extends AbstractReferenceCollection
implements ReferenceList,
Stack {
    private static final boolean ASSERTS = false;

    protected AbstractReferenceList() {
    }

    protected void ensureIndex(int index) {
        if (index < 0) {
            throw new IndexOutOfBoundsException("Index (" + index + ") is negative");
        }
        if (index > this.size()) {
            throw new IndexOutOfBoundsException("Index (" + index + ") is greater than list size (" + this.size() + ")");
        }
    }

    protected void ensureRestrictedIndex(int index) {
        if (index < 0) {
            throw new IndexOutOfBoundsException("Index (" + index + ") is negative");
        }
        if (index >= this.size()) {
            throw new IndexOutOfBoundsException("Index (" + index + ") is greater than or equal to list size (" + this.size() + ")");
        }
    }

    public void add(int index, Object k) {
        throw new UnsupportedOperationException();
    }

    public boolean add(Object k) {
        this.add(this.size(), k);
        return true;
    }

    public boolean rem(Object k) {
        int index = this.indexOf(k);
        if (index == -1) {
            return false;
        }
        this.remove(index);
        return true;
    }

    public Object remove(int i) {
        throw new UnsupportedOperationException();
    }

    public Object set(int index, Object k) {
        throw new UnsupportedOperationException();
    }

    public boolean addAll(int index, Collection c) {
        this.ensureIndex(index);
        int n = c.size();
        if (n == 0) {
            return false;
        }
        Iterator i = c.iterator();
        while (n-- != 0) {
            this.add(index++, i.next());
        }
        return true;
    }

    public boolean addAll(int index, ReferenceCollection c) {
        return this.addAll(index, (Collection)c);
    }

    public boolean addAll(int index, ReferenceList l) {
        return this.addAll(index, (ReferenceCollection)l);
    }

    public boolean addAll(Collection c) {
        return this.addAll(this.size(), c);
    }

    public boolean addAll(ReferenceCollection c) {
        return this.addAll(this.size(), c);
    }

    public boolean addAll(ReferenceList l) {
        return this.addAll(this.size(), l);
    }

    public ListIterator listIterator() {
        return this.objectListIterator();
    }

    public ListIterator listIterator(int index) {
        return this.objectListIterator(index);
    }

    public ObjectIterator objectIterator() {
        return this.objectListIterator();
    }

    public ObjectListIterator objectListIterator() {
        return this.objectListIterator(0);
    }

    public ObjectListIterator objectListIterator(final int index) {
        return new AbstractObjectListIterator(){
            int pos;
            int last;
            {
                this.pos = index;
                this.last = -1;
            }

            public boolean hasNext() {
                return this.pos < AbstractReferenceList.this.size();
            }

            public boolean hasPrevious() {
                return this.pos > 0;
            }

            public Object next() {
                if (!this.hasNext()) {
                    throw new NoSuchElementException();
                }
                this.last = this.pos++;
                return AbstractReferenceList.this.get(this.last);
            }

            public Object previous() {
                if (!this.hasPrevious()) {
                    throw new NoSuchElementException();
                }
                this.last = --this.pos;
                return AbstractReferenceList.this.get(this.pos);
            }

            public int nextIndex() {
                return this.pos;
            }

            public int previousIndex() {
                return this.pos - 1;
            }

            public void add(Object k) {
                if (this.last == -1) {
                    throw new IllegalStateException();
                }
                AbstractReferenceList.this.add(this.pos++, k);
                this.last = -1;
            }

            public void set(Object k) {
                if (this.last == -1) {
                    throw new IllegalStateException();
                }
                AbstractReferenceList.this.set(this.last, k);
            }

            public void remove() {
                if (this.last == -1) {
                    throw new IllegalStateException();
                }
                AbstractReferenceList.this.remove(this.last);
                if (this.last < this.pos) {
                    --this.pos;
                }
                this.last = -1;
            }
        };
    }

    public boolean contains(Object k) {
        return this.indexOf(k) >= 0;
    }

    public int indexOf(Object k) {
        ObjectListIterator i = this.objectListIterator();
        while (i.hasNext()) {
            Object e = i.next();
            if (k != e) continue;
            return i.previousIndex();
        }
        return -1;
    }

    public int lastIndexOf(Object k) {
        ObjectListIterator i = this.objectListIterator(this.size());
        while (i.hasPrevious()) {
            Object e = i.previous();
            if (k != e) continue;
            return i.nextIndex();
        }
        return -1;
    }

    public void size(int size) {
        int i = this.size();
        if (size > i) {
            while (i++ < size) {
                this.add((Object)null);
            }
        } else {
            while (i-- != size) {
                this.remove(i);
            }
        }
    }

    public ReferenceList referenceSubList(int from, int to) {
        this.ensureIndex(from);
        this.ensureIndex(to);
        if (from > to) {
            throw new IndexOutOfBoundsException("Start index (" + from + ") is greater than end index (" + to + ")");
        }
        return new ReferenceSubList(this, from, to);
    }

    public List subList(int from, int to) {
        return this.referenceSubList(from, to);
    }

    public void removeElements(int from, int to) {
        this.ensureIndex(to);
        ObjectListIterator i = this.objectListIterator(from);
        int n = to - from;
        if (n < 0) {
            throw new IllegalArgumentException("Start index (" + from + ") is greater than end index (" + to + ")");
        }
        while (n-- != 0) {
            i.next();
            i.remove();
        }
    }

    public void addElements(int index, Object[] a, int offset, int length) {
        this.ensureIndex(index);
        if (offset < 0) {
            throw new ArrayIndexOutOfBoundsException("Offset (" + offset + ") is negative");
        }
        if (offset + length > a.length) {
            throw new ArrayIndexOutOfBoundsException("End index (" + (offset + length) + ") is greater than array length (" + a.length + ")");
        }
        while (length-- != 0) {
            this.add(index++, a[offset++]);
        }
    }

    public void addElements(int index, Object[] a) {
        this.addElements(index, a, 0, a.length);
    }

    public void getElements(int from, Object[] a, int offset, int length) {
        ObjectListIterator i = this.objectListIterator(from);
        if (offset < 0) {
            throw new ArrayIndexOutOfBoundsException("Offset (" + offset + ") is negative");
        }
        if (offset + length > a.length) {
            throw new ArrayIndexOutOfBoundsException("End index (" + (offset + length) + ") is greater than array length (" + a.length + ")");
        }
        if (from + length > this.size()) {
            throw new IndexOutOfBoundsException("End index (" + (from + length) + ") is greater than list size (" + this.size() + ")");
        }
        while (length-- != 0) {
            a[offset++] = i.next();
        }
    }

    private boolean valEquals(Object a, Object b) {
        return a == null ? b == null : a.equals(b);
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof List)) {
            return false;
        }
        List l = (List)o;
        int s = this.size();
        if (s != l.size()) {
            return false;
        }
        ListIterator i1 = this.listIterator();
        ListIterator i2 = l.listIterator();
        while (s-- != 0) {
            if (i1.next() == i2.next()) continue;
            return false;
        }
        return true;
    }

    public int hashCode() {
        ObjectIterator i = this.objectIterator();
        int h = 1;
        int s = this.size();
        while (s-- != 0) {
            Object k = i.next();
            h = 31 * h + System.identityHashCode(k);
        }
        return h;
    }

    public void push(Object o) {
        this.add(o);
    }

    public Object pop() {
        if (this.isEmpty()) {
            throw new NoSuchElementException();
        }
        return this.remove(this.size() - 1);
    }

    public Object top() {
        if (this.isEmpty()) {
            throw new NoSuchElementException();
        }
        return this.get(this.size() - 1);
    }

    public Object peek(int i) {
        return this.get(this.size() - 1 - i);
    }

    public String toString() {
        StringBuffer s = new StringBuffer();
        ObjectIterator i = this.objectIterator();
        int n = this.size();
        boolean first = true;
        s.append("[");
        while (n-- != 0) {
            if (first) {
                first = false;
            } else {
                s.append(", ");
            }
            Object k = i.next();
            if (this == k) {
                s.append("(this list)");
                continue;
            }
            s.append(String.valueOf(k));
        }
        s.append("]");
        return s.toString();
    }

    public static class ReferenceSubList
    extends AbstractReferenceList
    implements Serializable {
        protected final ReferenceList l;
        protected final int from;
        protected int to;
        private static final boolean ASSERTS = false;

        public ReferenceSubList(ReferenceList l, int from, int to) {
            this.l = l;
            this.from = from;
            this.to = to;
        }

        private void assertRange() {
        }

        public boolean add(Object k) {
            this.l.add(this.to, k);
            ++this.to;
            return true;
        }

        public void add(int index, Object k) {
            this.ensureIndex(index);
            this.l.add(this.from + index, k);
            ++this.to;
        }

        public boolean addAll(int index, Collection c) {
            this.ensureIndex(index);
            this.to += c.size();
            return this.l.addAll(this.from + index, c);
        }

        public boolean addAll(int index, ReferenceCollection c) {
            this.ensureIndex(index);
            this.to += c.size();
            return this.l.addAll(this.from + index, c);
        }

        public boolean addAll(int index, ReferenceList l) {
            this.ensureIndex(index);
            this.to += l.size();
            return this.l.addAll(this.from + index, l);
        }

        public Object get(int index) {
            this.ensureRestrictedIndex(index);
            return this.l.get(this.from + index);
        }

        public Object remove(int index) {
            this.ensureRestrictedIndex(index);
            --this.to;
            return this.l.remove(this.from + index);
        }

        public boolean rem(Object k) {
            int index = this.indexOf(k);
            if (index == -1) {
                return false;
            }
            --this.to;
            this.l.remove(this.from + index);
            return true;
        }

        public Object set(int index, Object k) {
            this.ensureRestrictedIndex(index);
            return this.l.set(this.from + index, k);
        }

        public void clear() {
            this.removeElements(0, this.size());
        }

        public int size() {
            return this.to - this.from;
        }

        public void getElements(int from, Object[] a, int offset, int length) {
            this.ensureIndex(from);
            if (from + length > this.size()) {
                throw new IndexOutOfBoundsException("End index (" + from + length + ") is greater than list size (" + this.size() + ")");
            }
            this.l.getElements(this.from + from, a, offset, length);
        }

        public void removeElements(int from, int to) {
            this.ensureIndex(from);
            this.ensureIndex(to);
            this.l.removeElements(this.from + from, this.from + to);
            this.to -= to - from;
        }

        public void addElements(int index, Object[] a, int offset, int length) {
            this.ensureIndex(index);
            this.l.addElements(this.from + index, a, offset, length);
            this.to += length;
        }

        public ObjectListIterator objectListIterator(int index) {
            this.ensureIndex(index);
            return new AbstractObjectListIterator(this, index){
                int pos;
                int last;
                private final /* synthetic */ int val$index;
                private final /* synthetic */ ReferenceSubList this$0;
                {
                    this.this$0 = this$0;
                    this.val$index = val$index;
                    this.pos = this.val$index;
                    this.last = -1;
                }

                public boolean hasNext() {
                    return this.pos < this.this$0.size();
                }

                public boolean hasPrevious() {
                    return this.pos > 0;
                }

                public Object next() {
                    if (!this.hasNext()) {
                        throw new NoSuchElementException();
                    }
                    this.last = this.pos++;
                    return this.this$0.l.get(this.this$0.from + this.last);
                }

                public Object previous() {
                    if (!this.hasPrevious()) {
                        throw new NoSuchElementException();
                    }
                    this.last = --this.pos;
                    return this.this$0.l.get(this.this$0.from + this.pos);
                }

                public int nextIndex() {
                    return this.pos;
                }

                public int previousIndex() {
                    return this.pos - 1;
                }

                public void add(Object k) {
                    if (this.last == -1) {
                        throw new IllegalStateException();
                    }
                    this.this$0.add(this.pos++, k);
                    this.last = -1;
                }

                public void set(Object k) {
                    if (this.last == -1) {
                        throw new IllegalStateException();
                    }
                    this.this$0.set(this.last, k);
                }

                public void remove() {
                    if (this.last == -1) {
                        throw new IllegalStateException();
                    }
                    this.this$0.remove(this.last);
                    if (this.last < this.pos) {
                        --this.pos;
                    }
                    this.last = -1;
                }
            };
        }

        public ReferenceList referenceSubList(int from, int to) {
            this.ensureIndex(from);
            this.ensureIndex(to);
            if (from > to) {
                throw new IllegalArgumentException("Start index (" + from + ") is greater than end index (" + to + ")");
            }
            return new ReferenceSubList(this, from, to);
        }
    }
}

