/*
 * Decompiled with CFR 0.152.
 */
package it.unimi.dsi.fastutil.objects;

import it.unimi.dsi.fastutil.chars.AbstractCharCollection;
import it.unimi.dsi.fastutil.chars.AbstractCharIterator;
import it.unimi.dsi.fastutil.chars.CharCollection;
import it.unimi.dsi.fastutil.chars.CharIterator;
import it.unimi.dsi.fastutil.objects.AbstractObjectIterator;
import it.unimi.dsi.fastutil.objects.AbstractObjectSet;
import it.unimi.dsi.fastutil.objects.Object2CharMap;
import it.unimi.dsi.fastutil.objects.ObjectIterator;
import it.unimi.dsi.fastutil.objects.ObjectSet;
import java.io.Serializable;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;

public abstract class AbstractObject2CharMap
implements Object2CharMap,
Serializable {
    protected char defRetValue;

    protected AbstractObject2CharMap() {
    }

    public void setDefRetValue(char rv) {
        this.defaultReturnValue(rv);
    }

    public char getDefRetValue() {
        return this.defaultReturnValue();
    }

    public void defaultReturnValue(char rv) {
        this.defRetValue = rv;
    }

    public char defaultReturnValue() {
        return this.defRetValue;
    }

    public char put(Object key, char value) {
        throw new UnsupportedOperationException();
    }

    public char removeChar(Object key) {
        throw new UnsupportedOperationException();
    }

    public void clear() {
        throw new UnsupportedOperationException();
    }

    public Object get(Object ok) {
        Object k = ok;
        return this.containsKey(k) ? new Character(this.getChar(k)) : null;
    }

    public Object put(Object ok, Object ov) {
        Object k = ok;
        char v = this.put(k, ((Character)ov).charValue());
        return this.containsKey(k) ? new Character(v) : null;
    }

    public Object remove(Object ok) {
        Object k = ok;
        char v = this.removeChar(k);
        return this.containsKey(k) ? new Character(v) : null;
    }

    public boolean containsValue(Object ov) {
        return this.containsValue(((Character)ov).charValue());
    }

    public boolean containsValue(char v) {
        return ((CharCollection)this.values()).contains(v);
    }

    public boolean containsKey(Object k) {
        return ((ObjectSet)this.keySet()).contains(k);
    }

    public void putAll(Map m) {
        int n = m.size();
        Iterator i = m.entrySet().iterator();
        if (m instanceof Object2CharMap) {
            while (n-- != 0) {
                Object2CharMap.Entry e = (Object2CharMap.Entry)i.next();
                this.put(e.getKey(), e.getCharValue());
            }
        } else {
            while (n-- != 0) {
                Map.Entry e = i.next();
                this.put(e.getKey(), e.getValue());
            }
        }
    }

    public boolean isEmpty() {
        return this.size() == 0;
    }

    public Set keySet() {
        return new AbstractObjectSet(){

            public boolean contains(Object k) {
                return AbstractObject2CharMap.this.containsKey(k);
            }

            public int size() {
                return AbstractObject2CharMap.this.size();
            }

            public ObjectIterator objectIterator() {
                return new AbstractObjectIterator(this){
                    final Iterator i;
                    private final /* synthetic */ 1 this$1;
                    {
                        this.this$1 = this$1;
                        this.i = 1.access$000(this.this$1).entrySet().iterator();
                    }

                    public Object next() {
                        return ((Object2CharMap.Entry)this.i.next()).getKey();
                    }

                    public boolean hasNext() {
                        return this.i.hasNext();
                    }
                };
            }

            static /* synthetic */ AbstractObject2CharMap access$000(1 x0) {
                return x0.AbstractObject2CharMap.this;
            }
        };
    }

    public Collection values() {
        return new AbstractCharCollection(){

            public boolean contains(char k) {
                return AbstractObject2CharMap.this.containsValue(k);
            }

            public int size() {
                return AbstractObject2CharMap.this.size();
            }

            public CharIterator charIterator() {
                return new AbstractCharIterator(this){
                    final Iterator i;
                    private final /* synthetic */ 3 this$1;
                    {
                        this.this$1 = this$1;
                        this.i = 3.access$100(this.this$1).entrySet().iterator();
                    }

                    public char nextChar() {
                        return ((Object2CharMap.Entry)this.i.next()).getCharValue();
                    }

                    public boolean hasNext() {
                        return this.i.hasNext();
                    }
                };
            }

            static /* synthetic */ AbstractObject2CharMap access$100(3 x0) {
                return x0.AbstractObject2CharMap.this;
            }
        };
    }

    public int hashCode() {
        int h = 0;
        int n = this.size();
        Iterator i = this.entrySet().iterator();
        while (n-- != 0) {
            h += ((Object)i.next()).hashCode();
        }
        return h;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Map)) {
            return false;
        }
        Map m = (Map)o;
        if (m.size() != this.size()) {
            return false;
        }
        return this.entrySet().containsAll(m.entrySet());
    }

    public String toString() {
        StringBuffer s = new StringBuffer();
        Iterator i = this.entrySet().iterator();
        int n = this.size();
        boolean first = true;
        s.append("{");
        while (n-- != 0) {
            if (first) {
                first = false;
            } else {
                s.append(", ");
            }
            Object2CharMap.Entry e = (Object2CharMap.Entry)i.next();
            if (this == e.getKey()) {
                s.append("(this map)");
            } else {
                s.append(String.valueOf(e.getKey()));
            }
            s.append("=>");
            s.append(String.valueOf(e.getCharValue()));
        }
        s.append("}");
        return s.toString();
    }

    public static class BasicEntry
    implements Object2CharMap.Entry {
        protected Object key;
        protected char value;

        public BasicEntry(Object key, Object value) {
            this.key = key;
            this.value = ((Character)value).charValue();
        }

        public BasicEntry(Object key, char value) {
            this.key = key;
            this.value = value;
        }

        public Object getKey() {
            return this.key;
        }

        public Object getValue() {
            return new Character(this.value);
        }

        public char getCharValue() {
            return this.value;
        }

        public char setValue(char value) {
            throw new UnsupportedOperationException();
        }

        public Object setValue(Object value) {
            return new Character(this.setValue(((Character)value).charValue()));
        }

        public boolean equals(Object o) {
            if (!(o instanceof Map.Entry)) {
                return false;
            }
            Map.Entry e = (Map.Entry)o;
            return (this.key == null ? e.getKey() == null : this.key.equals(e.getKey())) && this.value == ((Character)e.getValue()).charValue();
        }

        public int hashCode() {
            return (this.key == null ? 0 : this.key.hashCode()) ^ this.value;
        }

        public String toString() {
            return this.key + "->" + this.value;
        }
    }
}

