/*
 * Decompiled with CFR 0.152.
 */
package it.unimi.dsi.fastutil.objects;

import it.unimi.dsi.fastutil.bytes.AbstractByteCollection;
import it.unimi.dsi.fastutil.bytes.AbstractByteIterator;
import it.unimi.dsi.fastutil.bytes.ByteCollection;
import it.unimi.dsi.fastutil.bytes.ByteIterator;
import it.unimi.dsi.fastutil.objects.AbstractObjectIterator;
import it.unimi.dsi.fastutil.objects.AbstractObjectSet;
import it.unimi.dsi.fastutil.objects.Object2ByteMap;
import it.unimi.dsi.fastutil.objects.ObjectIterator;
import it.unimi.dsi.fastutil.objects.ObjectSet;
import java.io.Serializable;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;

public abstract class AbstractObject2ByteMap
implements Object2ByteMap,
Serializable {
    protected byte defRetValue;

    protected AbstractObject2ByteMap() {
    }

    public void setDefRetValue(byte rv) {
        this.defaultReturnValue(rv);
    }

    public byte getDefRetValue() {
        return this.defaultReturnValue();
    }

    public void defaultReturnValue(byte rv) {
        this.defRetValue = rv;
    }

    public byte defaultReturnValue() {
        return this.defRetValue;
    }

    public byte put(Object key, byte value) {
        throw new UnsupportedOperationException();
    }

    public byte removeByte(Object key) {
        throw new UnsupportedOperationException();
    }

    public void clear() {
        throw new UnsupportedOperationException();
    }

    public Object get(Object ok) {
        Object k = ok;
        return this.containsKey(k) ? new Byte(this.getByte(k)) : null;
    }

    public Object put(Object ok, Object ov) {
        Object k = ok;
        byte v = this.put(k, (Byte)ov);
        return this.containsKey(k) ? new Byte(v) : null;
    }

    public Object remove(Object ok) {
        Object k = ok;
        byte v = this.removeByte(k);
        return this.containsKey(k) ? new Byte(v) : null;
    }

    public boolean containsValue(Object ov) {
        return this.containsValue((Byte)ov);
    }

    public boolean containsValue(byte v) {
        return ((ByteCollection)this.values()).contains(v);
    }

    public boolean containsKey(Object k) {
        return ((ObjectSet)this.keySet()).contains(k);
    }

    public void putAll(Map m) {
        int n = m.size();
        Iterator i = m.entrySet().iterator();
        if (m instanceof Object2ByteMap) {
            while (n-- != 0) {
                Object2ByteMap.Entry e = (Object2ByteMap.Entry)i.next();
                this.put(e.getKey(), e.getByteValue());
            }
        } else {
            while (n-- != 0) {
                Map.Entry e = i.next();
                this.put(e.getKey(), e.getValue());
            }
        }
    }

    public boolean isEmpty() {
        return this.size() == 0;
    }

    public Set keySet() {
        return new AbstractObjectSet(){

            public boolean contains(Object k) {
                return AbstractObject2ByteMap.this.containsKey(k);
            }

            public int size() {
                return AbstractObject2ByteMap.this.size();
            }

            public ObjectIterator objectIterator() {
                return new AbstractObjectIterator(this){
                    final Iterator i;
                    private final /* synthetic */ 1 this$1;
                    {
                        this.this$1 = this$1;
                        this.i = 1.access$000(this.this$1).entrySet().iterator();
                    }

                    public Object next() {
                        return ((Object2ByteMap.Entry)this.i.next()).getKey();
                    }

                    public boolean hasNext() {
                        return this.i.hasNext();
                    }
                };
            }

            static /* synthetic */ AbstractObject2ByteMap access$000(1 x0) {
                return x0.AbstractObject2ByteMap.this;
            }
        };
    }

    public Collection values() {
        return new AbstractByteCollection(){

            public boolean contains(byte k) {
                return AbstractObject2ByteMap.this.containsValue(k);
            }

            public int size() {
                return AbstractObject2ByteMap.this.size();
            }

            public ByteIterator byteIterator() {
                return new AbstractByteIterator(this){
                    final Iterator i;
                    private final /* synthetic */ 3 this$1;
                    {
                        this.this$1 = this$1;
                        this.i = 3.access$100(this.this$1).entrySet().iterator();
                    }

                    public byte nextByte() {
                        return ((Object2ByteMap.Entry)this.i.next()).getByteValue();
                    }

                    public boolean hasNext() {
                        return this.i.hasNext();
                    }
                };
            }

            static /* synthetic */ AbstractObject2ByteMap access$100(3 x0) {
                return x0.AbstractObject2ByteMap.this;
            }
        };
    }

    public int hashCode() {
        int h = 0;
        int n = this.size();
        Iterator i = this.entrySet().iterator();
        while (n-- != 0) {
            h += ((Object)i.next()).hashCode();
        }
        return h;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Map)) {
            return false;
        }
        Map m = (Map)o;
        if (m.size() != this.size()) {
            return false;
        }
        return this.entrySet().containsAll(m.entrySet());
    }

    public String toString() {
        StringBuffer s = new StringBuffer();
        Iterator i = this.entrySet().iterator();
        int n = this.size();
        boolean first = true;
        s.append("{");
        while (n-- != 0) {
            if (first) {
                first = false;
            } else {
                s.append(", ");
            }
            Object2ByteMap.Entry e = (Object2ByteMap.Entry)i.next();
            if (this == e.getKey()) {
                s.append("(this map)");
            } else {
                s.append(String.valueOf(e.getKey()));
            }
            s.append("=>");
            s.append(String.valueOf(e.getByteValue()));
        }
        s.append("}");
        return s.toString();
    }

    public static class BasicEntry
    implements Object2ByteMap.Entry {
        protected Object key;
        protected byte value;

        public BasicEntry(Object key, Object value) {
            this.key = key;
            this.value = (Byte)value;
        }

        public BasicEntry(Object key, byte value) {
            this.key = key;
            this.value = value;
        }

        public Object getKey() {
            return this.key;
        }

        public Object getValue() {
            return new Byte(this.value);
        }

        public byte getByteValue() {
            return this.value;
        }

        public byte setValue(byte value) {
            throw new UnsupportedOperationException();
        }

        public Object setValue(Object value) {
            return new Byte(this.setValue((Byte)value));
        }

        public boolean equals(Object o) {
            if (!(o instanceof Map.Entry)) {
                return false;
            }
            Map.Entry e = (Map.Entry)o;
            return (this.key == null ? e.getKey() == null : this.key.equals(e.getKey())) && this.value == (Byte)e.getValue();
        }

        public int hashCode() {
            return (this.key == null ? 0 : this.key.hashCode()) ^ this.value;
        }

        public String toString() {
            return this.key + "->" + this.value;
        }
    }
}

