/*
 * Decompiled with CFR 0.152.
 */
package it.unimi.dsi.fastutil.longs;

import it.unimi.dsi.fastutil.longs.AbstractLongPriorityQueue;
import it.unimi.dsi.fastutil.longs.LongArrays;
import it.unimi.dsi.fastutil.longs.LongComparator;
import it.unimi.dsi.fastutil.longs.LongHeaps;
import java.util.Comparator;
import java.util.NoSuchElementException;

public class LongHeapPriorityQueue
extends AbstractLongPriorityQueue {
    protected long[] heap = LongArrays.EMPTY_ARRAY;
    protected int size;
    protected LongComparator c;

    public LongHeapPriorityQueue(int capacity, LongComparator c) {
        if (capacity > 0) {
            this.heap = new long[capacity];
        }
        this.c = c;
    }

    public LongHeapPriorityQueue(int capacity) {
        this(capacity, null);
    }

    public LongHeapPriorityQueue(LongComparator c) {
        this(0, c);
    }

    public LongHeapPriorityQueue() {
        this(0, null);
    }

    public LongHeapPriorityQueue(long[] a, int size, LongComparator c) {
        this(c);
        this.heap = a;
        this.size = size;
        LongHeaps.makeHeap(a, size, c);
    }

    public LongHeapPriorityQueue(long[] a, LongComparator c) {
        this(a, a.length, c);
    }

    public LongHeapPriorityQueue(long[] a, int size) {
        this(a, size, null);
    }

    public LongHeapPriorityQueue(long[] a) {
        this(a, a.length);
    }

    private void ensureNonEmpty() {
        if (this.size == 0) {
            throw new NoSuchElementException();
        }
    }

    public void enqueue(long x) {
        if (this.size == this.heap.length) {
            this.heap = LongArrays.grow(this.heap, this.size + 1);
        }
        this.heap[this.size++] = x;
        LongHeaps.upHeap(this.heap, this.size, this.size - 1, this.c);
    }

    public long dequeueLong() {
        this.ensureNonEmpty();
        long result = this.heap[0];
        this.heap[0] = this.heap[--this.size];
        if (this.size != 0) {
            LongHeaps.downHeap(this.heap, this.size, 0, this.c);
        }
        return result;
    }

    public long firstLong() {
        this.ensureNonEmpty();
        return this.heap[0];
    }

    public void changed() {
        this.ensureNonEmpty();
        LongHeaps.downHeap(this.heap, this.size, 0, this.c);
    }

    public int size() {
        return this.size;
    }

    public void clear() {
        this.size = 0;
    }

    public void trim() {
        this.heap = LongArrays.trim(this.heap, this.size);
    }

    public Comparator comparator() {
        return this.c;
    }
}

