/*
 * Decompiled with CFR 0.152.
 */
package it.unimi.dsi.fastutil.longs;

import it.unimi.dsi.fastutil.longs.Long2IntMaps;
import it.unimi.dsi.fastutil.longs.Long2IntSortedMap;
import it.unimi.dsi.fastutil.longs.LongComparator;
import it.unimi.dsi.fastutil.longs.LongSortedSets;
import java.io.Serializable;
import java.util.Comparator;
import java.util.NoSuchElementException;
import java.util.Set;
import java.util.SortedMap;

public class Long2IntSortedMaps {
    public static final EmptySortedMap EMPTY_MAP = new EmptySortedMap();

    private Long2IntSortedMaps() {
    }

    public static Long2IntSortedMap singleton(long key, int value) {
        return new Singleton(key, value);
    }

    public static Long2IntSortedMap singleton(long key, int value, LongComparator comparator) {
        return new Singleton(key, value, comparator);
    }

    public static Long2IntSortedMap singleton(Object key, Object value) {
        return new Singleton((Long)key, (Integer)value);
    }

    public static Long2IntSortedMap singleton(Object key, Object value, LongComparator comparator) {
        return new Singleton((Long)key, (Integer)value, comparator);
    }

    public static Long2IntSortedMap synchronize(Long2IntSortedMap m) {
        return new SynchronizedSortedMap(m);
    }

    public static Long2IntSortedMap synchronize(Long2IntSortedMap m, Object sync) {
        return new SynchronizedSortedMap(m, sync);
    }

    public static Long2IntSortedMap unmodifiable(Long2IntSortedMap m) {
        return new UnmodifiableSortedMap(m);
    }

    public static class UnmodifiableSortedMap
    extends Long2IntMaps.UnmodifiableMap
    implements Long2IntSortedMap,
    Serializable {
        public static final long serialVersionUID = -7046029254386353129L;
        protected final Long2IntSortedMap sortedMap;

        protected UnmodifiableSortedMap(Long2IntSortedMap m) {
            super(m);
            this.sortedMap = m;
        }

        public Comparator comparator() {
            return this.sortedMap.comparator();
        }

        public Long2IntSortedMap subMap(long from, long to) {
            return new UnmodifiableSortedMap(this.sortedMap.subMap(from, to));
        }

        public Long2IntSortedMap headMap(long to) {
            return new UnmodifiableSortedMap(this.sortedMap.headMap(to));
        }

        public Long2IntSortedMap tailMap(long from) {
            return new UnmodifiableSortedMap(this.sortedMap.tailMap(from));
        }

        public long firstLongKey() {
            return this.sortedMap.firstLongKey();
        }

        public long lastLongKey() {
            return this.sortedMap.lastLongKey();
        }

        public Object firstKey() {
            return this.sortedMap.firstKey();
        }

        public Object lastKey() {
            return this.sortedMap.lastKey();
        }

        public SortedMap subMap(Object from, Object to) {
            return new UnmodifiableSortedMap((Long2IntSortedMap)this.sortedMap.subMap(from, to));
        }

        public SortedMap headMap(Object to) {
            return new UnmodifiableSortedMap((Long2IntSortedMap)this.sortedMap.headMap(to));
        }

        public SortedMap tailMap(Object from) {
            return new UnmodifiableSortedMap((Long2IntSortedMap)this.sortedMap.tailMap(from));
        }
    }

    public static class SynchronizedSortedMap
    extends Long2IntMaps.SynchronizedMap
    implements Long2IntSortedMap,
    Serializable {
        public static final long serialVersionUID = -7046029254386353129L;
        protected final Long2IntSortedMap sortedMap;

        protected SynchronizedSortedMap(Long2IntSortedMap m, Object sync) {
            super(m, sync);
            this.sortedMap = m;
        }

        protected SynchronizedSortedMap(Long2IntSortedMap m) {
            super(m);
            this.sortedMap = m;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Comparator comparator() {
            Object object = this.sync;
            synchronized (object) {
                return this.sortedMap.comparator();
            }
        }

        public Long2IntSortedMap subMap(long from, long to) {
            return new SynchronizedSortedMap(this.sortedMap.subMap(from, to), this.sync);
        }

        public Long2IntSortedMap headMap(long to) {
            return new SynchronizedSortedMap(this.sortedMap.headMap(to), this.sync);
        }

        public Long2IntSortedMap tailMap(long from) {
            return new SynchronizedSortedMap(this.sortedMap.tailMap(from), this.sync);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public long firstLongKey() {
            Object object = this.sync;
            synchronized (object) {
                return this.sortedMap.firstLongKey();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public long lastLongKey() {
            Object object = this.sync;
            synchronized (object) {
                return this.sortedMap.lastLongKey();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Object firstKey() {
            Object object = this.sync;
            synchronized (object) {
                return this.sortedMap.firstKey();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Object lastKey() {
            Object object = this.sync;
            synchronized (object) {
                return this.sortedMap.lastKey();
            }
        }

        public SortedMap subMap(Object from, Object to) {
            return new SynchronizedSortedMap((Long2IntSortedMap)this.sortedMap.subMap(from, to), this.sync);
        }

        public SortedMap headMap(Object to) {
            return new SynchronizedSortedMap((Long2IntSortedMap)this.sortedMap.headMap(to), this.sync);
        }

        public SortedMap tailMap(Object from) {
            return new SynchronizedSortedMap((Long2IntSortedMap)this.sortedMap.tailMap(from), this.sync);
        }
    }

    public static class Singleton
    extends Long2IntMaps.Singleton
    implements Long2IntSortedMap,
    Serializable,
    Cloneable {
        public static final long serialVersionUID = -7046029254386353129L;
        protected final LongComparator comparator;

        protected Singleton(long key, int value, LongComparator comparator) {
            super(key, value);
            this.comparator = comparator;
        }

        protected Singleton(long key, int value) {
            this(key, value, null);
        }

        final int compare(long k1, long k2) {
            return this.comparator == null ? (k1 < k2 ? -1 : (k1 == k2 ? 0 : 1)) : this.comparator.compare(k1, k2);
        }

        public Comparator comparator() {
            return this.comparator;
        }

        public Set keySet() {
            if (this.keys == null) {
                this.keys = LongSortedSets.singleton(this.key, this.comparator);
            }
            return this.keys;
        }

        public Long2IntSortedMap subMap(long from, long to) {
            if (this.compare(from, this.key) <= 0 && this.compare(this.key, to) < 0) {
                return this;
            }
            return EMPTY_MAP;
        }

        public Long2IntSortedMap headMap(long to) {
            if (this.compare(this.key, to) < 0) {
                return this;
            }
            return EMPTY_MAP;
        }

        public Long2IntSortedMap tailMap(long from) {
            if (this.compare(from, this.key) <= 0) {
                return this;
            }
            return EMPTY_MAP;
        }

        public long firstLongKey() {
            return this.key;
        }

        public long lastLongKey() {
            return this.key;
        }

        public SortedMap headMap(Object oto) {
            return this.headMap((Long)oto);
        }

        public SortedMap tailMap(Object ofrom) {
            return this.tailMap((Long)ofrom);
        }

        public SortedMap subMap(Object ofrom, Object oto) {
            return this.subMap((Long)ofrom, (Long)oto);
        }

        public Object firstKey() {
            return new Long(this.firstLongKey());
        }

        public Object lastKey() {
            return new Long(this.lastLongKey());
        }
    }

    public static class EmptySortedMap
    extends Long2IntMaps.EmptyMap
    implements Long2IntSortedMap,
    Serializable,
    Cloneable {
        public static final long serialVersionUID = -7046029254386353129L;

        protected EmptySortedMap() {
        }

        public Comparator comparator() {
            return null;
        }

        public Long2IntSortedMap subMap(long from, long to) {
            return EMPTY_MAP;
        }

        public Long2IntSortedMap headMap(long to) {
            return EMPTY_MAP;
        }

        public Long2IntSortedMap tailMap(long from) {
            return EMPTY_MAP;
        }

        public long firstLongKey() {
            throw new NoSuchElementException();
        }

        public long lastLongKey() {
            throw new NoSuchElementException();
        }

        public SortedMap headMap(Object oto) {
            return this.headMap((Long)oto);
        }

        public SortedMap tailMap(Object ofrom) {
            return this.tailMap((Long)ofrom);
        }

        public SortedMap subMap(Object ofrom, Object oto) {
            return this.subMap((Long)ofrom, (Long)oto);
        }

        public Object firstKey() {
            return new Long(this.firstLongKey());
        }

        public Object lastKey() {
            return new Long(this.lastLongKey());
        }
    }
}

