/*
 * Decompiled with CFR 0.152.
 */
package it.unimi.dsi.fastutil.longs;

import it.unimi.dsi.fastutil.HashCommon;
import it.unimi.dsi.fastutil.ints.AbstractIntCollection;
import it.unimi.dsi.fastutil.ints.IntCollection;
import it.unimi.dsi.fastutil.ints.IntIterator;
import it.unimi.dsi.fastutil.ints.IntListIterator;
import it.unimi.dsi.fastutil.longs.AbstractLong2IntSortedMap;
import it.unimi.dsi.fastutil.longs.AbstractLongSortedSet;
import it.unimi.dsi.fastutil.longs.Long2IntMap;
import it.unimi.dsi.fastutil.longs.Long2IntRBTreeMap;
import it.unimi.dsi.fastutil.longs.Long2IntSortedMap;
import it.unimi.dsi.fastutil.longs.LongBidirectionalIterator;
import it.unimi.dsi.fastutil.longs.LongComparator;
import it.unimi.dsi.fastutil.longs.LongIterator;
import it.unimi.dsi.fastutil.longs.LongListIterator;
import it.unimi.dsi.fastutil.longs.LongSet;
import it.unimi.dsi.fastutil.longs.LongSortedSet;
import it.unimi.dsi.fastutil.objects.AbstractObjectListIterator;
import it.unimi.dsi.fastutil.objects.AbstractObjectSet;
import it.unimi.dsi.fastutil.objects.ObjectIterator;
import it.unimi.dsi.fastutil.objects.ObjectSet;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import java.util.SortedMap;

public class Long2IntRBTreeMap
extends AbstractLong2IntSortedMap
implements Serializable,
Cloneable,
Long2IntSortedMap {
    protected transient Entry tree;
    protected int count;
    protected transient Entry firstEntry;
    protected transient Entry lastEntry;
    protected volatile transient ObjectSet entries;
    protected volatile transient LongSet keys;
    protected volatile transient IntCollection values;
    protected transient boolean modified;
    protected Comparator storedComparator;
    protected transient LongComparator actualComparator;
    public static final long serialVersionUID = -7046029254386353129L;
    private static final boolean ASSERTS = false;
    private transient boolean[] dirPath;
    private transient Entry[] nodePath;

    public Long2IntRBTreeMap() {
        this.allocatePaths();
        this.tree = null;
        this.count = 0;
    }

    private void setActualComparator() {
        this.actualComparator = this.storedComparator == null || this.storedComparator instanceof LongComparator ? (LongComparator)this.storedComparator : new LongComparator(){

            public int compare(long k1, long k2) {
                return Long2IntRBTreeMap.this.storedComparator.compare(new Long(k1), new Long(k2));
            }

            public int compare(Object ok1, Object ok2) {
                return Long2IntRBTreeMap.this.storedComparator.compare(ok1, ok2);
            }
        };
    }

    public Long2IntRBTreeMap(Comparator c) {
        this();
        this.storedComparator = c;
        this.setActualComparator();
    }

    public Long2IntRBTreeMap(Map m) {
        this();
        this.putAll(m);
    }

    public Long2IntRBTreeMap(SortedMap m) {
        this(m.comparator());
        this.putAll((Map)m);
    }

    public Long2IntRBTreeMap(Long2IntMap m) {
        this();
        this.putAll((Map)m);
    }

    public Long2IntRBTreeMap(Long2IntSortedMap m) {
        this(m.comparator());
        this.putAll((Map)m);
    }

    final int compare(long k1, long k2) {
        return this.actualComparator == null ? (k1 < k2 ? -1 : (k1 == k2 ? 0 : 1)) : this.actualComparator.compare(k1, k2);
    }

    final Entry findKey(long k) {
        int cmp;
        Entry e = this.tree;
        while (e != null && (cmp = this.compare(k, e.key)) != 0) {
            e = cmp < 0 ? e.left() : e.right();
        }
        return e;
    }

    final Entry locateKey(long k) {
        Entry e = this.tree;
        Entry last = this.tree;
        int cmp = 0;
        while (e != null && (cmp = this.compare(k, e.key)) != 0) {
            last = e;
            e = cmp < 0 ? e.left() : e.right();
        }
        return cmp == 0 ? e : last;
    }

    private void allocatePaths() {
        this.dirPath = new boolean[64];
        this.nodePath = new Entry[64];
    }

    public int put(long k, int v) {
        this.modified = false;
        if (this.tree == null) {
            ++this.count;
            this.lastEntry = this.firstEntry = new Entry(k, v);
            this.tree = this.firstEntry;
        } else {
            Entry p = this.tree;
            int i = 0;
            while (true) {
                Entry e;
                int cmp;
                if ((cmp = this.compare(k, p.key)) == 0) {
                    int oldValue = p.value;
                    p.value = v;
                    return oldValue;
                }
                this.nodePath[i] = p;
                this.dirPath[i++] = cmp > 0;
                if (this.dirPath[i++]) {
                    if (p.succ()) {
                        ++this.count;
                        e = new Entry(k, v);
                        if (p.right == null) {
                            this.lastEntry = e;
                        }
                        e.left = p;
                        e.right = p.right;
                        p.right(e);
                        break;
                    }
                    p = p.right;
                    continue;
                }
                if (p.pred()) {
                    ++this.count;
                    e = new Entry(k, v);
                    if (p.left == null) {
                        this.firstEntry = e;
                    }
                    e.right = p;
                    e.left = p.left;
                    p.left(e);
                    break;
                }
                p = p.left;
            }
            this.modified = true;
            --i;
            while (i > 0 && !this.nodePath[i].black()) {
                Entry x;
                Entry y;
                if (!this.dirPath[i - 1]) {
                    Entry x2;
                    y = this.nodePath[i - 1].right;
                    if (!this.nodePath[i - 1].succ() && !y.black()) {
                        this.nodePath[i].black(true);
                        y.black(true);
                        this.nodePath[i - 1].black(false);
                        i -= 2;
                        continue;
                    }
                    if (!this.dirPath[i]) {
                        y = this.nodePath[i];
                    } else {
                        x2 = this.nodePath[i];
                        y = x2.right;
                        x2.right = y.left;
                        y.left = x2;
                        this.nodePath[i - 1].left = y;
                        if (y.pred()) {
                            y.pred(false);
                            x2.succ(y);
                        }
                    }
                    x2 = this.nodePath[i - 1];
                    x2.black(false);
                    y.black(true);
                    x2.left = y.right;
                    y.right = x2;
                    if (i < 2) {
                        this.tree = y;
                    } else if (this.dirPath[i - 2]) {
                        this.nodePath[i - 2].right = y;
                    } else {
                        this.nodePath[i - 2].left = y;
                    }
                    if (!y.succ()) break;
                    y.succ(false);
                    x2.pred(y);
                    break;
                }
                y = this.nodePath[i - 1].left;
                if (!this.nodePath[i - 1].pred() && !y.black()) {
                    this.nodePath[i].black(true);
                    y.black(true);
                    this.nodePath[i - 1].black(false);
                    i -= 2;
                    continue;
                }
                if (this.dirPath[i]) {
                    y = this.nodePath[i];
                } else {
                    x = this.nodePath[i];
                    y = x.left;
                    x.left = y.right;
                    y.right = x;
                    this.nodePath[i - 1].right = y;
                    if (y.succ()) {
                        y.succ(false);
                        x.pred(y);
                    }
                }
                x = this.nodePath[i - 1];
                x.black(false);
                y.black(true);
                x.right = y.left;
                y.left = x;
                if (i < 2) {
                    this.tree = y;
                } else if (this.dirPath[i - 2]) {
                    this.nodePath[i - 2].right = y;
                } else {
                    this.nodePath[i - 2].left = y;
                }
                if (!y.pred()) break;
                y.pred(false);
                x.succ(y);
                break;
            }
        }
        this.tree.black(true);
        return this.defRetValue;
    }

    /*
     * Enabled aggressive block sorting
     */
    public int remove(long k) {
        int i;
        Entry p;
        block59: {
            Entry s;
            int j;
            boolean color;
            block65: {
                block60: {
                    Entry r;
                    block64: {
                        block62: {
                            block63: {
                                block57: {
                                    block58: {
                                        this.modified = false;
                                        if (this.tree == null) {
                                            return this.defRetValue;
                                        }
                                        p = this.tree;
                                        i = 0;
                                        do {
                                            int cmp;
                                            if ((cmp = this.compare(k, p.key)) == 0) {
                                                if (p.left != null) break block57;
                                                break block58;
                                            }
                                            this.dirPath[i] = cmp > 0;
                                            this.nodePath[i] = p;
                                        } while (!(this.dirPath[i++] ? (p = p.right()) == null : (p = p.left()) == null));
                                        return this.defRetValue;
                                    }
                                    this.firstEntry = p.next();
                                }
                                if (p.right == null) {
                                    this.lastEntry = p.prev();
                                }
                                if (!p.succ()) break block62;
                                if (!p.pred()) break block63;
                                if (i == 0) {
                                    this.tree = p.left;
                                    break block59;
                                } else if (this.dirPath[i - 1]) {
                                    this.nodePath[i - 1].succ(p.right);
                                    break block59;
                                } else {
                                    this.nodePath[i - 1].pred(p.left);
                                }
                                break block59;
                            }
                            p.prev().right = p.right;
                            if (i == 0) {
                                this.tree = p.left;
                                break block59;
                            } else if (this.dirPath[i - 1]) {
                                this.nodePath[i - 1].right = p.left;
                                break block59;
                            } else {
                                this.nodePath[i - 1].left = p.left;
                            }
                            break block59;
                        }
                        r = p.right;
                        if (!r.pred()) break block64;
                        r.left = p.left;
                        r.pred(p.pred());
                        if (!r.pred()) {
                            r.prev().right = r;
                        }
                        if (i == 0) {
                            this.tree = r;
                        } else if (this.dirPath[i - 1]) {
                            this.nodePath[i - 1].right = r;
                        } else {
                            this.nodePath[i - 1].left = r;
                        }
                        color = r.black();
                        r.black(p.black());
                        p.black(color);
                        this.dirPath[i] = true;
                        this.nodePath[i++] = r;
                        break block59;
                    }
                    j = i++;
                    while (true) {
                        this.dirPath[i] = false;
                        this.nodePath[i++] = r;
                        s = r.left;
                        if (s.pred()) {
                            this.dirPath[j] = true;
                            this.nodePath[j] = s;
                            if (s.succ()) {
                                break;
                            }
                            break block60;
                        }
                        r = s;
                    }
                    r.pred(s);
                    break block65;
                }
                r.left = s.right;
            }
            s.left = p.left;
            if (!p.pred()) {
                p.prev().right = s;
                s.pred(false);
            }
            s.right(p.right);
            color = s.black();
            s.black(p.black());
            p.black(color);
            if (j == 0) {
                this.tree = s;
            } else if (this.dirPath[j - 1]) {
                this.nodePath[j - 1].right = s;
            } else {
                this.nodePath[j - 1].left = s;
            }
        }
        if (p.black()) {
            while (i > 0) {
                block61: {
                    Entry y;
                    Entry w;
                    if (this.dirPath[i - 1] && !this.nodePath[i - 1].succ() || !this.dirPath[i - 1] && !this.nodePath[i - 1].pred()) {
                        Entry x;
                        Entry entry = x = this.dirPath[i - 1] ? this.nodePath[i - 1].right : this.nodePath[i - 1].left;
                        if (!x.black()) {
                            x.black(true);
                            break;
                        }
                    }
                    if (!this.dirPath[i - 1]) {
                        w = this.nodePath[i - 1].right;
                        if (!w.black()) {
                            w.black(true);
                            this.nodePath[i - 1].black(false);
                            this.nodePath[i - 1].right = w.left;
                            w.left = this.nodePath[i - 1];
                            if (i < 2) {
                                this.tree = w;
                            } else if (this.dirPath[i - 2]) {
                                this.nodePath[i - 2].right = w;
                            } else {
                                this.nodePath[i - 2].left = w;
                            }
                            this.nodePath[i] = this.nodePath[i - 1];
                            this.dirPath[i] = false;
                            this.nodePath[i - 1] = w;
                            w = this.nodePath[++i - 1].right;
                        }
                        if ((w.pred() || w.left.black()) && (w.succ() || w.right.black())) {
                            w.black(false);
                            break block61;
                        } else {
                            if (w.succ() || w.right.black()) {
                                y = w.left;
                                y.black(true);
                                w.black(false);
                                w.left = y.right;
                                y.right = w;
                                w = this.nodePath[i - 1].right = y;
                                if (w.succ()) {
                                    w.succ(false);
                                    w.right.pred(w);
                                }
                            }
                            w.black(this.nodePath[i - 1].black());
                            this.nodePath[i - 1].black(true);
                            w.right.black(true);
                            this.nodePath[i - 1].right = w.left;
                            w.left = this.nodePath[i - 1];
                            if (i < 2) {
                                this.tree = w;
                            } else if (this.dirPath[i - 2]) {
                                this.nodePath[i - 2].right = w;
                            } else {
                                this.nodePath[i - 2].left = w;
                            }
                            if (!w.pred()) break;
                            w.pred(false);
                            this.nodePath[i - 1].succ(w);
                            break;
                        }
                    }
                    w = this.nodePath[i - 1].left;
                    if (!w.black()) {
                        w.black(true);
                        this.nodePath[i - 1].black(false);
                        this.nodePath[i - 1].left = w.right;
                        w.right = this.nodePath[i - 1];
                        if (i < 2) {
                            this.tree = w;
                        } else if (this.dirPath[i - 2]) {
                            this.nodePath[i - 2].right = w;
                        } else {
                            this.nodePath[i - 2].left = w;
                        }
                        this.nodePath[i] = this.nodePath[i - 1];
                        this.dirPath[i] = true;
                        this.nodePath[i - 1] = w;
                        w = this.nodePath[++i - 1].left;
                    }
                    if ((w.pred() || w.left.black()) && (w.succ() || w.right.black())) {
                        w.black(false);
                    } else {
                        if (w.pred() || w.left.black()) {
                            y = w.right;
                            y.black(true);
                            w.black(false);
                            w.right = y.left;
                            y.left = w;
                            w = this.nodePath[i - 1].left = y;
                            if (w.pred()) {
                                w.pred(false);
                                w.left.succ(w);
                            }
                        }
                        w.black(this.nodePath[i - 1].black());
                        this.nodePath[i - 1].black(true);
                        w.left.black(true);
                        this.nodePath[i - 1].left = w.right;
                        w.right = this.nodePath[i - 1];
                        if (i < 2) {
                            this.tree = w;
                        } else if (this.dirPath[i - 2]) {
                            this.nodePath[i - 2].right = w;
                        } else {
                            this.nodePath[i - 2].left = w;
                        }
                        if (!w.succ()) break;
                        w.succ(false);
                        this.nodePath[i - 1].pred(w);
                        break;
                    }
                }
                --i;
            }
            if (this.tree != null) {
                this.tree.black(true);
            }
        }
        this.modified = true;
        --this.count;
        return p.value;
    }

    public Object put(Object ok, Object ov) {
        int oldValue = this.put((Long)ok, (Integer)ov);
        return this.modified ? null : new Integer(oldValue);
    }

    public Object remove(Object ok) {
        int oldValue = this.remove((Long)ok);
        return this.modified ? new Integer(oldValue) : null;
    }

    public boolean containsValue(int v) {
        ValueIterator i = new ValueIterator();
        int j = this.count;
        while (j-- != 0) {
            int ev = i.nextInt();
            if (ev != v) continue;
            return true;
        }
        return false;
    }

    public void clear() {
        this.count = 0;
        this.tree = null;
        this.entries = null;
        this.values = null;
        this.keys = null;
        this.lastEntry = null;
        this.firstEntry = null;
    }

    public boolean containsKey(long k) {
        return this.findKey(k) != null;
    }

    public int size() {
        return this.count;
    }

    public boolean isEmpty() {
        return this.count == 0;
    }

    public int get(long k) {
        Entry e = this.findKey(k);
        return e == null ? this.defRetValue : e.value;
    }

    public Object get(Object ok) {
        Entry e = this.findKey((Long)ok);
        return e == null ? null : e.getValue();
    }

    public long firstLongKey() {
        if (this.tree == null) {
            throw new NoSuchElementException();
        }
        return this.firstEntry.key;
    }

    public long lastLongKey() {
        if (this.tree == null) {
            throw new NoSuchElementException();
        }
        return this.lastEntry.key;
    }

    public Object firstKey() {
        return new Long(this.firstLongKey());
    }

    public Object lastKey() {
        return new Long(this.lastLongKey());
    }

    public Set entrySet() {
        if (this.entries == null) {
            this.entries = new AbstractObjectSet(){

                public ObjectIterator objectIterator() {
                    return new TreeIterator();
                }

                public boolean contains(Object o) {
                    if (!(o instanceof Map.Entry)) {
                        return false;
                    }
                    Map.Entry e = (Map.Entry)o;
                    Entry f = Long2IntRBTreeMap.this.findKey((Long)e.getKey());
                    return ((Object)e).equals(f);
                }

                public boolean remove(Object o) {
                    if (!(o instanceof Map.Entry)) {
                        return false;
                    }
                    Map.Entry e = (Map.Entry)o;
                    Entry f = Long2IntRBTreeMap.this.findKey((Long)e.getKey());
                    if (f != null) {
                        Long2IntRBTreeMap.this.remove(f.key);
                    }
                    return f != null;
                }

                public int size() {
                    return Long2IntRBTreeMap.this.count;
                }

                public void clear() {
                    Long2IntRBTreeMap.this.clear();
                }
            };
        }
        return this.entries;
    }

    public Set keySet() {
        if (this.keys == null) {
            class KeySet
            extends AbstractLongSortedSet {
                KeySet() {
                }

                public LongIterator longIterator() {
                    return new KeyIterator();
                }

                public LongBidirectionalIterator iterator(long from) {
                    return new KeyIterator(from);
                }

                public Comparator comparator() {
                    return Long2IntRBTreeMap.this.storedComparator;
                }

                public boolean contains(long k) {
                    return Long2IntRBTreeMap.this.containsKey(k);
                }

                public boolean remove(long k) {
                    Long2IntRBTreeMap.this.remove(k);
                    return Long2IntRBTreeMap.this.modified;
                }

                public int size() {
                    return Long2IntRBTreeMap.this.count;
                }

                public void clear() {
                    Long2IntRBTreeMap.this.clear();
                }

                public long firstLong() {
                    return Long2IntRBTreeMap.this.firstEntry.key;
                }

                public long lastLong() {
                    return Long2IntRBTreeMap.this.lastEntry.key;
                }

                public LongSortedSet headSet(long to) {
                    return (LongSortedSet)Long2IntRBTreeMap.this.headMap(to).keySet();
                }

                public LongSortedSet tailSet(long from) {
                    return (LongSortedSet)Long2IntRBTreeMap.this.tailMap(from).keySet();
                }

                public LongSortedSet subSet(long from, long to) {
                    return (LongSortedSet)Long2IntRBTreeMap.this.subMap(from, to).keySet();
                }
            }
            this.keys = new KeySet();
        }
        return this.keys;
    }

    public Collection values() {
        if (this.values == null) {
            this.values = new AbstractIntCollection(){

                public IntIterator intIterator() {
                    return new ValueIterator();
                }

                public boolean contains(int k) {
                    return Long2IntRBTreeMap.this.containsValue(k);
                }

                public int size() {
                    return Long2IntRBTreeMap.this.count;
                }

                public void clear() {
                    Long2IntRBTreeMap.this.clear();
                }
            };
        }
        return this.values;
    }

    public Comparator comparator() {
        return this.storedComparator;
    }

    public Long2IntSortedMap headMap(long to) {
        return new Submap(0L, true, to, false);
    }

    public Long2IntSortedMap tailMap(long from) {
        return new Submap(from, false, 0L, true);
    }

    public Long2IntSortedMap subMap(long from, long to) {
        return new Submap(from, false, to, false);
    }

    public Object clone() {
        Long2IntRBTreeMap c;
        try {
            c = (Long2IntRBTreeMap)super.clone();
        }
        catch (CloneNotSupportedException cantHappen) {
            throw new InternalError();
        }
        c.keys = null;
        c.values = null;
        c.entries = null;
        c.allocatePaths();
        if (this.count != 0) {
            Entry rp = new Entry();
            Entry rq = new Entry();
            Entry p = rp;
            rp.left(this.tree);
            Entry q = rq;
            rq.pred(null);
            while (true) {
                Entry e;
                if (!p.pred()) {
                    e = (Entry)p.left.clone();
                    e.pred(q.left);
                    e.succ(q);
                    q.left(e);
                    p = p.left;
                    q = q.left;
                } else {
                    while (p.succ()) {
                        p = p.right;
                        if (p == null) {
                            q.right = null;
                            c.firstEntry = c.tree = rq.left;
                            while (c.firstEntry.left != null) {
                                c.firstEntry = c.firstEntry.left;
                            }
                            c.lastEntry = c.tree;
                            while (c.lastEntry.right != null) {
                                c.lastEntry = c.lastEntry.right;
                            }
                            return c;
                        }
                        q = q.right;
                    }
                    p = p.right;
                    q = q.right;
                }
                if (p.succ()) continue;
                e = (Entry)p.right.clone();
                e.succ(q.right);
                e.pred(q);
                q.right(e);
            }
        }
        return c;
    }

    private void writeObject(ObjectOutputStream s) throws IOException {
        int n = this.count;
        TreeIterator i = new TreeIterator();
        s.defaultWriteObject();
        while (n-- != 0) {
            Entry e = (Entry)i.next();
            s.writeLong(e.key);
            s.writeInt(e.value);
        }
    }

    private Entry readTree(ObjectInputStream s, int n, Entry pred, Entry succ) throws IOException, ClassNotFoundException {
        if (n == 1) {
            Entry top = new Entry(s.readLong(), s.readInt());
            top.pred(pred);
            top.succ(succ);
            top.black(true);
            return top;
        }
        if (n == 2) {
            Entry top = new Entry(s.readLong(), s.readInt());
            top.black(true);
            top.right(new Entry(s.readLong(), s.readInt()));
            top.right.pred(top);
            top.pred(pred);
            top.right.succ(succ);
            return top;
        }
        int rightN = n / 2;
        int leftN = n - rightN - 1;
        Entry top = new Entry();
        top.left(this.readTree(s, leftN, pred, top));
        top.key = s.readLong();
        top.value = s.readInt();
        top.black(true);
        top.right(this.readTree(s, rightN, top, succ));
        if (n + 2 == (n + 2 & -(n + 2))) {
            top.right.black(false);
        }
        return top;
    }

    private int checkTree(Entry e, int d, int D) {
        if (e == null) {
            return 0;
        }
        if (e.black()) {
            ++d;
        }
        if (e.left() != null) {
            D = this.checkTree(e.left(), d, D);
        }
        if (e.right() != null) {
            D = this.checkTree(e.right(), d, D);
        }
        if (e.left() == null && e.right() == null) {
            if (D == -1) {
                D = d;
            } else if (D != d) {
                throw new AssertionError((Object)("Mismatch between number of black nodes (" + D + " and " + d + ")"));
            }
        }
        return D;
    }

    private void readObject(ObjectInputStream s) throws IOException, ClassNotFoundException {
        s.defaultReadObject();
        this.setActualComparator();
        this.allocatePaths();
        if (this.count != 0) {
            Entry e = this.tree = this.readTree(s, this.count, null, null);
            while (e.left() != null) {
                e = e.left();
            }
            this.firstEntry = e;
            e = this.tree;
            while (e.right() != null) {
                e = e.right();
            }
            this.lastEntry = e;
        }
    }

    private final class Submap
    extends AbstractLong2IntSortedMap
    implements Serializable,
    Long2IntSortedMap {
        long from;
        long to;
        boolean bottom;
        boolean top;
        protected volatile transient ObjectSet entries;
        protected volatile transient LongSet keys;
        protected volatile transient IntCollection values;

        public Submap(long from, boolean bottom, long to, boolean top) {
            if (!bottom && !top && Long2IntRBTreeMap.this.compare(from, to) > 0) {
                throw new IllegalArgumentException("Start key (" + from + ") is larger than end key (" + to + ")");
            }
            this.from = from;
            this.bottom = bottom;
            this.to = to;
            this.top = top;
            this.defRetValue = Long2IntRBTreeMap.this.defRetValue;
        }

        public void clear() {
            SubmapIterator i = new SubmapIterator();
            while (i.hasNext()) {
                i.next();
                i.remove();
            }
        }

        final boolean in(long k) {
            return !(!this.bottom && Long2IntRBTreeMap.this.compare(k, this.from) < 0 || !this.top && Long2IntRBTreeMap.this.compare(k, this.to) >= 0);
        }

        public Set entrySet() {
            if (this.entries == null) {
                this.entries = new AbstractObjectSet(this){
                    private final /* synthetic */ Submap this$1;
                    {
                        this.this$1 = this$1;
                    }

                    public ObjectIterator objectIterator() {
                        return this.this$1.new SubmapIterator();
                    }

                    public boolean contains(Object o) {
                        if (!(o instanceof Map.Entry)) {
                            return false;
                        }
                        Map.Entry e = (Map.Entry)o;
                        Entry f = Submap.access$100(this.this$1).findKey((Long)e.getKey());
                        return f != null && this.this$1.in(f.key) && ((Object)e).equals(f);
                    }

                    public boolean remove(Object o) {
                        if (!(o instanceof Map.Entry)) {
                            return false;
                        }
                        Map.Entry e = (Map.Entry)o;
                        Entry f = Submap.access$100(this.this$1).findKey((Long)e.getKey());
                        if (f != null && this.this$1.in(f.key)) {
                            this.this$1.remove(f.key);
                        }
                        return f != null;
                    }

                    public int size() {
                        int c = 0;
                        Iterator i = this.iterator();
                        while (i.hasNext()) {
                            ++c;
                            i.next();
                        }
                        return c;
                    }

                    public boolean isEmpty() {
                        return !this.this$1.new SubmapIterator().hasNext();
                    }

                    public void clear() {
                        this.this$1.clear();
                    }
                };
            }
            return this.entries;
        }

        public Set keySet() {
            if (this.keys == null) {
                class KeySet
                extends AbstractLongSortedSet
                implements LongSortedSet {
                    private final /* synthetic */ Submap this$1;

                    KeySet(Submap this$1) {
                        this.this$1 = this$1;
                    }

                    public LongIterator longIterator() {
                        return this.this$1.new SubmapKeyIterator();
                    }

                    public LongBidirectionalIterator iterator(long from) {
                        return this.this$1.new SubmapKeyIterator(from);
                    }

                    public Comparator comparator() {
                        return Submap.access$100((Submap)this.this$1).storedComparator;
                    }

                    public boolean contains(long k) {
                        return this.this$1.containsKey(k);
                    }

                    public boolean remove(long k) {
                        this.this$1.remove(k);
                        return Submap.access$100((Submap)this.this$1).modified;
                    }

                    public int size() {
                        return this.this$1.size();
                    }

                    public void clear() {
                        this.this$1.clear();
                    }

                    public long firstLong() {
                        return this.this$1.firstEntry().key;
                    }

                    public long lastLong() {
                        return this.this$1.lastEntry().key;
                    }

                    public LongSortedSet headSet(long to) {
                        return (LongSortedSet)this.this$1.headMap(to).keySet();
                    }

                    public LongSortedSet tailSet(long from) {
                        return (LongSortedSet)this.this$1.tailMap(from).keySet();
                    }

                    public LongSortedSet subSet(long from, long to) {
                        return (LongSortedSet)this.this$1.subMap(from, to).keySet();
                    }
                }
                this.keys = new KeySet(this);
            }
            return this.keys;
        }

        public Collection values() {
            if (this.values == null) {
                this.values = new AbstractIntCollection(this){
                    private final /* synthetic */ Submap this$1;
                    {
                        this.this$1 = this$1;
                    }

                    public IntIterator intIterator() {
                        return this.this$1.new SubmapValueIterator();
                    }

                    public boolean contains(int k) {
                        return this.this$1.containsValue(k);
                    }

                    public int size() {
                        return this.this$1.size();
                    }

                    public void clear() {
                        this.this$1.clear();
                    }
                };
            }
            return this.values;
        }

        public boolean containsKey(long k) {
            return this.in(k) && Long2IntRBTreeMap.this.containsKey(k);
        }

        public boolean containsValue(int v) {
            SubmapIterator i = new SubmapIterator();
            while (i.hasNext()) {
                int ev = ((Entry)i.next()).value;
                if (ev != v) continue;
                return true;
            }
            return false;
        }

        public int get(long k) {
            Entry e;
            return this.in(k) && (e = Long2IntRBTreeMap.this.findKey(k)) != null ? e.value : this.defRetValue;
        }

        public Object get(Object ok) {
            Entry e;
            return this.in((Long)ok) && (e = Long2IntRBTreeMap.this.findKey((Long)ok)) != null ? e.getValue() : null;
        }

        public int put(long k, int v) {
            Long2IntRBTreeMap.this.modified = false;
            if (!this.in(k)) {
                throw new IllegalArgumentException("Key (" + k + ") out of range [" + (this.bottom ? "-" : String.valueOf(this.from)) + ", " + (this.top ? "-" : String.valueOf(this.to)) + ")");
            }
            int oldValue = Long2IntRBTreeMap.this.put(k, v);
            return Long2IntRBTreeMap.this.modified ? this.defRetValue : oldValue;
        }

        public Object put(Object ok, Object ov) {
            int oldValue = this.put((Long)ok, (Integer)ov);
            return Long2IntRBTreeMap.this.modified ? null : new Integer(oldValue);
        }

        public int remove(long k) {
            Long2IntRBTreeMap.this.modified = false;
            if (!this.in(k)) {
                return this.defRetValue;
            }
            int oldValue = Long2IntRBTreeMap.this.remove(k);
            return Long2IntRBTreeMap.this.modified ? oldValue : this.defRetValue;
        }

        public Object remove(Object ok) {
            int oldValue = this.remove((Long)ok);
            return Long2IntRBTreeMap.this.modified ? new Integer(oldValue) : null;
        }

        public int size() {
            SubmapIterator i = new SubmapIterator();
            int n = 0;
            while (i.hasNext()) {
                ++n;
                i.next();
            }
            return n;
        }

        public boolean isEmpty() {
            return !new SubmapIterator().hasNext();
        }

        public Comparator comparator() {
            return Long2IntRBTreeMap.this.storedComparator;
        }

        public Long2IntSortedMap headMap(long to) {
            if (this.top) {
                return new Submap(this.from, this.bottom, to, false);
            }
            return Long2IntRBTreeMap.this.compare(to, this.to) < 0 ? new Submap(this.from, this.bottom, to, false) : this;
        }

        public Long2IntSortedMap tailMap(long from) {
            if (this.bottom) {
                return new Submap(from, false, this.to, this.top);
            }
            return Long2IntRBTreeMap.this.compare(from, this.from) > 0 ? new Submap(from, false, this.to, this.top) : this;
        }

        public Long2IntSortedMap subMap(long from, long to) {
            if (this.top && this.bottom) {
                return new Submap(from, false, to, false);
            }
            if (!this.top) {
                long l = to = Long2IntRBTreeMap.this.compare(to, this.to) < 0 ? to : this.to;
            }
            if (!this.bottom) {
                long l = from = Long2IntRBTreeMap.this.compare(from, this.from) > 0 ? from : this.from;
            }
            if (!this.top && !this.bottom && from == this.from && to == this.to) {
                return this;
            }
            return new Submap(from, false, to, false);
        }

        public Entry firstEntry() {
            Entry e;
            if (Long2IntRBTreeMap.this.tree == null) {
                return null;
            }
            if (this.bottom) {
                e = Long2IntRBTreeMap.this.firstEntry;
            } else {
                e = Long2IntRBTreeMap.this.locateKey(this.from);
                if (Long2IntRBTreeMap.this.compare(e.key, this.from) < 0) {
                    e = e.next();
                }
            }
            if (e == null || !this.top && Long2IntRBTreeMap.this.compare(e.key, this.to) >= 0) {
                return null;
            }
            return e;
        }

        public Entry lastEntry() {
            Entry e;
            if (Long2IntRBTreeMap.this.tree == null) {
                return null;
            }
            if (this.top) {
                e = Long2IntRBTreeMap.this.lastEntry;
            } else {
                e = Long2IntRBTreeMap.this.locateKey(this.to);
                if (Long2IntRBTreeMap.this.compare(e.key, this.to) >= 0) {
                    e = e.prev();
                }
            }
            if (e == null || !this.bottom && Long2IntRBTreeMap.this.compare(e.key, this.from) < 0) {
                return null;
            }
            return e;
        }

        public long firstLongKey() {
            Entry e = this.firstEntry();
            if (e == null) {
                throw new NoSuchElementException();
            }
            return e.key;
        }

        public long lastLongKey() {
            Entry e = this.lastEntry();
            if (e == null) {
                throw new NoSuchElementException();
            }
            return e.key;
        }

        public Object firstKey() {
            return new Long(this.firstLongKey());
        }

        public Object lastKey() {
            return new Long(this.lastLongKey());
        }

        private final class SubmapValueIterator
        extends SubmapIterator
        implements IntListIterator {
            private SubmapValueIterator() {
            }

            public int nextInt() {
                return this.nextEntry().value;
            }

            public int previousInt() {
                return this.previousEntry().value;
            }

            public Object next() {
                return new Integer(this.nextEntry().value);
            }

            public Object previous() {
                return new Integer(this.previousEntry().value);
            }

            public void set(int v) {
                throw new UnsupportedOperationException();
            }

            public void add(int v) {
                throw new UnsupportedOperationException();
            }
        }

        private final class SubmapKeyIterator
        extends SubmapIterator
        implements LongListIterator {
            public SubmapKeyIterator() {
            }

            public SubmapKeyIterator(long from) {
                super(from);
            }

            public long nextLong() {
                return this.nextEntry().key;
            }

            public long previousLong() {
                return this.previousEntry().key;
            }

            public Object next() {
                return new Long(this.nextEntry().key);
            }

            public Object previous() {
                return new Long(this.previousEntry().key);
            }

            public void set(long k) {
                throw new UnsupportedOperationException();
            }

            public void add(long k) {
                throw new UnsupportedOperationException();
            }
        }

        private class SubmapIterator
        extends TreeIterator {
            SubmapIterator() {
                this.next = Submap.this.firstEntry();
            }

            /*
             * Enabled aggressive block sorting
             */
            SubmapIterator(long k) {
                this();
                if (this.next == null) return;
                if (!this$1.bottom && this$1.Long2IntRBTreeMap.this.compare(k, this.next.key) < 0) {
                    this.prev = null;
                    return;
                }
                if (!this$1.top) {
                    this.prev = this$1.lastEntry();
                    if (this$1.Long2IntRBTreeMap.this.compare(k, this.prev.key) >= 0) {
                        this.next = null;
                        return;
                    }
                }
                this.next = this$1.Long2IntRBTreeMap.this.locateKey(k);
                if (this$1.Long2IntRBTreeMap.this.compare(this.next.key, k) <= 0) {
                    this.prev = this.next;
                    this.next = this.next.next();
                    return;
                }
                this.prev = this.next.prev();
            }

            void updatePrevious() {
                this.prev = this.prev.prev();
                if (!Submap.this.bottom && this.prev != null && Long2IntRBTreeMap.this.compare(this.prev.key, Submap.this.from) < 0) {
                    this.prev = null;
                }
            }

            void updateNext() {
                this.next = this.next.next();
                if (!Submap.this.top && this.next != null && Long2IntRBTreeMap.this.compare(this.next.key, Submap.this.to) >= 0) {
                    this.next = null;
                }
            }
        }
    }

    private final class ValueIterator
    extends TreeIterator
    implements IntListIterator {
        private ValueIterator() {
        }

        public int nextInt() {
            return this.nextEntry().value;
        }

        public int previousInt() {
            return this.previousEntry().value;
        }

        public Object next() {
            return new Integer(this.nextEntry().value);
        }

        public Object previous() {
            return new Integer(this.previousEntry().value);
        }

        public void set(int v) {
            throw new UnsupportedOperationException();
        }

        public void add(int v) {
            throw new UnsupportedOperationException();
        }
    }

    private final class KeyIterator
    extends TreeIterator
    implements LongListIterator {
        public KeyIterator() {
        }

        public KeyIterator(long k) {
            super(k);
        }

        public long nextLong() {
            return this.nextEntry().key;
        }

        public long previousLong() {
            return this.previousEntry().key;
        }

        public Object next() {
            return new Long(this.nextEntry().key);
        }

        public Object previous() {
            return new Long(this.previousEntry().key);
        }

        public void set(long k) {
            throw new UnsupportedOperationException();
        }

        public void add(long k) {
            throw new UnsupportedOperationException();
        }
    }

    private class TreeIterator
    extends AbstractObjectListIterator {
        Entry prev;
        Entry next;
        Entry curr;
        int index = 0;

        TreeIterator() {
            this.next = Long2IntRBTreeMap.this.firstEntry;
        }

        TreeIterator(long k) {
            this.next = Long2IntRBTreeMap.this.locateKey(k);
            if (this.next != null) {
                if (Long2IntRBTreeMap.this.compare(this.next.key, k) <= 0) {
                    this.prev = this.next;
                    this.next = this.next.next();
                } else {
                    this.prev = this.next.prev();
                }
            }
        }

        public boolean hasNext() {
            return this.next != null;
        }

        public boolean hasPrevious() {
            return this.prev != null;
        }

        void updateNext() {
            this.next = this.next.next();
        }

        Entry nextEntry() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            this.curr = this.prev = this.next;
            ++this.index;
            this.updateNext();
            return this.curr;
        }

        public Object next() {
            return this.nextEntry();
        }

        void updatePrevious() {
            this.prev = this.prev.prev();
        }

        Entry previousEntry() {
            if (!this.hasPrevious()) {
                throw new NoSuchElementException();
            }
            this.curr = this.next = this.prev;
            --this.index;
            this.updatePrevious();
            return this.curr;
        }

        public Object previous() {
            return this.previousEntry();
        }

        public int nextIndex() {
            return this.index;
        }

        public int previousIndex() {
            return this.index - 1;
        }

        public void remove() {
            if (this.curr == null) {
                throw new IllegalStateException();
            }
            if (this.curr == this.prev) {
                --this.index;
            }
            this.next = this.prev = this.curr;
            this.updatePrevious();
            this.updateNext();
            Long2IntRBTreeMap.this.remove(this.curr.key);
            this.curr = null;
        }
    }

    private static final class Entry
    implements Cloneable,
    Long2IntMap.Entry {
        private static final int BLACK_MASK = 1;
        private static final int SUCC_MASK = Integer.MIN_VALUE;
        private static final int PRED_MASK = 0x40000000;
        long key;
        int value;
        Entry left;
        Entry right;
        int info;

        Entry() {
        }

        Entry(Object k, Object v) {
            this.key = (Long)k;
            this.value = (Integer)v;
            this.info = -1073741824;
        }

        Entry(long k, int v) {
            this.key = k;
            this.value = v;
            this.info = -1073741824;
        }

        Entry left() {
            return (this.info & 0x40000000) != 0 ? null : this.left;
        }

        Entry right() {
            return (this.info & Integer.MIN_VALUE) != 0 ? null : this.right;
        }

        boolean pred() {
            return (this.info & 0x40000000) != 0;
        }

        boolean succ() {
            return (this.info & Integer.MIN_VALUE) != 0;
        }

        void pred(boolean pred) {
            this.info = pred ? (this.info |= 0x40000000) : (this.info &= 0xBFFFFFFF);
        }

        void succ(boolean succ) {
            this.info = succ ? (this.info |= Integer.MIN_VALUE) : (this.info &= Integer.MAX_VALUE);
        }

        void pred(Entry pred) {
            this.info |= 0x40000000;
            this.left = pred;
        }

        void succ(Entry succ) {
            this.info |= Integer.MIN_VALUE;
            this.right = succ;
        }

        void left(Entry left) {
            this.info &= 0xBFFFFFFF;
            this.left = left;
        }

        void right(Entry right) {
            this.info &= Integer.MAX_VALUE;
            this.right = right;
        }

        boolean black() {
            return (this.info & 1) != 0;
        }

        void black(boolean black) {
            this.info = black ? (this.info |= 1) : (this.info &= 0xFFFFFFFE);
        }

        Entry next() {
            Entry next = this.right;
            if ((this.info & Integer.MIN_VALUE) == 0) {
                while ((next.info & 0x40000000) == 0) {
                    next = next.left;
                }
            }
            return next;
        }

        Entry prev() {
            Entry prev = this.left;
            if ((this.info & 0x40000000) == 0) {
                while ((prev.info & Integer.MIN_VALUE) == 0) {
                    prev = prev.right;
                }
            }
            return prev;
        }

        public Object getKey() {
            return new Long(this.key);
        }

        public long getLongKey() {
            return this.key;
        }

        public Object getValue() {
            return new Integer(this.value);
        }

        public int getIntValue() {
            return this.value;
        }

        public int setValue(int value) {
            int oldValue = this.value;
            this.value = value;
            return oldValue;
        }

        public Object setValue(Object value) {
            return new Integer(this.setValue((Integer)value));
        }

        public Object clone() {
            Entry c;
            try {
                c = (Entry)super.clone();
            }
            catch (CloneNotSupportedException cantHappen) {
                throw new InternalError();
            }
            c.key = this.key;
            c.value = this.value;
            c.info = this.info;
            return c;
        }

        public boolean equals(Object o) {
            if (!(o instanceof Entry)) {
                return false;
            }
            Entry e = (Entry)o;
            return this.key == (Long)e.getKey() && this.value == (Integer)e.getValue();
        }

        public int hashCode() {
            return HashCommon.long2int(this.key) ^ this.value;
        }

        public String toString() {
            return this.key + "=>" + this.value;
        }
    }
}

