/*
 * Decompiled with CFR 0.152.
 */
package it.unimi.dsi.fastutil.longs;

import it.unimi.dsi.fastutil.HashCommon;
import it.unimi.dsi.fastutil.longs.AbstractLongCollection;
import it.unimi.dsi.fastutil.longs.AbstractLongListIterator;
import it.unimi.dsi.fastutil.longs.LongCollection;
import it.unimi.dsi.fastutil.longs.LongIterator;
import it.unimi.dsi.fastutil.longs.LongList;
import it.unimi.dsi.fastutil.longs.LongListIterator;
import it.unimi.dsi.fastutil.longs.LongStack;
import java.io.Serializable;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.NoSuchElementException;

public abstract class AbstractLongList
extends AbstractLongCollection
implements LongList,
LongStack {
    private static final boolean ASSERTS = false;

    protected AbstractLongList() {
    }

    protected void ensureIndex(int index) {
        if (index < 0) {
            throw new IndexOutOfBoundsException("Index (" + index + ") is negative");
        }
        if (index > this.size()) {
            throw new IndexOutOfBoundsException("Index (" + index + ") is greater than list size (" + this.size() + ")");
        }
    }

    protected void ensureRestrictedIndex(int index) {
        if (index < 0) {
            throw new IndexOutOfBoundsException("Index (" + index + ") is negative");
        }
        if (index >= this.size()) {
            throw new IndexOutOfBoundsException("Index (" + index + ") is greater than or equal to list size (" + this.size() + ")");
        }
    }

    public void add(int index, long k) {
        throw new UnsupportedOperationException();
    }

    public boolean add(long k) {
        this.add(this.size(), k);
        return true;
    }

    public boolean rem(long k) {
        int index = this.indexOf(k);
        if (index == -1) {
            return false;
        }
        this.removeLong(index);
        return true;
    }

    public long removeLong(int i) {
        throw new UnsupportedOperationException();
    }

    public long set(int index, long k) {
        throw new UnsupportedOperationException();
    }

    public boolean addAll(int index, Collection c) {
        this.ensureIndex(index);
        int n = c.size();
        if (n == 0) {
            return false;
        }
        Iterator i = c.iterator();
        while (n-- != 0) {
            this.add(index++, i.next());
        }
        return true;
    }

    public boolean addAll(int index, LongCollection c) {
        return this.addAll(index, (Collection)c);
    }

    public boolean addAll(int index, LongList l) {
        return this.addAll(index, (LongCollection)l);
    }

    public boolean addAll(Collection c) {
        return this.addAll(this.size(), c);
    }

    public boolean addAll(LongCollection c) {
        return this.addAll(this.size(), c);
    }

    public boolean addAll(LongList l) {
        return this.addAll(this.size(), l);
    }

    public ListIterator listIterator() {
        return this.longListIterator();
    }

    public ListIterator listIterator(int index) {
        return this.longListIterator(index);
    }

    public LongIterator longIterator() {
        return this.longListIterator();
    }

    public LongListIterator longListIterator() {
        return this.longListIterator(0);
    }

    public LongListIterator longListIterator(final int index) {
        return new AbstractLongListIterator(){
            int pos;
            int last;
            {
                this.pos = index;
                this.last = -1;
            }

            public boolean hasNext() {
                return this.pos < AbstractLongList.this.size();
            }

            public boolean hasPrevious() {
                return this.pos > 0;
            }

            public long nextLong() {
                if (!this.hasNext()) {
                    throw new NoSuchElementException();
                }
                this.last = this.pos++;
                return AbstractLongList.this.getLong(this.last);
            }

            public long previousLong() {
                if (!this.hasPrevious()) {
                    throw new NoSuchElementException();
                }
                this.last = --this.pos;
                return AbstractLongList.this.getLong(this.pos);
            }

            public int nextIndex() {
                return this.pos;
            }

            public int previousIndex() {
                return this.pos - 1;
            }

            public void add(long k) {
                if (this.last == -1) {
                    throw new IllegalStateException();
                }
                AbstractLongList.this.add(this.pos++, k);
                this.last = -1;
            }

            public void set(long k) {
                if (this.last == -1) {
                    throw new IllegalStateException();
                }
                AbstractLongList.this.set(this.last, k);
            }

            public void remove() {
                if (this.last == -1) {
                    throw new IllegalStateException();
                }
                AbstractLongList.this.removeLong(this.last);
                if (this.last < this.pos) {
                    --this.pos;
                }
                this.last = -1;
            }
        };
    }

    public boolean contains(long k) {
        return this.indexOf(k) >= 0;
    }

    public int indexOf(long k) {
        LongListIterator i = this.longListIterator();
        while (i.hasNext()) {
            long e = i.nextLong();
            if (k != e) continue;
            return i.previousIndex();
        }
        return -1;
    }

    public int lastIndexOf(long k) {
        LongListIterator i = this.longListIterator(this.size());
        while (i.hasPrevious()) {
            long e = i.previousLong();
            if (k != e) continue;
            return i.nextIndex();
        }
        return -1;
    }

    public void size(int size) {
        int i = this.size();
        if (size > i) {
            while (i++ < size) {
                this.add(0L);
            }
        } else {
            while (i-- != size) {
                this.remove(i);
            }
        }
    }

    public LongList longSubList(int from, int to) {
        this.ensureIndex(from);
        this.ensureIndex(to);
        if (from > to) {
            throw new IndexOutOfBoundsException("Start index (" + from + ") is greater than end index (" + to + ")");
        }
        return new LongSubList(this, from, to);
    }

    public List subList(int from, int to) {
        return this.longSubList(from, to);
    }

    public void removeElements(int from, int to) {
        this.ensureIndex(to);
        LongListIterator i = this.longListIterator(from);
        int n = to - from;
        if (n < 0) {
            throw new IllegalArgumentException("Start index (" + from + ") is greater than end index (" + to + ")");
        }
        while (n-- != 0) {
            i.nextLong();
            i.remove();
        }
    }

    public void addElements(int index, long[] a, int offset, int length) {
        this.ensureIndex(index);
        if (offset < 0) {
            throw new ArrayIndexOutOfBoundsException("Offset (" + offset + ") is negative");
        }
        if (offset + length > a.length) {
            throw new ArrayIndexOutOfBoundsException("End index (" + (offset + length) + ") is greater than array length (" + a.length + ")");
        }
        while (length-- != 0) {
            this.add(index++, a[offset++]);
        }
    }

    public void addElements(int index, long[] a) {
        this.addElements(index, a, 0, a.length);
    }

    public void getElements(int from, long[] a, int offset, int length) {
        LongListIterator i = this.longListIterator(from);
        if (offset < 0) {
            throw new ArrayIndexOutOfBoundsException("Offset (" + offset + ") is negative");
        }
        if (offset + length > a.length) {
            throw new ArrayIndexOutOfBoundsException("End index (" + (offset + length) + ") is greater than array length (" + a.length + ")");
        }
        if (from + length > this.size()) {
            throw new IndexOutOfBoundsException("End index (" + (from + length) + ") is greater than list size (" + this.size() + ")");
        }
        while (length-- != 0) {
            a[offset++] = i.nextLong();
        }
    }

    private boolean valEquals(Object a, Object b) {
        return a == null ? b == null : a.equals(b);
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof List)) {
            return false;
        }
        List l = (List)o;
        int s = this.size();
        if (s != l.size()) {
            return false;
        }
        ListIterator i1 = this.listIterator();
        ListIterator i2 = l.listIterator();
        while (s-- != 0) {
            if (this.valEquals(i1.next(), i2.next())) continue;
            return false;
        }
        return true;
    }

    public int compareTo(Object o) {
        if (o == this) {
            return 0;
        }
        if (o instanceof LongList) {
            LongList l = (LongList)o;
            LongListIterator i1 = this.longListIterator();
            LongListIterator i2 = l.longListIterator();
            while (i1.hasNext() && i2.hasNext()) {
                int r;
                long e2;
                long e1 = i1.nextLong();
                if ((e1 < (e2 = i2.nextLong()) ? -1 : (r = e1 == e2 ? 0 : 1)) == 0) continue;
                return r;
            }
            return i2.hasNext() ? -1 : (i1.hasNext() ? 1 : 0);
        }
        List l = (List)o;
        ListIterator i1 = this.listIterator();
        ListIterator i2 = l.listIterator();
        while (i1.hasNext() && i2.hasNext()) {
            int r = ((Comparable)i1.next()).compareTo(i2.next());
            if (r == 0) continue;
            return r;
        }
        return i2.hasNext() ? -1 : (i1.hasNext() ? 1 : 0);
    }

    public int hashCode() {
        LongIterator i = this.longIterator();
        int h = 1;
        int s = this.size();
        while (s-- != 0) {
            long k = i.nextLong();
            h = 31 * h + HashCommon.long2int(k);
        }
        return h;
    }

    public void push(long o) {
        this.add(o);
    }

    public long popLong() {
        if (this.isEmpty()) {
            throw new NoSuchElementException();
        }
        return this.removeLong(this.size() - 1);
    }

    public long topLong() {
        if (this.isEmpty()) {
            throw new NoSuchElementException();
        }
        return this.getLong(this.size() - 1);
    }

    public long peekLong(int i) {
        return this.getLong(this.size() - 1 - i);
    }

    public void add(int index, Object ok) {
        this.add(index, (Long)ok);
    }

    public Object set(int index, Object ok) {
        return new Long(this.set(index, (Long)ok));
    }

    public Object get(int index) {
        return new Long(this.getLong(index));
    }

    public int indexOf(Object ok) {
        return this.indexOf((Long)ok);
    }

    public int lastIndexOf(Object ok) {
        return this.lastIndexOf((Long)ok);
    }

    public Object remove(int index) {
        return new Long(this.removeLong(index));
    }

    public void push(Object o) {
        this.push((Long)o);
    }

    public Object pop() {
        return new Long(this.popLong());
    }

    public Object top() {
        return new Long(this.topLong());
    }

    public Object peek(int i) {
        return new Long(this.peekLong(i));
    }

    public String toString() {
        StringBuffer s = new StringBuffer();
        LongIterator i = this.longIterator();
        int n = this.size();
        boolean first = true;
        s.append("[");
        while (n-- != 0) {
            if (first) {
                first = false;
            } else {
                s.append(", ");
            }
            long k = i.nextLong();
            s.append(String.valueOf(k));
        }
        s.append("]");
        return s.toString();
    }

    public static class LongSubList
    extends AbstractLongList
    implements Serializable {
        protected final LongList l;
        protected final int from;
        protected int to;
        private static final boolean ASSERTS = false;

        public LongSubList(LongList l, int from, int to) {
            this.l = l;
            this.from = from;
            this.to = to;
        }

        private void assertRange() {
        }

        public boolean add(long k) {
            this.l.add(this.to, k);
            ++this.to;
            return true;
        }

        public void add(int index, long k) {
            this.ensureIndex(index);
            this.l.add(this.from + index, k);
            ++this.to;
        }

        public boolean addAll(int index, Collection c) {
            this.ensureIndex(index);
            this.to += c.size();
            return this.l.addAll(this.from + index, c);
        }

        public boolean addAll(int index, LongCollection c) {
            this.ensureIndex(index);
            this.to += c.size();
            return this.l.addAll(this.from + index, c);
        }

        public boolean addAll(int index, LongList l) {
            this.ensureIndex(index);
            this.to += l.size();
            return this.l.addAll(this.from + index, l);
        }

        public long getLong(int index) {
            this.ensureRestrictedIndex(index);
            return this.l.getLong(this.from + index);
        }

        public long removeLong(int index) {
            this.ensureRestrictedIndex(index);
            --this.to;
            return this.l.removeLong(this.from + index);
        }

        public boolean rem(long k) {
            int index = this.indexOf(k);
            if (index == -1) {
                return false;
            }
            --this.to;
            this.l.removeLong(this.from + index);
            return true;
        }

        public long set(int index, long k) {
            this.ensureRestrictedIndex(index);
            return this.l.set(this.from + index, k);
        }

        public void clear() {
            this.removeElements(0, this.size());
        }

        public int size() {
            return this.to - this.from;
        }

        public void getElements(int from, long[] a, int offset, int length) {
            this.ensureIndex(from);
            if (from + length > this.size()) {
                throw new IndexOutOfBoundsException("End index (" + from + length + ") is greater than list size (" + this.size() + ")");
            }
            this.l.getElements(this.from + from, a, offset, length);
        }

        public void removeElements(int from, int to) {
            this.ensureIndex(from);
            this.ensureIndex(to);
            this.l.removeElements(this.from + from, this.from + to);
            this.to -= to - from;
        }

        public void addElements(int index, long[] a, int offset, int length) {
            this.ensureIndex(index);
            this.l.addElements(this.from + index, a, offset, length);
            this.to += length;
        }

        public LongListIterator longListIterator(int index) {
            this.ensureIndex(index);
            return new AbstractLongListIterator(this, index){
                int pos;
                int last;
                private final /* synthetic */ int val$index;
                private final /* synthetic */ LongSubList this$0;
                {
                    this.this$0 = this$0;
                    this.val$index = val$index;
                    this.pos = this.val$index;
                    this.last = -1;
                }

                public boolean hasNext() {
                    return this.pos < this.this$0.size();
                }

                public boolean hasPrevious() {
                    return this.pos > 0;
                }

                public long nextLong() {
                    if (!this.hasNext()) {
                        throw new NoSuchElementException();
                    }
                    this.last = this.pos++;
                    return this.this$0.l.getLong(this.this$0.from + this.last);
                }

                public long previousLong() {
                    if (!this.hasPrevious()) {
                        throw new NoSuchElementException();
                    }
                    this.last = --this.pos;
                    return this.this$0.l.getLong(this.this$0.from + this.pos);
                }

                public int nextIndex() {
                    return this.pos;
                }

                public int previousIndex() {
                    return this.pos - 1;
                }

                public void add(long k) {
                    if (this.last == -1) {
                        throw new IllegalStateException();
                    }
                    this.this$0.add(this.pos++, k);
                    this.last = -1;
                }

                public void set(long k) {
                    if (this.last == -1) {
                        throw new IllegalStateException();
                    }
                    this.this$0.set(this.last, k);
                }

                public void remove() {
                    if (this.last == -1) {
                        throw new IllegalStateException();
                    }
                    this.this$0.removeLong(this.last);
                    if (this.last < this.pos) {
                        --this.pos;
                    }
                    this.last = -1;
                }
            };
        }

        public LongList longSubList(int from, int to) {
            this.ensureIndex(from);
            this.ensureIndex(to);
            if (from > to) {
                throw new IllegalArgumentException("Start index (" + from + ") is greater than end index (" + to + ")");
            }
            return new LongSubList(this, from, to);
        }
    }
}

