/*
 * Decompiled with CFR 0.152.
 */
package it.unimi.dsi.fastutil.longs;

import it.unimi.dsi.fastutil.HashCommon;
import it.unimi.dsi.fastutil.longs.AbstractLongIterator;
import it.unimi.dsi.fastutil.longs.AbstractLongSet;
import it.unimi.dsi.fastutil.longs.Long2ShortMap;
import it.unimi.dsi.fastutil.longs.LongIterator;
import it.unimi.dsi.fastutil.longs.LongSet;
import it.unimi.dsi.fastutil.shorts.AbstractShortCollection;
import it.unimi.dsi.fastutil.shorts.AbstractShortIterator;
import it.unimi.dsi.fastutil.shorts.ShortCollection;
import it.unimi.dsi.fastutil.shorts.ShortIterator;
import java.io.Serializable;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;

public abstract class AbstractLong2ShortMap
implements Long2ShortMap,
Serializable {
    protected short defRetValue;

    protected AbstractLong2ShortMap() {
    }

    public void setDefRetValue(short rv) {
        this.defaultReturnValue(rv);
    }

    public short getDefRetValue() {
        return this.defaultReturnValue();
    }

    public void defaultReturnValue(short rv) {
        this.defRetValue = rv;
    }

    public short defaultReturnValue() {
        return this.defRetValue;
    }

    public short put(long key, short value) {
        throw new UnsupportedOperationException();
    }

    public short remove(long key) {
        throw new UnsupportedOperationException();
    }

    public void clear() {
        throw new UnsupportedOperationException();
    }

    public Object get(Object ok) {
        long k = (Long)ok;
        return this.containsKey(k) ? new Short(this.get(k)) : null;
    }

    public Object put(Object ok, Object ov) {
        long k = (Long)ok;
        short v = this.put(k, (Short)ov);
        return this.containsKey(k) ? new Short(v) : null;
    }

    public Object remove(Object ok) {
        long k = (Long)ok;
        short v = this.remove(k);
        return this.containsKey(k) ? new Short(v) : null;
    }

    public boolean containsValue(Object ov) {
        return this.containsValue((Short)ov);
    }

    public boolean containsKey(Object ok) {
        return this.containsKey((Long)ok);
    }

    public boolean containsValue(short v) {
        return ((ShortCollection)this.values()).contains(v);
    }

    public boolean containsKey(long k) {
        return ((LongSet)this.keySet()).contains(k);
    }

    public void putAll(Map m) {
        int n = m.size();
        Iterator i = m.entrySet().iterator();
        if (m instanceof Long2ShortMap) {
            while (n-- != 0) {
                Long2ShortMap.Entry e = (Long2ShortMap.Entry)i.next();
                this.put(e.getLongKey(), e.getShortValue());
            }
        } else {
            while (n-- != 0) {
                Map.Entry e = i.next();
                this.put(e.getKey(), e.getValue());
            }
        }
    }

    public boolean isEmpty() {
        return this.size() == 0;
    }

    public Set keySet() {
        return new AbstractLongSet(){

            public boolean contains(long k) {
                return AbstractLong2ShortMap.this.containsKey(k);
            }

            public int size() {
                return AbstractLong2ShortMap.this.size();
            }

            public LongIterator longIterator() {
                return new AbstractLongIterator(this){
                    final Iterator i;
                    private final /* synthetic */ 1 this$1;
                    {
                        this.this$1 = this$1;
                        this.i = 1.access$000(this.this$1).entrySet().iterator();
                    }

                    public long nextLong() {
                        return ((Long2ShortMap.Entry)this.i.next()).getLongKey();
                    }

                    public boolean hasNext() {
                        return this.i.hasNext();
                    }
                };
            }

            static /* synthetic */ AbstractLong2ShortMap access$000(1 x0) {
                return x0.AbstractLong2ShortMap.this;
            }
        };
    }

    public Collection values() {
        return new AbstractShortCollection(){

            public boolean contains(short k) {
                return AbstractLong2ShortMap.this.containsValue(k);
            }

            public int size() {
                return AbstractLong2ShortMap.this.size();
            }

            public ShortIterator shortIterator() {
                return new AbstractShortIterator(this){
                    final Iterator i;
                    private final /* synthetic */ 3 this$1;
                    {
                        this.this$1 = this$1;
                        this.i = 3.access$100(this.this$1).entrySet().iterator();
                    }

                    public short nextShort() {
                        return ((Long2ShortMap.Entry)this.i.next()).getShortValue();
                    }

                    public boolean hasNext() {
                        return this.i.hasNext();
                    }
                };
            }

            static /* synthetic */ AbstractLong2ShortMap access$100(3 x0) {
                return x0.AbstractLong2ShortMap.this;
            }
        };
    }

    public int hashCode() {
        int h = 0;
        int n = this.size();
        Iterator i = this.entrySet().iterator();
        while (n-- != 0) {
            h += ((Object)i.next()).hashCode();
        }
        return h;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Map)) {
            return false;
        }
        Map m = (Map)o;
        if (m.size() != this.size()) {
            return false;
        }
        return this.entrySet().containsAll(m.entrySet());
    }

    public String toString() {
        StringBuffer s = new StringBuffer();
        Iterator i = this.entrySet().iterator();
        int n = this.size();
        boolean first = true;
        s.append("{");
        while (n-- != 0) {
            if (first) {
                first = false;
            } else {
                s.append(", ");
            }
            Long2ShortMap.Entry e = (Long2ShortMap.Entry)i.next();
            s.append(String.valueOf(e.getLongKey()));
            s.append("=>");
            s.append(String.valueOf(e.getShortValue()));
        }
        s.append("}");
        return s.toString();
    }

    public static class BasicEntry
    implements Long2ShortMap.Entry {
        protected long key;
        protected short value;

        public BasicEntry(Object key, Object value) {
            this.key = (Long)key;
            this.value = (Short)value;
        }

        public BasicEntry(long key, short value) {
            this.key = key;
            this.value = value;
        }

        public Object getKey() {
            return new Long(this.key);
        }

        public long getLongKey() {
            return this.key;
        }

        public Object getValue() {
            return new Short(this.value);
        }

        public short getShortValue() {
            return this.value;
        }

        public short setValue(short value) {
            throw new UnsupportedOperationException();
        }

        public Object setValue(Object value) {
            return new Short(this.setValue((Short)value));
        }

        public boolean equals(Object o) {
            if (!(o instanceof Map.Entry)) {
                return false;
            }
            Map.Entry e = (Map.Entry)o;
            return this.key == (Long)e.getKey() && this.value == (Short)e.getValue();
        }

        public int hashCode() {
            return HashCommon.long2int(this.key) ^ this.value;
        }

        public String toString() {
            return this.key + "->" + this.value;
        }
    }
}

