/*
 * Decompiled with CFR 0.152.
 */
package it.unimi.dsi.fastutil.longs;

import it.unimi.dsi.fastutil.HashCommon;
import it.unimi.dsi.fastutil.longs.AbstractLongIterator;
import it.unimi.dsi.fastutil.longs.AbstractLongSet;
import it.unimi.dsi.fastutil.longs.Long2ReferenceMap;
import it.unimi.dsi.fastutil.longs.LongIterator;
import it.unimi.dsi.fastutil.longs.LongSet;
import it.unimi.dsi.fastutil.objects.AbstractObjectIterator;
import it.unimi.dsi.fastutil.objects.AbstractReferenceCollection;
import it.unimi.dsi.fastutil.objects.ObjectIterator;
import it.unimi.dsi.fastutil.objects.ReferenceCollection;
import java.io.Serializable;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;

public abstract class AbstractLong2ReferenceMap
implements Long2ReferenceMap,
Serializable {
    protected Object defRetValue;

    protected AbstractLong2ReferenceMap() {
    }

    public void setDefRetValue(Object rv) {
        this.defaultReturnValue(rv);
    }

    public Object getDefRetValue() {
        return this.defaultReturnValue();
    }

    public void defaultReturnValue(Object rv) {
        this.defRetValue = rv;
    }

    public Object defaultReturnValue() {
        return this.defRetValue;
    }

    public Object put(long key, Object value) {
        throw new UnsupportedOperationException();
    }

    public Object remove(long key) {
        throw new UnsupportedOperationException();
    }

    public void clear() {
        throw new UnsupportedOperationException();
    }

    public Object get(Object ok) {
        long k = (Long)ok;
        return this.containsKey(k) ? this.get(k) : null;
    }

    public Object put(Object ok, Object ov) {
        long k = (Long)ok;
        Object v = this.put(k, ov);
        return this.containsKey(k) ? v : null;
    }

    public Object remove(Object ok) {
        long k = (Long)ok;
        Object v = this.remove(k);
        return this.containsKey(k) ? v : null;
    }

    public boolean containsKey(Object ok) {
        return this.containsKey((Long)ok);
    }

    public boolean containsValue(Object v) {
        return ((ReferenceCollection)this.values()).contains(v);
    }

    public boolean containsKey(long k) {
        return ((LongSet)this.keySet()).contains(k);
    }

    public void putAll(Map m) {
        int n = m.size();
        Iterator i = m.entrySet().iterator();
        if (m instanceof Long2ReferenceMap) {
            while (n-- != 0) {
                Long2ReferenceMap.Entry e = (Long2ReferenceMap.Entry)i.next();
                this.put(e.getLongKey(), e.getValue());
            }
        } else {
            while (n-- != 0) {
                Map.Entry e = i.next();
                this.put(e.getKey(), e.getValue());
            }
        }
    }

    public boolean isEmpty() {
        return this.size() == 0;
    }

    public Set keySet() {
        return new AbstractLongSet(){

            public boolean contains(long k) {
                return AbstractLong2ReferenceMap.this.containsKey(k);
            }

            public int size() {
                return AbstractLong2ReferenceMap.this.size();
            }

            public LongIterator longIterator() {
                return new AbstractLongIterator(this){
                    final Iterator i;
                    private final /* synthetic */ 1 this$1;
                    {
                        this.this$1 = this$1;
                        this.i = 1.access$000(this.this$1).entrySet().iterator();
                    }

                    public long nextLong() {
                        return ((Long2ReferenceMap.Entry)this.i.next()).getLongKey();
                    }

                    public boolean hasNext() {
                        return this.i.hasNext();
                    }
                };
            }

            static /* synthetic */ AbstractLong2ReferenceMap access$000(1 x0) {
                return x0.AbstractLong2ReferenceMap.this;
            }
        };
    }

    public Collection values() {
        return new AbstractReferenceCollection(){

            public boolean contains(Object k) {
                return AbstractLong2ReferenceMap.this.containsValue(k);
            }

            public int size() {
                return AbstractLong2ReferenceMap.this.size();
            }

            public ObjectIterator objectIterator() {
                return new AbstractObjectIterator(this){
                    final Iterator i;
                    private final /* synthetic */ 3 this$1;
                    {
                        this.this$1 = this$1;
                        this.i = 3.access$100(this.this$1).entrySet().iterator();
                    }

                    public Object next() {
                        return ((Long2ReferenceMap.Entry)this.i.next()).getValue();
                    }

                    public boolean hasNext() {
                        return this.i.hasNext();
                    }
                };
            }

            static /* synthetic */ AbstractLong2ReferenceMap access$100(3 x0) {
                return x0.AbstractLong2ReferenceMap.this;
            }
        };
    }

    public int hashCode() {
        int h = 0;
        int n = this.size();
        Iterator i = this.entrySet().iterator();
        while (n-- != 0) {
            h += ((Object)i.next()).hashCode();
        }
        return h;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Map)) {
            return false;
        }
        Map m = (Map)o;
        if (m.size() != this.size()) {
            return false;
        }
        return this.entrySet().containsAll(m.entrySet());
    }

    public String toString() {
        StringBuffer s = new StringBuffer();
        Iterator i = this.entrySet().iterator();
        int n = this.size();
        boolean first = true;
        s.append("{");
        while (n-- != 0) {
            if (first) {
                first = false;
            } else {
                s.append(", ");
            }
            Long2ReferenceMap.Entry e = (Long2ReferenceMap.Entry)i.next();
            s.append(String.valueOf(e.getLongKey()));
            s.append("=>");
            if (this == e.getValue()) {
                s.append("(this map)");
                continue;
            }
            s.append(String.valueOf(e.getValue()));
        }
        s.append("}");
        return s.toString();
    }

    public static class BasicEntry
    implements Long2ReferenceMap.Entry {
        protected long key;
        protected Object value;

        public BasicEntry(Object key, Object value) {
            this.key = (Long)key;
            this.value = value;
        }

        public BasicEntry(long key, Object value) {
            this.key = key;
            this.value = value;
        }

        public Object getKey() {
            return new Long(this.key);
        }

        public long getLongKey() {
            return this.key;
        }

        public Object getValue() {
            return this.value;
        }

        public Object setValue(Object value) {
            throw new UnsupportedOperationException();
        }

        public boolean equals(Object o) {
            if (!(o instanceof Map.Entry)) {
                return false;
            }
            Map.Entry e = (Map.Entry)o;
            return this.key == (Long)e.getKey() && this.value == e.getValue();
        }

        public int hashCode() {
            return HashCommon.long2int(this.key) ^ System.identityHashCode(this.value);
        }

        public String toString() {
            return this.key + "->" + this.value;
        }
    }
}

