/*
 * Decompiled with CFR 0.152.
 */
package it.unimi.dsi.fastutil.io;

import it.unimi.dsi.fastutil.bytes.AbstractByteIterator;
import it.unimi.dsi.fastutil.bytes.ByteArrays;
import it.unimi.dsi.fastutil.bytes.ByteIterator;
import it.unimi.dsi.fastutil.doubles.AbstractDoubleIterator;
import it.unimi.dsi.fastutil.doubles.DoubleArrays;
import it.unimi.dsi.fastutil.doubles.DoubleIterator;
import it.unimi.dsi.fastutil.floats.AbstractFloatIterator;
import it.unimi.dsi.fastutil.floats.FloatArrays;
import it.unimi.dsi.fastutil.floats.FloatIterator;
import it.unimi.dsi.fastutil.ints.AbstractIntIterator;
import it.unimi.dsi.fastutil.ints.IntArrays;
import it.unimi.dsi.fastutil.ints.IntIterator;
import it.unimi.dsi.fastutil.io.FastBufferedOutputStream;
import it.unimi.dsi.fastutil.longs.AbstractLongIterator;
import it.unimi.dsi.fastutil.longs.LongArrays;
import it.unimi.dsi.fastutil.longs.LongIterator;
import it.unimi.dsi.fastutil.shorts.AbstractShortIterator;
import it.unimi.dsi.fastutil.shorts.ShortArrays;
import it.unimi.dsi.fastutil.shorts.ShortIterator;
import java.io.BufferedReader;
import java.io.EOFException;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.PrintStream;
import java.util.NoSuchElementException;

public class TextIO {
    public static final int BUFFER_SIZE = 65536;

    private TextIO() {
    }

    public static int loadBytes(BufferedReader reader, byte[] array, int offset, int length) throws IOException {
        ByteArrays.ensureOffsetLength(array, offset, length);
        int i = 0;
        try {
            String s;
            for (i = 0; i < length && (s = reader.readLine()) != null; ++i) {
                array[i + offset] = Byte.parseByte(s);
            }
        }
        catch (EOFException itsOk) {
            // empty catch block
        }
        return i;
    }

    public static int loadBytes(BufferedReader reader, byte[] array) throws IOException {
        return TextIO.loadBytes(reader, array, 0, array.length);
    }

    public static int loadBytes(CharSequence filename, byte[] array, int offset, int length) throws IOException {
        BufferedReader reader = new BufferedReader(new FileReader(((Object)filename).toString()), 65536);
        int result = TextIO.loadBytes(reader, array, offset, length);
        reader.close();
        return result;
    }

    public static int loadBytes(CharSequence filename, byte[] array) throws IOException {
        return TextIO.loadBytes(filename, array, 0, array.length);
    }

    public static void storeBytes(byte[] array, int offset, int length, PrintStream stream) throws IOException {
        ByteArrays.ensureOffsetLength(array, offset, length);
        for (int i = 0; i < length; ++i) {
            stream.println(array[offset + i]);
        }
    }

    public static void storeBytes(byte[] array, PrintStream stream) throws IOException {
        TextIO.storeBytes(array, 0, array.length, stream);
    }

    public static void storeBytes(byte[] array, int offset, int length, CharSequence filename) throws IOException {
        PrintStream stream = new PrintStream(new FastBufferedOutputStream(new FileOutputStream(((Object)filename).toString()), 65536));
        TextIO.storeBytes(array, offset, length, stream);
        stream.close();
    }

    public static void storeBytes(byte[] array, CharSequence filename) throws IOException {
        TextIO.storeBytes(array, 0, array.length, filename);
    }

    public static void storeBytes(ByteIterator i, PrintStream stream) throws IOException {
        while (i.hasNext()) {
            stream.println(i.nextByte());
        }
    }

    public static void storeBytes(ByteIterator i, CharSequence filename) throws IOException {
        PrintStream stream = new PrintStream(new FastBufferedOutputStream(new FileOutputStream(((Object)filename).toString()), 65536));
        TextIO.storeBytes(i, stream);
        stream.close();
    }

    public static ByteIterator asByteIterator(BufferedReader reader) throws IOException {
        return new ByteReaderWrapper(reader);
    }

    public static ByteIterator asByteIterator(CharSequence filename) throws IOException {
        return new ByteReaderWrapper(new BufferedReader(new FileReader(((Object)filename).toString())));
    }

    public static int loadShorts(BufferedReader reader, short[] array, int offset, int length) throws IOException {
        ShortArrays.ensureOffsetLength(array, offset, length);
        int i = 0;
        try {
            String s;
            for (i = 0; i < length && (s = reader.readLine()) != null; ++i) {
                array[i + offset] = Short.parseShort(s);
            }
        }
        catch (EOFException itsOk) {
            // empty catch block
        }
        return i;
    }

    public static int loadShorts(BufferedReader reader, short[] array) throws IOException {
        return TextIO.loadShorts(reader, array, 0, array.length);
    }

    public static int loadShorts(CharSequence filename, short[] array, int offset, int length) throws IOException {
        BufferedReader reader = new BufferedReader(new FileReader(((Object)filename).toString()), 65536);
        int result = TextIO.loadShorts(reader, array, offset, length);
        reader.close();
        return result;
    }

    public static int loadShorts(CharSequence filename, short[] array) throws IOException {
        return TextIO.loadShorts(filename, array, 0, array.length);
    }

    public static void storeShorts(short[] array, int offset, int length, PrintStream stream) throws IOException {
        ShortArrays.ensureOffsetLength(array, offset, length);
        for (int i = 0; i < length; ++i) {
            stream.println(array[offset + i]);
        }
    }

    public static void storeShorts(short[] array, PrintStream stream) throws IOException {
        TextIO.storeShorts(array, 0, array.length, stream);
    }

    public static void storeShorts(short[] array, int offset, int length, CharSequence filename) throws IOException {
        PrintStream stream = new PrintStream(new FastBufferedOutputStream(new FileOutputStream(((Object)filename).toString()), 65536));
        TextIO.storeShorts(array, offset, length, stream);
        stream.close();
    }

    public static void storeShorts(short[] array, CharSequence filename) throws IOException {
        TextIO.storeShorts(array, 0, array.length, filename);
    }

    public static void storeShorts(ShortIterator i, PrintStream stream) throws IOException {
        while (i.hasNext()) {
            stream.println(i.nextShort());
        }
    }

    public static void storeShorts(ShortIterator i, CharSequence filename) throws IOException {
        PrintStream stream = new PrintStream(new FastBufferedOutputStream(new FileOutputStream(((Object)filename).toString()), 65536));
        TextIO.storeShorts(i, stream);
        stream.close();
    }

    public static ShortIterator asShortIterator(BufferedReader reader) throws IOException {
        return new ShortReaderWrapper(reader);
    }

    public static ShortIterator asShortIterator(CharSequence filename) throws IOException {
        return new ShortReaderWrapper(new BufferedReader(new FileReader(((Object)filename).toString())));
    }

    public static int loadInts(BufferedReader reader, int[] array, int offset, int length) throws IOException {
        IntArrays.ensureOffsetLength(array, offset, length);
        int i = 0;
        try {
            String s;
            for (i = 0; i < length && (s = reader.readLine()) != null; ++i) {
                array[i + offset] = Integer.parseInt(s);
            }
        }
        catch (EOFException itsOk) {
            // empty catch block
        }
        return i;
    }

    public static int loadInts(BufferedReader reader, int[] array) throws IOException {
        return TextIO.loadInts(reader, array, 0, array.length);
    }

    public static int loadInts(CharSequence filename, int[] array, int offset, int length) throws IOException {
        BufferedReader reader = new BufferedReader(new FileReader(((Object)filename).toString()), 65536);
        int result = TextIO.loadInts(reader, array, offset, length);
        reader.close();
        return result;
    }

    public static int loadInts(CharSequence filename, int[] array) throws IOException {
        return TextIO.loadInts(filename, array, 0, array.length);
    }

    public static void storeInts(int[] array, int offset, int length, PrintStream stream) throws IOException {
        IntArrays.ensureOffsetLength(array, offset, length);
        for (int i = 0; i < length; ++i) {
            stream.println(array[offset + i]);
        }
    }

    public static void storeInts(int[] array, PrintStream stream) throws IOException {
        TextIO.storeInts(array, 0, array.length, stream);
    }

    public static void storeInts(int[] array, int offset, int length, CharSequence filename) throws IOException {
        PrintStream stream = new PrintStream(new FastBufferedOutputStream(new FileOutputStream(((Object)filename).toString()), 65536));
        TextIO.storeInts(array, offset, length, stream);
        stream.close();
    }

    public static void storeInts(int[] array, CharSequence filename) throws IOException {
        TextIO.storeInts(array, 0, array.length, filename);
    }

    public static void storeInts(IntIterator i, PrintStream stream) throws IOException {
        while (i.hasNext()) {
            stream.println(i.nextInt());
        }
    }

    public static void storeInts(IntIterator i, CharSequence filename) throws IOException {
        PrintStream stream = new PrintStream(new FastBufferedOutputStream(new FileOutputStream(((Object)filename).toString()), 65536));
        TextIO.storeInts(i, stream);
        stream.close();
    }

    public static IntIterator asIntIterator(BufferedReader reader) throws IOException {
        return new IntReaderWrapper(reader);
    }

    public static IntIterator asIntIterator(CharSequence filename) throws IOException {
        return new IntReaderWrapper(new BufferedReader(new FileReader(((Object)filename).toString())));
    }

    public static int loadLongs(BufferedReader reader, long[] array, int offset, int length) throws IOException {
        LongArrays.ensureOffsetLength(array, offset, length);
        int i = 0;
        try {
            String s;
            for (i = 0; i < length && (s = reader.readLine()) != null; ++i) {
                array[i + offset] = Long.parseLong(s);
            }
        }
        catch (EOFException itsOk) {
            // empty catch block
        }
        return i;
    }

    public static int loadLongs(BufferedReader reader, long[] array) throws IOException {
        return TextIO.loadLongs(reader, array, 0, array.length);
    }

    public static int loadLongs(CharSequence filename, long[] array, int offset, int length) throws IOException {
        BufferedReader reader = new BufferedReader(new FileReader(((Object)filename).toString()), 65536);
        int result = TextIO.loadLongs(reader, array, offset, length);
        reader.close();
        return result;
    }

    public static int loadLongs(CharSequence filename, long[] array) throws IOException {
        return TextIO.loadLongs(filename, array, 0, array.length);
    }

    public static void storeLongs(long[] array, int offset, int length, PrintStream stream) throws IOException {
        LongArrays.ensureOffsetLength(array, offset, length);
        for (int i = 0; i < length; ++i) {
            stream.println(array[offset + i]);
        }
    }

    public static void storeLongs(long[] array, PrintStream stream) throws IOException {
        TextIO.storeLongs(array, 0, array.length, stream);
    }

    public static void storeLongs(long[] array, int offset, int length, CharSequence filename) throws IOException {
        PrintStream stream = new PrintStream(new FastBufferedOutputStream(new FileOutputStream(((Object)filename).toString()), 65536));
        TextIO.storeLongs(array, offset, length, stream);
        stream.close();
    }

    public static void storeLongs(long[] array, CharSequence filename) throws IOException {
        TextIO.storeLongs(array, 0, array.length, filename);
    }

    public static void storeLongs(LongIterator i, PrintStream stream) throws IOException {
        while (i.hasNext()) {
            stream.println(i.nextLong());
        }
    }

    public static void storeLongs(LongIterator i, CharSequence filename) throws IOException {
        PrintStream stream = new PrintStream(new FastBufferedOutputStream(new FileOutputStream(((Object)filename).toString()), 65536));
        TextIO.storeLongs(i, stream);
        stream.close();
    }

    public static LongIterator asLongIterator(BufferedReader reader) throws IOException {
        return new LongReaderWrapper(reader);
    }

    public static LongIterator asLongIterator(CharSequence filename) throws IOException {
        return new LongReaderWrapper(new BufferedReader(new FileReader(((Object)filename).toString())));
    }

    public static int loadFloats(BufferedReader reader, float[] array, int offset, int length) throws IOException {
        FloatArrays.ensureOffsetLength(array, offset, length);
        int i = 0;
        try {
            String s;
            for (i = 0; i < length && (s = reader.readLine()) != null; ++i) {
                array[i + offset] = Float.parseFloat(s);
            }
        }
        catch (EOFException itsOk) {
            // empty catch block
        }
        return i;
    }

    public static int loadFloats(BufferedReader reader, float[] array) throws IOException {
        return TextIO.loadFloats(reader, array, 0, array.length);
    }

    public static int loadFloats(CharSequence filename, float[] array, int offset, int length) throws IOException {
        BufferedReader reader = new BufferedReader(new FileReader(((Object)filename).toString()), 65536);
        int result = TextIO.loadFloats(reader, array, offset, length);
        reader.close();
        return result;
    }

    public static int loadFloats(CharSequence filename, float[] array) throws IOException {
        return TextIO.loadFloats(filename, array, 0, array.length);
    }

    public static void storeFloats(float[] array, int offset, int length, PrintStream stream) throws IOException {
        FloatArrays.ensureOffsetLength(array, offset, length);
        for (int i = 0; i < length; ++i) {
            stream.println(array[offset + i]);
        }
    }

    public static void storeFloats(float[] array, PrintStream stream) throws IOException {
        TextIO.storeFloats(array, 0, array.length, stream);
    }

    public static void storeFloats(float[] array, int offset, int length, CharSequence filename) throws IOException {
        PrintStream stream = new PrintStream(new FastBufferedOutputStream(new FileOutputStream(((Object)filename).toString()), 65536));
        TextIO.storeFloats(array, offset, length, stream);
        stream.close();
    }

    public static void storeFloats(float[] array, CharSequence filename) throws IOException {
        TextIO.storeFloats(array, 0, array.length, filename);
    }

    public static void storeFloats(FloatIterator i, PrintStream stream) throws IOException {
        while (i.hasNext()) {
            stream.println(i.nextFloat());
        }
    }

    public static void storeFloats(FloatIterator i, CharSequence filename) throws IOException {
        PrintStream stream = new PrintStream(new FastBufferedOutputStream(new FileOutputStream(((Object)filename).toString()), 65536));
        TextIO.storeFloats(i, stream);
        stream.close();
    }

    public static FloatIterator asFloatIterator(BufferedReader reader) throws IOException {
        return new FloatReaderWrapper(reader);
    }

    public static FloatIterator asFloatIterator(CharSequence filename) throws IOException {
        return new FloatReaderWrapper(new BufferedReader(new FileReader(((Object)filename).toString())));
    }

    public static int loadDoubles(BufferedReader reader, double[] array, int offset, int length) throws IOException {
        DoubleArrays.ensureOffsetLength(array, offset, length);
        int i = 0;
        try {
            String s;
            for (i = 0; i < length && (s = reader.readLine()) != null; ++i) {
                array[i + offset] = Double.parseDouble(s);
            }
        }
        catch (EOFException itsOk) {
            // empty catch block
        }
        return i;
    }

    public static int loadDoubles(BufferedReader reader, double[] array) throws IOException {
        return TextIO.loadDoubles(reader, array, 0, array.length);
    }

    public static int loadDoubles(CharSequence filename, double[] array, int offset, int length) throws IOException {
        BufferedReader reader = new BufferedReader(new FileReader(((Object)filename).toString()), 65536);
        int result = TextIO.loadDoubles(reader, array, offset, length);
        reader.close();
        return result;
    }

    public static int loadDoubles(CharSequence filename, double[] array) throws IOException {
        return TextIO.loadDoubles(filename, array, 0, array.length);
    }

    public static void storeDoubles(double[] array, int offset, int length, PrintStream stream) throws IOException {
        DoubleArrays.ensureOffsetLength(array, offset, length);
        for (int i = 0; i < length; ++i) {
            stream.println(array[offset + i]);
        }
    }

    public static void storeDoubles(double[] array, PrintStream stream) throws IOException {
        TextIO.storeDoubles(array, 0, array.length, stream);
    }

    public static void storeDoubles(double[] array, int offset, int length, CharSequence filename) throws IOException {
        PrintStream stream = new PrintStream(new FastBufferedOutputStream(new FileOutputStream(((Object)filename).toString()), 65536));
        TextIO.storeDoubles(array, offset, length, stream);
        stream.close();
    }

    public static void storeDoubles(double[] array, CharSequence filename) throws IOException {
        TextIO.storeDoubles(array, 0, array.length, filename);
    }

    public static void storeDoubles(DoubleIterator i, PrintStream stream) throws IOException {
        while (i.hasNext()) {
            stream.println(i.nextDouble());
        }
    }

    public static void storeDoubles(DoubleIterator i, CharSequence filename) throws IOException {
        PrintStream stream = new PrintStream(new FastBufferedOutputStream(new FileOutputStream(((Object)filename).toString()), 65536));
        TextIO.storeDoubles(i, stream);
        stream.close();
    }

    public static DoubleIterator asDoubleIterator(BufferedReader reader) throws IOException {
        return new DoubleReaderWrapper(reader);
    }

    public static DoubleIterator asDoubleIterator(CharSequence filename) throws IOException {
        return new DoubleReaderWrapper(new BufferedReader(new FileReader(((Object)filename).toString())));
    }

    private static final class DoubleReaderWrapper
    extends AbstractDoubleIterator {
        private final BufferedReader reader;
        private boolean toAdvance = true;
        private String s;
        private double next;

        public DoubleReaderWrapper(BufferedReader reader) {
            this.reader = reader;
        }

        public boolean hasNext() {
            if (!this.toAdvance) {
                return this.s != null;
            }
            this.toAdvance = false;
            try {
                this.s = this.reader.readLine();
            }
            catch (EOFException itsOk) {
            }
            catch (IOException rethrow) {
                throw new RuntimeException(rethrow);
            }
            if (this.s == null) {
                return false;
            }
            this.next = Double.parseDouble(this.s);
            return true;
        }

        public double nextDouble() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            this.toAdvance = true;
            return this.next;
        }
    }

    private static final class FloatReaderWrapper
    extends AbstractFloatIterator {
        private final BufferedReader reader;
        private boolean toAdvance = true;
        private String s;
        private float next;

        public FloatReaderWrapper(BufferedReader reader) {
            this.reader = reader;
        }

        public boolean hasNext() {
            if (!this.toAdvance) {
                return this.s != null;
            }
            this.toAdvance = false;
            try {
                this.s = this.reader.readLine();
            }
            catch (EOFException itsOk) {
            }
            catch (IOException rethrow) {
                throw new RuntimeException(rethrow);
            }
            if (this.s == null) {
                return false;
            }
            this.next = Float.parseFloat(this.s);
            return true;
        }

        public float nextFloat() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            this.toAdvance = true;
            return this.next;
        }
    }

    private static final class LongReaderWrapper
    extends AbstractLongIterator {
        private final BufferedReader reader;
        private boolean toAdvance = true;
        private String s;
        private long next;

        public LongReaderWrapper(BufferedReader reader) {
            this.reader = reader;
        }

        public boolean hasNext() {
            if (!this.toAdvance) {
                return this.s != null;
            }
            this.toAdvance = false;
            try {
                this.s = this.reader.readLine();
            }
            catch (EOFException itsOk) {
            }
            catch (IOException rethrow) {
                throw new RuntimeException(rethrow);
            }
            if (this.s == null) {
                return false;
            }
            this.next = Long.parseLong(this.s);
            return true;
        }

        public long nextLong() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            this.toAdvance = true;
            return this.next;
        }
    }

    private static final class IntReaderWrapper
    extends AbstractIntIterator {
        private final BufferedReader reader;
        private boolean toAdvance = true;
        private String s;
        private int next;

        public IntReaderWrapper(BufferedReader reader) {
            this.reader = reader;
        }

        public boolean hasNext() {
            if (!this.toAdvance) {
                return this.s != null;
            }
            this.toAdvance = false;
            try {
                this.s = this.reader.readLine();
            }
            catch (EOFException itsOk) {
            }
            catch (IOException rethrow) {
                throw new RuntimeException(rethrow);
            }
            if (this.s == null) {
                return false;
            }
            this.next = Integer.parseInt(this.s);
            return true;
        }

        public int nextInt() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            this.toAdvance = true;
            return this.next;
        }
    }

    private static final class ShortReaderWrapper
    extends AbstractShortIterator {
        private final BufferedReader reader;
        private boolean toAdvance = true;
        private String s;
        private short next;

        public ShortReaderWrapper(BufferedReader reader) {
            this.reader = reader;
        }

        public boolean hasNext() {
            if (!this.toAdvance) {
                return this.s != null;
            }
            this.toAdvance = false;
            try {
                this.s = this.reader.readLine();
            }
            catch (EOFException itsOk) {
            }
            catch (IOException rethrow) {
                throw new RuntimeException(rethrow);
            }
            if (this.s == null) {
                return false;
            }
            this.next = Short.parseShort(this.s);
            return true;
        }

        public short nextShort() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            this.toAdvance = true;
            return this.next;
        }
    }

    private static final class ByteReaderWrapper
    extends AbstractByteIterator {
        private final BufferedReader reader;
        private boolean toAdvance = true;
        private String s;
        private byte next;

        public ByteReaderWrapper(BufferedReader reader) {
            this.reader = reader;
        }

        public boolean hasNext() {
            if (!this.toAdvance) {
                return this.s != null;
            }
            this.toAdvance = false;
            try {
                this.s = this.reader.readLine();
            }
            catch (EOFException itsOk) {
            }
            catch (IOException rethrow) {
                throw new RuntimeException(rethrow);
            }
            if (this.s == null) {
                return false;
            }
            this.next = Byte.parseByte(this.s);
            return true;
        }

        public byte nextByte() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            this.toAdvance = true;
            return this.next;
        }
    }
}

