/*
 * Decompiled with CFR 0.152.
 */
package it.unimi.dsi.fastutil.io;

import it.unimi.dsi.fastutil.bytes.AbstractByteIterator;
import it.unimi.dsi.fastutil.bytes.ByteArrays;
import it.unimi.dsi.fastutil.bytes.ByteIterator;
import it.unimi.dsi.fastutil.chars.AbstractCharIterator;
import it.unimi.dsi.fastutil.chars.CharArrays;
import it.unimi.dsi.fastutil.chars.CharIterator;
import it.unimi.dsi.fastutil.doubles.AbstractDoubleIterator;
import it.unimi.dsi.fastutil.doubles.DoubleArrays;
import it.unimi.dsi.fastutil.doubles.DoubleIterator;
import it.unimi.dsi.fastutil.floats.AbstractFloatIterator;
import it.unimi.dsi.fastutil.floats.FloatArrays;
import it.unimi.dsi.fastutil.floats.FloatIterator;
import it.unimi.dsi.fastutil.ints.AbstractIntIterator;
import it.unimi.dsi.fastutil.ints.IntArrays;
import it.unimi.dsi.fastutil.ints.IntIterator;
import it.unimi.dsi.fastutil.io.FastBufferedInputStream;
import it.unimi.dsi.fastutil.io.FastBufferedOutputStream;
import it.unimi.dsi.fastutil.longs.AbstractLongIterator;
import it.unimi.dsi.fastutil.longs.LongArrays;
import it.unimi.dsi.fastutil.longs.LongIterator;
import it.unimi.dsi.fastutil.shorts.AbstractShortIterator;
import it.unimi.dsi.fastutil.shorts.ShortArrays;
import it.unimi.dsi.fastutil.shorts.ShortIterator;
import java.io.DataInput;
import java.io.DataInputStream;
import java.io.DataOutput;
import java.io.DataOutputStream;
import java.io.EOFException;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.NoSuchElementException;

public class BinIO {
    public static final int BUFFER_SIZE = 65536;

    private BinIO() {
    }

    public static void storeObject(Object o, CharSequence filename) throws FileNotFoundException, IOException {
        ObjectOutputStream oos = new ObjectOutputStream(new FastBufferedOutputStream(new FileOutputStream(((Object)filename).toString()), 65536));
        oos.writeObject(o);
        oos.close();
    }

    public static Object loadObject(CharSequence filename) throws IOException, ClassNotFoundException {
        ObjectInputStream ois = new ObjectInputStream(new FastBufferedInputStream(new FileInputStream(((Object)filename).toString()), 65536));
        Object result = ois.readObject();
        ois.close();
        return result;
    }

    public static int loadBytes(DataInput dataInput, byte[] array, int offset, int length) throws IOException {
        ByteArrays.ensureOffsetLength(array, offset, length);
        int i = 0;
        try {
            for (i = 0; i < length; ++i) {
                array[i + offset] = dataInput.readByte();
            }
        }
        catch (EOFException itsOk) {
            // empty catch block
        }
        return i;
    }

    public static int loadBytes(DataInput dataInput, byte[] array) throws IOException {
        int i = 0;
        try {
            int length = array.length;
            for (i = 0; i < length; ++i) {
                array[i] = dataInput.readByte();
            }
        }
        catch (EOFException eOFException) {
            // empty catch block
        }
        return i;
    }

    public static int loadBytes(CharSequence filename, byte[] array, int offset, int length) throws IOException {
        ByteArrays.ensureOffsetLength(array, offset, length);
        FileInputStream fis = new FileInputStream(((Object)filename).toString());
        DataInputStream dis = new DataInputStream(new FastBufferedInputStream(fis, 65536));
        int i = 0;
        try {
            for (i = 0; i < length; ++i) {
                array[i + offset] = dis.readByte();
            }
        }
        catch (EOFException itsOk) {
            // empty catch block
        }
        dis.close();
        return i;
    }

    public static int loadBytes(CharSequence filename, byte[] array) throws IOException {
        FileInputStream fis = new FileInputStream(((Object)filename).toString());
        DataInputStream dis = new DataInputStream(new FastBufferedInputStream(fis, 65536));
        int i = 0;
        try {
            int length = array.length;
            for (i = 0; i < length; ++i) {
                array[i] = dis.readByte();
            }
        }
        catch (EOFException itsOk) {
            // empty catch block
        }
        dis.close();
        return i;
    }

    public static byte[] loadBytes(CharSequence filename) throws IOException {
        FileInputStream fis = new FileInputStream(((Object)filename).toString());
        DataInputStream dis = new DataInputStream(new FastBufferedInputStream(fis, 65536));
        int length = (int)(fis.getChannel().size() / 1L);
        byte[] array = new byte[length];
        for (int i = 0; i < length; ++i) {
            array[i] = dis.readByte();
        }
        dis.close();
        return array;
    }

    public static void storeBytes(byte[] array, int offset, int length, DataOutput dataOutput) throws IOException {
        ByteArrays.ensureOffsetLength(array, offset, length);
        for (int i = 0; i < length; ++i) {
            dataOutput.writeByte(array[offset + i]);
        }
    }

    public static void storeBytes(byte[] array, DataOutput dataOutput) throws IOException {
        int length = array.length;
        for (int i = 0; i < length; ++i) {
            dataOutput.writeByte(array[i]);
        }
    }

    public static void storeBytes(byte[] array, int offset, int length, CharSequence filename) throws IOException {
        ByteArrays.ensureOffsetLength(array, offset, length);
        DataOutputStream dos = new DataOutputStream(new FastBufferedOutputStream(new FileOutputStream(((Object)filename).toString()), 65536));
        for (int i = 0; i < length; ++i) {
            dos.writeByte(array[offset + i]);
        }
        dos.close();
    }

    public static void storeBytes(byte[] array, CharSequence filename) throws IOException {
        DataOutputStream dos = new DataOutputStream(new FastBufferedOutputStream(new FileOutputStream(((Object)filename).toString()), 65536));
        int length = array.length;
        for (int i = 0; i < length; ++i) {
            dos.writeByte(array[i]);
        }
        dos.close();
    }

    public static void storeBytes(ByteIterator i, DataOutput dataOutput) throws IOException {
        while (i.hasNext()) {
            dataOutput.writeByte(i.nextByte());
        }
    }

    public static void storeBytes(ByteIterator i, CharSequence filename) throws IOException {
        DataOutputStream dos = new DataOutputStream(new FastBufferedOutputStream(new FileOutputStream(((Object)filename).toString()), 65536));
        while (i.hasNext()) {
            dos.writeByte(i.nextByte());
        }
        dos.close();
    }

    public static ByteIterator asByteIterator(DataInputStream stream) throws IOException {
        return new ByteStreamWrapper(stream);
    }

    public static ByteIterator asByteIterator(CharSequence filename) throws IOException {
        return new ByteStreamWrapper(new DataInputStream(new FastBufferedInputStream(new FileInputStream(((Object)filename).toString()))));
    }

    public static int loadShorts(DataInput dataInput, short[] array, int offset, int length) throws IOException {
        ShortArrays.ensureOffsetLength(array, offset, length);
        int i = 0;
        try {
            for (i = 0; i < length; ++i) {
                array[i + offset] = dataInput.readShort();
            }
        }
        catch (EOFException itsOk) {
            // empty catch block
        }
        return i;
    }

    public static int loadShorts(DataInput dataInput, short[] array) throws IOException {
        int i = 0;
        try {
            int length = array.length;
            for (i = 0; i < length; ++i) {
                array[i] = dataInput.readShort();
            }
        }
        catch (EOFException eOFException) {
            // empty catch block
        }
        return i;
    }

    public static int loadShorts(CharSequence filename, short[] array, int offset, int length) throws IOException {
        ShortArrays.ensureOffsetLength(array, offset, length);
        FileInputStream fis = new FileInputStream(((Object)filename).toString());
        DataInputStream dis = new DataInputStream(new FastBufferedInputStream(fis, 65536));
        int i = 0;
        try {
            for (i = 0; i < length; ++i) {
                array[i + offset] = dis.readShort();
            }
        }
        catch (EOFException itsOk) {
            // empty catch block
        }
        dis.close();
        return i;
    }

    public static int loadShorts(CharSequence filename, short[] array) throws IOException {
        FileInputStream fis = new FileInputStream(((Object)filename).toString());
        DataInputStream dis = new DataInputStream(new FastBufferedInputStream(fis, 65536));
        int i = 0;
        try {
            int length = array.length;
            for (i = 0; i < length; ++i) {
                array[i] = dis.readShort();
            }
        }
        catch (EOFException itsOk) {
            // empty catch block
        }
        dis.close();
        return i;
    }

    public static short[] loadShorts(CharSequence filename) throws IOException {
        FileInputStream fis = new FileInputStream(((Object)filename).toString());
        DataInputStream dis = new DataInputStream(new FastBufferedInputStream(fis, 65536));
        int length = (int)(fis.getChannel().size() / 2L);
        short[] array = new short[length];
        for (int i = 0; i < length; ++i) {
            array[i] = dis.readShort();
        }
        dis.close();
        return array;
    }

    public static void storeShorts(short[] array, int offset, int length, DataOutput dataOutput) throws IOException {
        ShortArrays.ensureOffsetLength(array, offset, length);
        for (int i = 0; i < length; ++i) {
            dataOutput.writeShort(array[offset + i]);
        }
    }

    public static void storeShorts(short[] array, DataOutput dataOutput) throws IOException {
        int length = array.length;
        for (int i = 0; i < length; ++i) {
            dataOutput.writeShort(array[i]);
        }
    }

    public static void storeShorts(short[] array, int offset, int length, CharSequence filename) throws IOException {
        ShortArrays.ensureOffsetLength(array, offset, length);
        DataOutputStream dos = new DataOutputStream(new FastBufferedOutputStream(new FileOutputStream(((Object)filename).toString()), 65536));
        for (int i = 0; i < length; ++i) {
            dos.writeShort(array[offset + i]);
        }
        dos.close();
    }

    public static void storeShorts(short[] array, CharSequence filename) throws IOException {
        DataOutputStream dos = new DataOutputStream(new FastBufferedOutputStream(new FileOutputStream(((Object)filename).toString()), 65536));
        int length = array.length;
        for (int i = 0; i < length; ++i) {
            dos.writeShort(array[i]);
        }
        dos.close();
    }

    public static void storeShorts(ShortIterator i, DataOutput dataOutput) throws IOException {
        while (i.hasNext()) {
            dataOutput.writeShort(i.nextShort());
        }
    }

    public static void storeShorts(ShortIterator i, CharSequence filename) throws IOException {
        DataOutputStream dos = new DataOutputStream(new FastBufferedOutputStream(new FileOutputStream(((Object)filename).toString()), 65536));
        while (i.hasNext()) {
            dos.writeShort(i.nextShort());
        }
        dos.close();
    }

    public static ShortIterator asShortIterator(DataInputStream stream) throws IOException {
        return new ShortStreamWrapper(stream);
    }

    public static ShortIterator asShortIterator(CharSequence filename) throws IOException {
        return new ShortStreamWrapper(new DataInputStream(new FastBufferedInputStream(new FileInputStream(((Object)filename).toString()))));
    }

    public static int loadChars(DataInput dataInput, char[] array, int offset, int length) throws IOException {
        CharArrays.ensureOffsetLength(array, offset, length);
        int i = 0;
        try {
            for (i = 0; i < length; ++i) {
                array[i + offset] = dataInput.readChar();
            }
        }
        catch (EOFException itsOk) {
            // empty catch block
        }
        return i;
    }

    public static int loadChars(DataInput dataInput, char[] array) throws IOException {
        int i = 0;
        try {
            int length = array.length;
            for (i = 0; i < length; ++i) {
                array[i] = dataInput.readChar();
            }
        }
        catch (EOFException eOFException) {
            // empty catch block
        }
        return i;
    }

    public static int loadChars(CharSequence filename, char[] array, int offset, int length) throws IOException {
        CharArrays.ensureOffsetLength(array, offset, length);
        FileInputStream fis = new FileInputStream(((Object)filename).toString());
        DataInputStream dis = new DataInputStream(new FastBufferedInputStream(fis, 65536));
        int i = 0;
        try {
            for (i = 0; i < length; ++i) {
                array[i + offset] = dis.readChar();
            }
        }
        catch (EOFException itsOk) {
            // empty catch block
        }
        dis.close();
        return i;
    }

    public static int loadChars(CharSequence filename, char[] array) throws IOException {
        FileInputStream fis = new FileInputStream(((Object)filename).toString());
        DataInputStream dis = new DataInputStream(new FastBufferedInputStream(fis, 65536));
        int i = 0;
        try {
            int length = array.length;
            for (i = 0; i < length; ++i) {
                array[i] = dis.readChar();
            }
        }
        catch (EOFException itsOk) {
            // empty catch block
        }
        dis.close();
        return i;
    }

    public static char[] loadChars(CharSequence filename) throws IOException {
        FileInputStream fis = new FileInputStream(((Object)filename).toString());
        DataInputStream dis = new DataInputStream(new FastBufferedInputStream(fis, 65536));
        int length = (int)(fis.getChannel().size() / 2L);
        char[] array = new char[length];
        for (int i = 0; i < length; ++i) {
            array[i] = dis.readChar();
        }
        dis.close();
        return array;
    }

    public static void storeChars(char[] array, int offset, int length, DataOutput dataOutput) throws IOException {
        CharArrays.ensureOffsetLength(array, offset, length);
        for (int i = 0; i < length; ++i) {
            dataOutput.writeChar(array[offset + i]);
        }
    }

    public static void storeChars(char[] array, DataOutput dataOutput) throws IOException {
        int length = array.length;
        for (int i = 0; i < length; ++i) {
            dataOutput.writeChar(array[i]);
        }
    }

    public static void storeChars(char[] array, int offset, int length, CharSequence filename) throws IOException {
        CharArrays.ensureOffsetLength(array, offset, length);
        DataOutputStream dos = new DataOutputStream(new FastBufferedOutputStream(new FileOutputStream(((Object)filename).toString()), 65536));
        for (int i = 0; i < length; ++i) {
            dos.writeChar(array[offset + i]);
        }
        dos.close();
    }

    public static void storeChars(char[] array, CharSequence filename) throws IOException {
        DataOutputStream dos = new DataOutputStream(new FastBufferedOutputStream(new FileOutputStream(((Object)filename).toString()), 65536));
        int length = array.length;
        for (int i = 0; i < length; ++i) {
            dos.writeChar(array[i]);
        }
        dos.close();
    }

    public static void storeChars(CharIterator i, DataOutput dataOutput) throws IOException {
        while (i.hasNext()) {
            dataOutput.writeChar(i.nextChar());
        }
    }

    public static void storeChars(CharIterator i, CharSequence filename) throws IOException {
        DataOutputStream dos = new DataOutputStream(new FastBufferedOutputStream(new FileOutputStream(((Object)filename).toString()), 65536));
        while (i.hasNext()) {
            dos.writeChar(i.nextChar());
        }
        dos.close();
    }

    public static CharIterator asCharIterator(DataInputStream stream) throws IOException {
        return new CharStreamWrapper(stream);
    }

    public static CharIterator asCharIterator(CharSequence filename) throws IOException {
        return new CharStreamWrapper(new DataInputStream(new FastBufferedInputStream(new FileInputStream(((Object)filename).toString()))));
    }

    public static int loadInts(DataInput dataInput, int[] array, int offset, int length) throws IOException {
        IntArrays.ensureOffsetLength(array, offset, length);
        int i = 0;
        try {
            for (i = 0; i < length; ++i) {
                array[i + offset] = dataInput.readInt();
            }
        }
        catch (EOFException itsOk) {
            // empty catch block
        }
        return i;
    }

    public static int loadInts(DataInput dataInput, int[] array) throws IOException {
        int i = 0;
        try {
            int length = array.length;
            for (i = 0; i < length; ++i) {
                array[i] = dataInput.readInt();
            }
        }
        catch (EOFException eOFException) {
            // empty catch block
        }
        return i;
    }

    public static int loadInts(CharSequence filename, int[] array, int offset, int length) throws IOException {
        IntArrays.ensureOffsetLength(array, offset, length);
        FileInputStream fis = new FileInputStream(((Object)filename).toString());
        DataInputStream dis = new DataInputStream(new FastBufferedInputStream(fis, 65536));
        int i = 0;
        try {
            for (i = 0; i < length; ++i) {
                array[i + offset] = dis.readInt();
            }
        }
        catch (EOFException itsOk) {
            // empty catch block
        }
        dis.close();
        return i;
    }

    public static int loadInts(CharSequence filename, int[] array) throws IOException {
        FileInputStream fis = new FileInputStream(((Object)filename).toString());
        DataInputStream dis = new DataInputStream(new FastBufferedInputStream(fis, 65536));
        int i = 0;
        try {
            int length = array.length;
            for (i = 0; i < length; ++i) {
                array[i] = dis.readInt();
            }
        }
        catch (EOFException itsOk) {
            // empty catch block
        }
        dis.close();
        return i;
    }

    public static int[] loadInts(CharSequence filename) throws IOException {
        FileInputStream fis = new FileInputStream(((Object)filename).toString());
        DataInputStream dis = new DataInputStream(new FastBufferedInputStream(fis, 65536));
        int length = (int)(fis.getChannel().size() / 4L);
        int[] array = new int[length];
        for (int i = 0; i < length; ++i) {
            array[i] = dis.readInt();
        }
        dis.close();
        return array;
    }

    public static void storeInts(int[] array, int offset, int length, DataOutput dataOutput) throws IOException {
        IntArrays.ensureOffsetLength(array, offset, length);
        for (int i = 0; i < length; ++i) {
            dataOutput.writeInt(array[offset + i]);
        }
    }

    public static void storeInts(int[] array, DataOutput dataOutput) throws IOException {
        int length = array.length;
        for (int i = 0; i < length; ++i) {
            dataOutput.writeInt(array[i]);
        }
    }

    public static void storeInts(int[] array, int offset, int length, CharSequence filename) throws IOException {
        IntArrays.ensureOffsetLength(array, offset, length);
        DataOutputStream dos = new DataOutputStream(new FastBufferedOutputStream(new FileOutputStream(((Object)filename).toString()), 65536));
        for (int i = 0; i < length; ++i) {
            dos.writeInt(array[offset + i]);
        }
        dos.close();
    }

    public static void storeInts(int[] array, CharSequence filename) throws IOException {
        DataOutputStream dos = new DataOutputStream(new FastBufferedOutputStream(new FileOutputStream(((Object)filename).toString()), 65536));
        int length = array.length;
        for (int i = 0; i < length; ++i) {
            dos.writeInt(array[i]);
        }
        dos.close();
    }

    public static void storeInts(IntIterator i, DataOutput dataOutput) throws IOException {
        while (i.hasNext()) {
            dataOutput.writeInt(i.nextInt());
        }
    }

    public static void storeInts(IntIterator i, CharSequence filename) throws IOException {
        DataOutputStream dos = new DataOutputStream(new FastBufferedOutputStream(new FileOutputStream(((Object)filename).toString()), 65536));
        while (i.hasNext()) {
            dos.writeInt(i.nextInt());
        }
        dos.close();
    }

    public static IntIterator asIntIterator(DataInputStream stream) throws IOException {
        return new IntStreamWrapper(stream);
    }

    public static IntIterator asIntIterator(CharSequence filename) throws IOException {
        return new IntStreamWrapper(new DataInputStream(new FastBufferedInputStream(new FileInputStream(((Object)filename).toString()))));
    }

    public static int loadLongs(DataInput dataInput, long[] array, int offset, int length) throws IOException {
        LongArrays.ensureOffsetLength(array, offset, length);
        int i = 0;
        try {
            for (i = 0; i < length; ++i) {
                array[i + offset] = dataInput.readLong();
            }
        }
        catch (EOFException itsOk) {
            // empty catch block
        }
        return i;
    }

    public static int loadLongs(DataInput dataInput, long[] array) throws IOException {
        int i = 0;
        try {
            int length = array.length;
            for (i = 0; i < length; ++i) {
                array[i] = dataInput.readLong();
            }
        }
        catch (EOFException eOFException) {
            // empty catch block
        }
        return i;
    }

    public static int loadLongs(CharSequence filename, long[] array, int offset, int length) throws IOException {
        LongArrays.ensureOffsetLength(array, offset, length);
        FileInputStream fis = new FileInputStream(((Object)filename).toString());
        DataInputStream dis = new DataInputStream(new FastBufferedInputStream(fis, 65536));
        int i = 0;
        try {
            for (i = 0; i < length; ++i) {
                array[i + offset] = dis.readLong();
            }
        }
        catch (EOFException itsOk) {
            // empty catch block
        }
        dis.close();
        return i;
    }

    public static int loadLongs(CharSequence filename, long[] array) throws IOException {
        FileInputStream fis = new FileInputStream(((Object)filename).toString());
        DataInputStream dis = new DataInputStream(new FastBufferedInputStream(fis, 65536));
        int i = 0;
        try {
            int length = array.length;
            for (i = 0; i < length; ++i) {
                array[i] = dis.readLong();
            }
        }
        catch (EOFException itsOk) {
            // empty catch block
        }
        dis.close();
        return i;
    }

    public static long[] loadLongs(CharSequence filename) throws IOException {
        FileInputStream fis = new FileInputStream(((Object)filename).toString());
        DataInputStream dis = new DataInputStream(new FastBufferedInputStream(fis, 65536));
        int length = (int)(fis.getChannel().size() / 8L);
        long[] array = new long[length];
        for (int i = 0; i < length; ++i) {
            array[i] = dis.readLong();
        }
        dis.close();
        return array;
    }

    public static void storeLongs(long[] array, int offset, int length, DataOutput dataOutput) throws IOException {
        LongArrays.ensureOffsetLength(array, offset, length);
        for (int i = 0; i < length; ++i) {
            dataOutput.writeLong(array[offset + i]);
        }
    }

    public static void storeLongs(long[] array, DataOutput dataOutput) throws IOException {
        int length = array.length;
        for (int i = 0; i < length; ++i) {
            dataOutput.writeLong(array[i]);
        }
    }

    public static void storeLongs(long[] array, int offset, int length, CharSequence filename) throws IOException {
        LongArrays.ensureOffsetLength(array, offset, length);
        DataOutputStream dos = new DataOutputStream(new FastBufferedOutputStream(new FileOutputStream(((Object)filename).toString()), 65536));
        for (int i = 0; i < length; ++i) {
            dos.writeLong(array[offset + i]);
        }
        dos.close();
    }

    public static void storeLongs(long[] array, CharSequence filename) throws IOException {
        DataOutputStream dos = new DataOutputStream(new FastBufferedOutputStream(new FileOutputStream(((Object)filename).toString()), 65536));
        int length = array.length;
        for (int i = 0; i < length; ++i) {
            dos.writeLong(array[i]);
        }
        dos.close();
    }

    public static void storeLongs(LongIterator i, DataOutput dataOutput) throws IOException {
        while (i.hasNext()) {
            dataOutput.writeLong(i.nextLong());
        }
    }

    public static void storeLongs(LongIterator i, CharSequence filename) throws IOException {
        DataOutputStream dos = new DataOutputStream(new FastBufferedOutputStream(new FileOutputStream(((Object)filename).toString()), 65536));
        while (i.hasNext()) {
            dos.writeLong(i.nextLong());
        }
        dos.close();
    }

    public static LongIterator asLongIterator(DataInputStream stream) throws IOException {
        return new LongStreamWrapper(stream);
    }

    public static LongIterator asLongIterator(CharSequence filename) throws IOException {
        return new LongStreamWrapper(new DataInputStream(new FastBufferedInputStream(new FileInputStream(((Object)filename).toString()))));
    }

    public static int loadFloats(DataInput dataInput, float[] array, int offset, int length) throws IOException {
        FloatArrays.ensureOffsetLength(array, offset, length);
        int i = 0;
        try {
            for (i = 0; i < length; ++i) {
                array[i + offset] = dataInput.readFloat();
            }
        }
        catch (EOFException itsOk) {
            // empty catch block
        }
        return i;
    }

    public static int loadFloats(DataInput dataInput, float[] array) throws IOException {
        int i = 0;
        try {
            int length = array.length;
            for (i = 0; i < length; ++i) {
                array[i] = dataInput.readFloat();
            }
        }
        catch (EOFException eOFException) {
            // empty catch block
        }
        return i;
    }

    public static int loadFloats(CharSequence filename, float[] array, int offset, int length) throws IOException {
        FloatArrays.ensureOffsetLength(array, offset, length);
        FileInputStream fis = new FileInputStream(((Object)filename).toString());
        DataInputStream dis = new DataInputStream(new FastBufferedInputStream(fis, 65536));
        int i = 0;
        try {
            for (i = 0; i < length; ++i) {
                array[i + offset] = dis.readFloat();
            }
        }
        catch (EOFException itsOk) {
            // empty catch block
        }
        dis.close();
        return i;
    }

    public static int loadFloats(CharSequence filename, float[] array) throws IOException {
        FileInputStream fis = new FileInputStream(((Object)filename).toString());
        DataInputStream dis = new DataInputStream(new FastBufferedInputStream(fis, 65536));
        int i = 0;
        try {
            int length = array.length;
            for (i = 0; i < length; ++i) {
                array[i] = dis.readFloat();
            }
        }
        catch (EOFException itsOk) {
            // empty catch block
        }
        dis.close();
        return i;
    }

    public static float[] loadFloats(CharSequence filename) throws IOException {
        FileInputStream fis = new FileInputStream(((Object)filename).toString());
        DataInputStream dis = new DataInputStream(new FastBufferedInputStream(fis, 65536));
        int length = (int)(fis.getChannel().size() / 4L);
        float[] array = new float[length];
        for (int i = 0; i < length; ++i) {
            array[i] = dis.readFloat();
        }
        dis.close();
        return array;
    }

    public static void storeFloats(float[] array, int offset, int length, DataOutput dataOutput) throws IOException {
        FloatArrays.ensureOffsetLength(array, offset, length);
        for (int i = 0; i < length; ++i) {
            dataOutput.writeFloat(array[offset + i]);
        }
    }

    public static void storeFloats(float[] array, DataOutput dataOutput) throws IOException {
        int length = array.length;
        for (int i = 0; i < length; ++i) {
            dataOutput.writeFloat(array[i]);
        }
    }

    public static void storeFloats(float[] array, int offset, int length, CharSequence filename) throws IOException {
        FloatArrays.ensureOffsetLength(array, offset, length);
        DataOutputStream dos = new DataOutputStream(new FastBufferedOutputStream(new FileOutputStream(((Object)filename).toString()), 65536));
        for (int i = 0; i < length; ++i) {
            dos.writeFloat(array[offset + i]);
        }
        dos.close();
    }

    public static void storeFloats(float[] array, CharSequence filename) throws IOException {
        DataOutputStream dos = new DataOutputStream(new FastBufferedOutputStream(new FileOutputStream(((Object)filename).toString()), 65536));
        int length = array.length;
        for (int i = 0; i < length; ++i) {
            dos.writeFloat(array[i]);
        }
        dos.close();
    }

    public static void storeFloats(FloatIterator i, DataOutput dataOutput) throws IOException {
        while (i.hasNext()) {
            dataOutput.writeFloat(i.nextFloat());
        }
    }

    public static void storeFloats(FloatIterator i, CharSequence filename) throws IOException {
        DataOutputStream dos = new DataOutputStream(new FastBufferedOutputStream(new FileOutputStream(((Object)filename).toString()), 65536));
        while (i.hasNext()) {
            dos.writeFloat(i.nextFloat());
        }
        dos.close();
    }

    public static FloatIterator asFloatIterator(DataInputStream stream) throws IOException {
        return new FloatStreamWrapper(stream);
    }

    public static FloatIterator asFloatIterator(CharSequence filename) throws IOException {
        return new FloatStreamWrapper(new DataInputStream(new FastBufferedInputStream(new FileInputStream(((Object)filename).toString()))));
    }

    public static int loadDoubles(DataInput dataInput, double[] array, int offset, int length) throws IOException {
        DoubleArrays.ensureOffsetLength(array, offset, length);
        int i = 0;
        try {
            for (i = 0; i < length; ++i) {
                array[i + offset] = dataInput.readDouble();
            }
        }
        catch (EOFException itsOk) {
            // empty catch block
        }
        return i;
    }

    public static int loadDoubles(DataInput dataInput, double[] array) throws IOException {
        int i = 0;
        try {
            int length = array.length;
            for (i = 0; i < length; ++i) {
                array[i] = dataInput.readDouble();
            }
        }
        catch (EOFException eOFException) {
            // empty catch block
        }
        return i;
    }

    public static int loadDoubles(CharSequence filename, double[] array, int offset, int length) throws IOException {
        DoubleArrays.ensureOffsetLength(array, offset, length);
        FileInputStream fis = new FileInputStream(((Object)filename).toString());
        DataInputStream dis = new DataInputStream(new FastBufferedInputStream(fis, 65536));
        int i = 0;
        try {
            for (i = 0; i < length; ++i) {
                array[i + offset] = dis.readDouble();
            }
        }
        catch (EOFException itsOk) {
            // empty catch block
        }
        dis.close();
        return i;
    }

    public static int loadDoubles(CharSequence filename, double[] array) throws IOException {
        FileInputStream fis = new FileInputStream(((Object)filename).toString());
        DataInputStream dis = new DataInputStream(new FastBufferedInputStream(fis, 65536));
        int i = 0;
        try {
            int length = array.length;
            for (i = 0; i < length; ++i) {
                array[i] = dis.readDouble();
            }
        }
        catch (EOFException itsOk) {
            // empty catch block
        }
        dis.close();
        return i;
    }

    public static double[] loadDoubles(CharSequence filename) throws IOException {
        FileInputStream fis = new FileInputStream(((Object)filename).toString());
        DataInputStream dis = new DataInputStream(new FastBufferedInputStream(fis, 65536));
        int length = (int)(fis.getChannel().size() / 8L);
        double[] array = new double[length];
        for (int i = 0; i < length; ++i) {
            array[i] = dis.readDouble();
        }
        dis.close();
        return array;
    }

    public static void storeDoubles(double[] array, int offset, int length, DataOutput dataOutput) throws IOException {
        DoubleArrays.ensureOffsetLength(array, offset, length);
        for (int i = 0; i < length; ++i) {
            dataOutput.writeDouble(array[offset + i]);
        }
    }

    public static void storeDoubles(double[] array, DataOutput dataOutput) throws IOException {
        int length = array.length;
        for (int i = 0; i < length; ++i) {
            dataOutput.writeDouble(array[i]);
        }
    }

    public static void storeDoubles(double[] array, int offset, int length, CharSequence filename) throws IOException {
        DoubleArrays.ensureOffsetLength(array, offset, length);
        DataOutputStream dos = new DataOutputStream(new FastBufferedOutputStream(new FileOutputStream(((Object)filename).toString()), 65536));
        for (int i = 0; i < length; ++i) {
            dos.writeDouble(array[offset + i]);
        }
        dos.close();
    }

    public static void storeDoubles(double[] array, CharSequence filename) throws IOException {
        DataOutputStream dos = new DataOutputStream(new FastBufferedOutputStream(new FileOutputStream(((Object)filename).toString()), 65536));
        int length = array.length;
        for (int i = 0; i < length; ++i) {
            dos.writeDouble(array[i]);
        }
        dos.close();
    }

    public static void storeDoubles(DoubleIterator i, DataOutput dataOutput) throws IOException {
        while (i.hasNext()) {
            dataOutput.writeDouble(i.nextDouble());
        }
    }

    public static void storeDoubles(DoubleIterator i, CharSequence filename) throws IOException {
        DataOutputStream dos = new DataOutputStream(new FastBufferedOutputStream(new FileOutputStream(((Object)filename).toString()), 65536));
        while (i.hasNext()) {
            dos.writeDouble(i.nextDouble());
        }
        dos.close();
    }

    public static DoubleIterator asDoubleIterator(DataInputStream stream) throws IOException {
        return new DoubleStreamWrapper(stream);
    }

    public static DoubleIterator asDoubleIterator(CharSequence filename) throws IOException {
        return new DoubleStreamWrapper(new DataInputStream(new FastBufferedInputStream(new FileInputStream(((Object)filename).toString()))));
    }

    private static final class DoubleStreamWrapper
    extends AbstractDoubleIterator {
        private final DataInputStream stream;
        private boolean toAdvance = true;
        private boolean endOfProcess = false;
        private double next;

        public DoubleStreamWrapper(DataInputStream stream) {
            this.stream = stream;
        }

        public boolean hasNext() {
            if (!this.toAdvance) {
                return !this.endOfProcess;
            }
            this.toAdvance = false;
            try {
                this.next = this.stream.readDouble();
            }
            catch (EOFException eof) {
                this.endOfProcess = true;
            }
            catch (IOException rethrow) {
                throw new RuntimeException(rethrow);
            }
            return !this.endOfProcess;
        }

        public double nextDouble() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            this.toAdvance = true;
            return this.next;
        }
    }

    private static final class FloatStreamWrapper
    extends AbstractFloatIterator {
        private final DataInputStream stream;
        private boolean toAdvance = true;
        private boolean endOfProcess = false;
        private float next;

        public FloatStreamWrapper(DataInputStream stream) {
            this.stream = stream;
        }

        public boolean hasNext() {
            if (!this.toAdvance) {
                return !this.endOfProcess;
            }
            this.toAdvance = false;
            try {
                this.next = this.stream.readFloat();
            }
            catch (EOFException eof) {
                this.endOfProcess = true;
            }
            catch (IOException rethrow) {
                throw new RuntimeException(rethrow);
            }
            return !this.endOfProcess;
        }

        public float nextFloat() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            this.toAdvance = true;
            return this.next;
        }
    }

    private static final class LongStreamWrapper
    extends AbstractLongIterator {
        private final DataInputStream stream;
        private boolean toAdvance = true;
        private boolean endOfProcess = false;
        private long next;

        public LongStreamWrapper(DataInputStream stream) {
            this.stream = stream;
        }

        public boolean hasNext() {
            if (!this.toAdvance) {
                return !this.endOfProcess;
            }
            this.toAdvance = false;
            try {
                this.next = this.stream.readLong();
            }
            catch (EOFException eof) {
                this.endOfProcess = true;
            }
            catch (IOException rethrow) {
                throw new RuntimeException(rethrow);
            }
            return !this.endOfProcess;
        }

        public long nextLong() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            this.toAdvance = true;
            return this.next;
        }
    }

    private static final class IntStreamWrapper
    extends AbstractIntIterator {
        private final DataInputStream stream;
        private boolean toAdvance = true;
        private boolean endOfProcess = false;
        private int next;

        public IntStreamWrapper(DataInputStream stream) {
            this.stream = stream;
        }

        public boolean hasNext() {
            if (!this.toAdvance) {
                return !this.endOfProcess;
            }
            this.toAdvance = false;
            try {
                this.next = this.stream.readInt();
            }
            catch (EOFException eof) {
                this.endOfProcess = true;
            }
            catch (IOException rethrow) {
                throw new RuntimeException(rethrow);
            }
            return !this.endOfProcess;
        }

        public int nextInt() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            this.toAdvance = true;
            return this.next;
        }
    }

    private static final class CharStreamWrapper
    extends AbstractCharIterator {
        private final DataInputStream stream;
        private boolean toAdvance = true;
        private boolean endOfProcess = false;
        private char next;

        public CharStreamWrapper(DataInputStream stream) {
            this.stream = stream;
        }

        public boolean hasNext() {
            if (!this.toAdvance) {
                return !this.endOfProcess;
            }
            this.toAdvance = false;
            try {
                this.next = this.stream.readChar();
            }
            catch (EOFException eof) {
                this.endOfProcess = true;
            }
            catch (IOException rethrow) {
                throw new RuntimeException(rethrow);
            }
            return !this.endOfProcess;
        }

        public char nextChar() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            this.toAdvance = true;
            return this.next;
        }
    }

    private static final class ShortStreamWrapper
    extends AbstractShortIterator {
        private final DataInputStream stream;
        private boolean toAdvance = true;
        private boolean endOfProcess = false;
        private short next;

        public ShortStreamWrapper(DataInputStream stream) {
            this.stream = stream;
        }

        public boolean hasNext() {
            if (!this.toAdvance) {
                return !this.endOfProcess;
            }
            this.toAdvance = false;
            try {
                this.next = this.stream.readShort();
            }
            catch (EOFException eof) {
                this.endOfProcess = true;
            }
            catch (IOException rethrow) {
                throw new RuntimeException(rethrow);
            }
            return !this.endOfProcess;
        }

        public short nextShort() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            this.toAdvance = true;
            return this.next;
        }
    }

    private static final class ByteStreamWrapper
    extends AbstractByteIterator {
        private final DataInputStream stream;
        private boolean toAdvance = true;
        private boolean endOfProcess = false;
        private byte next;

        public ByteStreamWrapper(DataInputStream stream) {
            this.stream = stream;
        }

        public boolean hasNext() {
            if (!this.toAdvance) {
                return !this.endOfProcess;
            }
            this.toAdvance = false;
            try {
                this.next = this.stream.readByte();
            }
            catch (EOFException eof) {
                this.endOfProcess = true;
            }
            catch (IOException rethrow) {
                throw new RuntimeException(rethrow);
            }
            return !this.endOfProcess;
        }

        public byte nextByte() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            this.toAdvance = true;
            return this.next;
        }
    }
}

