/*
 * Decompiled with CFR 0.152.
 */
package it.unimi.dsi.fastutil.ints;

import it.unimi.dsi.fastutil.ints.Int2IntMaps;
import it.unimi.dsi.fastutil.ints.Int2IntSortedMap;
import it.unimi.dsi.fastutil.ints.IntComparator;
import it.unimi.dsi.fastutil.ints.IntSortedSets;
import java.io.Serializable;
import java.util.Comparator;
import java.util.NoSuchElementException;
import java.util.Set;
import java.util.SortedMap;

public class Int2IntSortedMaps {
    public static final EmptySortedMap EMPTY_MAP = new EmptySortedMap();

    private Int2IntSortedMaps() {
    }

    public static Int2IntSortedMap singleton(int key, int value) {
        return new Singleton(key, value);
    }

    public static Int2IntSortedMap singleton(int key, int value, IntComparator comparator) {
        return new Singleton(key, value, comparator);
    }

    public static Int2IntSortedMap singleton(Object key, Object value) {
        return new Singleton((Integer)key, (Integer)value);
    }

    public static Int2IntSortedMap singleton(Object key, Object value, IntComparator comparator) {
        return new Singleton((Integer)key, (Integer)value, comparator);
    }

    public static Int2IntSortedMap synchronize(Int2IntSortedMap m) {
        return new SynchronizedSortedMap(m);
    }

    public static Int2IntSortedMap synchronize(Int2IntSortedMap m, Object sync) {
        return new SynchronizedSortedMap(m, sync);
    }

    public static Int2IntSortedMap unmodifiable(Int2IntSortedMap m) {
        return new UnmodifiableSortedMap(m);
    }

    public static class UnmodifiableSortedMap
    extends Int2IntMaps.UnmodifiableMap
    implements Int2IntSortedMap,
    Serializable {
        public static final long serialVersionUID = -7046029254386353129L;
        protected final Int2IntSortedMap sortedMap;

        protected UnmodifiableSortedMap(Int2IntSortedMap m) {
            super(m);
            this.sortedMap = m;
        }

        public Comparator comparator() {
            return this.sortedMap.comparator();
        }

        public Int2IntSortedMap subMap(int from, int to) {
            return new UnmodifiableSortedMap(this.sortedMap.subMap(from, to));
        }

        public Int2IntSortedMap headMap(int to) {
            return new UnmodifiableSortedMap(this.sortedMap.headMap(to));
        }

        public Int2IntSortedMap tailMap(int from) {
            return new UnmodifiableSortedMap(this.sortedMap.tailMap(from));
        }

        public int firstIntKey() {
            return this.sortedMap.firstIntKey();
        }

        public int lastIntKey() {
            return this.sortedMap.lastIntKey();
        }

        public Object firstKey() {
            return this.sortedMap.firstKey();
        }

        public Object lastKey() {
            return this.sortedMap.lastKey();
        }

        public SortedMap subMap(Object from, Object to) {
            return new UnmodifiableSortedMap((Int2IntSortedMap)this.sortedMap.subMap(from, to));
        }

        public SortedMap headMap(Object to) {
            return new UnmodifiableSortedMap((Int2IntSortedMap)this.sortedMap.headMap(to));
        }

        public SortedMap tailMap(Object from) {
            return new UnmodifiableSortedMap((Int2IntSortedMap)this.sortedMap.tailMap(from));
        }
    }

    public static class SynchronizedSortedMap
    extends Int2IntMaps.SynchronizedMap
    implements Int2IntSortedMap,
    Serializable {
        public static final long serialVersionUID = -7046029254386353129L;
        protected final Int2IntSortedMap sortedMap;

        protected SynchronizedSortedMap(Int2IntSortedMap m, Object sync) {
            super(m, sync);
            this.sortedMap = m;
        }

        protected SynchronizedSortedMap(Int2IntSortedMap m) {
            super(m);
            this.sortedMap = m;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Comparator comparator() {
            Object object = this.sync;
            synchronized (object) {
                return this.sortedMap.comparator();
            }
        }

        public Int2IntSortedMap subMap(int from, int to) {
            return new SynchronizedSortedMap(this.sortedMap.subMap(from, to), this.sync);
        }

        public Int2IntSortedMap headMap(int to) {
            return new SynchronizedSortedMap(this.sortedMap.headMap(to), this.sync);
        }

        public Int2IntSortedMap tailMap(int from) {
            return new SynchronizedSortedMap(this.sortedMap.tailMap(from), this.sync);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public int firstIntKey() {
            Object object = this.sync;
            synchronized (object) {
                return this.sortedMap.firstIntKey();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public int lastIntKey() {
            Object object = this.sync;
            synchronized (object) {
                return this.sortedMap.lastIntKey();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Object firstKey() {
            Object object = this.sync;
            synchronized (object) {
                return this.sortedMap.firstKey();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Object lastKey() {
            Object object = this.sync;
            synchronized (object) {
                return this.sortedMap.lastKey();
            }
        }

        public SortedMap subMap(Object from, Object to) {
            return new SynchronizedSortedMap((Int2IntSortedMap)this.sortedMap.subMap(from, to), this.sync);
        }

        public SortedMap headMap(Object to) {
            return new SynchronizedSortedMap((Int2IntSortedMap)this.sortedMap.headMap(to), this.sync);
        }

        public SortedMap tailMap(Object from) {
            return new SynchronizedSortedMap((Int2IntSortedMap)this.sortedMap.tailMap(from), this.sync);
        }
    }

    public static class Singleton
    extends Int2IntMaps.Singleton
    implements Int2IntSortedMap,
    Serializable,
    Cloneable {
        public static final long serialVersionUID = -7046029254386353129L;
        protected final IntComparator comparator;

        protected Singleton(int key, int value, IntComparator comparator) {
            super(key, value);
            this.comparator = comparator;
        }

        protected Singleton(int key, int value) {
            this(key, value, null);
        }

        final int compare(int k1, int k2) {
            return this.comparator == null ? (k1 < k2 ? -1 : (k1 == k2 ? 0 : 1)) : this.comparator.compare(k1, k2);
        }

        public Comparator comparator() {
            return this.comparator;
        }

        public Set keySet() {
            if (this.keys == null) {
                this.keys = IntSortedSets.singleton(this.key, this.comparator);
            }
            return this.keys;
        }

        public Int2IntSortedMap subMap(int from, int to) {
            if (this.compare(from, this.key) <= 0 && this.compare(this.key, to) < 0) {
                return this;
            }
            return EMPTY_MAP;
        }

        public Int2IntSortedMap headMap(int to) {
            if (this.compare(this.key, to) < 0) {
                return this;
            }
            return EMPTY_MAP;
        }

        public Int2IntSortedMap tailMap(int from) {
            if (this.compare(from, this.key) <= 0) {
                return this;
            }
            return EMPTY_MAP;
        }

        public int firstIntKey() {
            return this.key;
        }

        public int lastIntKey() {
            return this.key;
        }

        public SortedMap headMap(Object oto) {
            return this.headMap((Integer)oto);
        }

        public SortedMap tailMap(Object ofrom) {
            return this.tailMap((Integer)ofrom);
        }

        public SortedMap subMap(Object ofrom, Object oto) {
            return this.subMap((Integer)ofrom, (Integer)oto);
        }

        public Object firstKey() {
            return new Integer(this.firstIntKey());
        }

        public Object lastKey() {
            return new Integer(this.lastIntKey());
        }
    }

    public static class EmptySortedMap
    extends Int2IntMaps.EmptyMap
    implements Int2IntSortedMap,
    Serializable,
    Cloneable {
        public static final long serialVersionUID = -7046029254386353129L;

        protected EmptySortedMap() {
        }

        public Comparator comparator() {
            return null;
        }

        public Int2IntSortedMap subMap(int from, int to) {
            return EMPTY_MAP;
        }

        public Int2IntSortedMap headMap(int to) {
            return EMPTY_MAP;
        }

        public Int2IntSortedMap tailMap(int from) {
            return EMPTY_MAP;
        }

        public int firstIntKey() {
            throw new NoSuchElementException();
        }

        public int lastIntKey() {
            throw new NoSuchElementException();
        }

        public SortedMap headMap(Object oto) {
            return this.headMap((Integer)oto);
        }

        public SortedMap tailMap(Object ofrom) {
            return this.tailMap((Integer)ofrom);
        }

        public SortedMap subMap(Object ofrom, Object oto) {
            return this.subMap((Integer)ofrom, (Integer)oto);
        }

        public Object firstKey() {
            return new Integer(this.firstIntKey());
        }

        public Object lastKey() {
            return new Integer(this.lastIntKey());
        }
    }
}

