/*
 * Decompiled with CFR 0.152.
 */
package it.unimi.dsi.fastutil.ints;

import it.unimi.dsi.fastutil.HashCommon;
import it.unimi.dsi.fastutil.floats.AbstractFloatCollection;
import it.unimi.dsi.fastutil.floats.FloatCollection;
import it.unimi.dsi.fastutil.floats.FloatIterator;
import it.unimi.dsi.fastutil.floats.FloatListIterator;
import it.unimi.dsi.fastutil.ints.AbstractInt2FloatSortedMap;
import it.unimi.dsi.fastutil.ints.AbstractIntSortedSet;
import it.unimi.dsi.fastutil.ints.Int2FloatAVLTreeMap;
import it.unimi.dsi.fastutil.ints.Int2FloatMap;
import it.unimi.dsi.fastutil.ints.Int2FloatSortedMap;
import it.unimi.dsi.fastutil.ints.IntBidirectionalIterator;
import it.unimi.dsi.fastutil.ints.IntComparator;
import it.unimi.dsi.fastutil.ints.IntIterator;
import it.unimi.dsi.fastutil.ints.IntListIterator;
import it.unimi.dsi.fastutil.ints.IntSet;
import it.unimi.dsi.fastutil.ints.IntSortedSet;
import it.unimi.dsi.fastutil.objects.AbstractObjectListIterator;
import it.unimi.dsi.fastutil.objects.AbstractObjectSet;
import it.unimi.dsi.fastutil.objects.ObjectIterator;
import it.unimi.dsi.fastutil.objects.ObjectSet;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import java.util.SortedMap;

public class Int2FloatAVLTreeMap
extends AbstractInt2FloatSortedMap
implements Serializable,
Cloneable,
Int2FloatSortedMap {
    protected transient Entry tree;
    protected int count;
    protected transient Entry firstEntry;
    protected transient Entry lastEntry;
    protected volatile transient ObjectSet entries;
    protected volatile transient IntSet keys;
    protected volatile transient FloatCollection values;
    protected transient boolean modified;
    protected Comparator storedComparator;
    protected transient IntComparator actualComparator;
    public static final long serialVersionUID = -7046029254386353129L;
    private static final boolean ASSERTS = false;
    private transient boolean[] dirPath;

    public Int2FloatAVLTreeMap() {
        this.allocatePaths();
        this.tree = null;
        this.count = 0;
    }

    private void setActualComparator() {
        this.actualComparator = this.storedComparator == null || this.storedComparator instanceof IntComparator ? (IntComparator)this.storedComparator : new IntComparator(){

            public int compare(int k1, int k2) {
                return Int2FloatAVLTreeMap.this.storedComparator.compare(new Integer(k1), new Integer(k2));
            }

            public int compare(Object ok1, Object ok2) {
                return Int2FloatAVLTreeMap.this.storedComparator.compare(ok1, ok2);
            }
        };
    }

    public Int2FloatAVLTreeMap(Comparator c) {
        this();
        this.storedComparator = c;
        this.setActualComparator();
    }

    public Int2FloatAVLTreeMap(Map m) {
        this();
        this.putAll(m);
    }

    public Int2FloatAVLTreeMap(SortedMap m) {
        this(m.comparator());
        this.putAll((Map)m);
    }

    public Int2FloatAVLTreeMap(Int2FloatMap m) {
        this();
        this.putAll((Map)m);
    }

    public Int2FloatAVLTreeMap(Int2FloatSortedMap m) {
        this(m.comparator());
        this.putAll((Map)m);
    }

    final int compare(int k1, int k2) {
        return this.actualComparator == null ? (k1 < k2 ? -1 : (k1 == k2 ? 0 : 1)) : this.actualComparator.compare(k1, k2);
    }

    final Entry findKey(int k) {
        int cmp;
        Entry e = this.tree;
        while (e != null && (cmp = this.compare(k, e.key)) != 0) {
            e = cmp < 0 ? e.left() : e.right();
        }
        return e;
    }

    final Entry locateKey(int k) {
        Entry e = this.tree;
        Entry last = this.tree;
        int cmp = 0;
        while (e != null && (cmp = this.compare(k, e.key)) != 0) {
            last = e;
            e = cmp < 0 ? e.left() : e.right();
        }
        return cmp == 0 ? e : last;
    }

    private void allocatePaths() {
        this.dirPath = new boolean[48];
    }

    public float put(int k, float v) {
        this.modified = false;
        if (this.tree == null) {
            ++this.count;
            this.lastEntry = this.firstEntry = new Entry(k, v);
            this.tree = this.firstEntry;
            this.modified = true;
        } else {
            Entry p = this.tree;
            Entry q = null;
            Entry y = this.tree;
            Entry z = null;
            Entry e = null;
            Entry w = null;
            int i = 0;
            while (true) {
                int cmp;
                if ((cmp = this.compare(k, p.key)) == 0) {
                    float oldValue = p.value;
                    p.value = v;
                    return oldValue;
                }
                if ((byte)p.info != 0) {
                    i = 0;
                    z = q;
                    y = p;
                }
                if (this.dirPath[i++] = cmp > 0) {
                    if (p.succ()) {
                        ++this.count;
                        e = new Entry(k, v);
                        this.modified = true;
                        if (p.right == null) {
                            this.lastEntry = e;
                        }
                        e.left = p;
                        e.right = p.right;
                        p.right(e);
                        break;
                    }
                    q = p;
                    p = p.right;
                    continue;
                }
                if (p.pred()) {
                    ++this.count;
                    e = new Entry(k, v);
                    this.modified = true;
                    if (p.left == null) {
                        this.firstEntry = e;
                    }
                    e.right = p;
                    e.left = p.left;
                    p.left(e);
                    break;
                }
                q = p;
                p = p.left;
            }
            p = y;
            i = 0;
            while (p != e) {
                if (this.dirPath[i]) {
                    p.incBalance();
                } else {
                    p.decBalance();
                }
                p = this.dirPath[i++] ? p.right : p.left;
            }
            if ((byte)y.info == -2) {
                Entry x = y.left;
                if ((byte)x.info == -1) {
                    w = x;
                    if (x.succ()) {
                        x.succ(false);
                        y.pred(x);
                    } else {
                        y.left = x.right;
                    }
                    x.right = y;
                    x.balance(0);
                    y.balance(0);
                } else {
                    w = x.right;
                    x.right = w.left;
                    w.left = x;
                    y.left = w.right;
                    w.right = y;
                    if ((byte)w.info == -1) {
                        x.balance(0);
                        y.balance(1);
                    } else if ((byte)w.info == 0) {
                        x.balance(0);
                        y.balance(0);
                    } else {
                        x.balance(-1);
                        y.balance(0);
                    }
                    w.balance(0);
                    if (w.pred()) {
                        x.succ(w);
                        w.pred(false);
                    }
                    if (w.succ()) {
                        y.pred(w);
                        w.succ(false);
                    }
                }
            } else if ((byte)y.info == 2) {
                Entry x = y.right;
                if ((byte)x.info == 1) {
                    w = x;
                    if (x.pred()) {
                        x.pred(false);
                        y.succ(x);
                    } else {
                        y.right = x.left;
                    }
                    x.left = y;
                    x.balance(0);
                    y.balance(0);
                } else {
                    w = x.left;
                    x.left = w.right;
                    w.right = x;
                    y.right = w.left;
                    w.left = y;
                    if ((byte)w.info == 1) {
                        x.balance(0);
                        y.balance(-1);
                    } else if ((byte)w.info == 0) {
                        x.balance(0);
                        y.balance(0);
                    } else {
                        x.balance(1);
                        y.balance(0);
                    }
                    w.balance(0);
                    if (w.pred()) {
                        y.succ(w);
                        w.pred(false);
                    }
                    if (w.succ()) {
                        x.pred(w);
                        w.succ(false);
                    }
                }
            } else {
                return this.defRetValue;
            }
            if (z == null) {
                this.tree = w;
            } else if (z.left == y) {
                z.left = w;
            } else {
                z.right = w;
            }
        }
        return this.defRetValue;
    }

    private Entry parent(Entry e) {
        Entry y;
        if (e == this.tree) {
            return null;
        }
        Entry x = y = e;
        while (true) {
            if (y.succ()) {
                Entry p = y.right;
                if (p == null || p.left != e) {
                    while (!x.pred()) {
                        x = x.left;
                    }
                    p = x.left;
                }
                return p;
            }
            if (x.pred()) {
                Entry p = x.left;
                if (p == null || p.right != e) {
                    while (!y.succ()) {
                        y = y.right;
                    }
                    p = y.right;
                }
                return p;
            }
            x = x.left;
            y = y.right;
        }
    }

    public float remove(int k) {
        int cmp;
        this.modified = false;
        if (this.tree == null) {
            return this.defRetValue;
        }
        Entry p = this.tree;
        Entry q = null;
        boolean dir = false;
        while ((cmp = this.compare(k, p.key)) != 0) {
            dir = cmp > 0;
            if (dir) {
                q = p;
                if ((p = p.right()) != null) continue;
                return this.defRetValue;
            }
            q = p;
            if ((p = p.left()) != null) continue;
            return this.defRetValue;
        }
        if (p.left == null) {
            this.firstEntry = p.next();
        }
        if (p.right == null) {
            this.lastEntry = p.prev();
        }
        if (p.succ()) {
            if (p.pred()) {
                if (q != null) {
                    if (dir) {
                        q.succ(p.right);
                    } else {
                        q.pred(p.left);
                    }
                } else {
                    this.tree = dir ? p.right : p.left;
                }
            } else {
                p.prev().right = p.right;
                if (q != null) {
                    if (dir) {
                        q.right = p.left;
                    } else {
                        q.left = p.left;
                    }
                } else {
                    this.tree = p.left;
                }
            }
        } else {
            Entry r = p.right;
            if (r.pred()) {
                r.left = p.left;
                r.pred(p.pred());
                if (!r.pred()) {
                    r.prev().right = r;
                }
                if (q != null) {
                    if (dir) {
                        q.right = r;
                    } else {
                        q.left = r;
                    }
                } else {
                    this.tree = r;
                }
                r.balance((byte)p.info);
                q = r;
                dir = true;
            } else {
                Entry s;
                while (!(s = r.left).pred()) {
                    r = s;
                }
                if (s.succ()) {
                    r.pred(s);
                } else {
                    r.left = s.right;
                }
                s.left = p.left;
                if (!p.pred()) {
                    p.prev().right = s;
                    s.pred(false);
                }
                s.right = p.right;
                s.succ(false);
                if (q != null) {
                    if (dir) {
                        q.right = s;
                    } else {
                        q.left = s;
                    }
                } else {
                    this.tree = s;
                }
                s.balance((byte)p.info);
                q = r;
                dir = false;
            }
        }
        while (q != null) {
            Entry w;
            Entry x;
            Entry y = q;
            q = this.parent(y);
            if (!dir) {
                dir = q != null && q.left != y;
                y.incBalance();
                if ((byte)y.info == 1) break;
                if ((byte)y.info != 2) continue;
                x = y.right;
                if ((byte)x.info == -1) {
                    w = x.left;
                    x.left = w.right;
                    w.right = x;
                    y.right = w.left;
                    w.left = y;
                    if ((byte)w.info == 1) {
                        x.balance(0);
                        y.balance(-1);
                    } else if ((byte)w.info == 0) {
                        x.balance(0);
                        y.balance(0);
                    } else {
                        x.balance(1);
                        y.balance(0);
                    }
                    w.balance(0);
                    if (w.pred()) {
                        y.succ(w);
                        w.pred(false);
                    }
                    if (w.succ()) {
                        x.pred(w);
                        w.succ(false);
                    }
                    if (q != null) {
                        if (dir) {
                            q.right = w;
                            continue;
                        }
                        q.left = w;
                        continue;
                    }
                    this.tree = w;
                    continue;
                }
                if (q != null) {
                    if (dir) {
                        q.right = x;
                    } else {
                        q.left = x;
                    }
                } else {
                    this.tree = x;
                }
                if ((byte)x.info == 0) {
                    y.right = x.left;
                    x.left = y;
                    x.balance(-1);
                    y.balance(1);
                    break;
                }
                if (x.pred()) {
                    y.succ(true);
                    x.pred(false);
                } else {
                    y.right = x.left;
                }
                x.left = y;
                y.balance(0);
                x.balance(0);
                continue;
            }
            dir = q != null && q.left != y;
            y.decBalance();
            if ((byte)y.info == -1) break;
            if ((byte)y.info != -2) continue;
            x = y.left;
            if ((byte)x.info == 1) {
                w = x.right;
                x.right = w.left;
                w.left = x;
                y.left = w.right;
                w.right = y;
                if ((byte)w.info == -1) {
                    x.balance(0);
                    y.balance(1);
                } else if ((byte)w.info == 0) {
                    x.balance(0);
                    y.balance(0);
                } else {
                    x.balance(-1);
                    y.balance(0);
                }
                w.balance(0);
                if (w.pred()) {
                    x.succ(w);
                    w.pred(false);
                }
                if (w.succ()) {
                    y.pred(w);
                    w.succ(false);
                }
                if (q != null) {
                    if (dir) {
                        q.right = w;
                        continue;
                    }
                    q.left = w;
                    continue;
                }
                this.tree = w;
                continue;
            }
            if (q != null) {
                if (dir) {
                    q.right = x;
                } else {
                    q.left = x;
                }
            } else {
                this.tree = x;
            }
            if ((byte)x.info == 0) {
                y.left = x.right;
                x.right = y;
                x.balance(1);
                y.balance(-1);
                break;
            }
            if (x.succ()) {
                y.pred(true);
                x.succ(false);
            } else {
                y.left = x.right;
            }
            x.right = y;
            y.balance(0);
            x.balance(0);
        }
        this.modified = true;
        --this.count;
        return p.value;
    }

    public Object put(Object ok, Object ov) {
        float oldValue = this.put((Integer)ok, ((Float)ov).floatValue());
        return this.modified ? null : new Float(oldValue);
    }

    public Object remove(Object ok) {
        float oldValue = this.remove((Integer)ok);
        return this.modified ? new Float(oldValue) : null;
    }

    public boolean containsValue(float v) {
        TreeIterator i = new TreeIterator();
        while (i.hasNext()) {
            float ev = ((Entry)i.next()).value;
            if (ev != v) continue;
            return true;
        }
        return false;
    }

    public void clear() {
        this.count = 0;
        this.tree = null;
        this.entries = null;
        this.values = null;
        this.keys = null;
        this.lastEntry = null;
        this.firstEntry = null;
    }

    public boolean containsKey(int k) {
        return this.findKey(k) != null;
    }

    public int size() {
        return this.count;
    }

    public boolean isEmpty() {
        return this.count == 0;
    }

    public float get(int k) {
        Entry e = this.findKey(k);
        return e == null ? this.defRetValue : e.value;
    }

    public Object get(Object ok) {
        Entry e = this.findKey((Integer)ok);
        return e == null ? null : e.getValue();
    }

    public int firstIntKey() {
        if (this.tree == null) {
            throw new NoSuchElementException();
        }
        return this.firstEntry.key;
    }

    public int lastIntKey() {
        if (this.tree == null) {
            throw new NoSuchElementException();
        }
        return this.lastEntry.key;
    }

    public Object firstKey() {
        return new Integer(this.firstIntKey());
    }

    public Object lastKey() {
        return new Integer(this.lastIntKey());
    }

    public Set entrySet() {
        if (this.entries == null) {
            this.entries = new AbstractObjectSet(){

                public ObjectIterator objectIterator() {
                    return new TreeIterator();
                }

                public boolean contains(Object o) {
                    if (!(o instanceof Map.Entry)) {
                        return false;
                    }
                    Map.Entry e = (Map.Entry)o;
                    Entry f = Int2FloatAVLTreeMap.this.findKey((Integer)e.getKey());
                    return ((Object)e).equals(f);
                }

                public boolean remove(Object o) {
                    if (!(o instanceof Map.Entry)) {
                        return false;
                    }
                    Map.Entry e = (Map.Entry)o;
                    Entry f = Int2FloatAVLTreeMap.this.findKey((Integer)e.getKey());
                    if (f != null) {
                        Int2FloatAVLTreeMap.this.remove(f.key);
                    }
                    return f != null;
                }

                public int size() {
                    return Int2FloatAVLTreeMap.this.count;
                }

                public void clear() {
                    Int2FloatAVLTreeMap.this.clear();
                }
            };
        }
        return this.entries;
    }

    public Set keySet() {
        if (this.keys == null) {
            class KeySet
            extends AbstractIntSortedSet {
                KeySet() {
                }

                public IntIterator intIterator() {
                    return new KeyIterator();
                }

                public IntBidirectionalIterator iterator(int from) {
                    return new KeyIterator(from);
                }

                public Comparator comparator() {
                    return Int2FloatAVLTreeMap.this.storedComparator;
                }

                public boolean contains(int k) {
                    return Int2FloatAVLTreeMap.this.containsKey(k);
                }

                public boolean remove(int k) {
                    Int2FloatAVLTreeMap.this.remove(k);
                    return Int2FloatAVLTreeMap.this.modified;
                }

                public boolean rem(int k) {
                    return this.remove(k);
                }

                public int size() {
                    return Int2FloatAVLTreeMap.this.count;
                }

                public void clear() {
                    Int2FloatAVLTreeMap.this.clear();
                }

                public int firstInt() {
                    return Int2FloatAVLTreeMap.this.firstEntry.key;
                }

                public int lastInt() {
                    return Int2FloatAVLTreeMap.this.lastEntry.key;
                }

                public IntSortedSet headSet(int to) {
                    return (IntSortedSet)Int2FloatAVLTreeMap.this.headMap(to).keySet();
                }

                public IntSortedSet tailSet(int from) {
                    return (IntSortedSet)Int2FloatAVLTreeMap.this.tailMap(from).keySet();
                }

                public IntSortedSet subSet(int from, int to) {
                    return (IntSortedSet)Int2FloatAVLTreeMap.this.subMap(from, to).keySet();
                }
            }
            this.keys = new KeySet();
        }
        return this.keys;
    }

    public Collection values() {
        if (this.values == null) {
            this.values = new AbstractFloatCollection(){

                public FloatIterator floatIterator() {
                    return new ValueIterator();
                }

                public boolean contains(float k) {
                    return Int2FloatAVLTreeMap.this.containsValue(k);
                }

                public int size() {
                    return Int2FloatAVLTreeMap.this.count;
                }

                public void clear() {
                    Int2FloatAVLTreeMap.this.clear();
                }
            };
        }
        return this.values;
    }

    public Comparator comparator() {
        return this.storedComparator;
    }

    public Int2FloatSortedMap headMap(int to) {
        return new Submap(0, true, to, false);
    }

    public Int2FloatSortedMap tailMap(int from) {
        return new Submap(from, false, 0, true);
    }

    public Int2FloatSortedMap subMap(int from, int to) {
        return new Submap(from, false, to, false);
    }

    public Object clone() {
        Int2FloatAVLTreeMap c;
        try {
            c = (Int2FloatAVLTreeMap)super.clone();
        }
        catch (CloneNotSupportedException cantHappen) {
            throw new InternalError();
        }
        c.keys = null;
        c.values = null;
        c.entries = null;
        c.allocatePaths();
        if (this.count != 0) {
            Entry rp = new Entry();
            Entry rq = new Entry();
            Entry p = rp;
            rp.left(this.tree);
            Entry q = rq;
            rq.pred(null);
            while (true) {
                Entry e;
                if (!p.pred()) {
                    e = (Entry)p.left.clone();
                    e.pred(q.left);
                    e.succ(q);
                    q.left(e);
                    p = p.left;
                    q = q.left;
                } else {
                    while (p.succ()) {
                        p = p.right;
                        if (p == null) {
                            q.right = null;
                            c.firstEntry = c.tree = rq.left;
                            while (c.firstEntry.left != null) {
                                c.firstEntry = c.firstEntry.left;
                            }
                            c.lastEntry = c.tree;
                            while (c.lastEntry.right != null) {
                                c.lastEntry = c.lastEntry.right;
                            }
                            return c;
                        }
                        q = q.right;
                    }
                    p = p.right;
                    q = q.right;
                }
                if (p.succ()) continue;
                e = (Entry)p.right.clone();
                e.succ(q.right);
                e.pred(q);
                q.right(e);
            }
        }
        return c;
    }

    private void writeObject(ObjectOutputStream s) throws IOException {
        int n = this.count;
        TreeIterator i = new TreeIterator();
        s.defaultWriteObject();
        while (n-- != 0) {
            Entry e = (Entry)i.next();
            s.writeInt(e.key);
            s.writeFloat(e.value);
        }
    }

    private Entry readTree(ObjectInputStream s, int n, Entry pred, Entry succ) throws IOException, ClassNotFoundException {
        if (n == 1) {
            Entry top = new Entry(s.readInt(), s.readFloat());
            top.pred(pred);
            top.succ(succ);
            return top;
        }
        if (n == 2) {
            Entry top = new Entry(s.readInt(), s.readFloat());
            top.right(new Entry(s.readInt(), s.readFloat()));
            top.right.pred(top);
            top.balance(1);
            top.pred(pred);
            top.right.succ(succ);
            return top;
        }
        int rightN = n / 2;
        int leftN = n - rightN - 1;
        Entry top = new Entry();
        top.left(this.readTree(s, leftN, pred, top));
        top.key = s.readInt();
        top.value = s.readFloat();
        top.right(this.readTree(s, rightN, top, succ));
        if (n == (n & -n)) {
            top.balance(1);
        }
        return top;
    }

    private static int checkTree(Entry e) {
        if (e == null) {
            return 0;
        }
        int leftN = Int2FloatAVLTreeMap.checkTree(e.left());
        int rightN = Int2FloatAVLTreeMap.checkTree(e.right());
        if (leftN + e.balance() != rightN) {
            throw new AssertionError((Object)("Mismatch between left tree size (" + leftN + "), right tree size (" + rightN + ") and balance (" + e.balance() + ")"));
        }
        return Math.max(leftN, rightN) + 1;
    }

    private void readObject(ObjectInputStream s) throws IOException, ClassNotFoundException {
        s.defaultReadObject();
        this.setActualComparator();
        this.allocatePaths();
        if (this.count != 0) {
            Entry e = this.tree = this.readTree(s, this.count, null, null);
            while (e.left() != null) {
                e = e.left();
            }
            this.firstEntry = e;
            e = this.tree;
            while (e.right() != null) {
                e = e.right();
            }
            this.lastEntry = e;
        }
    }

    private final class Submap
    extends AbstractInt2FloatSortedMap
    implements Serializable,
    Int2FloatSortedMap {
        int from;
        int to;
        boolean bottom;
        boolean top;
        protected volatile transient ObjectSet entries;
        protected volatile transient IntSet keys;
        protected volatile transient FloatCollection values;

        public Submap(int from, boolean bottom, int to, boolean top) {
            if (!bottom && !top && Int2FloatAVLTreeMap.this.compare(from, to) > 0) {
                throw new IllegalArgumentException("Start key (" + from + ") is larger than end key (" + to + ")");
            }
            this.from = from;
            this.bottom = bottom;
            this.to = to;
            this.top = top;
            this.defRetValue = Int2FloatAVLTreeMap.this.defRetValue;
        }

        public void clear() {
            SubmapIterator i = new SubmapIterator();
            while (i.hasNext()) {
                i.next();
                i.remove();
            }
        }

        final boolean in(int k) {
            return !(!this.bottom && Int2FloatAVLTreeMap.this.compare(k, this.from) < 0 || !this.top && Int2FloatAVLTreeMap.this.compare(k, this.to) >= 0);
        }

        public Set entrySet() {
            if (this.entries == null) {
                this.entries = new AbstractObjectSet(this){
                    private final /* synthetic */ Submap this$1;
                    {
                        this.this$1 = this$1;
                    }

                    public ObjectIterator objectIterator() {
                        return this.this$1.new SubmapIterator();
                    }

                    public boolean contains(Object o) {
                        if (!(o instanceof Map.Entry)) {
                            return false;
                        }
                        Map.Entry e = (Map.Entry)o;
                        Entry f = Submap.access$100(this.this$1).findKey((Integer)e.getKey());
                        return f != null && this.this$1.in(f.key) && ((Object)e).equals(f);
                    }

                    public boolean remove(Object o) {
                        if (!(o instanceof Map.Entry)) {
                            return false;
                        }
                        Map.Entry e = (Map.Entry)o;
                        Entry f = Submap.access$100(this.this$1).findKey((Integer)e.getKey());
                        if (f != null && this.this$1.in(f.key)) {
                            this.this$1.remove(f.key);
                        }
                        return f != null;
                    }

                    public int size() {
                        int c = 0;
                        Iterator i = this.iterator();
                        while (i.hasNext()) {
                            ++c;
                            i.next();
                        }
                        return c;
                    }

                    public boolean isEmpty() {
                        return !this.this$1.new SubmapIterator().hasNext();
                    }

                    public void clear() {
                        this.this$1.clear();
                    }
                };
            }
            return this.entries;
        }

        public Set keySet() {
            if (this.keys == null) {
                class KeySet
                extends AbstractIntSortedSet
                implements IntSortedSet {
                    private final /* synthetic */ Submap this$1;

                    KeySet(Submap this$1) {
                        this.this$1 = this$1;
                    }

                    public IntIterator intIterator() {
                        return this.this$1.new SubmapKeyIterator();
                    }

                    public IntBidirectionalIterator iterator(int from) {
                        return this.this$1.new SubmapKeyIterator(from);
                    }

                    public Comparator comparator() {
                        return Submap.access$100((Submap)this.this$1).storedComparator;
                    }

                    public boolean contains(int k) {
                        return this.this$1.containsKey(k);
                    }

                    public boolean remove(int k) {
                        this.this$1.remove(k);
                        return Submap.access$100((Submap)this.this$1).modified;
                    }

                    public boolean rem(int k) {
                        return this.remove(k);
                    }

                    public int size() {
                        return this.this$1.size();
                    }

                    public void clear() {
                        this.this$1.clear();
                    }

                    public int firstInt() {
                        return this.this$1.firstEntry().key;
                    }

                    public int lastInt() {
                        return this.this$1.lastEntry().key;
                    }

                    public IntSortedSet headSet(int to) {
                        return (IntSortedSet)this.this$1.headMap(to).keySet();
                    }

                    public IntSortedSet tailSet(int from) {
                        return (IntSortedSet)this.this$1.tailMap(from).keySet();
                    }

                    public IntSortedSet subSet(int from, int to) {
                        return (IntSortedSet)this.this$1.subMap(from, to).keySet();
                    }
                }
                this.keys = new KeySet(this);
            }
            return this.keys;
        }

        public Collection values() {
            if (this.values == null) {
                this.values = new AbstractFloatCollection(this){
                    private final /* synthetic */ Submap this$1;
                    {
                        this.this$1 = this$1;
                    }

                    public FloatIterator floatIterator() {
                        return this.this$1.new SubmapValueIterator();
                    }

                    public boolean contains(float k) {
                        return this.this$1.containsValue(k);
                    }

                    public int size() {
                        return this.this$1.size();
                    }

                    public void clear() {
                        this.this$1.clear();
                    }
                };
            }
            return this.values;
        }

        public boolean containsKey(int k) {
            return this.in(k) && Int2FloatAVLTreeMap.this.containsKey(k);
        }

        public boolean containsValue(float v) {
            SubmapIterator i = new SubmapIterator();
            while (i.hasNext()) {
                float ev = ((Entry)i.next()).value;
                if (ev != v) continue;
                return true;
            }
            return false;
        }

        public float get(int k) {
            Entry e;
            return this.in(k) && (e = Int2FloatAVLTreeMap.this.findKey(k)) != null ? e.value : this.defRetValue;
        }

        public Object get(Object ok) {
            Entry e;
            return this.in((Integer)ok) && (e = Int2FloatAVLTreeMap.this.findKey((Integer)ok)) != null ? e.getValue() : null;
        }

        public float put(int k, float v) {
            Int2FloatAVLTreeMap.this.modified = false;
            if (!this.in(k)) {
                throw new IllegalArgumentException("Key (" + k + ") out of range [" + (this.bottom ? "-" : String.valueOf(this.from)) + ", " + (this.top ? "-" : String.valueOf(this.to)) + ")");
            }
            float oldValue = Int2FloatAVLTreeMap.this.put(k, v);
            return Int2FloatAVLTreeMap.this.modified ? this.defRetValue : oldValue;
        }

        public Object put(Object ok, Object ov) {
            float oldValue = this.put((Integer)ok, ((Float)ov).floatValue());
            return Int2FloatAVLTreeMap.this.modified ? null : new Float(oldValue);
        }

        public float remove(int k) {
            Int2FloatAVLTreeMap.this.modified = false;
            if (!this.in(k)) {
                return this.defRetValue;
            }
            float oldValue = Int2FloatAVLTreeMap.this.remove(k);
            return Int2FloatAVLTreeMap.this.modified ? oldValue : this.defRetValue;
        }

        public Object remove(Object ok) {
            float oldValue = this.remove((Integer)ok);
            return Int2FloatAVLTreeMap.this.modified ? new Float(oldValue) : null;
        }

        public int size() {
            SubmapIterator i = new SubmapIterator();
            int n = 0;
            while (i.hasNext()) {
                ++n;
                i.next();
            }
            return n;
        }

        public boolean isEmpty() {
            return !new SubmapIterator().hasNext();
        }

        public Comparator comparator() {
            return Int2FloatAVLTreeMap.this.storedComparator;
        }

        public Int2FloatSortedMap headMap(int to) {
            if (this.top) {
                return new Submap(this.from, this.bottom, to, false);
            }
            return Int2FloatAVLTreeMap.this.compare(to, this.to) < 0 ? new Submap(this.from, this.bottom, to, false) : this;
        }

        public Int2FloatSortedMap tailMap(int from) {
            if (this.bottom) {
                return new Submap(from, false, this.to, this.top);
            }
            return Int2FloatAVLTreeMap.this.compare(from, this.from) > 0 ? new Submap(from, false, this.to, this.top) : this;
        }

        public Int2FloatSortedMap subMap(int from, int to) {
            if (this.top && this.bottom) {
                return new Submap(from, false, to, false);
            }
            if (!this.top) {
                int n = to = Int2FloatAVLTreeMap.this.compare(to, this.to) < 0 ? to : this.to;
            }
            if (!this.bottom) {
                int n = from = Int2FloatAVLTreeMap.this.compare(from, this.from) > 0 ? from : this.from;
            }
            if (!this.top && !this.bottom && from == this.from && to == this.to) {
                return this;
            }
            return new Submap(from, false, to, false);
        }

        public Entry firstEntry() {
            Entry e;
            if (Int2FloatAVLTreeMap.this.tree == null) {
                return null;
            }
            if (this.bottom) {
                e = Int2FloatAVLTreeMap.this.firstEntry;
            } else {
                e = Int2FloatAVLTreeMap.this.locateKey(this.from);
                if (Int2FloatAVLTreeMap.this.compare(e.key, this.from) < 0) {
                    e = e.next();
                }
            }
            if (e == null || !this.top && Int2FloatAVLTreeMap.this.compare(e.key, this.to) >= 0) {
                return null;
            }
            return e;
        }

        public Entry lastEntry() {
            Entry e;
            if (Int2FloatAVLTreeMap.this.tree == null) {
                return null;
            }
            if (this.top) {
                e = Int2FloatAVLTreeMap.this.lastEntry;
            } else {
                e = Int2FloatAVLTreeMap.this.locateKey(this.to);
                if (Int2FloatAVLTreeMap.this.compare(e.key, this.to) >= 0) {
                    e = e.prev();
                }
            }
            if (e == null || !this.bottom && Int2FloatAVLTreeMap.this.compare(e.key, this.from) < 0) {
                return null;
            }
            return e;
        }

        public int firstIntKey() {
            Entry e = this.firstEntry();
            if (e == null) {
                throw new NoSuchElementException();
            }
            return e.key;
        }

        public int lastIntKey() {
            Entry e = this.lastEntry();
            if (e == null) {
                throw new NoSuchElementException();
            }
            return e.key;
        }

        public Object firstKey() {
            Entry e = this.firstEntry();
            if (e == null) {
                throw new NoSuchElementException();
            }
            return e.getKey();
        }

        public Object lastKey() {
            Entry e = this.lastEntry();
            if (e == null) {
                throw new NoSuchElementException();
            }
            return e.getKey();
        }

        private final class SubmapValueIterator
        extends SubmapIterator
        implements FloatListIterator {
            private SubmapValueIterator() {
            }

            public float nextFloat() {
                return this.nextEntry().value;
            }

            public float previousFloat() {
                return this.previousEntry().value;
            }

            public Object next() {
                return new Float(this.nextEntry().value);
            }

            public Object previous() {
                return new Float(this.previousEntry().value);
            }

            public void set(float v) {
                throw new UnsupportedOperationException();
            }

            public void add(float v) {
                throw new UnsupportedOperationException();
            }
        }

        private final class SubmapKeyIterator
        extends SubmapIterator
        implements IntListIterator {
            public SubmapKeyIterator() {
            }

            public SubmapKeyIterator(int from) {
                super(from);
            }

            public int nextInt() {
                return this.nextEntry().key;
            }

            public int previousInt() {
                return this.previousEntry().key;
            }

            public Object next() {
                return new Integer(this.nextEntry().key);
            }

            public Object previous() {
                return new Integer(this.previousEntry().key);
            }

            public void set(int k) {
                throw new UnsupportedOperationException();
            }

            public void add(int k) {
                throw new UnsupportedOperationException();
            }
        }

        private class SubmapIterator
        extends TreeIterator {
            SubmapIterator() {
                this.next = Submap.this.firstEntry();
            }

            /*
             * Enabled aggressive block sorting
             */
            SubmapIterator(int k) {
                this();
                if (this.next == null) return;
                if (!this$1.bottom && this$1.Int2FloatAVLTreeMap.this.compare(k, this.next.key) < 0) {
                    this.prev = null;
                    return;
                }
                if (!this$1.top) {
                    this.prev = this$1.lastEntry();
                    if (this$1.Int2FloatAVLTreeMap.this.compare(k, this.prev.key) >= 0) {
                        this.next = null;
                        return;
                    }
                }
                this.next = this$1.Int2FloatAVLTreeMap.this.locateKey(k);
                if (this$1.Int2FloatAVLTreeMap.this.compare(this.next.key, k) <= 0) {
                    this.prev = this.next;
                    this.next = this.next.next();
                    return;
                }
                this.prev = this.next.prev();
            }

            void updatePrevious() {
                this.prev = this.prev.prev();
                if (!Submap.this.bottom && this.prev != null && Int2FloatAVLTreeMap.this.compare(this.prev.key, Submap.this.from) < 0) {
                    this.prev = null;
                }
            }

            void updateNext() {
                this.next = this.next.next();
                if (!Submap.this.top && this.next != null && Int2FloatAVLTreeMap.this.compare(this.next.key, Submap.this.to) >= 0) {
                    this.next = null;
                }
            }
        }
    }

    private final class ValueIterator
    extends TreeIterator
    implements FloatListIterator {
        private ValueIterator() {
        }

        public float nextFloat() {
            return this.nextEntry().value;
        }

        public float previousFloat() {
            return this.previousEntry().value;
        }

        public Object next() {
            return new Float(this.nextEntry().value);
        }

        public Object previous() {
            return new Float(this.previousEntry().value);
        }

        public void set(float v) {
            throw new UnsupportedOperationException();
        }

        public void add(float v) {
            throw new UnsupportedOperationException();
        }
    }

    private final class KeyIterator
    extends TreeIterator
    implements IntListIterator {
        public KeyIterator() {
        }

        public KeyIterator(int k) {
            super(k);
        }

        public int nextInt() {
            return this.nextEntry().key;
        }

        public int previousInt() {
            return this.previousEntry().key;
        }

        public Object next() {
            return new Integer(this.nextEntry().key);
        }

        public Object previous() {
            return new Integer(this.previousEntry().key);
        }

        public void set(int k) {
            throw new UnsupportedOperationException();
        }

        public void add(int k) {
            throw new UnsupportedOperationException();
        }
    }

    private class TreeIterator
    extends AbstractObjectListIterator {
        Entry prev;
        Entry next;
        Entry curr;
        int index = 0;

        TreeIterator() {
            this.next = Int2FloatAVLTreeMap.this.firstEntry;
        }

        TreeIterator(int k) {
            this.next = Int2FloatAVLTreeMap.this.locateKey(k);
            if (this.next != null) {
                if (Int2FloatAVLTreeMap.this.compare(this.next.key, k) <= 0) {
                    this.prev = this.next;
                    this.next = this.next.next();
                } else {
                    this.prev = this.next.prev();
                }
            }
        }

        public boolean hasNext() {
            return this.next != null;
        }

        public boolean hasPrevious() {
            return this.prev != null;
        }

        void updateNext() {
            this.next = this.next.next();
        }

        Entry nextEntry() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            this.curr = this.prev = this.next;
            ++this.index;
            this.updateNext();
            return this.curr;
        }

        public Object next() {
            return this.nextEntry();
        }

        void updatePrevious() {
            this.prev = this.prev.prev();
        }

        Entry previousEntry() {
            if (!this.hasPrevious()) {
                throw new NoSuchElementException();
            }
            this.curr = this.next = this.prev;
            --this.index;
            this.updatePrevious();
            return this.curr;
        }

        public Object previous() {
            return this.previousEntry();
        }

        public int nextIndex() {
            return this.index;
        }

        public int previousIndex() {
            return this.index - 1;
        }

        public void remove() {
            if (this.curr == null) {
                throw new IllegalStateException();
            }
            if (this.curr == this.prev) {
                --this.index;
            }
            this.next = this.prev = this.curr;
            this.updatePrevious();
            this.updateNext();
            Int2FloatAVLTreeMap.this.remove(this.curr.key);
            this.curr = null;
        }
    }

    private static final class Entry
    implements Cloneable,
    Int2FloatMap.Entry {
        private static final int SUCC_MASK = Integer.MIN_VALUE;
        private static final int PRED_MASK = 0x40000000;
        private static final int BALANCE_MASK = 255;
        int key;
        float value;
        Entry left;
        Entry right;
        int info;

        Entry() {
        }

        Entry(Object k, Object v) {
            this.key = (Integer)k;
            this.value = ((Float)v).floatValue();
            this.info = -1073741824;
        }

        Entry(int k, float v) {
            this.key = k;
            this.value = v;
            this.info = -1073741824;
        }

        Entry left() {
            return (this.info & 0x40000000) != 0 ? null : this.left;
        }

        Entry right() {
            return (this.info & Integer.MIN_VALUE) != 0 ? null : this.right;
        }

        boolean pred() {
            return (this.info & 0x40000000) != 0;
        }

        boolean succ() {
            return (this.info & Integer.MIN_VALUE) != 0;
        }

        void pred(boolean pred) {
            this.info = pred ? (this.info |= 0x40000000) : (this.info &= 0xBFFFFFFF);
        }

        void succ(boolean succ) {
            this.info = succ ? (this.info |= Integer.MIN_VALUE) : (this.info &= Integer.MAX_VALUE);
        }

        void pred(Entry pred) {
            this.info |= 0x40000000;
            this.left = pred;
        }

        void succ(Entry succ) {
            this.info |= Integer.MIN_VALUE;
            this.right = succ;
        }

        void left(Entry left) {
            this.info &= 0xBFFFFFFF;
            this.left = left;
        }

        void right(Entry right) {
            this.info &= Integer.MAX_VALUE;
            this.right = right;
        }

        int balance() {
            return (byte)this.info;
        }

        void balance(int level) {
            this.info &= 0xFFFFFF00;
            this.info |= level & 0xFF;
        }

        void incBalance() {
            this.info = this.info & 0xFFFFFF00 | (byte)this.info + 1 & 0xFF;
        }

        protected void decBalance() {
            this.info = this.info & 0xFFFFFF00 | (byte)this.info - 1 & 0xFF;
        }

        Entry next() {
            Entry next = this.right;
            if ((this.info & Integer.MIN_VALUE) == 0) {
                while ((next.info & 0x40000000) == 0) {
                    next = next.left;
                }
            }
            return next;
        }

        Entry prev() {
            Entry prev = this.left;
            if ((this.info & 0x40000000) == 0) {
                while ((prev.info & Integer.MIN_VALUE) == 0) {
                    prev = prev.right;
                }
            }
            return prev;
        }

        public Object getKey() {
            return new Integer(this.key);
        }

        public int getIntKey() {
            return this.key;
        }

        public Object getValue() {
            return new Float(this.value);
        }

        public float getFloatValue() {
            return this.value;
        }

        public float setValue(float value) {
            float oldValue = this.value;
            this.value = value;
            return oldValue;
        }

        public Object setValue(Object value) {
            return new Float(this.setValue(((Float)value).floatValue()));
        }

        public Object clone() {
            Entry c;
            try {
                c = (Entry)super.clone();
            }
            catch (CloneNotSupportedException cantHappen) {
                throw new InternalError();
            }
            c.key = this.key;
            c.value = this.value;
            c.info = this.info;
            return c;
        }

        public boolean equals(Object o) {
            if (!(o instanceof Map.Entry)) {
                return false;
            }
            Map.Entry e = (Map.Entry)o;
            return this.key == (Integer)e.getKey() && this.value == ((Float)e.getValue()).floatValue();
        }

        public int hashCode() {
            return this.key ^ HashCommon.float2int(this.value);
        }

        public String toString() {
            return this.key + "=>" + this.value;
        }
    }
}

