/*
 * Decompiled with CFR 0.152.
 */
package it.unimi.dsi.fastutil.ints;

import it.unimi.dsi.fastutil.ints.IntCollection;
import it.unimi.dsi.fastutil.ints.IntIterator;
import it.unimi.dsi.fastutil.ints.IntIterators;
import it.unimi.dsi.fastutil.objects.ObjectIterators;
import java.lang.reflect.Array;
import java.util.Collection;
import java.util.Iterator;

public abstract class AbstractIntCollection
implements IntCollection {
    protected AbstractIntCollection() {
    }

    public int[] toArray(int[] a) {
        return this.toIntArray(a);
    }

    public int[] toIntArray() {
        return this.toIntArray(null);
    }

    public int[] toIntArray(int[] a) {
        if (a == null || a.length < this.size()) {
            a = new int[this.size()];
        }
        IntIterators.unwrap(this.intIterator(), a);
        return a;
    }

    public boolean addAll(IntCollection c) {
        boolean retVal = false;
        IntIterator i = c.intIterator();
        int n = c.size();
        while (n-- != 0) {
            if (!this.add(i.nextInt())) continue;
            retVal = true;
        }
        return retVal;
    }

    public boolean containsAll(IntCollection c) {
        IntIterator i = c.intIterator();
        int n = c.size();
        while (n-- != 0) {
            if (this.contains(i.nextInt())) continue;
            return false;
        }
        return true;
    }

    public boolean retainAll(IntCollection c) {
        boolean retVal = false;
        int n = this.size();
        IntIterator i = this.intIterator();
        while (n-- != 0) {
            if (c.contains(i.nextInt())) continue;
            i.remove();
            retVal = true;
        }
        return retVal;
    }

    public boolean removeAll(IntCollection c) {
        boolean retVal = false;
        int n = c.size();
        IntIterator i = c.intIterator();
        while (n-- != 0) {
            if (!this.rem(i.nextInt())) continue;
            retVal = true;
        }
        return retVal;
    }

    public Object[] toArray() {
        return this.toArray((Object[])null);
    }

    public Object[] toArray(Object[] a) {
        if (a == null) {
            a = new Object[this.size()];
        } else if (a.length < this.size()) {
            a = (Object[])Array.newInstance(a.getClass().getComponentType(), this.size());
        }
        ObjectIterators.unwrap((Iterator)this.intIterator(), a);
        return a;
    }

    public boolean addAll(Collection c) {
        boolean retVal = false;
        Iterator i = c.iterator();
        int n = c.size();
        while (n-- != 0) {
            if (!this.add(i.next())) continue;
            retVal = true;
        }
        return retVal;
    }

    public boolean add(int k) {
        throw new UnsupportedOperationException();
    }

    public boolean rem(int k) {
        throw new UnsupportedOperationException();
    }

    public boolean remove(Object ok) {
        return this.rem((Integer)ok);
    }

    public void clear() {
        throw new UnsupportedOperationException();
    }

    public Iterator iterator() {
        return this.intIterator();
    }

    public boolean add(Object o) {
        return this.add((Integer)o);
    }

    public boolean rem(Object o) {
        return this.rem((Integer)o);
    }

    public boolean contains(Object o) {
        return this.contains((Integer)o);
    }

    public boolean containsAll(Collection c) {
        int n = c.size();
        Iterator i = c.iterator();
        while (n-- != 0) {
            if (this.contains(i.next())) continue;
            return false;
        }
        return true;
    }

    public boolean retainAll(Collection c) {
        boolean retVal = false;
        int n = this.size();
        Iterator i = this.iterator();
        while (n-- != 0) {
            if (c.contains(i.next())) continue;
            i.remove();
            retVal = true;
        }
        return retVal;
    }

    public boolean removeAll(Collection c) {
        boolean retVal = false;
        int n = c.size();
        Iterator i = c.iterator();
        while (n-- != 0) {
            if (!this.remove(i.next())) continue;
            retVal = true;
        }
        return retVal;
    }

    public boolean isEmpty() {
        return this.size() == 0;
    }

    public String toString() {
        StringBuffer s = new StringBuffer();
        IntIterator i = this.intIterator();
        int n = this.size();
        boolean first = true;
        s.append("{");
        while (n-- != 0) {
            if (first) {
                first = false;
            } else {
                s.append(", ");
            }
            int k = i.nextInt();
            s.append(String.valueOf(k));
        }
        s.append("}");
        return s.toString();
    }
}

