/*
 * Decompiled with CFR 0.152.
 */
package it.unimi.dsi.fastutil.ints;

import it.unimi.dsi.fastutil.HashCommon;
import it.unimi.dsi.fastutil.floats.AbstractFloatCollection;
import it.unimi.dsi.fastutil.floats.AbstractFloatIterator;
import it.unimi.dsi.fastutil.floats.FloatCollection;
import it.unimi.dsi.fastutil.floats.FloatIterator;
import it.unimi.dsi.fastutil.ints.AbstractIntIterator;
import it.unimi.dsi.fastutil.ints.AbstractIntSet;
import it.unimi.dsi.fastutil.ints.Int2FloatMap;
import it.unimi.dsi.fastutil.ints.IntIterator;
import it.unimi.dsi.fastutil.ints.IntSet;
import java.io.Serializable;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;

public abstract class AbstractInt2FloatMap
implements Int2FloatMap,
Serializable {
    protected float defRetValue;

    protected AbstractInt2FloatMap() {
    }

    public void setDefRetValue(float rv) {
        this.defaultReturnValue(rv);
    }

    public float getDefRetValue() {
        return this.defaultReturnValue();
    }

    public void defaultReturnValue(float rv) {
        this.defRetValue = rv;
    }

    public float defaultReturnValue() {
        return this.defRetValue;
    }

    public float put(int key, float value) {
        throw new UnsupportedOperationException();
    }

    public float remove(int key) {
        throw new UnsupportedOperationException();
    }

    public void clear() {
        throw new UnsupportedOperationException();
    }

    public Object get(Object ok) {
        int k = (Integer)ok;
        return this.containsKey(k) ? new Float(this.get(k)) : null;
    }

    public Object put(Object ok, Object ov) {
        int k = (Integer)ok;
        float v = this.put(k, ((Float)ov).floatValue());
        return this.containsKey(k) ? new Float(v) : null;
    }

    public Object remove(Object ok) {
        int k = (Integer)ok;
        float v = this.remove(k);
        return this.containsKey(k) ? new Float(v) : null;
    }

    public boolean containsValue(Object ov) {
        return this.containsValue(((Float)ov).floatValue());
    }

    public boolean containsKey(Object ok) {
        return this.containsKey((Integer)ok);
    }

    public boolean containsValue(float v) {
        return ((FloatCollection)this.values()).contains(v);
    }

    public boolean containsKey(int k) {
        return ((IntSet)this.keySet()).contains(k);
    }

    public void putAll(Map m) {
        int n = m.size();
        Iterator i = m.entrySet().iterator();
        if (m instanceof Int2FloatMap) {
            while (n-- != 0) {
                Int2FloatMap.Entry e = (Int2FloatMap.Entry)i.next();
                this.put(e.getIntKey(), e.getFloatValue());
            }
        } else {
            while (n-- != 0) {
                Map.Entry e = i.next();
                this.put(e.getKey(), e.getValue());
            }
        }
    }

    public boolean isEmpty() {
        return this.size() == 0;
    }

    public Set keySet() {
        return new AbstractIntSet(){

            public boolean contains(int k) {
                return AbstractInt2FloatMap.this.containsKey(k);
            }

            public int size() {
                return AbstractInt2FloatMap.this.size();
            }

            public IntIterator intIterator() {
                return new AbstractIntIterator(this){
                    final Iterator i;
                    private final /* synthetic */ 1 this$1;
                    {
                        this.this$1 = this$1;
                        this.i = 1.access$000(this.this$1).entrySet().iterator();
                    }

                    public int nextInt() {
                        return ((Int2FloatMap.Entry)this.i.next()).getIntKey();
                    }

                    public boolean hasNext() {
                        return this.i.hasNext();
                    }
                };
            }

            static /* synthetic */ AbstractInt2FloatMap access$000(1 x0) {
                return x0.AbstractInt2FloatMap.this;
            }
        };
    }

    public Collection values() {
        return new AbstractFloatCollection(){

            public boolean contains(float k) {
                return AbstractInt2FloatMap.this.containsValue(k);
            }

            public int size() {
                return AbstractInt2FloatMap.this.size();
            }

            public FloatIterator floatIterator() {
                return new AbstractFloatIterator(this){
                    final Iterator i;
                    private final /* synthetic */ 3 this$1;
                    {
                        this.this$1 = this$1;
                        this.i = 3.access$100(this.this$1).entrySet().iterator();
                    }

                    public float nextFloat() {
                        return ((Int2FloatMap.Entry)this.i.next()).getFloatValue();
                    }

                    public boolean hasNext() {
                        return this.i.hasNext();
                    }
                };
            }

            static /* synthetic */ AbstractInt2FloatMap access$100(3 x0) {
                return x0.AbstractInt2FloatMap.this;
            }
        };
    }

    public int hashCode() {
        int h = 0;
        int n = this.size();
        Iterator i = this.entrySet().iterator();
        while (n-- != 0) {
            h += ((Object)i.next()).hashCode();
        }
        return h;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Map)) {
            return false;
        }
        Map m = (Map)o;
        if (m.size() != this.size()) {
            return false;
        }
        return this.entrySet().containsAll(m.entrySet());
    }

    public String toString() {
        StringBuffer s = new StringBuffer();
        Iterator i = this.entrySet().iterator();
        int n = this.size();
        boolean first = true;
        s.append("{");
        while (n-- != 0) {
            if (first) {
                first = false;
            } else {
                s.append(", ");
            }
            Int2FloatMap.Entry e = (Int2FloatMap.Entry)i.next();
            s.append(String.valueOf(e.getIntKey()));
            s.append("=>");
            s.append(String.valueOf(e.getFloatValue()));
        }
        s.append("}");
        return s.toString();
    }

    public static class BasicEntry
    implements Int2FloatMap.Entry {
        protected int key;
        protected float value;

        public BasicEntry(Object key, Object value) {
            this.key = (Integer)key;
            this.value = ((Float)value).floatValue();
        }

        public BasicEntry(int key, float value) {
            this.key = key;
            this.value = value;
        }

        public Object getKey() {
            return new Integer(this.key);
        }

        public int getIntKey() {
            return this.key;
        }

        public Object getValue() {
            return new Float(this.value);
        }

        public float getFloatValue() {
            return this.value;
        }

        public float setValue(float value) {
            throw new UnsupportedOperationException();
        }

        public Object setValue(Object value) {
            return new Float(this.setValue(((Float)value).floatValue()));
        }

        public boolean equals(Object o) {
            if (!(o instanceof Map.Entry)) {
                return false;
            }
            Map.Entry e = (Map.Entry)o;
            return this.key == (Integer)e.getKey() && this.value == ((Float)e.getValue()).floatValue();
        }

        public int hashCode() {
            return this.key ^ HashCommon.float2int(this.value);
        }

        public String toString() {
            return this.key + "->" + this.value;
        }
    }
}

