/*
 * Decompiled with CFR 0.152.
 */
package it.unimi.dsi.fastutil.ints;

import it.unimi.dsi.fastutil.bytes.AbstractByteCollection;
import it.unimi.dsi.fastutil.bytes.AbstractByteIterator;
import it.unimi.dsi.fastutil.bytes.ByteCollection;
import it.unimi.dsi.fastutil.bytes.ByteIterator;
import it.unimi.dsi.fastutil.ints.AbstractIntIterator;
import it.unimi.dsi.fastutil.ints.AbstractIntSet;
import it.unimi.dsi.fastutil.ints.Int2ByteMap;
import it.unimi.dsi.fastutil.ints.IntIterator;
import it.unimi.dsi.fastutil.ints.IntSet;
import java.io.Serializable;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;

public abstract class AbstractInt2ByteMap
implements Int2ByteMap,
Serializable {
    protected byte defRetValue;

    protected AbstractInt2ByteMap() {
    }

    public void setDefRetValue(byte rv) {
        this.defaultReturnValue(rv);
    }

    public byte getDefRetValue() {
        return this.defaultReturnValue();
    }

    public void defaultReturnValue(byte rv) {
        this.defRetValue = rv;
    }

    public byte defaultReturnValue() {
        return this.defRetValue;
    }

    public byte put(int key, byte value) {
        throw new UnsupportedOperationException();
    }

    public byte remove(int key) {
        throw new UnsupportedOperationException();
    }

    public void clear() {
        throw new UnsupportedOperationException();
    }

    public Object get(Object ok) {
        int k = (Integer)ok;
        return this.containsKey(k) ? new Byte(this.get(k)) : null;
    }

    public Object put(Object ok, Object ov) {
        int k = (Integer)ok;
        byte v = this.put(k, (Byte)ov);
        return this.containsKey(k) ? new Byte(v) : null;
    }

    public Object remove(Object ok) {
        int k = (Integer)ok;
        byte v = this.remove(k);
        return this.containsKey(k) ? new Byte(v) : null;
    }

    public boolean containsValue(Object ov) {
        return this.containsValue((Byte)ov);
    }

    public boolean containsKey(Object ok) {
        return this.containsKey((Integer)ok);
    }

    public boolean containsValue(byte v) {
        return ((ByteCollection)this.values()).contains(v);
    }

    public boolean containsKey(int k) {
        return ((IntSet)this.keySet()).contains(k);
    }

    public void putAll(Map m) {
        int n = m.size();
        Iterator i = m.entrySet().iterator();
        if (m instanceof Int2ByteMap) {
            while (n-- != 0) {
                Int2ByteMap.Entry e = (Int2ByteMap.Entry)i.next();
                this.put(e.getIntKey(), e.getByteValue());
            }
        } else {
            while (n-- != 0) {
                Map.Entry e = i.next();
                this.put(e.getKey(), e.getValue());
            }
        }
    }

    public boolean isEmpty() {
        return this.size() == 0;
    }

    public Set keySet() {
        return new AbstractIntSet(){

            public boolean contains(int k) {
                return AbstractInt2ByteMap.this.containsKey(k);
            }

            public int size() {
                return AbstractInt2ByteMap.this.size();
            }

            public IntIterator intIterator() {
                return new AbstractIntIterator(this){
                    final Iterator i;
                    private final /* synthetic */ 1 this$1;
                    {
                        this.this$1 = this$1;
                        this.i = 1.access$000(this.this$1).entrySet().iterator();
                    }

                    public int nextInt() {
                        return ((Int2ByteMap.Entry)this.i.next()).getIntKey();
                    }

                    public boolean hasNext() {
                        return this.i.hasNext();
                    }
                };
            }

            static /* synthetic */ AbstractInt2ByteMap access$000(1 x0) {
                return x0.AbstractInt2ByteMap.this;
            }
        };
    }

    public Collection values() {
        return new AbstractByteCollection(){

            public boolean contains(byte k) {
                return AbstractInt2ByteMap.this.containsValue(k);
            }

            public int size() {
                return AbstractInt2ByteMap.this.size();
            }

            public ByteIterator byteIterator() {
                return new AbstractByteIterator(this){
                    final Iterator i;
                    private final /* synthetic */ 3 this$1;
                    {
                        this.this$1 = this$1;
                        this.i = 3.access$100(this.this$1).entrySet().iterator();
                    }

                    public byte nextByte() {
                        return ((Int2ByteMap.Entry)this.i.next()).getByteValue();
                    }

                    public boolean hasNext() {
                        return this.i.hasNext();
                    }
                };
            }

            static /* synthetic */ AbstractInt2ByteMap access$100(3 x0) {
                return x0.AbstractInt2ByteMap.this;
            }
        };
    }

    public int hashCode() {
        int h = 0;
        int n = this.size();
        Iterator i = this.entrySet().iterator();
        while (n-- != 0) {
            h += ((Object)i.next()).hashCode();
        }
        return h;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Map)) {
            return false;
        }
        Map m = (Map)o;
        if (m.size() != this.size()) {
            return false;
        }
        return this.entrySet().containsAll(m.entrySet());
    }

    public String toString() {
        StringBuffer s = new StringBuffer();
        Iterator i = this.entrySet().iterator();
        int n = this.size();
        boolean first = true;
        s.append("{");
        while (n-- != 0) {
            if (first) {
                first = false;
            } else {
                s.append(", ");
            }
            Int2ByteMap.Entry e = (Int2ByteMap.Entry)i.next();
            s.append(String.valueOf(e.getIntKey()));
            s.append("=>");
            s.append(String.valueOf(e.getByteValue()));
        }
        s.append("}");
        return s.toString();
    }

    public static class BasicEntry
    implements Int2ByteMap.Entry {
        protected int key;
        protected byte value;

        public BasicEntry(Object key, Object value) {
            this.key = (Integer)key;
            this.value = (Byte)value;
        }

        public BasicEntry(int key, byte value) {
            this.key = key;
            this.value = value;
        }

        public Object getKey() {
            return new Integer(this.key);
        }

        public int getIntKey() {
            return this.key;
        }

        public Object getValue() {
            return new Byte(this.value);
        }

        public byte getByteValue() {
            return this.value;
        }

        public byte setValue(byte value) {
            throw new UnsupportedOperationException();
        }

        public Object setValue(Object value) {
            return new Byte(this.setValue((Byte)value));
        }

        public boolean equals(Object o) {
            if (!(o instanceof Map.Entry)) {
                return false;
            }
            Map.Entry e = (Map.Entry)o;
            return this.key == (Integer)e.getKey() && this.value == (Byte)e.getValue();
        }

        public int hashCode() {
            return this.key ^ this.value;
        }

        public String toString() {
            return this.key + "->" + this.value;
        }
    }
}

