/*
 * Decompiled with CFR 0.152.
 */
package it.unimi.dsi.fastutil.ints;

import it.unimi.dsi.fastutil.booleans.AbstractBooleanCollection;
import it.unimi.dsi.fastutil.booleans.AbstractBooleanIterator;
import it.unimi.dsi.fastutil.booleans.BooleanCollection;
import it.unimi.dsi.fastutil.booleans.BooleanIterator;
import it.unimi.dsi.fastutil.ints.AbstractIntIterator;
import it.unimi.dsi.fastutil.ints.AbstractIntSet;
import it.unimi.dsi.fastutil.ints.Int2BooleanMap;
import it.unimi.dsi.fastutil.ints.IntIterator;
import it.unimi.dsi.fastutil.ints.IntSet;
import java.io.Serializable;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;

public abstract class AbstractInt2BooleanMap
implements Int2BooleanMap,
Serializable {
    protected boolean defRetValue;

    protected AbstractInt2BooleanMap() {
    }

    public void setDefRetValue(boolean rv) {
        this.defaultReturnValue(rv);
    }

    public boolean getDefRetValue() {
        return this.defaultReturnValue();
    }

    public void defaultReturnValue(boolean rv) {
        this.defRetValue = rv;
    }

    public boolean defaultReturnValue() {
        return this.defRetValue;
    }

    public boolean put(int key, boolean value) {
        throw new UnsupportedOperationException();
    }

    public boolean remove(int key) {
        throw new UnsupportedOperationException();
    }

    public void clear() {
        throw new UnsupportedOperationException();
    }

    public Object get(Object ok) {
        int k = (Integer)ok;
        return this.containsKey(k) ? Boolean.valueOf(this.get(k)) : null;
    }

    public Object put(Object ok, Object ov) {
        int k = (Integer)ok;
        boolean v = this.put(k, (Boolean)ov);
        return this.containsKey(k) ? Boolean.valueOf(v) : null;
    }

    public Object remove(Object ok) {
        int k = (Integer)ok;
        boolean v = this.remove(k);
        return this.containsKey(k) ? Boolean.valueOf(v) : null;
    }

    public boolean containsValue(Object ov) {
        return this.containsValue((Boolean)ov);
    }

    public boolean containsKey(Object ok) {
        return this.containsKey((Integer)ok);
    }

    public boolean containsValue(boolean v) {
        return ((BooleanCollection)this.values()).contains(v);
    }

    public boolean containsKey(int k) {
        return ((IntSet)this.keySet()).contains(k);
    }

    public void putAll(Map m) {
        int n = m.size();
        Iterator i = m.entrySet().iterator();
        if (m instanceof Int2BooleanMap) {
            while (n-- != 0) {
                Int2BooleanMap.Entry e = (Int2BooleanMap.Entry)i.next();
                this.put(e.getIntKey(), e.getBooleanValue());
            }
        } else {
            while (n-- != 0) {
                Map.Entry e = i.next();
                this.put(e.getKey(), e.getValue());
            }
        }
    }

    public boolean isEmpty() {
        return this.size() == 0;
    }

    public Set keySet() {
        return new AbstractIntSet(){

            public boolean contains(int k) {
                return AbstractInt2BooleanMap.this.containsKey(k);
            }

            public int size() {
                return AbstractInt2BooleanMap.this.size();
            }

            public IntIterator intIterator() {
                return new AbstractIntIterator(this){
                    final Iterator i;
                    private final /* synthetic */ 1 this$1;
                    {
                        this.this$1 = this$1;
                        this.i = 1.access$000(this.this$1).entrySet().iterator();
                    }

                    public int nextInt() {
                        return ((Int2BooleanMap.Entry)this.i.next()).getIntKey();
                    }

                    public boolean hasNext() {
                        return this.i.hasNext();
                    }
                };
            }

            static /* synthetic */ AbstractInt2BooleanMap access$000(1 x0) {
                return x0.AbstractInt2BooleanMap.this;
            }
        };
    }

    public Collection values() {
        return new AbstractBooleanCollection(){

            public boolean contains(boolean k) {
                return AbstractInt2BooleanMap.this.containsValue(k);
            }

            public int size() {
                return AbstractInt2BooleanMap.this.size();
            }

            public BooleanIterator booleanIterator() {
                return new AbstractBooleanIterator(this){
                    final Iterator i;
                    private final /* synthetic */ 3 this$1;
                    {
                        this.this$1 = this$1;
                        this.i = 3.access$100(this.this$1).entrySet().iterator();
                    }

                    public boolean nextBoolean() {
                        return ((Int2BooleanMap.Entry)this.i.next()).getBooleanValue();
                    }

                    public boolean hasNext() {
                        return this.i.hasNext();
                    }
                };
            }

            static /* synthetic */ AbstractInt2BooleanMap access$100(3 x0) {
                return x0.AbstractInt2BooleanMap.this;
            }
        };
    }

    public int hashCode() {
        int h = 0;
        int n = this.size();
        Iterator i = this.entrySet().iterator();
        while (n-- != 0) {
            h += ((Object)i.next()).hashCode();
        }
        return h;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Map)) {
            return false;
        }
        Map m = (Map)o;
        if (m.size() != this.size()) {
            return false;
        }
        return this.entrySet().containsAll(m.entrySet());
    }

    public String toString() {
        StringBuffer s = new StringBuffer();
        Iterator i = this.entrySet().iterator();
        int n = this.size();
        boolean first = true;
        s.append("{");
        while (n-- != 0) {
            if (first) {
                first = false;
            } else {
                s.append(", ");
            }
            Int2BooleanMap.Entry e = (Int2BooleanMap.Entry)i.next();
            s.append(String.valueOf(e.getIntKey()));
            s.append("=>");
            s.append(String.valueOf(e.getBooleanValue()));
        }
        s.append("}");
        return s.toString();
    }

    public static class BasicEntry
    implements Int2BooleanMap.Entry {
        protected int key;
        protected boolean value;

        public BasicEntry(Object key, Object value) {
            this.key = (Integer)key;
            this.value = (Boolean)value;
        }

        public BasicEntry(int key, boolean value) {
            this.key = key;
            this.value = value;
        }

        public Object getKey() {
            return new Integer(this.key);
        }

        public int getIntKey() {
            return this.key;
        }

        public Object getValue() {
            return this.value;
        }

        public boolean getBooleanValue() {
            return this.value;
        }

        public boolean setValue(boolean value) {
            throw new UnsupportedOperationException();
        }

        public Object setValue(Object value) {
            return this.setValue((Boolean)value);
        }

        public boolean equals(Object o) {
            if (!(o instanceof Map.Entry)) {
                return false;
            }
            Map.Entry e = (Map.Entry)o;
            return this.key == (Integer)e.getKey() && this.value == (Boolean)e.getValue();
        }

        public int hashCode() {
            return this.key ^ (this.value ? 1231 : 1237);
        }

        public String toString() {
            return this.key + "->" + this.value;
        }
    }
}

