/*
 * Decompiled with CFR 0.152.
 */
package it.unimi.dsi.fastutil.floats;

import it.unimi.dsi.fastutil.Sets;
import it.unimi.dsi.fastutil.floats.FloatBidirectionalIterator;
import it.unimi.dsi.fastutil.floats.FloatComparator;
import it.unimi.dsi.fastutil.floats.FloatIterators;
import it.unimi.dsi.fastutil.floats.FloatSets;
import it.unimi.dsi.fastutil.floats.FloatSortedSet;
import java.io.Serializable;
import java.util.Comparator;
import java.util.Iterator;
import java.util.SortedSet;

public class FloatSortedSets {
    private FloatSortedSets() {
    }

    public static FloatSortedSet singleton(float element) {
        return new Singleton(element);
    }

    public static FloatSortedSet singleton(float element, FloatComparator comparator) {
        return new Singleton(element, comparator);
    }

    public static FloatSortedSet singleton(Object element) {
        return new Singleton(((Float)element).floatValue());
    }

    public static FloatSortedSet singleton(Object element, FloatComparator comparator) {
        return new Singleton(((Float)element).floatValue(), comparator);
    }

    public static FloatSortedSet synchronize(FloatSortedSet s) {
        return new SynchronizedSortedSet(s);
    }

    public static FloatSortedSet synchronize(FloatSortedSet s, Object sync) {
        return new SynchronizedSortedSet(s, sync);
    }

    public static FloatSortedSet unmodifiable(FloatSortedSet s) {
        return new UnmodifiableSortedSet(s);
    }

    public static class UnmodifiableSortedSet
    extends FloatSets.UnmodifiableSet
    implements FloatSortedSet,
    Serializable {
        public static final long serialVersionUID = -7046029254386353129L;
        protected final FloatSortedSet sortedSet;

        protected UnmodifiableSortedSet(FloatSortedSet s) {
            super(s);
            this.sortedSet = s;
        }

        public Comparator comparator() {
            return this.sortedSet.comparator();
        }

        public FloatSortedSet subSet(float from, float to) {
            return new UnmodifiableSortedSet(this.sortedSet.subSet(from, to));
        }

        public FloatSortedSet headSet(float to) {
            return new UnmodifiableSortedSet(this.sortedSet.headSet(to));
        }

        public FloatSortedSet tailSet(float from) {
            return new UnmodifiableSortedSet(this.sortedSet.tailSet(from));
        }

        public FloatBidirectionalIterator iterator(float from) {
            return FloatIterators.unmodifiable(this.sortedSet.iterator(from));
        }

        public float firstFloat() {
            return this.sortedSet.firstFloat();
        }

        public float lastFloat() {
            return this.sortedSet.lastFloat();
        }

        public Object first() {
            return this.sortedSet.first();
        }

        public Object last() {
            return this.sortedSet.last();
        }

        public Iterator iterator(Object from) {
            return FloatIterators.unmodifiable(this.sortedSet.iterator(((Float)from).floatValue()));
        }

        public SortedSet subSet(Object from, Object to) {
            return new UnmodifiableSortedSet((FloatSortedSet)this.sortedSet.subSet(from, to));
        }

        public SortedSet headSet(Object to) {
            return new UnmodifiableSortedSet((FloatSortedSet)this.sortedSet.headSet(to));
        }

        public SortedSet tailSet(Object from) {
            return new UnmodifiableSortedSet((FloatSortedSet)this.sortedSet.tailSet(from));
        }
    }

    public static class SynchronizedSortedSet
    extends FloatSets.SynchronizedSet
    implements FloatSortedSet,
    Serializable {
        public static final long serialVersionUID = -7046029254386353129L;
        protected final FloatSortedSet sortedSet;

        protected SynchronizedSortedSet(FloatSortedSet s, Object sync) {
            super(s, sync);
            this.sortedSet = s;
        }

        protected SynchronizedSortedSet(FloatSortedSet s) {
            super(s);
            this.sortedSet = s;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Comparator comparator() {
            Object object = this.sync;
            synchronized (object) {
                return this.sortedSet.comparator();
            }
        }

        public FloatSortedSet subSet(float from, float to) {
            return new SynchronizedSortedSet(this.sortedSet.subSet(from, to), this.sync);
        }

        public FloatSortedSet headSet(float to) {
            return new SynchronizedSortedSet(this.sortedSet.headSet(to), this.sync);
        }

        public FloatSortedSet tailSet(float from) {
            return new SynchronizedSortedSet(this.sortedSet.tailSet(from), this.sync);
        }

        public FloatBidirectionalIterator iterator(float from) {
            return this.sortedSet.iterator(from);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public float firstFloat() {
            Object object = this.sync;
            synchronized (object) {
                return this.sortedSet.firstFloat();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public float lastFloat() {
            Object object = this.sync;
            synchronized (object) {
                return this.sortedSet.lastFloat();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Object first() {
            Object object = this.sync;
            synchronized (object) {
                return this.sortedSet.first();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Object last() {
            Object object = this.sync;
            synchronized (object) {
                return this.sortedSet.last();
            }
        }

        public Iterator iterator(Object from) {
            return this.sortedSet.iterator(((Float)from).floatValue());
        }

        public SortedSet subSet(Object from, Object to) {
            return new SynchronizedSortedSet((FloatSortedSet)this.sortedSet.subSet(from, to), this.sync);
        }

        public SortedSet headSet(Object to) {
            return new SynchronizedSortedSet((FloatSortedSet)this.sortedSet.headSet(to), this.sync);
        }

        public SortedSet tailSet(Object from) {
            return new SynchronizedSortedSet((FloatSortedSet)this.sortedSet.tailSet(from), this.sync);
        }
    }

    public static class Singleton
    extends FloatSets.Singleton
    implements FloatSortedSet,
    Serializable,
    Cloneable {
        public static final long serialVersionUID = -7046029254386353129L;
        final FloatComparator comparator;

        private Singleton(float element, FloatComparator comparator) {
            super(element);
            this.comparator = comparator;
        }

        private Singleton(float element) {
            this(element, (FloatComparator)null);
        }

        final int compare(float k1, float k2) {
            return this.comparator == null ? (k1 < k2 ? -1 : (k1 == k2 ? 0 : 1)) : this.comparator.compare(k1, k2);
        }

        public FloatBidirectionalIterator iterator(float from) {
            FloatBidirectionalIterator i = (FloatBidirectionalIterator)this.floatIterator();
            if (this.compare(this.element, from) <= 0) {
                i.next();
            }
            return i;
        }

        public Comparator comparator() {
            return this.comparator;
        }

        public FloatSortedSet subSet(float from, float to) {
            if (this.compare(from, this.element) <= 0 && this.compare(this.element, to) < 0) {
                return this;
            }
            return Sets.EMPTY_SET;
        }

        public FloatSortedSet headSet(float to) {
            if (this.compare(this.element, to) < 0) {
                return this;
            }
            return Sets.EMPTY_SET;
        }

        public FloatSortedSet tailSet(float from) {
            if (this.compare(from, this.element) <= 0) {
                return this;
            }
            return Sets.EMPTY_SET;
        }

        public float firstFloat() {
            return this.element;
        }

        public float lastFloat() {
            return this.element;
        }

        public Object first() {
            return new Float(this.element);
        }

        public Object last() {
            return new Float(this.element);
        }

        public Iterator iterator(Object from) {
            return this.iterator(((Float)from).floatValue());
        }

        public SortedSet subSet(Object from, Object to) {
            return this.subSet(((Float)from).floatValue(), ((Float)to).floatValue());
        }

        public SortedSet headSet(Object to) {
            return this.headSet(((Float)to).floatValue());
        }

        public SortedSet tailSet(Object from) {
            return this.tailSet(((Float)from).floatValue());
        }
    }
}

