/*
 * Decompiled with CFR 0.152.
 */
package it.unimi.dsi.fastutil.floats;

import it.unimi.dsi.fastutil.floats.FloatCollection;
import it.unimi.dsi.fastutil.floats.FloatIterator;
import it.unimi.dsi.fastutil.floats.FloatIterators;
import java.io.Serializable;
import java.util.Collection;
import java.util.Iterator;

public class FloatCollections {
    private FloatCollections() {
    }

    public static FloatCollection synchronize(FloatCollection c) {
        return new SynchronizedCollection(c);
    }

    public static FloatCollection synchronize(FloatCollection c, Object sync) {
        return new SynchronizedCollection(c, sync);
    }

    public static FloatCollection unmodifiable(FloatCollection c) {
        return new UnmodifiableCollection(c);
    }

    public static class UnmodifiableCollection
    implements FloatCollection,
    Serializable {
        public static final long serialVersionUID = -7046029254386353129L;
        protected final FloatCollection collection;

        protected UnmodifiableCollection(FloatCollection c) {
            if (c == null) {
                throw new NullPointerException();
            }
            this.collection = c;
        }

        public int size() {
            return this.collection.size();
        }

        public boolean isEmpty() {
            return this.collection.isEmpty();
        }

        public boolean contains(float o) {
            return this.collection.contains(o);
        }

        public float[] toFloatArray() {
            return this.collection.toFloatArray();
        }

        public float[] toFloatArray(float[] a) {
            return this.collection.toFloatArray(a);
        }

        public Iterator iterator() {
            return FloatIterators.unmodifiable((FloatIterator)this.collection.iterator());
        }

        public FloatIterator floatIterator() {
            return FloatIterators.unmodifiable(this.collection.floatIterator());
        }

        public boolean add(float k) {
            throw new UnsupportedOperationException();
        }

        public boolean rem(float k) {
            throw new UnsupportedOperationException();
        }

        public boolean remove(Object ok) {
            throw new UnsupportedOperationException();
        }

        public boolean addAll(Collection c) {
            throw new UnsupportedOperationException();
        }

        public boolean containsAll(Collection c) {
            return this.collection.containsAll(c);
        }

        public boolean removeAll(Collection c) {
            throw new UnsupportedOperationException();
        }

        public boolean retainAll(Collection c) {
            throw new UnsupportedOperationException();
        }

        public boolean addAll(FloatCollection c) {
            throw new UnsupportedOperationException();
        }

        public boolean containsAll(FloatCollection c) {
            return this.collection.containsAll(c);
        }

        public boolean removeAll(FloatCollection c) {
            throw new UnsupportedOperationException();
        }

        public boolean retainAll(FloatCollection c) {
            throw new UnsupportedOperationException();
        }

        public void clear() {
            throw new UnsupportedOperationException();
        }

        public String toString() {
            return this.collection.toString();
        }

        public boolean add(Object k) {
            throw new UnsupportedOperationException();
        }

        public boolean contains(Object k) {
            return this.collection.contains(k);
        }

        public Object[] toArray() {
            return this.collection.toArray();
        }

        public Object[] toArray(Object[] a) {
            return this.collection.toArray(a);
        }

        public float[] toArray(float[] a) {
            return this.collection.toFloatArray(a);
        }
    }

    public static class SynchronizedCollection
    implements FloatCollection,
    Serializable {
        public static final long serialVersionUID = -7046029254386353129L;
        protected final FloatCollection collection;
        protected final Object sync;

        protected SynchronizedCollection(FloatCollection c, Object sync) {
            if (c == null) {
                throw new NullPointerException();
            }
            this.collection = c;
            this.sync = sync;
        }

        protected SynchronizedCollection(FloatCollection c) {
            if (c == null) {
                throw new NullPointerException();
            }
            this.collection = c;
            this.sync = this;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public int size() {
            Object object = this.sync;
            synchronized (object) {
                return this.collection.size();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean isEmpty() {
            Object object = this.sync;
            synchronized (object) {
                return this.collection.isEmpty();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean contains(float o) {
            Object object = this.sync;
            synchronized (object) {
                return this.collection.contains(o);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public float[] toFloatArray() {
            Object object = this.sync;
            synchronized (object) {
                return this.collection.toFloatArray();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public float[] toFloatArray(float[] a) {
            Object object = this.sync;
            synchronized (object) {
                return this.collection.toFloatArray(a);
            }
        }

        public Iterator iterator() {
            return this.collection.iterator();
        }

        public FloatIterator floatIterator() {
            return this.collection.floatIterator();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean add(float k) {
            Object object = this.sync;
            synchronized (object) {
                return this.collection.add(k);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean rem(float k) {
            Object object = this.sync;
            synchronized (object) {
                return this.collection.rem(k);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean remove(Object ok) {
            Object object = this.sync;
            synchronized (object) {
                return this.collection.remove(ok);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean addAll(Collection c) {
            Object object = this.sync;
            synchronized (object) {
                return this.collection.addAll(c);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean containsAll(Collection c) {
            Object object = this.sync;
            synchronized (object) {
                return this.collection.containsAll(c);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean removeAll(Collection c) {
            Object object = this.sync;
            synchronized (object) {
                return this.collection.removeAll(c);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean retainAll(Collection c) {
            Object object = this.sync;
            synchronized (object) {
                return this.collection.retainAll(c);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean addAll(FloatCollection c) {
            Object object = this.sync;
            synchronized (object) {
                return this.collection.addAll(c);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean containsAll(FloatCollection c) {
            Object object = this.sync;
            synchronized (object) {
                return this.collection.containsAll(c);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean removeAll(FloatCollection c) {
            Object object = this.sync;
            synchronized (object) {
                return this.collection.removeAll(c);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean retainAll(FloatCollection c) {
            Object object = this.sync;
            synchronized (object) {
                return this.collection.retainAll(c);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void clear() {
            Object object = this.sync;
            synchronized (object) {
                this.collection.clear();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public String toString() {
            Object object = this.sync;
            synchronized (object) {
                return this.collection.toString();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean add(Object k) {
            Object object = this.sync;
            synchronized (object) {
                return this.collection.add(k);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean contains(Object k) {
            Object object = this.sync;
            synchronized (object) {
                return this.collection.contains(k);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Object[] toArray() {
            Object object = this.sync;
            synchronized (object) {
                return this.collection.toArray();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Object[] toArray(Object[] a) {
            Object object = this.sync;
            synchronized (object) {
                return this.collection.toArray(a);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public float[] toArray(float[] a) {
            Object object = this.sync;
            synchronized (object) {
                return this.collection.toFloatArray(a);
            }
        }
    }
}

