/*
 * Decompiled with CFR 0.152.
 */
package it.unimi.dsi.fastutil.floats;

import it.unimi.dsi.fastutil.Arrays;
import it.unimi.dsi.fastutil.Hash;
import it.unimi.dsi.fastutil.HashCommon;
import java.io.Serializable;

public class FloatArrays {
    private static final long ONEOVERPHI = 106039L;
    public static final float[] EMPTY_ARRAY = new float[0];
    public static final Hash.Strategy HASH_STRATEGY = new ArrayHashStrategy();

    private FloatArrays() {
    }

    public static float[] ensureCapacity(float[] array, int length) {
        if (length > array.length) {
            float[] t = new float[length];
            System.arraycopy(array, 0, t, 0, array.length);
            return t;
        }
        return array;
    }

    public static float[] ensureCapacity(float[] array, int length, int preserve) {
        if (length > array.length) {
            float[] t = new float[length];
            System.arraycopy(array, 0, t, 0, preserve);
            return t;
        }
        return array;
    }

    public static float[] grow(float[] array, int length) {
        if (length > array.length) {
            int newLength = (int)Math.min(Math.max(106039L * (long)array.length >>> 16, (long)length), Integer.MAX_VALUE);
            float[] t = new float[newLength];
            System.arraycopy(array, 0, t, 0, array.length);
            return t;
        }
        return array;
    }

    public static float[] grow(float[] array, int length, int preserve) {
        if (length > array.length) {
            int newLength = (int)Math.min(Math.max(106039L * (long)array.length >>> 16, (long)length), Integer.MAX_VALUE);
            try {
                float[] t = new float[newLength];
                System.arraycopy(array, 0, t, 0, preserve);
                return t;
            }
            catch (Error T) {
                System.err.println(newLength);
                throw T;
            }
        }
        return array;
    }

    public static float[] trim(float[] array, int length) {
        if (length >= array.length) {
            return array;
        }
        float[] t = length == 0 ? EMPTY_ARRAY : new float[length];
        System.arraycopy(array, 0, t, 0, length);
        return t;
    }

    public static float[] setLength(float[] array, int length) {
        if (length == array.length) {
            return array;
        }
        if (length < array.length) {
            return FloatArrays.trim(array, length);
        }
        return FloatArrays.ensureCapacity(array, length);
    }

    public static float[] copy(float[] array, int offset, int length) {
        FloatArrays.ensureOffsetLength(array, offset, length);
        float[] a = length == 0 ? EMPTY_ARRAY : new float[length];
        System.arraycopy(array, offset, a, 0, length);
        return a;
    }

    public static float[] copy(float[] array) {
        return (float[])array.clone();
    }

    public static void fill(float[] array, float value) {
        int i = array.length;
        while (i-- != 0) {
            array[i] = value;
        }
    }

    public static void fill(float[] array, int from, int to, float value) {
        FloatArrays.ensureFromTo(array, from, to);
        if (from == 0) {
            while (to-- != 0) {
                array[to] = value;
            }
        } else {
            for (int i = from; i < to; ++i) {
                array[i] = value;
            }
        }
    }

    public static boolean equals(float[] a1, float[] a2) {
        int i = a1.length;
        if (i != a2.length) {
            return false;
        }
        while (i-- != 0) {
            if (a1[i] == a2[i]) continue;
            return false;
        }
        return true;
    }

    public static void ensureFromTo(float[] a, int from, int to) {
        Arrays.ensureFromTo(a.length, from, to);
    }

    public static void ensureOffsetLength(float[] a, int offset, int length) {
        Arrays.ensureOffsetLength(a.length, offset, length);
    }

    private static final class ArrayHashStrategy
    implements Hash.Strategy,
    Serializable {
        private ArrayHashStrategy() {
        }

        public int hashCode(Object o) {
            if (o == null) {
                return 0;
            }
            if (o == HashCommon.REMOVED) {
                return HashCommon.REMOVED.hashCode();
            }
            float[] a = (float[])o;
            int i = a.length;
            int hashCode = -1;
            while (i-- != 0) {
                hashCode = 31 * hashCode + HashCommon.float2int(a[i]);
            }
            return hashCode;
        }

        public boolean equals(Object a, Object b) {
            if (a == null) {
                return b == null;
            }
            if (a == HashCommon.REMOVED || b == HashCommon.REMOVED) {
                return a == b;
            }
            return FloatArrays.equals((float[])a, (float[])b);
        }
    }
}

