/*
 * Decompiled with CFR 0.152.
 */
package it.unimi.dsi.fastutil.floats;

import it.unimi.dsi.fastutil.floats.AbstractFloatPriorityQueue;
import it.unimi.dsi.fastutil.floats.FloatArrays;
import it.unimi.dsi.fastutil.floats.FloatComparator;
import java.util.Comparator;
import java.util.NoSuchElementException;

public class FloatArrayPriorityQueue
extends AbstractFloatPriorityQueue {
    protected float[] array = FloatArrays.EMPTY_ARRAY;
    protected int size;
    protected FloatComparator c;

    public FloatArrayPriorityQueue(int capacity, FloatComparator c) {
        if (capacity > 0) {
            this.array = new float[capacity];
        }
        this.c = c;
    }

    public FloatArrayPriorityQueue(int capacity) {
        this(capacity, null);
    }

    public FloatArrayPriorityQueue(FloatComparator c) {
        this(0, c);
    }

    public FloatArrayPriorityQueue() {
        this(0, null);
    }

    public FloatArrayPriorityQueue(float[] a, int size, FloatComparator c) {
        this(c);
        this.array = a;
        this.size = size;
    }

    public FloatArrayPriorityQueue(float[] a, FloatComparator c) {
        this(a, a.length, c);
    }

    public FloatArrayPriorityQueue(float[] a, int size) {
        this(a, size, null);
    }

    public FloatArrayPriorityQueue(float[] a) {
        this(a, a.length);
    }

    private int findFirst() {
        int i = this.size;
        int firstIndex = --i;
        float first = this.array[firstIndex];
        if (this.c == null) {
            while (i-- != 0) {
                if (!(this.array[i] < first)) continue;
                firstIndex = i;
                first = this.array[firstIndex];
            }
        } else {
            while (i-- != 0) {
                if (this.c.compare(this.array[i], first) >= 0) continue;
                firstIndex = i;
                first = this.array[firstIndex];
            }
        }
        return firstIndex;
    }

    private void ensureNonEmpty() {
        if (this.size == 0) {
            throw new NoSuchElementException();
        }
    }

    public void enqueue(float x) {
        if (this.size == this.array.length) {
            this.array = FloatArrays.grow(this.array, this.size + 1);
        }
        this.array[this.size++] = x;
    }

    public float dequeueFloat() {
        this.ensureNonEmpty();
        int first = this.findFirst();
        float result = this.array[first];
        System.arraycopy(this.array, first + 1, this.array, first, --this.size - first);
        return result;
    }

    public float firstFloat() {
        this.ensureNonEmpty();
        return this.array[this.findFirst()];
    }

    public void changed() {
        this.ensureNonEmpty();
    }

    public int size() {
        return this.size;
    }

    public void clear() {
        this.size = 0;
    }

    public void trim() {
        this.array = FloatArrays.trim(this.array, this.size);
    }

    public Comparator comparator() {
        return this.c;
    }
}

