/*
 * Decompiled with CFR 0.152.
 */
package it.unimi.dsi.fastutil.floats;

import it.unimi.dsi.fastutil.IndirectDoublePriorityQueue;
import it.unimi.dsi.fastutil.floats.FloatArrayIndirectPriorityQueue;
import it.unimi.dsi.fastutil.floats.FloatComparator;
import it.unimi.dsi.fastutil.floats.FloatComparators;
import java.util.Comparator;

public class FloatArrayIndirectDoublePriorityQueue
extends FloatArrayIndirectPriorityQueue
implements IndirectDoublePriorityQueue {
    protected FloatComparator secondaryComparator;

    public FloatArrayIndirectDoublePriorityQueue(float[] refArray, int capacity, FloatComparator c, FloatComparator d) {
        super(refArray, capacity, c);
        this.secondaryComparator = d;
    }

    public FloatArrayIndirectDoublePriorityQueue(float[] refArray, int capacity, FloatComparator c) {
        super(refArray, capacity, c == null ? FloatComparators.OPPOSITE_COMPARATOR : FloatComparators.oppositeComparator(c));
    }

    public FloatArrayIndirectDoublePriorityQueue(float[] refArray, int capacity) {
        this(refArray, capacity, null);
    }

    public FloatArrayIndirectDoublePriorityQueue(float[] refArray, FloatComparator c, FloatComparator d) {
        this(refArray, refArray.length, c, d);
    }

    public FloatArrayIndirectDoublePriorityQueue(float[] refArray, FloatComparator c) {
        this(refArray, refArray.length, c);
    }

    public FloatArrayIndirectDoublePriorityQueue(float[] refArray) {
        this(refArray, refArray.length, null);
    }

    public FloatArrayIndirectDoublePriorityQueue(float[] refArray, int[] a, int size, FloatComparator c, FloatComparator d) {
        this(refArray, 0, c, d);
        this.array = a;
        this.size = size;
    }

    public FloatArrayIndirectDoublePriorityQueue(float[] refArray, int[] a, FloatComparator c, FloatComparator d) {
        this(refArray, a, a.length, c, d);
    }

    public FloatArrayIndirectDoublePriorityQueue(float[] refArray, int[] a, int size, FloatComparator c) {
        this(refArray, 0, c);
        this.array = a;
        this.size = size;
    }

    public FloatArrayIndirectDoublePriorityQueue(float[] refArray, int[] a, FloatComparator c) {
        this(refArray, a, a.length, c);
    }

    public FloatArrayIndirectDoublePriorityQueue(float[] refArray, int[] a, int size) {
        this(refArray, a, size, null);
    }

    public FloatArrayIndirectDoublePriorityQueue(float[] refArray, int[] a) {
        this(refArray, a, a.length);
    }

    private int findSecondaryFirst() {
        int i = this.size;
        int firstIndex = --i;
        float first = this.refArray[this.array[firstIndex]];
        if (this.secondaryComparator == null) {
            while (i-- != 0) {
                if (!(this.refArray[this.array[i]] < first)) continue;
                firstIndex = i;
                first = this.refArray[this.array[firstIndex]];
            }
        } else {
            while (i-- != 0) {
                if (this.secondaryComparator.compare(this.refArray[this.array[i]], first) >= 0) continue;
                firstIndex = i;
                first = this.refArray[this.array[firstIndex]];
            }
        }
        return firstIndex;
    }

    private int findSecondaryLast() {
        int i = this.size;
        int lastIndex = --i;
        float last = this.refArray[this.array[lastIndex]];
        if (this.secondaryComparator == null) {
            while (i-- != 0) {
                if (!(last < this.refArray[this.array[i]])) continue;
                lastIndex = i;
                last = this.refArray[this.array[lastIndex]];
            }
        } else {
            while (i-- != 0) {
                if (this.secondaryComparator.compare(last, this.refArray[this.array[i]]) >= 0) continue;
                lastIndex = i;
                last = this.refArray[this.array[lastIndex]];
            }
        }
        return lastIndex;
    }

    public int secondaryFirst() {
        return this.array[this.findSecondaryFirst()];
    }

    public int secondaryLast() {
        return this.array[this.findSecondaryLast()];
    }

    public void changed(int i) {
    }

    public Comparator secondaryComparator() {
        return this.secondaryComparator;
    }
}

