/*
 * Decompiled with CFR 0.152.
 */
package it.unimi.dsi.fastutil.floats;

import it.unimi.dsi.fastutil.HashCommon;
import it.unimi.dsi.fastutil.Sets;
import it.unimi.dsi.fastutil.floats.AbstractFloat2ObjectMap;
import it.unimi.dsi.fastutil.floats.Float2ObjectMap;
import it.unimi.dsi.fastutil.floats.FloatSet;
import it.unimi.dsi.fastutil.floats.FloatSets;
import it.unimi.dsi.fastutil.objects.ObjectCollection;
import it.unimi.dsi.fastutil.objects.ObjectCollections;
import it.unimi.dsi.fastutil.objects.ObjectSet;
import it.unimi.dsi.fastutil.objects.ObjectSets;
import java.io.Serializable;
import java.util.Collection;
import java.util.Map;
import java.util.Set;

public class Float2ObjectMaps {
    public static final EmptyMap EMPTY_MAP = new EmptyMap();

    private Float2ObjectMaps() {
    }

    public static Float2ObjectMap singleton(float key, Object value) {
        return new Singleton(key, value);
    }

    public static Float2ObjectMap singleton(Object key, Object value) {
        return new Singleton(((Float)key).floatValue(), value);
    }

    public static Float2ObjectMap synchronize(Float2ObjectMap m) {
        return new SynchronizedMap(m);
    }

    public static Float2ObjectMap synchronize(Float2ObjectMap m, Object sync) {
        return new SynchronizedMap(m, sync);
    }

    public static Float2ObjectMap unmodifiable(Float2ObjectMap m) {
        return new UnmodifiableMap(m);
    }

    public static class UnmodifiableMap
    extends AbstractFloat2ObjectMap
    implements Float2ObjectMap,
    Serializable {
        public static final long serialVersionUID = -7046029254386353129L;
        protected final Float2ObjectMap map;
        protected volatile transient Set entries;
        protected volatile transient Set keys;
        protected volatile transient Collection values;

        protected UnmodifiableMap(Float2ObjectMap m) {
            if (m == null) {
                throw new NullPointerException();
            }
            this.map = m;
        }

        public Object remove(Object ok) {
            throw new UnsupportedOperationException();
        }

        public Object get(Object ok) {
            return this.map.get(ok);
        }

        public int size() {
            return this.map.size();
        }

        public boolean containsKey(float k) {
            return this.map.containsKey(k);
        }

        public boolean containsValue(Object v) {
            return this.map.containsValue(v);
        }

        public Object defaultReturnValue() {
            throw new UnsupportedOperationException();
        }

        public void defaultReturnValue(Object defRetValue) {
            throw new UnsupportedOperationException();
        }

        public Object put(float k, Object v) {
            throw new UnsupportedOperationException();
        }

        public void putAll(Float2ObjectMap c) {
            throw new UnsupportedOperationException();
        }

        public void putAll(Map m) {
            throw new UnsupportedOperationException();
        }

        public Set entrySet() {
            if (this.entries == null) {
                this.entries = ObjectSets.unmodifiable((ObjectSet)this.map.entrySet());
            }
            return this.entries;
        }

        public Set keySet() {
            if (this.keys == null) {
                this.keys = FloatSets.unmodifiable((FloatSet)this.map.keySet());
            }
            return this.keys;
        }

        public Collection values() {
            if (this.values == null) {
                return ObjectCollections.unmodifiable((ObjectCollection)this.map.values());
            }
            return this.values;
        }

        public void clear() {
            throw new UnsupportedOperationException();
        }

        public String toString() {
            return this.map.toString();
        }

        public Object put(Object k, Object v) {
            throw new UnsupportedOperationException();
        }

        public Object remove(float k) {
            throw new UnsupportedOperationException();
        }

        public Object get(float k) {
            return this.map.get(k);
        }

        public boolean containsKey(Object ok) {
            return this.map.containsKey(ok);
        }
    }

    public static class SynchronizedMap
    extends AbstractFloat2ObjectMap
    implements Float2ObjectMap,
    Serializable {
        public static final long serialVersionUID = -7046029254386353129L;
        protected final Float2ObjectMap map;
        protected final Object sync;
        protected volatile transient Set entries;
        protected volatile transient Set keys;
        protected volatile transient Collection values;

        protected SynchronizedMap(Float2ObjectMap m, Object sync) {
            if (m == null) {
                throw new NullPointerException();
            }
            this.map = m;
            this.sync = sync;
        }

        protected SynchronizedMap(Float2ObjectMap m) {
            if (m == null) {
                throw new NullPointerException();
            }
            this.map = m;
            this.sync = this;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Object remove(Object ok) {
            Object object = this.sync;
            synchronized (object) {
                return this.map.remove(ok);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Object get(Object ok) {
            Object object = this.sync;
            synchronized (object) {
                return this.map.get(ok);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public int size() {
            Object object = this.sync;
            synchronized (object) {
                return this.map.size();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean containsKey(float k) {
            Object object = this.sync;
            synchronized (object) {
                return this.map.containsKey(k);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean containsValue(Object v) {
            Object object = this.sync;
            synchronized (object) {
                return this.map.containsValue(v);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Object defaultReturnValue() {
            Object object = this.sync;
            synchronized (object) {
                return this.map.defaultReturnValue();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void defaultReturnValue(Object defRetValue) {
            Object object = this.sync;
            synchronized (object) {
                this.map.defaultReturnValue(defRetValue);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Object put(float k, Object v) {
            Object object = this.sync;
            synchronized (object) {
                return this.map.put(k, v);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void putAll(Float2ObjectMap c) {
            Object object = this.sync;
            synchronized (object) {
                this.map.putAll(c);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void putAll(Map m) {
            Object object = this.sync;
            synchronized (object) {
                this.map.putAll(m);
            }
        }

        public Set entrySet() {
            if (this.entries == null) {
                this.entries = ObjectSets.synchronize((ObjectSet)this.map.entrySet(), this.sync);
            }
            return this.entries;
        }

        public Set keySet() {
            if (this.keys == null) {
                this.keys = FloatSets.synchronize((FloatSet)this.map.keySet(), this.sync);
            }
            return this.keys;
        }

        public Collection values() {
            if (this.values == null) {
                return ObjectCollections.synchronize((ObjectCollection)this.map.values(), this.sync);
            }
            return this.values;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void clear() {
            Object object = this.sync;
            synchronized (object) {
                this.map.clear();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public String toString() {
            Object object = this.sync;
            synchronized (object) {
                return this.map.toString();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Object put(Object k, Object v) {
            Object object = this.sync;
            synchronized (object) {
                return this.map.put(k, v);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Object remove(float k) {
            Object object = this.sync;
            synchronized (object) {
                return this.map.remove(k);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Object get(float k) {
            Object object = this.sync;
            synchronized (object) {
                return this.map.get(k);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean containsKey(Object ok) {
            Object object = this.sync;
            synchronized (object) {
                return this.map.containsKey(ok);
            }
        }
    }

    public static class Singleton
    extends AbstractFloat2ObjectMap
    implements Serializable,
    Cloneable {
        public static final long serialVersionUID = -7046029254386353129L;
        protected final float key;
        protected final Object value;
        protected volatile transient Set entries;
        protected volatile transient Set keys;
        protected volatile transient Collection values;

        protected Singleton(float key, Object value) {
            this.key = key;
            this.value = value;
        }

        public boolean containsKey(float k) {
            return this.key == k;
        }

        public boolean containsValue(Object v) {
            return this.value == null ? v == null : this.value.equals(v);
        }

        public void putAll(Map m) {
            throw new UnsupportedOperationException();
        }

        public Set entrySet() {
            if (this.entries == null) {
                this.entries = ObjectSets.singleton(new SingletonEntry());
            }
            return this.entries;
        }

        public Set keySet() {
            if (this.keys == null) {
                this.keys = FloatSets.singleton(this.key);
            }
            return this.keys;
        }

        public Collection values() {
            if (this.values == null) {
                this.values = ObjectSets.singleton(this.value);
            }
            return this.values;
        }

        public Object get(float k) {
            if (this.key == k) {
                return this.value;
            }
            return this.defRetValue;
        }

        public int size() {
            return 1;
        }

        public Object clone() {
            return this;
        }

        private class SingletonEntry
        implements Float2ObjectMap.Entry {
            private SingletonEntry() {
            }

            public Object getKey() {
                return new Float(Singleton.this.key);
            }

            public Object getValue() {
                return Singleton.this.value;
            }

            public float getFloatKey() {
                return Singleton.this.key;
            }

            public Object setValue(Object value) {
                throw new UnsupportedOperationException();
            }

            public boolean equals(Object o) {
                if (!(o instanceof Map.Entry)) {
                    return false;
                }
                Map.Entry e = (Map.Entry)o;
                return Singleton.this.key == ((Float)e.getKey()).floatValue() && (Singleton.this.value == null ? e.getValue() == null : Singleton.this.value.equals(e.getValue()));
            }

            public int hashCode() {
                return HashCommon.float2int(Singleton.this.key) ^ (Singleton.this.value == null ? 0 : Singleton.this.value.hashCode());
            }

            public String toString() {
                return Singleton.this.key + "->" + Singleton.this.value;
            }
        }
    }

    public static class EmptyMap
    extends AbstractFloat2ObjectMap
    implements Serializable,
    Cloneable {
        public static final long serialVersionUID = -7046029254386353129L;

        protected EmptyMap() {
        }

        public Object put(float k, Object v) {
            throw new UnsupportedOperationException();
        }

        public Object get(Object ok) {
            return null;
        }

        public boolean containsKey(float k) {
            return false;
        }

        public boolean containsValue(Object v) {
            return false;
        }

        public Object defaultReturnValue() {
            return null;
        }

        public void defaultReturnValue(Object defRetValue) {
            throw new UnsupportedOperationException();
        }

        public void putAll(Map m) {
            throw new UnsupportedOperationException();
        }

        public Set entrySet() {
            return Sets.EMPTY_SET;
        }

        public Set keySet() {
            return Sets.EMPTY_SET;
        }

        public Collection values() {
            return Sets.EMPTY_SET;
        }

        public Object put(Object k, Object v) {
            throw new UnsupportedOperationException();
        }

        public Object get(float k) {
            return null;
        }

        public boolean containsKey(Object ok) {
            return false;
        }

        public int size() {
            return 0;
        }

        public void clear() {
        }

        private Object readResolve() {
            return EMPTY_MAP;
        }

        public Object clone() {
            return EMPTY_MAP;
        }
    }
}

