/*
 * Decompiled with CFR 0.152.
 */
package it.unimi.dsi.fastutil.floats;

import it.unimi.dsi.fastutil.floats.Float2DoubleMaps;
import it.unimi.dsi.fastutil.floats.Float2DoubleSortedMap;
import it.unimi.dsi.fastutil.floats.FloatComparator;
import it.unimi.dsi.fastutil.floats.FloatSortedSets;
import java.io.Serializable;
import java.util.Comparator;
import java.util.NoSuchElementException;
import java.util.Set;
import java.util.SortedMap;

public class Float2DoubleSortedMaps {
    public static final EmptySortedMap EMPTY_MAP = new EmptySortedMap();

    private Float2DoubleSortedMaps() {
    }

    public static Float2DoubleSortedMap singleton(float key, double value) {
        return new Singleton(key, value);
    }

    public static Float2DoubleSortedMap singleton(float key, double value, FloatComparator comparator) {
        return new Singleton(key, value, comparator);
    }

    public static Float2DoubleSortedMap singleton(Object key, Object value) {
        return new Singleton(((Float)key).floatValue(), (Double)value);
    }

    public static Float2DoubleSortedMap singleton(Object key, Object value, FloatComparator comparator) {
        return new Singleton(((Float)key).floatValue(), (Double)value, comparator);
    }

    public static Float2DoubleSortedMap synchronize(Float2DoubleSortedMap m) {
        return new SynchronizedSortedMap(m);
    }

    public static Float2DoubleSortedMap synchronize(Float2DoubleSortedMap m, Object sync) {
        return new SynchronizedSortedMap(m, sync);
    }

    public static Float2DoubleSortedMap unmodifiable(Float2DoubleSortedMap m) {
        return new UnmodifiableSortedMap(m);
    }

    public static class UnmodifiableSortedMap
    extends Float2DoubleMaps.UnmodifiableMap
    implements Float2DoubleSortedMap,
    Serializable {
        public static final long serialVersionUID = -7046029254386353129L;
        protected final Float2DoubleSortedMap sortedMap;

        protected UnmodifiableSortedMap(Float2DoubleSortedMap m) {
            super(m);
            this.sortedMap = m;
        }

        public Comparator comparator() {
            return this.sortedMap.comparator();
        }

        public Float2DoubleSortedMap subMap(float from, float to) {
            return new UnmodifiableSortedMap(this.sortedMap.subMap(from, to));
        }

        public Float2DoubleSortedMap headMap(float to) {
            return new UnmodifiableSortedMap(this.sortedMap.headMap(to));
        }

        public Float2DoubleSortedMap tailMap(float from) {
            return new UnmodifiableSortedMap(this.sortedMap.tailMap(from));
        }

        public float firstFloatKey() {
            return this.sortedMap.firstFloatKey();
        }

        public float lastFloatKey() {
            return this.sortedMap.lastFloatKey();
        }

        public Object firstKey() {
            return this.sortedMap.firstKey();
        }

        public Object lastKey() {
            return this.sortedMap.lastKey();
        }

        public SortedMap subMap(Object from, Object to) {
            return new UnmodifiableSortedMap((Float2DoubleSortedMap)this.sortedMap.subMap(from, to));
        }

        public SortedMap headMap(Object to) {
            return new UnmodifiableSortedMap((Float2DoubleSortedMap)this.sortedMap.headMap(to));
        }

        public SortedMap tailMap(Object from) {
            return new UnmodifiableSortedMap((Float2DoubleSortedMap)this.sortedMap.tailMap(from));
        }
    }

    public static class SynchronizedSortedMap
    extends Float2DoubleMaps.SynchronizedMap
    implements Float2DoubleSortedMap,
    Serializable {
        public static final long serialVersionUID = -7046029254386353129L;
        protected final Float2DoubleSortedMap sortedMap;

        protected SynchronizedSortedMap(Float2DoubleSortedMap m, Object sync) {
            super(m, sync);
            this.sortedMap = m;
        }

        protected SynchronizedSortedMap(Float2DoubleSortedMap m) {
            super(m);
            this.sortedMap = m;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Comparator comparator() {
            Object object = this.sync;
            synchronized (object) {
                return this.sortedMap.comparator();
            }
        }

        public Float2DoubleSortedMap subMap(float from, float to) {
            return new SynchronizedSortedMap(this.sortedMap.subMap(from, to), this.sync);
        }

        public Float2DoubleSortedMap headMap(float to) {
            return new SynchronizedSortedMap(this.sortedMap.headMap(to), this.sync);
        }

        public Float2DoubleSortedMap tailMap(float from) {
            return new SynchronizedSortedMap(this.sortedMap.tailMap(from), this.sync);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public float firstFloatKey() {
            Object object = this.sync;
            synchronized (object) {
                return this.sortedMap.firstFloatKey();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public float lastFloatKey() {
            Object object = this.sync;
            synchronized (object) {
                return this.sortedMap.lastFloatKey();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Object firstKey() {
            Object object = this.sync;
            synchronized (object) {
                return this.sortedMap.firstKey();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Object lastKey() {
            Object object = this.sync;
            synchronized (object) {
                return this.sortedMap.lastKey();
            }
        }

        public SortedMap subMap(Object from, Object to) {
            return new SynchronizedSortedMap((Float2DoubleSortedMap)this.sortedMap.subMap(from, to), this.sync);
        }

        public SortedMap headMap(Object to) {
            return new SynchronizedSortedMap((Float2DoubleSortedMap)this.sortedMap.headMap(to), this.sync);
        }

        public SortedMap tailMap(Object from) {
            return new SynchronizedSortedMap((Float2DoubleSortedMap)this.sortedMap.tailMap(from), this.sync);
        }
    }

    public static class Singleton
    extends Float2DoubleMaps.Singleton
    implements Float2DoubleSortedMap,
    Serializable,
    Cloneable {
        public static final long serialVersionUID = -7046029254386353129L;
        protected final FloatComparator comparator;

        protected Singleton(float key, double value, FloatComparator comparator) {
            super(key, value);
            this.comparator = comparator;
        }

        protected Singleton(float key, double value) {
            this(key, value, null);
        }

        final int compare(float k1, float k2) {
            return this.comparator == null ? (k1 < k2 ? -1 : (k1 == k2 ? 0 : 1)) : this.comparator.compare(k1, k2);
        }

        public Comparator comparator() {
            return this.comparator;
        }

        public Set keySet() {
            if (this.keys == null) {
                this.keys = FloatSortedSets.singleton(this.key, this.comparator);
            }
            return this.keys;
        }

        public Float2DoubleSortedMap subMap(float from, float to) {
            if (this.compare(from, this.key) <= 0 && this.compare(this.key, to) < 0) {
                return this;
            }
            return EMPTY_MAP;
        }

        public Float2DoubleSortedMap headMap(float to) {
            if (this.compare(this.key, to) < 0) {
                return this;
            }
            return EMPTY_MAP;
        }

        public Float2DoubleSortedMap tailMap(float from) {
            if (this.compare(from, this.key) <= 0) {
                return this;
            }
            return EMPTY_MAP;
        }

        public float firstFloatKey() {
            return this.key;
        }

        public float lastFloatKey() {
            return this.key;
        }

        public SortedMap headMap(Object oto) {
            return this.headMap(((Float)oto).floatValue());
        }

        public SortedMap tailMap(Object ofrom) {
            return this.tailMap(((Float)ofrom).floatValue());
        }

        public SortedMap subMap(Object ofrom, Object oto) {
            return this.subMap(((Float)ofrom).floatValue(), ((Float)oto).floatValue());
        }

        public Object firstKey() {
            return new Float(this.firstFloatKey());
        }

        public Object lastKey() {
            return new Float(this.lastFloatKey());
        }
    }

    public static class EmptySortedMap
    extends Float2DoubleMaps.EmptyMap
    implements Float2DoubleSortedMap,
    Serializable,
    Cloneable {
        public static final long serialVersionUID = -7046029254386353129L;

        protected EmptySortedMap() {
        }

        public Comparator comparator() {
            return null;
        }

        public Float2DoubleSortedMap subMap(float from, float to) {
            return EMPTY_MAP;
        }

        public Float2DoubleSortedMap headMap(float to) {
            return EMPTY_MAP;
        }

        public Float2DoubleSortedMap tailMap(float from) {
            return EMPTY_MAP;
        }

        public float firstFloatKey() {
            throw new NoSuchElementException();
        }

        public float lastFloatKey() {
            throw new NoSuchElementException();
        }

        public SortedMap headMap(Object oto) {
            return this.headMap(((Float)oto).floatValue());
        }

        public SortedMap tailMap(Object ofrom) {
            return this.tailMap(((Float)ofrom).floatValue());
        }

        public SortedMap subMap(Object ofrom, Object oto) {
            return this.subMap(((Float)ofrom).floatValue(), ((Float)oto).floatValue());
        }

        public Object firstKey() {
            return new Float(this.firstFloatKey());
        }

        public Object lastKey() {
            return new Float(this.lastFloatKey());
        }
    }
}

