/*
 * Decompiled with CFR 0.152.
 */
package it.unimi.dsi.fastutil.floats;

import it.unimi.dsi.fastutil.floats.Float2CharMaps;
import it.unimi.dsi.fastutil.floats.Float2CharSortedMap;
import it.unimi.dsi.fastutil.floats.FloatComparator;
import it.unimi.dsi.fastutil.floats.FloatSortedSets;
import java.io.Serializable;
import java.util.Comparator;
import java.util.NoSuchElementException;
import java.util.Set;
import java.util.SortedMap;

public class Float2CharSortedMaps {
    public static final EmptySortedMap EMPTY_MAP = new EmptySortedMap();

    private Float2CharSortedMaps() {
    }

    public static Float2CharSortedMap singleton(float key, char value) {
        return new Singleton(key, value);
    }

    public static Float2CharSortedMap singleton(float key, char value, FloatComparator comparator) {
        return new Singleton(key, value, comparator);
    }

    public static Float2CharSortedMap singleton(Object key, Object value) {
        return new Singleton(((Float)key).floatValue(), ((Character)value).charValue());
    }

    public static Float2CharSortedMap singleton(Object key, Object value, FloatComparator comparator) {
        return new Singleton(((Float)key).floatValue(), ((Character)value).charValue(), comparator);
    }

    public static Float2CharSortedMap synchronize(Float2CharSortedMap m) {
        return new SynchronizedSortedMap(m);
    }

    public static Float2CharSortedMap synchronize(Float2CharSortedMap m, Object sync) {
        return new SynchronizedSortedMap(m, sync);
    }

    public static Float2CharSortedMap unmodifiable(Float2CharSortedMap m) {
        return new UnmodifiableSortedMap(m);
    }

    public static class UnmodifiableSortedMap
    extends Float2CharMaps.UnmodifiableMap
    implements Float2CharSortedMap,
    Serializable {
        public static final long serialVersionUID = -7046029254386353129L;
        protected final Float2CharSortedMap sortedMap;

        protected UnmodifiableSortedMap(Float2CharSortedMap m) {
            super(m);
            this.sortedMap = m;
        }

        public Comparator comparator() {
            return this.sortedMap.comparator();
        }

        public Float2CharSortedMap subMap(float from, float to) {
            return new UnmodifiableSortedMap(this.sortedMap.subMap(from, to));
        }

        public Float2CharSortedMap headMap(float to) {
            return new UnmodifiableSortedMap(this.sortedMap.headMap(to));
        }

        public Float2CharSortedMap tailMap(float from) {
            return new UnmodifiableSortedMap(this.sortedMap.tailMap(from));
        }

        public float firstFloatKey() {
            return this.sortedMap.firstFloatKey();
        }

        public float lastFloatKey() {
            return this.sortedMap.lastFloatKey();
        }

        public Object firstKey() {
            return this.sortedMap.firstKey();
        }

        public Object lastKey() {
            return this.sortedMap.lastKey();
        }

        public SortedMap subMap(Object from, Object to) {
            return new UnmodifiableSortedMap((Float2CharSortedMap)this.sortedMap.subMap(from, to));
        }

        public SortedMap headMap(Object to) {
            return new UnmodifiableSortedMap((Float2CharSortedMap)this.sortedMap.headMap(to));
        }

        public SortedMap tailMap(Object from) {
            return new UnmodifiableSortedMap((Float2CharSortedMap)this.sortedMap.tailMap(from));
        }
    }

    public static class SynchronizedSortedMap
    extends Float2CharMaps.SynchronizedMap
    implements Float2CharSortedMap,
    Serializable {
        public static final long serialVersionUID = -7046029254386353129L;
        protected final Float2CharSortedMap sortedMap;

        protected SynchronizedSortedMap(Float2CharSortedMap m, Object sync) {
            super(m, sync);
            this.sortedMap = m;
        }

        protected SynchronizedSortedMap(Float2CharSortedMap m) {
            super(m);
            this.sortedMap = m;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Comparator comparator() {
            Object object = this.sync;
            synchronized (object) {
                return this.sortedMap.comparator();
            }
        }

        public Float2CharSortedMap subMap(float from, float to) {
            return new SynchronizedSortedMap(this.sortedMap.subMap(from, to), this.sync);
        }

        public Float2CharSortedMap headMap(float to) {
            return new SynchronizedSortedMap(this.sortedMap.headMap(to), this.sync);
        }

        public Float2CharSortedMap tailMap(float from) {
            return new SynchronizedSortedMap(this.sortedMap.tailMap(from), this.sync);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public float firstFloatKey() {
            Object object = this.sync;
            synchronized (object) {
                return this.sortedMap.firstFloatKey();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public float lastFloatKey() {
            Object object = this.sync;
            synchronized (object) {
                return this.sortedMap.lastFloatKey();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Object firstKey() {
            Object object = this.sync;
            synchronized (object) {
                return this.sortedMap.firstKey();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Object lastKey() {
            Object object = this.sync;
            synchronized (object) {
                return this.sortedMap.lastKey();
            }
        }

        public SortedMap subMap(Object from, Object to) {
            return new SynchronizedSortedMap((Float2CharSortedMap)this.sortedMap.subMap(from, to), this.sync);
        }

        public SortedMap headMap(Object to) {
            return new SynchronizedSortedMap((Float2CharSortedMap)this.sortedMap.headMap(to), this.sync);
        }

        public SortedMap tailMap(Object from) {
            return new SynchronizedSortedMap((Float2CharSortedMap)this.sortedMap.tailMap(from), this.sync);
        }
    }

    public static class Singleton
    extends Float2CharMaps.Singleton
    implements Float2CharSortedMap,
    Serializable,
    Cloneable {
        public static final long serialVersionUID = -7046029254386353129L;
        protected final FloatComparator comparator;

        protected Singleton(float key, char value, FloatComparator comparator) {
            super(key, value);
            this.comparator = comparator;
        }

        protected Singleton(float key, char value) {
            this(key, value, null);
        }

        final int compare(float k1, float k2) {
            return this.comparator == null ? (k1 < k2 ? -1 : (k1 == k2 ? 0 : 1)) : this.comparator.compare(k1, k2);
        }

        public Comparator comparator() {
            return this.comparator;
        }

        public Set keySet() {
            if (this.keys == null) {
                this.keys = FloatSortedSets.singleton(this.key, this.comparator);
            }
            return this.keys;
        }

        public Float2CharSortedMap subMap(float from, float to) {
            if (this.compare(from, this.key) <= 0 && this.compare(this.key, to) < 0) {
                return this;
            }
            return EMPTY_MAP;
        }

        public Float2CharSortedMap headMap(float to) {
            if (this.compare(this.key, to) < 0) {
                return this;
            }
            return EMPTY_MAP;
        }

        public Float2CharSortedMap tailMap(float from) {
            if (this.compare(from, this.key) <= 0) {
                return this;
            }
            return EMPTY_MAP;
        }

        public float firstFloatKey() {
            return this.key;
        }

        public float lastFloatKey() {
            return this.key;
        }

        public SortedMap headMap(Object oto) {
            return this.headMap(((Float)oto).floatValue());
        }

        public SortedMap tailMap(Object ofrom) {
            return this.tailMap(((Float)ofrom).floatValue());
        }

        public SortedMap subMap(Object ofrom, Object oto) {
            return this.subMap(((Float)ofrom).floatValue(), ((Float)oto).floatValue());
        }

        public Object firstKey() {
            return new Float(this.firstFloatKey());
        }

        public Object lastKey() {
            return new Float(this.lastFloatKey());
        }
    }

    public static class EmptySortedMap
    extends Float2CharMaps.EmptyMap
    implements Float2CharSortedMap,
    Serializable,
    Cloneable {
        public static final long serialVersionUID = -7046029254386353129L;

        protected EmptySortedMap() {
        }

        public Comparator comparator() {
            return null;
        }

        public Float2CharSortedMap subMap(float from, float to) {
            return EMPTY_MAP;
        }

        public Float2CharSortedMap headMap(float to) {
            return EMPTY_MAP;
        }

        public Float2CharSortedMap tailMap(float from) {
            return EMPTY_MAP;
        }

        public float firstFloatKey() {
            throw new NoSuchElementException();
        }

        public float lastFloatKey() {
            throw new NoSuchElementException();
        }

        public SortedMap headMap(Object oto) {
            return this.headMap(((Float)oto).floatValue());
        }

        public SortedMap tailMap(Object ofrom) {
            return this.tailMap(((Float)ofrom).floatValue());
        }

        public SortedMap subMap(Object ofrom, Object oto) {
            return this.subMap(((Float)ofrom).floatValue(), ((Float)oto).floatValue());
        }

        public Object firstKey() {
            return new Float(this.firstFloatKey());
        }

        public Object lastKey() {
            return new Float(this.lastFloatKey());
        }
    }
}

